/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.repository.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.dependency.tree.DependencyNode;
import org.apache.maven.shared.dependency.tree.traversal.DependencyNodeVisitor;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.core.spi.multiview.CloseOperationState;
import org.netbeans.core.spi.multiview.MultiViewElement;
import org.netbeans.core.spi.multiview.MultiViewElementCallback;
import org.netbeans.modules.maven.indexer.api.ui.ArtifactViewer;
import org.openide.awt.Actions;
import org.openide.awt.Mnemonics;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependencyPanel
extends TopComponent
implements MultiViewElement,
LookupListener {
    private MultiViewElementCallback callback;
    private Lookup.Result<DependencyNode> result;
    private static final Icon dirIcon = ImageUtilities.image2Icon((Image)ImageUtilities.loadImage((String)"org/netbeans/modules/maven/repository/ui/DependencyIcon.png", (boolean)true));
    private static final Icon trIcon = ImageUtilities.image2Icon((Image)ImageUtilities.loadImage((String)"org/netbeans/modules/maven/repository/ui/TransitiveDependencyIcon.png", (boolean)true));
    private JToolBar toolbar;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JLabel lblCompile;
    private JLabel lblHint;
    private JLabel lblRuntime;
    private JLabel lblTest;
    private JList lstCompile;
    private JList lstRuntime;
    private JList lstTest;

    DependencyPanel(Lookup lookup) {
        super(lookup);
        this.initComponents();
        Rend rend = new Rend();
        this.lstTest.setCellRenderer(rend);
        this.lstRuntime.setCellRenderer(rend);
        this.lstCompile.setCellRenderer(rend);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                MavenProject mavenProject;
                DependencyNode dependencyNode;
                if (mouseEvent.getClickCount() > 1 && (dependencyNode = (DependencyNode)((JList)mouseEvent.getComponent()).getSelectedValue()) != null && (mavenProject = (MavenProject)DependencyPanel.this.getLookup().lookup(MavenProject.class)) != null) {
                    ArtifactViewer.showArtifactViewer((Artifact)dependencyNode.getArtifact(), (List)mavenProject.getRemoteArtifactRepositories(), (String)"dep");
                }
            }
        };
        this.lstTest.addMouseListener(mouseAdapter);
        this.lstRuntime.addMouseListener(mouseAdapter);
        this.lstCompile.addMouseListener(mouseAdapter);
    }

    private void initComponents() {
        this.lblCompile = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.lstCompile = new JList();
        this.lblRuntime = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.lstRuntime = new JList();
        this.lblTest = new JLabel();
        this.jScrollPane3 = new JScrollPane();
        this.lstTest = new JList();
        this.lblHint = new JLabel();
        this.setFocusable(true);
        this.lblCompile.setLabelFor(this.lstCompile);
        Mnemonics.setLocalizedText((JLabel)this.lblCompile, (String)NbBundle.getMessage(DependencyPanel.class, (String)"DependencyPanel.lblCompile.text"));
        this.jScrollPane1.setViewportView(this.lstCompile);
        this.lstCompile.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DependencyPanel.class, (String)"DependencyPanel.lstCompile.AccessibleContext.accessibleDescription"));
        this.lblRuntime.setLabelFor(this.lstRuntime);
        Mnemonics.setLocalizedText((JLabel)this.lblRuntime, (String)NbBundle.getMessage(DependencyPanel.class, (String)"DependencyPanel.lblRuntime.text"));
        this.jScrollPane2.setViewportView(this.lstRuntime);
        this.lstRuntime.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DependencyPanel.class, (String)"DependencyPanel.lstRuntime.AccessibleContext.accessibleDescription"));
        this.lblTest.setLabelFor(this.lstTest);
        Mnemonics.setLocalizedText((JLabel)this.lblTest, (String)NbBundle.getMessage(DependencyPanel.class, (String)"DependencyPanel.lblTest.text"));
        this.jScrollPane3.setViewportView(this.lstTest);
        this.lstTest.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DependencyPanel.class, (String)"DependencyPanel.lstTest.AccessibleContext.accessibleDescription"));
        this.lblHint.setText(NbBundle.getMessage(DependencyPanel.class, (String)"DependencyPanel.lblHint.text"));
        GroupLayout groupLayout = new GroupLayout((Container)((Object)this));
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(2).add(1, (Component)this.lblHint, -1, 798, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.lblCompile).add((Component)this.jScrollPane1, -1, 262, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.lblRuntime).add((Component)this.jScrollPane2, -1, 262, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.lblTest).add((Component)this.jScrollPane3, -1, 262, Short.MAX_VALUE)))).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lblCompile).add((Component)this.lblRuntime).add((Component)this.lblTest)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.jScrollPane3, -1, 330, Short.MAX_VALUE).add((Component)this.jScrollPane2, -1, 330, Short.MAX_VALUE).add((Component)this.jScrollPane1, -1, 330, Short.MAX_VALUE)).addPreferredGap(0).add((Component)this.lblHint).addContainerGap()));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DependencyPanel.class, (String)"DependencyPanel.AccessibleContext.accessibleName"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DependencyPanel.class, (String)"DependencyPanel.AccessibleContext.accessibleDescription"));
    }

    public JComponent getVisualRepresentation() {
        return this;
    }

    public JComponent getToolbarRepresentation() {
        if (this.toolbar == null) {
            this.toolbar = new JToolBar();
            this.toolbar.setFloatable(false);
            Action[] actionArray = new Action[1];
            Action[] actionArray2 = (Action[])this.getLookup().lookup(actionArray.getClass());
            Dimension dimension = new Dimension(3, 0);
            this.toolbar.addSeparator(dimension);
            for (Action action : actionArray2) {
                JButton jButton = new JButton();
                Actions.connect((AbstractButton)jButton, (Action)action);
                this.toolbar.add(jButton);
                this.toolbar.addSeparator(dimension);
            }
        }
        return this.toolbar;
    }

    public void componentOpened() {
        super.componentOpened();
        this.result = this.getLookup().lookup(new Lookup.Template(DependencyNode.class));
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                DependencyPanel.this.populateFields();
            }
        });
        this.result.addLookupListener((LookupListener)this);
    }

    public void componentClosed() {
        super.componentClosed();
        this.result.removeLookupListener((LookupListener)this);
    }

    public void componentShowing() {
        super.componentShowing();
    }

    public void componentHidden() {
        super.componentHidden();
    }

    public void componentActivated() {
        super.componentActivated();
    }

    public void componentDeactivated() {
        super.componentDeactivated();
    }

    public void setMultiViewCallback(MultiViewElementCallback multiViewElementCallback) {
        this.callback = multiViewElementCallback;
    }

    public CloseOperationState canCloseElement() {
        return CloseOperationState.STATE_OK;
    }

    private void populateFields() {
        boolean bl = true;
        Iterator iterator = this.result.allInstances().iterator();
        if (iterator.hasNext()) {
            bl = false;
            final DependencyNode dependencyNode = (DependencyNode)iterator.next();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    DependencyPanel.this.setDepModel(DependencyPanel.this.lstCompile, dependencyNode, Arrays.asList(Artifact.SCOPE_COMPILE, Artifact.SCOPE_PROVIDED));
                    DependencyPanel.this.setDepModel(DependencyPanel.this.lstRuntime, dependencyNode, Arrays.asList(Artifact.SCOPE_RUNTIME));
                    DependencyPanel.this.setDepModel(DependencyPanel.this.lstTest, dependencyNode, Arrays.asList(Artifact.SCOPE_TEST));
                }
            });
        }
    }

    public void resultChanged(LookupEvent lookupEvent) {
        this.populateFields();
    }

    private void setDepModel(JList jList, DependencyNode dependencyNode, List<String> list) {
        DefaultListModel<DependencyNode> defaultListModel = new DefaultListModel<DependencyNode>();
        NodeVisitor nodeVisitor = new NodeVisitor(list);
        dependencyNode.accept((DependencyNodeVisitor)nodeVisitor);
        for (DependencyNode dependencyNode2 : nodeVisitor.getDirects()) {
            defaultListModel.addElement(dependencyNode2);
        }
        for (DependencyNode dependencyNode2 : nodeVisitor.getTransitives()) {
            defaultListModel.addElement(dependencyNode2);
        }
        jList.setModel(defaultListModel);
        jList.putClientProperty("directs", nodeVisitor.getDirects());
        jList.putClientProperty("trans", nodeVisitor.getTransitives());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NodeVisitor
    implements DependencyNodeVisitor {
        private List<DependencyNode> directs;
        private List<DependencyNode> trans;
        private List<String> scopes;
        private DependencyNode root;
        private Stack<DependencyNode> path;

        private NodeVisitor(List<String> list) {
            this.scopes = list;
        }

        public boolean visit(DependencyNode dependencyNode) {
            if (this.root == null) {
                this.root = dependencyNode;
                this.directs = new ArrayList<DependencyNode>();
                this.trans = new ArrayList<DependencyNode>();
                this.path = new Stack();
                return true;
            }
            if (dependencyNode.getState() == 0 && this.scopes.contains(dependencyNode.getArtifact().getScope())) {
                if (this.path.empty()) {
                    this.directs.add(dependencyNode);
                } else {
                    this.trans.add(dependencyNode);
                }
            }
            this.path.push(dependencyNode);
            return true;
        }

        public boolean endVisit(DependencyNode dependencyNode) {
            if (this.root == dependencyNode) {
                this.root = null;
                this.path = null;
                return true;
            }
            this.path.pop();
            return true;
        }

        private Iterable<DependencyNode> getDirects() {
            return this.directs;
        }

        private Iterable<DependencyNode> getTransitives() {
            return this.trans;
        }
    }

    private static class Rend
    extends DefaultListCellRenderer {
        private Rend() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Component component = super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            if (object instanceof DependencyNode) {
                DependencyNode dependencyNode = (DependencyNode)object;
                JLabel jLabel = (JLabel)component;
                jLabel.setText(dependencyNode.getArtifact().getArtifactId() + ":" + dependencyNode.getArtifact().getVersion());
                List list = (List)jList.getClientProperty("directs");
                if (list.contains(dependencyNode)) {
                    jLabel.setIcon(dirIcon);
                } else {
                    jLabel.setIcon(trIcon);
                }
            }
            return component;
        }
    }
}

