/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.editor.completion;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.groovy.editor.api.completion.CompletionHandler;
import org.netbeans.modules.groovy.editor.api.completion.CompletionItem;
import org.netbeans.modules.groovy.editor.api.completion.FieldSignature;
import org.netbeans.modules.groovy.editor.api.completion.MethodSignature;
import org.netbeans.modules.groovy.editor.completion.AccessLevel;
import org.netbeans.modules.groovy.editor.completion.GroovyElementHandler;
import org.openide.filesystems.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JavaElementHandler {
    private static final Logger LOG = Logger.getLogger(GroovyElementHandler.class.getName());
    private final ParserResult info;

    private JavaElementHandler(ParserResult parserResult) {
        this.info = parserResult;
    }

    public static JavaElementHandler forCompilationInfo(ParserResult parserResult) {
        return new JavaElementHandler(parserResult);
    }

    public Map<MethodSignature, ? extends CompletionItem> getMethods(String string, String string2, int n, String[] stringArray, boolean bl, Set<AccessLevel> set, boolean bl2) {
        JavaSource javaSource = this.createJavaSource();
        if (javaSource == null) {
            return Collections.emptyMap();
        }
        CountDownLatch countDownLatch = new CountDownLatch(1);
        Map<MethodSignature, CompletionItem> map = Collections.synchronizedMap(new HashMap());
        try {
            javaSource.runUserActionTask((Task)new MethodCompletionHelper(countDownLatch, javaSource, string, stringArray, set, string2, n, map, bl, bl2), true);
        }
        catch (IOException iOException) {
            LOG.log(Level.FINEST, "Problem in runUserActionTask :  {0}", iOException.getMessage());
            return Collections.emptyMap();
        }
        try {
            countDownLatch.await();
        }
        catch (InterruptedException interruptedException) {
            LOG.log(Level.FINEST, "InterruptedException while waiting on latch :  {0}", interruptedException.getMessage());
            return Collections.emptyMap();
        }
        return map;
    }

    public Map<FieldSignature, ? extends CompletionItem> getFields(String string, String string2, int n, boolean bl) {
        JavaSource javaSource = this.createJavaSource();
        if (javaSource == null) {
            return Collections.emptyMap();
        }
        CountDownLatch countDownLatch = new CountDownLatch(1);
        Map<FieldSignature, CompletionItem> map = Collections.synchronizedMap(new HashMap());
        try {
            javaSource.runUserActionTask((Task)new FieldCompletionHelper(countDownLatch, javaSource, string, Collections.singleton(AccessLevel.PUBLIC), string2, n, map, bl), true);
        }
        catch (IOException iOException) {
            LOG.log(Level.FINEST, "Problem in runUserActionTask :  {0}", iOException.getMessage());
            return Collections.emptyMap();
        }
        try {
            countDownLatch.await();
        }
        catch (InterruptedException interruptedException) {
            LOG.log(Level.FINEST, "InterruptedException while waiting on latch :  {0}", interruptedException.getMessage());
            return Collections.emptyMap();
        }
        return map;
    }

    private JavaSource createJavaSource() {
        FileObject fileObject = this.info.getSnapshot().getSource().getFileObject();
        if (fileObject == null) {
            return null;
        }
        JavaSource javaSource = JavaSource.create((ClasspathInfo)ClasspathInfo.create((FileObject)fileObject), (FileObject[])new FileObject[0]);
        if (javaSource == null) {
            LOG.log(Level.FINEST, "Problem retrieving JavaSource from ClassPathInfo, exiting.");
            return null;
        }
        return javaSource;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FieldCompletionHelper
    implements Task<CompilationController> {
        private final CountDownLatch cnt;
        private final JavaSource javaSource;
        private final String className;
        private final Set<AccessLevel> levels;
        private final String prefix;
        private final int anchor;
        private final boolean emphasise;
        private final Map<FieldSignature, CompletionItem> proposals;

        public FieldCompletionHelper(CountDownLatch countDownLatch, JavaSource javaSource, String string, Set<AccessLevel> set, String string2, int n, Map<FieldSignature, CompletionItem> map, boolean bl) {
            this.cnt = countDownLatch;
            this.javaSource = javaSource;
            this.className = string;
            this.levels = set;
            this.prefix = string2;
            this.anchor = n;
            this.proposals = map;
            this.emphasise = bl;
        }

        public void run(CompilationController compilationController) throws Exception {
            Elements elements = compilationController.getElements();
            if (elements != null) {
                ElementUtilities.ElementAcceptor elementAcceptor = new ElementUtilities.ElementAcceptor(){

                    public boolean accept(Element element, TypeMirror typeMirror) {
                        if (element.getKind() != ElementKind.FIELD) {
                            return false;
                        }
                        for (AccessLevel accessLevel : FieldCompletionHelper.this.levels) {
                            if (!accessLevel.getJavaAcceptor().accept(element, typeMirror)) continue;
                            return true;
                        }
                        return false;
                    }
                };
                TypeElement typeElement = elements.getTypeElement(this.className);
                if (typeElement != null) {
                    for (VariableElement variableElement : ElementFilter.fieldsIn(typeElement.getEnclosedElements())) {
                        if (!elementAcceptor.accept((Element)variableElement, typeElement.asType())) continue;
                        String string = variableElement.getSimpleName().toString();
                        TypeMirror typeMirror = variableElement.asType();
                        if (!string.toUpperCase(Locale.ENGLISH).startsWith(this.prefix.toUpperCase(Locale.ENGLISH))) continue;
                        if (LOG.isLoggable(Level.FINEST)) {
                            LOG.log(Level.FINEST, string + " " + ((Object)typeMirror).toString());
                        }
                        this.proposals.put(this.getSignature(typeElement, variableElement), new CompletionItem.JavaFieldItem(this.className, string, typeMirror, variableElement.getModifiers(), this.anchor, this.emphasise));
                    }
                }
            }
            this.cnt.countDown();
        }

        private FieldSignature getSignature(TypeElement typeElement, VariableElement variableElement) {
            String string = variableElement.getSimpleName().toString();
            return new FieldSignature(string);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MethodCompletionHelper
    implements Task<CompilationController> {
        private final CountDownLatch cnt;
        private final JavaSource javaSource;
        private final String className;
        private final String[] typeParameters;
        private final Set<AccessLevel> levels;
        private final String prefix;
        private final int anchor;
        private final boolean emphasise;
        private final Map<MethodSignature, CompletionItem> proposals;
        private final boolean nameOnly;

        public MethodCompletionHelper(CountDownLatch countDownLatch, JavaSource javaSource, String string, String[] stringArray, Set<AccessLevel> set, String string2, int n, Map<MethodSignature, CompletionItem> map, boolean bl, boolean bl2) {
            this.cnt = countDownLatch;
            this.javaSource = javaSource;
            this.className = string;
            this.typeParameters = stringArray;
            this.levels = set;
            this.prefix = string2;
            this.anchor = n;
            this.proposals = map;
            this.emphasise = bl;
            this.nameOnly = bl2;
        }

        public void run(CompilationController compilationController) throws Exception {
            Elements elements = compilationController.getElements();
            if (elements != null) {
                ElementUtilities.ElementAcceptor elementAcceptor = new ElementUtilities.ElementAcceptor(){

                    public boolean accept(Element element, TypeMirror typeMirror) {
                        if (element.getKind() != ElementKind.METHOD) {
                            return false;
                        }
                        for (AccessLevel accessLevel : MethodCompletionHelper.this.levels) {
                            if (!accessLevel.getJavaAcceptor().accept(element, typeMirror)) continue;
                            return true;
                        }
                        return false;
                    }
                };
                TypeElement typeElement = elements.getTypeElement(this.className);
                if (typeElement != null) {
                    for (ExecutableElement executableElement : ElementFilter.methodsIn(typeElement.getEnclosedElements())) {
                        if (!elementAcceptor.accept((Element)executableElement, typeElement.asType())) continue;
                        String string = executableElement.getSimpleName().toString();
                        String string2 = CompletionHandler.getParameterListForMethod(executableElement);
                        TypeMirror typeMirror = executableElement.getReturnType();
                        if (!string.toUpperCase(Locale.ENGLISH).startsWith(this.prefix.toUpperCase(Locale.ENGLISH))) continue;
                        if (LOG.isLoggable(Level.FINEST)) {
                            LOG.log(Level.FINEST, string + " " + string2 + " " + ((Object)typeMirror).toString());
                        }
                        this.proposals.put(this.getSignature(typeElement, executableElement, this.typeParameters, compilationController.getTypes()), CompletionItem.forJavaMethod(this.className, string, string2, typeMirror, executableElement.getModifiers(), this.anchor, this.emphasise, this.nameOnly));
                    }
                }
            }
            this.cnt.countDown();
        }

        private MethodSignature getSignature(TypeElement typeElement, ExecutableElement executableElement, String[] stringArray, Types types) {
            String string = executableElement.getSimpleName().toString();
            String[] stringArray2 = new String[executableElement.getParameters().size()];
            for (int i = 0; i < stringArray2.length; ++i) {
                VariableElement variableElement = executableElement.getParameters().get(i);
                TypeMirror typeMirror = variableElement.asType();
                String string2 = null;
                if (typeMirror.getKind() == TypeKind.TYPEVAR) {
                    List<? extends TypeParameterElement> list = executableElement.getTypeParameters();
                    if (list.isEmpty()) {
                        list = typeElement.getTypeParameters();
                    }
                    int n = -1;
                    for (TypeParameterElement typeParameterElement : list) {
                        ++n;
                        if (!typeParameterElement.getSimpleName().toString().equals(((Object)typeMirror).toString())) continue;
                        break;
                    }
                    string2 = n >= 0 && n < stringArray.length ? stringArray[n] : ((Object)types.erasure(typeMirror)).toString();
                } else {
                    string2 = ((Object)typeMirror).toString();
                }
                int n = string2.indexOf(60);
                if (n >= 0) {
                    string2 = string2.substring(0, n);
                }
                stringArray2[i] = string2;
            }
            return new MethodSignature(string, stringArray2);
        }
    }
}

