/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.core.ui.components;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;
import org.netbeans.modules.dlight.core.ui.components.ContentValidator;
import org.netbeans.modules.dlight.core.ui.components.DLightTargetSelectionDialogLayout;
import org.netbeans.modules.dlight.core.ui.components.JComboBox2;
import org.netbeans.modules.dlight.core.ui.components.JFileChooser2;
import org.netbeans.modules.dlight.core.ui.components.Validatable;
import org.openide.util.NbBundle;

public abstract class DLightTargetSelectionDialog
extends JDialog
implements ActionListener {
    public static final int RESULT_OK = 0;
    public static final int RESULT_CANCEL = 1;
    public static final int RESULT_ERROR = -1;
    private int result = -1;
    protected JButton btnOK = new JButton(NbBundle.getMessage(DLightTargetSelectionDialog.class, (String)"DLightTargetSelectionDialog.OK_Button"));
    protected JButton btnCancel = new JButton(NbBundle.getMessage(DLightTargetSelectionDialog.class, (String)"DLightTargetSelectionDialog.Cancel_Button"));
    protected JPanel buttonPanel = new JPanel();
    protected ArrayList<Validatable> toValidate = new ArrayList();

    public abstract String getProgramName();

    public abstract String getProgramArguments();

    public abstract String getWorkingDirectory();

    public DLightTargetSelectionDialog(String string) {
        this.setModal(true);
        this.setDefaultCloseOperation(1);
        this.setTitle(string);
    }

    public void show(Frame frame) {
        this.setLocationRelativeTo(frame);
        this.setVisible(true);
    }

    final void init() {
        this.initComponents();
        this.initCancelOKButtons();
        this.getRootPane().setDefaultButton(this.btnOK);
        this.pack();
    }

    void initCancelOKButtons() {
        int n = (int)this.btnOK.getPreferredSize().getHeight();
        this.btnOK.addActionListener(this);
        this.btnOK.setPreferredSize(new Dimension(80, n));
        this.btnCancel.addActionListener(this);
        this.btnCancel.setPreferredSize(new Dimension(80, n));
        this.btnOK.setToolTipText(NbBundle.getMessage(DLightTargetSelectionDialog.class, (String)"DLightTargetSelectionDialog.OK_Button.Tooltip"));
        this.btnCancel.setToolTipText(NbBundle.getMessage(DLightTargetSelectionDialog.class, (String)"DLightTargetSelectionDialog.Cancel_Button.Tooltip"));
        this.buttonPanel.setLayout(new FlowLayout(4, 5, 20));
        this.buttonPanel.add(this.btnOK);
        this.buttonPanel.add(this.btnCancel);
        this.getContentPane().add(this.buttonPanel);
    }

    void setResult(int n) {
        this.result = n;
    }

    String selectFile(String string) {
        return this.selectFile(string, null, null);
    }

    String selectFile(String string, FileFilter fileFilter) {
        return this.selectFile(string, fileFilter, null);
    }

    String selectFile(String string, FileFilter fileFilter, ContentValidator contentValidator) {
        return this.select(string, fileFilter, contentValidator, 0);
    }

    String selectDirectory(String string) {
        return this.selectDirectory(string, null);
    }

    String selectDirectory(String string, ContentValidator contentValidator) {
        return this.select(string, null, contentValidator, 1);
    }

    String select(String string, FileFilter fileFilter, ContentValidator contentValidator, int n) {
        if (string == null) {
            string = ".";
        }
        File file = new File(string);
        String string2 = string;
        JFileChooser2 jFileChooser2 = new JFileChooser2(file, contentValidator);
        jFileChooser2.setFileSelectionMode(n);
        jFileChooser2.setFileFilter(fileFilter);
        jFileChooser2.addChoosableFileFilter(fileFilter);
        jFileChooser2.setMultiSelectionEnabled(false);
        int n2 = jFileChooser2.showOpenDialog(this);
        if (n2 == 0) {
            try {
                File file2 = jFileChooser2.getSelectedFile();
                string2 = file2.getCanonicalPath();
                return string2;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    void addPanel(String string, JComboBox2 jComboBox2, JButton jButton) {
        JPanel jPanel = new JPanel(new DLightTargetSelectionDialogLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(string));
        if (jComboBox2 != null) {
            jPanel.add((Component)jComboBox2, DLightTargetSelectionDialogLayout.COMBO_IDX);
            this.toValidate.add(jComboBox2);
        }
        if (jButton != null) {
            jPanel.add((Component)jButton, DLightTargetSelectionDialogLayout.BTN_IDX);
        }
        this.getContentPane().add(jPanel);
    }

    static void updateModel(DefaultComboBoxModel defaultComboBoxModel, String string) {
        if (string == null) {
            return;
        }
        defaultComboBoxModel.removeElement(string);
        defaultComboBoxModel.insertElementAt(string, 0);
        defaultComboBoxModel.setSelectedItem(string);
    }

    public int getResult() {
        return this.result;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (!(object instanceof JButton)) {
            return;
        }
        if (object == this.btnOK) {
            this.approveSelection();
        } else if (object == this.btnCancel) {
            this.setResult(1);
            this.setVisible(false);
        }
    }

    abstract void initComponents();

    public void approveSelection() {
        for (Validatable validatable : this.toValidate) {
            if (validatable.validateContent()) continue;
            return;
        }
        this.setResult(0);
        this.setVisible(false);
    }
}

