/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.ui;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import javax.lang.model.AnnotatedConstruct;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.TypeMirrorHandle;
import org.netbeans.api.java.source.ui.ElementHeaders;
import org.netbeans.api.java.source.ui.ElementIcons;
import org.netbeans.modules.refactoring.java.api.ExtractInterfaceRefactoring;
import org.netbeans.modules.refactoring.java.ui.UIUtilities;
import org.netbeans.modules.refactoring.spi.ui.CustomRefactoringPanel;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public final class ExtractInterfacePanel
extends JPanel
implements CustomRefactoringPanel {
    private static final String[] COLUMN_NAMES = new String[]{"LBL_Selected", "LBL_ExtractInterface_Member"};
    private static final Class[] COLUMN_CLASSES = new Class[]{Boolean.class, TreePathHandle.class};
    private final ExtractInterfaceRefactoring refactoring;
    private final TableModel tableModel;
    private Object[][] members = new Object[0][0];
    private JLabel chooseLabel;
    private JTable membersTable;
    private JLabel nameLabel;
    private JPanel namePanel;
    private JTextField nameText;
    private JScrollPane scrollPane;

    public ExtractInterfacePanel(ExtractInterfaceRefactoring extractInterfaceRefactoring, final ChangeListener changeListener) {
        this.refactoring = extractInterfaceRefactoring;
        this.tableModel = new TableModel();
        this.initComponents();
        this.setPreferredSize(new Dimension(420, 380));
        String string = "NewInterface";
        this.nameText.setText(string);
        this.nameText.setSelectionStart(0);
        this.nameText.setSelectionEnd(string.length());
        this.nameText.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                changeListener.stateChanged(null);
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                changeListener.stateChanged(null);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                changeListener.stateChanged(null);
            }
        });
    }

    public void requestFocus() {
        super.requestFocus();
        this.nameText.requestFocus();
    }

    public void initialize() {
        this.membersTable.setDefaultRenderer(COLUMN_CLASSES[1], new DefaultTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                super.getTableCellRendererComponent(jTable, this.extractText(object), bl, bl2, n, n2);
                if (object instanceof ExtractInterfaceInfo) {
                    this.setIcon(((ExtractInterfaceInfo)object).icon);
                }
                return this;
            }

            protected String extractText(Object object) {
                String string = object instanceof ExtractInterfaceInfo ? ((ExtractInterfaceInfo)object).htmlText : String.valueOf(object);
                return string;
            }
        });
        this.scrollPane.setBackground(this.membersTable.getBackground());
        this.scrollPane.getViewport().setBackground(this.membersTable.getBackground());
        this.membersTable.setRowHeight(18);
        if (UIManager.getColor("control") != null) {
            this.membersTable.setGridColor(UIManager.getColor("control"));
        }
        UIUtilities.initColumnWidth(this.membersTable, 0, Boolean.TRUE, 4);
    }

    public void storeSettings() {
        ArrayList<ElementHandle<VariableElement>> arrayList = new ArrayList<ElementHandle<VariableElement>>();
        ArrayList<ElementHandle<ExecutableElement>> arrayList2 = new ArrayList<ElementHandle<ExecutableElement>>();
        ArrayList<TypeMirrorHandle<TypeMirror>> arrayList3 = new ArrayList<TypeMirrorHandle<TypeMirror>>();
        block5: for (int i = 0; i < this.members.length; ++i) {
            if (!this.members[i][0].equals(Boolean.TRUE)) continue;
            ExtractInterfaceInfo extractInterfaceInfo = (ExtractInterfaceInfo)this.members[i][1];
            switch (extractInterfaceInfo.group) {
                case FIELD: {
                    arrayList.add((ElementHandle<VariableElement>)((ElementHandle)extractInterfaceInfo.handle));
                    continue block5;
                }
                case METHOD: {
                    arrayList2.add((ElementHandle<ExecutableElement>)((ElementHandle)extractInterfaceInfo.handle));
                    continue block5;
                }
                case IMPLEMENTS: {
                    arrayList3.add((TypeMirrorHandle<TypeMirror>)((TypeMirrorHandle)extractInterfaceInfo.handle));
                }
            }
        }
        this.refactoring.setFields(arrayList);
        this.refactoring.setImplements(arrayList3);
        this.refactoring.setMethods(arrayList2);
        this.refactoring.setInterfaceName(this.nameText.getText());
    }

    private void initComponents() {
        this.namePanel = new JPanel();
        this.nameLabel = new JLabel();
        this.chooseLabel = new JLabel();
        this.nameText = new JTextField();
        this.scrollPane = new JScrollPane();
        this.membersTable = new JTable();
        this.setBorder(BorderFactory.createEmptyBorder(12, 12, 11, 11));
        this.setLayout(new BorderLayout());
        this.namePanel.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.namePanel.setLayout(new BorderLayout(12, 0));
        this.nameLabel.setLabelFor(this.nameText);
        Mnemonics.setLocalizedText((JLabel)this.nameLabel, (String)NbBundle.getMessage(ExtractInterfacePanel.class, (String)"LBL_ExtractInterface_Name"));
        this.namePanel.add((Component)this.nameLabel, "West");
        this.nameLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ExtractInterfacePanel.class, (String)"ACSD_InterfaceName"));
        this.nameLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ExtractInterfacePanel.class, (String)"ACSD_InterfaceNameDescription"));
        this.chooseLabel.setLabelFor(this.membersTable);
        Mnemonics.setLocalizedText((JLabel)this.chooseLabel, (String)NbBundle.getMessage(ExtractInterfacePanel.class, (String)"LBL_ExtractInterfaceLabel"));
        this.chooseLabel.setBorder(BorderFactory.createEmptyBorder(6, 0, 0, 0));
        this.namePanel.add((Component)this.chooseLabel, "South");
        this.chooseLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ExtractInterfacePanel.class, (String)"ExtractInterfacePanel.chooseLabel.AccessibleContext.accessibleDescription"));
        this.namePanel.add((Component)this.nameText, "Center");
        this.add((Component)this.namePanel, "North");
        this.membersTable.setModel(this.tableModel);
        this.membersTable.setAutoResizeMode(1);
        this.scrollPane.setViewportView(this.membersTable);
        this.membersTable.getAccessibleContext().setAccessibleName(null);
        this.membersTable.getAccessibleContext().setAccessibleDescription(null);
        this.add((Component)this.scrollPane, "Center");
    }

    public Component getComponent() {
        return this;
    }

    static /* synthetic */ Object[][] access$202(ExtractInterfacePanel extractInterfacePanel, Object[][] objectArray) {
        extractInterfacePanel.members = objectArray;
        return objectArray;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Group {
        IMPLEMENTS,
        METHOD,
        FIELD;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ExtractInterfaceInfo<H> {
        final H handle;
        final String htmlText;
        final Icon icon;
        final String name;
        final Group group;

        public ExtractInterfaceInfo(H h, String string, Icon icon, String string2, Group group) {
            this.handle = h;
            this.htmlText = string;
            this.icon = icon;
            this.name = string2;
            this.group = group;
        }
    }

    private class TableModel
    extends AbstractTableModel {
        TableModel() {
            this.initialize();
        }

        public int getColumnCount() {
            return COLUMN_NAMES.length;
        }

        public String getColumnName(int n) {
            return UIUtilities.getColumnName(NbBundle.getMessage(ExtractInterfacePanel.class, (String)COLUMN_NAMES[n]));
        }

        public Class getColumnClass(int n) {
            return COLUMN_CLASSES[n];
        }

        public int getRowCount() {
            return ExtractInterfacePanel.this.members.length;
        }

        public Object getValueAt(int n, int n2) {
            return ExtractInterfacePanel.this.members[n][n2];
        }

        public void setValueAt(Object object, int n, int n2) {
            ((ExtractInterfacePanel)ExtractInterfacePanel.this).members[n][n2] = object;
        }

        public boolean isCellEditable(int n, int n2) {
            return n2 == 0;
        }

        private void initialize() {
            final TreePathHandle treePathHandle = ExtractInterfacePanel.this.refactoring.getSourceType();
            if (treePathHandle == null) {
                return;
            }
            FileObject fileObject = treePathHandle.getFileObject();
            JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
            try {
                javaSource.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                    public void cancel() {
                    }

                    public void run(CompilationController compilationController) throws Exception {
                        compilationController.toPhase(JavaSource.Phase.RESOLVED);
                        TableModel.this.initializeInTransaction(compilationController, treePathHandle);
                    }
                }, true);
            }
            catch (IOException iOException) {
                throw new IllegalStateException(iOException);
            }
        }

        private void initializeInTransaction(CompilationController compilationController, TreePathHandle treePathHandle) {
            AnnotatedConstruct annotatedConstruct;
            TreePath treePath;
            TreePath treePath2 = treePathHandle.resolve((CompilationInfo)compilationController);
            ClassTree classTree = (ClassTree)treePath2.getLeaf();
            ArrayList<ExtractInterfaceInfo<Object>> arrayList = new ArrayList<ExtractInterfaceInfo<Object>>();
            for (Tree tree : classTree.getImplementsClause()) {
                treePath = compilationController.getTrees().getPath(compilationController.getCompilationUnit(), tree);
                annotatedConstruct = compilationController.getTrees().getTypeMirror(treePath);
                arrayList.add(new ExtractInterfaceInfo<TypeMirrorHandle>(TypeMirrorHandle.create((TypeMirror)annotatedConstruct), "implements " + tree.toString(), ElementIcons.getElementIcon((ElementKind)ElementKind.INTERFACE, null), tree.toString(), Group.IMPLEMENTS));
            }
            for (Tree tree : classTree.getMembers()) {
                Group group;
                Set<Modifier> set;
                treePath = compilationController.getTrees().getPath(compilationController.getCompilationUnit(), tree);
                if (compilationController.getTreeUtilities().isSynthetic(treePath) || (annotatedConstruct = compilationController.getTrees().getElement(treePath)) == null || !(set = annotatedConstruct.getModifiers()).contains((Object)Modifier.PUBLIC)) continue;
                String string = "%name%";
                if (annotatedConstruct.getKind() == ElementKind.FIELD) {
                    if (!set.contains((Object)Modifier.STATIC) || !set.contains((Object)Modifier.FINAL) || ((VariableTree)tree).getInitializer() == null) continue;
                    group = Group.FIELD;
                    string = string + " : %type%";
                } else {
                    if (annotatedConstruct.getKind() != ElementKind.METHOD || set.contains((Object)Modifier.STATIC)) continue;
                    group = Group.METHOD;
                    string = string + "%parameters% : %type%";
                }
                arrayList.add(new ExtractInterfaceInfo<ElementHandle>(ElementHandle.create((Element)annotatedConstruct), ElementHeaders.getHeader((Element)annotatedConstruct, (CompilationInfo)compilationController, (String)string), ElementIcons.getElementIcon((ElementKind)annotatedConstruct.getKind(), set), annotatedConstruct.getSimpleName().toString(), group));
            }
            Collections.sort(arrayList, new Comparator(){

                public int compare(Object object, Object object2) {
                    ExtractInterfaceInfo extractInterfaceInfo = (ExtractInterfaceInfo)object;
                    ExtractInterfaceInfo extractInterfaceInfo2 = (ExtractInterfaceInfo)object2;
                    int n = extractInterfaceInfo.group.compareTo(extractInterfaceInfo2.group);
                    if (n == 0) {
                        n = extractInterfaceInfo.name.compareTo(extractInterfaceInfo2.name);
                    }
                    return n;
                }
            });
            ExtractInterfacePanel.access$202(ExtractInterfacePanel.this, new Object[arrayList.size()][2]);
            for (int i = 0; i < ExtractInterfacePanel.this.members.length; ++i) {
                ((ExtractInterfacePanel)ExtractInterfacePanel.this).members[i][0] = Boolean.FALSE;
                ((ExtractInterfacePanel)ExtractInterfacePanel.this).members[i][1] = arrayList.get(i);
            }
            this.fireTableDataChanged();
        }
    }
}

