/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.plugins;

import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.refactoring.java.spi.RefactoringVisitor;
import org.netbeans.modules.refactoring.java.spi.ToPhaseException;
import org.openide.util.Exceptions;

class VarUsageVisitor
extends RefactoringVisitor {
    private final TypeElement superTypeElement;
    private final TypeElement subTypeElement;
    private boolean isReplCandidate = true;

    VarUsageVisitor(TypeElement typeElement, WorkingCopy workingCopy, TypeElement typeElement2) {
        try {
            this.setWorkingCopy(workingCopy);
        }
        catch (ToPhaseException toPhaseException) {
            Exceptions.printStackTrace((Throwable)toPhaseException);
        }
        this.superTypeElement = typeElement2;
        this.subTypeElement = typeElement;
    }

    public Tree visitMemberSelect(MemberSelectTree memberSelectTree, Element element) {
        Element element2 = this.asElement(memberSelectTree);
        Element element3 = this.asElement(memberSelectTree.getExpression());
        if (!((Object)element).equals(element3)) {
            return (Tree)super.visitMemberSelect(memberSelectTree, element);
        }
        boolean bl = this.isMemberAvailable(this.subTypeElement, element2, this.superTypeElement);
        if (!bl) {
            this.isReplCandidate = false;
        }
        return (Tree)super.visitMemberSelect(memberSelectTree, element);
    }

    public Tree visitAssignment(AssignmentTree assignmentTree, Element element) {
        ExpressionTree expressionTree = assignmentTree.getExpression();
        Element element2 = this.asElement(expressionTree);
        if (!((Object)element).equals(element2)) {
            return (Tree)super.visitAssignment(assignmentTree, element);
        }
        ExpressionTree expressionTree2 = assignmentTree.getVariable();
        VariableElement variableElement = (VariableElement)this.asElement(expressionTree2);
        this.isReplCandidate = this.isReplacableAssgnmt(variableElement) && this.isReplCandidate;
        return (Tree)super.visitAssignment(assignmentTree, element);
    }

    public Tree visitVariable(VariableTree variableTree, Element element) {
        ExpressionTree expressionTree = variableTree.getInitializer();
        if (null == expressionTree) {
            return (Tree)super.visitVariable(variableTree, element);
        }
        Element element2 = this.asElement(expressionTree);
        if (!((Object)element).equals(element2)) {
            return (Tree)super.visitVariable(variableTree, element);
        }
        VariableElement variableElement = (VariableElement)this.asElement(variableTree);
        this.isReplCandidate = this.isReplacableAssgnmt(variableElement) && this.isReplCandidate;
        return (Tree)super.visitVariable(variableTree, element);
    }

    private boolean isMemberAvailable(TypeElement typeElement, Element element, TypeElement typeElement2) {
        ElementKind elementKind = element.getKind();
        if (ElementKind.METHOD.equals((Object)elementKind)) {
            return this.isMethodAvailable(typeElement, (ExecutableElement)element, typeElement2);
        }
        return this.isHidingMember(typeElement, element, typeElement2);
    }

    private boolean isMethodAvailable(TypeElement typeElement, ExecutableElement executableElement, TypeElement typeElement2) {
        Elements elements = this.workingCopy.getElements();
        List<? extends Element> list = elements.getAllMembers(typeElement2);
        for (Element element : list) {
            if (!ElementKind.METHOD.equals((Object)element.getKind())) continue;
            if (this.isStatic(executableElement) && elements.hides(executableElement, element)) {
                return true;
            }
            if (!executableElement.equals(element) && !elements.overrides(executableElement, (ExecutableElement)element, typeElement)) continue;
            return true;
        }
        return false;
    }

    private boolean isHidingMember(TypeElement typeElement, Element element, TypeElement typeElement2) {
        Elements elements = this.workingCopy.getElements();
        List<? extends Element> list = elements.getAllMembers(typeElement2);
        for (Element element2 : list) {
            if (!((Object)element).equals(element2) && !elements.hides(element, element2)) continue;
            return true;
        }
        return false;
    }

    private boolean isReplacableAssgnmt(VariableElement variableElement) {
        DeclaredType declaredType;
        TypeElement typeElement;
        return this.isDeclaredType(variableElement.asType()) && this.isAssignable(this.superTypeElement, typeElement = (TypeElement)(declaredType = (DeclaredType)variableElement.asType()).asElement());
    }

    boolean isReplaceCandidate() {
        return this.isReplCandidate;
    }

    private boolean isAssignable(TypeElement typeElement, TypeElement typeElement2) {
        Types types = this.workingCopy.getTypes();
        return types.isAssignable(typeElement.asType(), typeElement2.asType());
    }

    private Element asElement(Tree tree) {
        Trees trees = this.workingCopy.getTrees();
        TreePath treePath = trees.getPath(this.workingCopy.getCompilationUnit(), tree);
        Element element = trees.getElement(treePath);
        return element;
    }

    private boolean isDeclaredType(TypeMirror typeMirror) {
        return TypeKind.DECLARED.equals((Object)typeMirror.getKind());
    }

    private boolean isStatic(Element element) {
        Set<Modifier> set = element.getModifiers();
        return set.contains((Object)Modifier.STATIC);
    }
}

