/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.client.tools.api;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.prefs.Preferences;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.modules.web.client.tools.api.Log;
import org.openide.awt.HtmlBrowser;
import org.openide.execution.NbProcessDescriptor;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FirefoxBrowserUtils {
    public static final String PROFILE_PREF = "firefox-defaultProfile";
    private static final String APPDATA_CMD = "cmd /c echo %AppData%";
    private static final String[] WIN32_PROFILES_LOCATIONS = new String[]{"\\Mozilla\\Firefox\\"};
    private static final String[] LINUX_PROFILES_LOCATIONS = new String[]{"/.mozilla/firefox/"};
    private static final String[] MACOSX_PROFILES_LOCATIONS = new String[]{"/Library/Application Support/Firefox/", "/Library/Mozilla/Firefox/"};

    public static File getProfileFromPreferences() {
        Preferences preferences = NbPreferences.forModule(FirefoxBrowserUtils.class);
        String string = preferences.get(PROFILE_PREF, "");
        if (string.length() > 0) {
            File file = new File(string);
            return file.isDirectory() ? file : null;
        }
        return null;
    }

    public static File getDefaultProfile() {
        String[] stringArray = FirefoxBrowserUtils.getLocationsForOS();
        if (stringArray != null) {
            for (String string : stringArray) {
                File file = new File(string);
                if (!file.isDirectory() || !file.exists()) continue;
                List<FirefoxProfile> list = FirefoxBrowserUtils.getAllProfiles(file);
                if (list == null || list.size() == 0) {
                    File file2 = new File(file, "Profiles");
                    if (!file2.isDirectory()) continue;
                    File[] fileArray = file2.listFiles();
                    for (int i = 0; fileArray != null && i < fileArray.length; ++i) {
                        File file3 = fileArray[i];
                        if (!file3.isDirectory() || !file3.getAbsolutePath().endsWith(".default")) continue;
                        return file3;
                    }
                    continue;
                }
                for (FirefoxProfile firefoxProfile : list) {
                    if (!firefoxProfile.isDefaultProfile()) continue;
                    File file4 = null;
                    file4 = firefoxProfile.isRelative() ? new File(file, firefoxProfile.getPath()) : new File(firefoxProfile.getPath());
                    if (!file4.isDirectory()) continue;
                    return file4;
                }
                for (FirefoxProfile firefoxProfile : list) {
                    File file5 = null;
                    file5 = firefoxProfile.isRelative() ? new File(file, firefoxProfile.getPath()) : new File(firefoxProfile.getPath());
                    if (!file5.isDirectory()) continue;
                    return file5;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isFirefox2(HtmlBrowser.Factory factory, File file, StringBuffer stringBuffer) {
        String string = FirefoxBrowserUtils.getBrowserExecutable(factory);
        if (string == null) {
            return FirefoxBrowserUtils.isCompatibleFirefox(file);
        }
        File file2 = new File(new File(string).getParentFile(), "defaults/pref/firefox.js");
        if (!file2.exists()) {
            return FirefoxBrowserUtils.isCompatibleFirefox(file);
        }
        Pattern pattern = Pattern.compile("\\s*pref\\s*\\(\\s*\"general\\.useragent\\.extra\\.firefox\"");
        Pattern pattern2 = Pattern.compile("\"Firefox/[^\"]+\"");
        int n = -1;
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(file2));
            while (bufferedReader.ready()) {
                Matcher matcher;
                String string2 = bufferedReader.readLine();
                if (!pattern.matcher(string2).find() || !(matcher = pattern2.matcher(string2)).find()) continue;
                String string3 = matcher.group();
                n = Integer.valueOf(string3.substring(9, 10));
                if (stringBuffer == null) break;
                stringBuffer.append(string3);
                break;
            }
            boolean bl = n == 2;
            return bl;
        }
        catch (IOException iOException) {
            Log.getLogger().log(Level.INFO, "Error reading Firefox version.", iOException);
            boolean bl = FirefoxBrowserUtils.isCompatibleFirefox(file);
            return bl;
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    Log.getLogger().log(Level.SEVERE, "Could not read Firefox version file", iOException);
                }
            }
        }
    }

    private static String[] getLocationsForOS() {
        if (Utilities.isWindows()) {
            return FirefoxBrowserUtils.getUserPaths(WIN32_PROFILES_LOCATIONS);
        }
        if (Utilities.isMac()) {
            return FirefoxBrowserUtils.getUserPaths(MACOSX_PROFILES_LOCATIONS);
        }
        return FirefoxBrowserUtils.getUserPaths(LINUX_PROFILES_LOCATIONS);
    }

    private static String[] getUserPaths(String[] stringArray) {
        String[] stringArray2 = new String[stringArray.length];
        String string = FirefoxBrowserUtils.getUserHome();
        if (string == null) {
            return null;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = string + stringArray[i];
        }
        return stringArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getUserHome() {
        String string = System.getProperty("user.home");
        if (!Utilities.isWindows()) {
            return string;
        }
        String string2 = string + File.separator + NbBundle.getMessage(FirefoxBrowserUtils.class, (String)"WIN32_APPDATA_FOLDER");
        BufferedReader bufferedReader = null;
        try {
            Process process = Runtime.getRuntime().exec(APPDATA_CMD);
            process.waitFor();
            InputStream inputStream = process.getInputStream();
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            while (true) {
                if (bufferedReader.ready()) {
                    String string3 = bufferedReader.readLine();
                    if (string3.trim().length() == 0) continue;
                    File file = new File(string3.trim());
                    if (!file.exists() || !file.isDirectory()) continue;
                    String string4 = file.getAbsolutePath();
                    return string4;
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            Log.getLogger().info("Unable to run process: cmd /c echo %AppData%");
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return string2;
    }

    protected static String getBrowserExecutable(HtmlBrowser.Factory factory) {
        if (factory != null) {
            try {
                Method method = factory.getClass().getMethod("getBrowserExecutable", new Class[0]);
                NbProcessDescriptor nbProcessDescriptor = (NbProcessDescriptor)method.invoke((Object)factory, new Object[0]);
                return nbProcessDescriptor.getProcessName();
            }
            catch (SecurityException securityException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        return null;
    }

    private static boolean isCompatibleFirefox(File file) {
        if (file == null && (file = FirefoxBrowserUtils.getDefaultProfile()) == null) {
            Log.getLogger().warning("Could not find Firefox profile data");
            return false;
        }
        File file2 = new File(file, "compatibility.ini");
        if (file2.exists() && file2.isFile() && file2.canRead()) {
            try {
                String string;
                BufferedReader bufferedReader = new BufferedReader(new FileReader(file2));
                while ((string = bufferedReader.readLine()) != null) {
                    if (!string.startsWith("LastVersion=")) continue;
                    string = string.substring(12);
                    return string.startsWith("2.0.0");
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                Log.getLogger().log(Level.INFO, "File not found: " + file2.getAbsolutePath());
            }
            catch (IOException iOException) {
                Log.getLogger().log(Level.INFO, "Error reading " + file2.getAbsolutePath());
            }
        }
        return false;
    }

    private static List<FirefoxProfile> getAllProfiles(File file) {
        File file2 = new File(file, "profiles.ini");
        try {
            Object object;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file2));
            ArrayList arrayList = new ArrayList();
            ArrayList<Object> arrayList2 = null;
            while (bufferedReader.ready()) {
                object = bufferedReader.readLine().trim();
                if (((String)object).startsWith("[") && ((String)object).endsWith("]")) {
                    if (arrayList2 != null) {
                        arrayList.add(arrayList2);
                    }
                    arrayList2 = new ArrayList<Object>();
                    arrayList2.add(object);
                    continue;
                }
                if (((String)object).indexOf(61) <= 0) continue;
                arrayList2.add(object);
            }
            if (arrayList2 != null && !arrayList.contains(arrayList2)) {
                arrayList.add(arrayList2);
            }
            object = new ArrayList();
            for (List list : arrayList) {
                if (list.size() == 0 || !((String)list.get(0)).startsWith("[")) continue;
                FirefoxProfile firefoxProfile = new FirefoxProfile();
                boolean bl = false;
                for (String string : list) {
                    int n = string.indexOf(61);
                    if (n <= 0 || n >= string.length() - 1) continue;
                    String string2 = string.substring(0, n);
                    String string3 = string.substring(n + 1, string.length());
                    if (string2.equals("Name")) {
                        bl = true;
                        continue;
                    }
                    if (string2.equals("IsRelative")) {
                        if (!string3.equals("1")) continue;
                        firefoxProfile.setRelative(true);
                        continue;
                    }
                    if (string2.equals("Path")) {
                        firefoxProfile.setPath(string3);
                        continue;
                    }
                    if (!string2.equals("Default") || !string3.equals("1")) continue;
                    firefoxProfile.setDefaultProfile(true);
                }
                if (!bl) continue;
                object.add(firefoxProfile);
            }
            return object;
        }
        catch (IOException iOException) {
            Log.getLogger().log(Level.WARNING, "Could not read Firefox profiles", iOException);
            return null;
        }
    }

    private static final class FirefoxProfile {
        private boolean relative = false;
        private boolean defaultProfile = false;
        private String path = "";

        public boolean isDefaultProfile() {
            return this.defaultProfile;
        }

        public void setDefaultProfile(boolean bl) {
            this.defaultProfile = bl;
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String string) {
            this.path = string;
        }

        public boolean isRelative() {
            return this.relative;
        }

        public void setRelative(boolean bl) {
            this.relative = bl;
        }
    }
}

