/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.parsing.impl.indexing;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.parsing.impl.indexing.FileObjectProvider;
import org.netbeans.modules.parsing.impl.indexing.IndexableImpl;
import org.netbeans.modules.parsing.impl.indexing.Util;
import org.openide.filesystems.FileObject;

public final class DeletedIndexable
implements IndexableImpl,
FileObjectProvider {
    private static final Logger LOG = Logger.getLogger(DeletedIndexable.class.getName());
    private final URL root;
    private final String relativePath;

    public DeletedIndexable(URL uRL, String string) {
        assert (uRL != null) : "root must not be null";
        assert (string != null) : "relativePath must not be null";
        assert (string.length() == 0 || string.charAt(0) != '/');
        this.root = uRL;
        this.relativePath = string;
    }

    public String getRelativePath() {
        return this.relativePath;
    }

    public URL getURL() {
        try {
            return Util.resolveUrl(this.root, this.relativePath);
        }
        catch (MalformedURLException malformedURLException) {
            LOG.log(Level.WARNING, null, malformedURLException);
            return null;
        }
    }

    public String getMimeType() {
        throw new UnsupportedOperationException("Mimetype related operations are not supported by DeletedIndexable");
    }

    public boolean isTypeOf(String string) {
        throw new UnsupportedOperationException("Mimetype related operations are not supported by DeletedIndexable");
    }

    public FileObject getFileObject() {
        return null;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        DeletedIndexable deletedIndexable = (DeletedIndexable)object;
        if (!(this.root == deletedIndexable.root || this.root != null && this.root.equals(deletedIndexable.root))) {
            return false;
        }
        return this.relativePath == deletedIndexable.relativePath || this.relativePath != null && this.relativePath.equals(deletedIndexable.relativePath);
    }

    public int hashCode() {
        int n = 7;
        n = 83 * n + (this.root != null ? this.root.hashCode() : 0);
        n = 83 * n + (this.relativePath != null ? this.relativePath.hashCode() : 0);
        return n;
    }

    public String toString() {
        return "DeletedIndexable@" + Integer.toHexString(System.identityHashCode(this)) + " [" + this.getURL() + "]";
    }
}

