/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.parsing.api.indexing;

import java.io.File;
import java.net.URL;
import java.util.Collection;
import java.util.concurrent.Callable;
import javax.swing.SwingUtilities;
import org.netbeans.modules.parsing.impl.Utilities;
import org.netbeans.modules.parsing.impl.event.EventSupport;
import org.netbeans.modules.parsing.impl.indexing.RepositoryUpdater;
import org.netbeans.modules.parsing.impl.indexing.friendapi.IndexingController;
import org.openide.filesystems.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IndexingManager {
    private static IndexingManager instance;

    public static synchronized IndexingManager getDefault() {
        if (instance == null) {
            instance = new IndexingManager();
        }
        return instance;
    }

    public boolean isIndexing() {
        return Utilities.isScanInProgress();
    }

    public void refreshIndex(URL uRL, Collection<? extends URL> collection) {
        this.refreshIndex(uRL, collection, true);
    }

    public void refreshIndex(URL uRL, Collection<? extends URL> collection, boolean bl) {
        RepositoryUpdater.getDefault().addIndexingJob(uRL, collection, false, false, false, bl, true);
    }

    public void refreshIndexAndWait(URL uRL, Collection<? extends URL> collection) {
        this.refreshIndexAndWait(uRL, collection, true);
    }

    public void refreshIndexAndWait(URL uRL, Collection<? extends URL> collection, boolean bl) {
        if (SwingUtilities.isEventDispatchThread()) {
            EventSupport.releaseCompletionCondition();
        }
        RepositoryUpdater.getDefault().addIndexingJob(uRL, collection, false, false, true, bl, false);
    }

    public void refreshAllIndices(String string) {
        if (string != null) {
            RepositoryUpdater.getDefault().addIndexingJob(string);
        } else {
            RepositoryUpdater.getDefault().refreshAll(true, false, false, new Object[0]);
        }
    }

    public void refreshAllIndices(FileObject ... fileObjectArray) {
        this.refreshAllIndices(true, false, fileObjectArray);
    }

    public void refreshAllIndices(boolean bl, boolean bl2, FileObject ... fileObjectArray) {
        RepositoryUpdater.getDefault().refreshAll(bl, bl2, false, fileObjectArray);
    }

    public void refreshAllIndices(boolean bl, boolean bl2, File ... fileArray) {
        RepositoryUpdater.getDefault().refreshAll(bl, bl2, false, fileArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T runProtected(Callable<T> callable) throws Exception {
        IndexingController.getDefault().enterProtectedMode();
        try {
            T t = callable.call();
            return t;
        }
        finally {
            IndexingController.getDefault().exitProtectedMode(null);
        }
    }

    private IndexingManager() {
        RepositoryUpdater.getDefault().start(false);
    }
}

