/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.tax.beans.customizer;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeEvent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.netbeans.modules.xml.tax.beans.Lib;
import org.netbeans.modules.xml.tax.beans.customizer.AbstractTreeCustomizer;
import org.netbeans.modules.xml.tax.beans.customizer.Util;
import org.netbeans.modules.xml.tax.util.TAXUtil;
import org.netbeans.tax.TreeAttribute;
import org.netbeans.tax.TreeElement;
import org.netbeans.tax.TreeException;

public class TreeAttributeCustomizer
extends AbstractTreeCustomizer {
    private static final long serialVersionUID = 7976099790445909386L;
    private volatile boolean askingDialog = false;
    private JLabel nameLabel;
    private JTextField nameField;
    private JLabel valueLabel;
    private JTextField valueField;

    public TreeAttributeCustomizer() {
        this.initComponents();
        this.nameLabel.setDisplayedMnemonic(Util.THIS.getChar("MNE_xmlName"));
        this.valueLabel.setDisplayedMnemonic(Util.THIS.getChar("MNE_xmlValue"));
    }

    protected final TreeAttribute getAttribute() {
        return (TreeAttribute)this.getTreeObject();
    }

    protected final void safePropertyChange(PropertyChangeEvent propertyChangeEvent) {
        super.safePropertyChange(propertyChangeEvent);
        if (propertyChangeEvent.getPropertyName().equals("name")) {
            this.updateNameComponent();
        } else if (propertyChangeEvent.getPropertyName().equals("value")) {
            this.updateValueComponent();
        }
    }

    protected final void updateAttributeName() {
        if (this.askingDialog) {
            return;
        }
        try {
            String string = this.nameField.getText();
            boolean bl = true;
            TreeElement treeElement = this.getAttribute().getOwnerElement();
            if (treeElement != null) {
                TreeAttribute treeAttribute = treeElement.getAttribute(string);
                if (this.getAttribute() != treeAttribute && treeAttribute != null) {
                    this.askingDialog = true;
                    bl = Lib.confirmAction(Util.THIS.getString("MSG_replace_attribute", string));
                    this.askingDialog = false;
                }
            }
            if (bl) {
                this.getAttribute().setQName(string);
            } else {
                this.updateNameComponent();
            }
        }
        catch (TreeException treeException) {
            this.updateNameComponent();
            TAXUtil.notifyTreeException(treeException);
        }
    }

    protected final void updateNameComponent() {
        this.nameField.setText(this.getAttribute().getQName());
    }

    protected final void updateAttributeValue() {
        try {
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("\nTreeAttributeCustomizer::updateAttributeValue: valueField.getText() = " + this.valueField.getText());
            }
            this.getAttribute().setValue(this.valueField.getText());
        }
        catch (TreeException treeException) {
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("                       ::updateAttributeValue: ex = " + treeException + "\n");
            }
            this.updateValueComponent();
            TAXUtil.notifyTreeException(treeException);
        }
    }

    protected final void updateValueComponent() {
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("\nTreeAttributeCustomizer::updateValueComponent: getAttribute().getValue() = " + this.getAttribute().getValue());
        }
        this.valueField.setText(this.getAttribute().getValue());
    }

    protected void initComponentValues() {
        this.updateNameComponent();
        this.updateValueComponent();
    }

    protected final void updateReadOnlyStatus(boolean bl) {
        this.nameField.setEditable(bl);
        this.valueField.setEditable(bl);
    }

    private void initComponents() {
        this.nameLabel = new JLabel();
        this.nameField = new JTextField();
        this.valueLabel = new JLabel();
        this.valueField = new JTextField();
        this.setLayout(new GridBagLayout());
        this.nameLabel.setText(Util.THIS.getString("PROP_xmlName"));
        this.nameLabel.setLabelFor(this.nameField);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.add((Component)this.nameLabel, gridBagConstraints);
        this.nameField.setColumns(20);
        this.nameField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TreeAttributeCustomizer.this.nameFieldActionPerformed(actionEvent);
            }
        });
        this.nameField.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                TreeAttributeCustomizer.this.nameFieldFocusGained(focusEvent);
            }

            public void focusLost(FocusEvent focusEvent) {
                TreeAttributeCustomizer.this.nameFieldFocusLost(focusEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 0, 11);
        this.add((Component)this.nameField, gridBagConstraints);
        this.valueLabel.setText(Util.THIS.getString("PROP_xmlValue"));
        this.valueLabel.setLabelFor(this.valueField);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.add((Component)this.valueLabel, gridBagConstraints);
        this.valueField.setColumns(20);
        this.valueField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TreeAttributeCustomizer.this.valueFieldActionPerformed(actionEvent);
            }
        });
        this.valueField.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                TreeAttributeCustomizer.this.valueFieldFocusGained(focusEvent);
            }

            public void focusLost(FocusEvent focusEvent) {
                TreeAttributeCustomizer.this.valueFieldFocusLost(focusEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 0, 11);
        this.add((Component)this.valueField, gridBagConstraints);
    }

    private void valueFieldFocusGained(FocusEvent focusEvent) {
        if ("new".equals(this.getClientProperty("xml-edit-mode"))) {
            this.valueField.selectAll();
        }
    }

    private void nameFieldFocusGained(FocusEvent focusEvent) {
        if ("new".equals(this.getClientProperty("xml-edit-mode"))) {
            this.nameField.selectAll();
        }
    }

    private void valueFieldFocusLost(FocusEvent focusEvent) {
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("TreeAttributeCustomizer::valueFieldFocusLost");
        }
        this.updateAttributeValue();
    }

    private void nameFieldFocusLost(FocusEvent focusEvent) {
        this.updateAttributeName();
    }

    private void valueFieldActionPerformed(ActionEvent actionEvent) {
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("TreeAttributeCustomizer::valueFieldActionPerformed");
        }
        this.updateAttributeValue();
    }

    private void nameFieldActionPerformed(ActionEvent actionEvent) {
        this.updateAttributeName();
    }
}

