/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.game.view;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.netbeans.modules.vmd.game.dialog.NewSceneDialog;
import org.netbeans.modules.vmd.game.model.GlobalRepository;
import org.netbeans.modules.vmd.game.model.GlobalRepositoryListener;
import org.netbeans.modules.vmd.game.model.ImageResource;
import org.netbeans.modules.vmd.game.model.Scene;
import org.netbeans.modules.vmd.game.model.Sprite;
import org.netbeans.modules.vmd.game.model.TiledLayer;
import org.netbeans.modules.vmd.game.nbdialog.SpriteDialog;
import org.netbeans.modules.vmd.game.nbdialog.TiledLayerDialog;
import org.netbeans.modules.vmd.game.view.ColorConstants;
import org.netbeans.modules.vmd.game.view.GameDesignPreviewComponent;
import org.netbeans.modules.vmd.game.view.ImagePreviewComponent;
import org.netbeans.modules.vmd.game.view.ScrollableFlowPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.NbBundle;

public class GameDesignOverViewPanel
extends ScrollableFlowPanel
implements ComponentListener {
    private GlobalRepository gameDesign;
    private JLabel labelTiledLayers;
    private JLabel labelSprites;
    private JLabel labelScenes;
    private ScrollableFlowPanel panelTiledLayers = new ScrollableFlowPanel();
    private ScrollableFlowPanel panelSprites = new ScrollableFlowPanel();
    private ScrollableFlowPanel panelScenes = new ScrollableFlowPanel();
    private Map<TiledLayer, GameDesignPreviewComponent> tiledLayerPreviews = new HashMap<TiledLayer, GameDesignPreviewComponent>();
    private Map<Sprite, GameDesignPreviewComponent> spritePreviews = new HashMap<Sprite, GameDesignPreviewComponent>();
    private Map<Scene, GameDesignPreviewComponent> scenePreviews = new HashMap<Scene, GameDesignPreviewComponent>();

    public GameDesignOverViewPanel(final GlobalRepository globalRepository) {
        this.gameDesign = globalRepository;
        this.gameDesign.addGlobalRepositoryListener(new GlobalRepositoryListener(){

            public void sceneAdded(Scene scene, int n) {
                GameDesignPreviewComponent gameDesignPreviewComponent = new GameDesignPreviewComponent(globalRepository, scene.getPreview(), scene.getName(), scene);
                GameDesignOverViewPanel.this.panelScenes.add((Component)gameDesignPreviewComponent, n);
                GameDesignOverViewPanel.this.panelScenes.revalidate();
                GameDesignOverViewPanel.this.panelScenes.repaint();
                GameDesignOverViewPanel.this.scenePreviews.put(scene, gameDesignPreviewComponent);
            }

            public void sceneRemoved(Scene scene, int n) {
                JComponent jComponent = (JComponent)GameDesignOverViewPanel.this.scenePreviews.remove(scene);
                if (jComponent != null) {
                    GameDesignOverViewPanel.this.panelScenes.remove(jComponent);
                    GameDesignOverViewPanel.this.panelScenes.revalidate();
                    GameDesignOverViewPanel.this.panelScenes.repaint();
                }
            }

            public void tiledLayerAdded(TiledLayer tiledLayer, int n) {
                GameDesignPreviewComponent gameDesignPreviewComponent = new GameDesignPreviewComponent(globalRepository, tiledLayer.getPreview(), tiledLayer.getName(), tiledLayer);
                GameDesignOverViewPanel.this.panelTiledLayers.add((Component)gameDesignPreviewComponent, n);
                GameDesignOverViewPanel.this.panelTiledLayers.revalidate();
                GameDesignOverViewPanel.this.panelTiledLayers.repaint();
                GameDesignOverViewPanel.this.tiledLayerPreviews.put(tiledLayer, gameDesignPreviewComponent);
            }

            public void tiledLayerRemoved(TiledLayer tiledLayer, int n) {
                JComponent jComponent = (JComponent)GameDesignOverViewPanel.this.tiledLayerPreviews.remove(tiledLayer);
                if (jComponent != null) {
                    GameDesignOverViewPanel.this.panelTiledLayers.remove(jComponent);
                    GameDesignOverViewPanel.this.panelTiledLayers.revalidate();
                    GameDesignOverViewPanel.this.panelTiledLayers.repaint();
                }
            }

            public void spriteAdded(Sprite sprite, int n) {
                ImagePreviewComponent imagePreviewComponent = new ImagePreviewComponent(true);
                imagePreviewComponent.setPreviewable(sprite.getDefaultSequence().getFrame(0));
                GameDesignPreviewComponent gameDesignPreviewComponent = new GameDesignPreviewComponent(globalRepository, imagePreviewComponent, sprite.getName(), sprite);
                GameDesignOverViewPanel.this.panelSprites.add((Component)gameDesignPreviewComponent, n);
                GameDesignOverViewPanel.this.panelSprites.revalidate();
                GameDesignOverViewPanel.this.panelSprites.repaint();
                GameDesignOverViewPanel.this.spritePreviews.put(sprite, gameDesignPreviewComponent);
            }

            public void spriteRemoved(Sprite sprite, int n) {
                JComponent jComponent = (JComponent)GameDesignOverViewPanel.this.spritePreviews.remove(sprite);
                if (jComponent != null) {
                    GameDesignOverViewPanel.this.panelSprites.remove(jComponent);
                    GameDesignOverViewPanel.this.panelSprites.revalidate();
                    GameDesignOverViewPanel.this.panelSprites.repaint();
                }
            }

            public void imageResourceAdded(ImageResource imageResource) {
            }
        });
        this.manualInit();
        this.addComponentListener(this);
        this.putClientProperty("print.printable", Boolean.TRUE);
    }

    private void manualInit() {
        this.setBackground(ColorConstants.COLOR_EDITOR_PANEL);
        this.panelTiledLayers.setBackground(ColorConstants.COLOR_EDITOR_PANEL);
        this.panelSprites.setBackground(ColorConstants.COLOR_EDITOR_PANEL);
        this.panelScenes.setBackground(ColorConstants.COLOR_EDITOR_PANEL);
        ((FlowLayout)this.getLayout()).setAlignment(0);
        ((FlowLayout)this.panelTiledLayers.getLayout()).setAlignment(0);
        ((FlowLayout)this.panelSprites.getLayout()).setAlignment(0);
        ((FlowLayout)this.panelScenes.getLayout()).setAlignment(0);
        this.labelScenes = new JLabel(NbBundle.getMessage(GameDesignOverViewPanel.class, (String)"GameDesignOverViewPanel.labelScenes.txt"));
        this.labelScenes.setFont(new Font("Dialog", 1, this.labelScenes.getFont().getSize() + 7));
        this.labelScenes.setForeground(ColorConstants.COLOR_TEXT_PLAIN);
        this.labelScenes.setHorizontalAlignment(2);
        this.add(this.labelScenes);
        this.add(this.panelScenes);
        this.labelTiledLayers = new JLabel(NbBundle.getMessage(GameDesignOverViewPanel.class, (String)"GameDesignOverViewPanel.labelTiledLayers.txt"));
        this.labelTiledLayers.setFont(new Font("Dialog", 1, this.labelTiledLayers.getFont().getSize() + 7));
        this.labelTiledLayers.setForeground(new Color(163, 184, 215));
        this.labelTiledLayers.setHorizontalAlignment(2);
        this.add(this.labelTiledLayers);
        this.add(this.panelTiledLayers);
        this.labelSprites = new JLabel(NbBundle.getMessage(GameDesignOverViewPanel.class, (String)"GameDesignOverViewPanel.labelSprites.txt"));
        this.labelSprites.setFont(new Font("Dialog", 1, this.labelSprites.getFont().getSize() + 7));
        this.labelSprites.setForeground(ColorConstants.COLOR_TEXT_PLAIN);
        this.labelSprites.setHorizontalAlignment(2);
        this.add(this.labelSprites);
        this.add(this.panelSprites);
        this.populateScenePreviewList(this.panelScenes);
        this.populateTiledLayerPreviewList(this.panelTiledLayers);
        this.populateSpritePreviewList(this.panelSprites);
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(GameDesignOverViewPanel.class, (String)"GameDesignOverViewPanel.accessible.name"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GameDesignOverViewPanel.class, (String)"GameDesignOverViewPanel.accessible.description"));
    }

    private void populateTiledLayerPreviewList(JComponent jComponent) {
        List<TiledLayer> list = this.gameDesign.getTiledLayers();
        for (TiledLayer tiledLayer : list) {
            GameDesignPreviewComponent gameDesignPreviewComponent = new GameDesignPreviewComponent(this.gameDesign, tiledLayer.getPreview(), tiledLayer.getName(), tiledLayer);
            jComponent.add(gameDesignPreviewComponent);
            this.tiledLayerPreviews.put(tiledLayer, gameDesignPreviewComponent);
        }
        final JLabel jLabel = new JLabel(NbBundle.getMessage(GameDesignOverViewPanel.class, (String)"GameDesignOverViewPanel.labelNewTiledLayer.txt"));
        jLabel.setPreferredSize(new Dimension(jLabel.getPreferredSize().width + 15, 40));
        jLabel.setForeground(new Color(100, 123, 156));
        jLabel.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent mouseEvent) {
                jLabel.setFont(jLabel.getFont().deriveFont(1));
            }

            public void mouseExited(MouseEvent mouseEvent) {
                jLabel.setFont(jLabel.getFont().deriveFont(0));
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                TiledLayerDialog tiledLayerDialog = new TiledLayerDialog(GameDesignOverViewPanel.this.gameDesign);
                DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)tiledLayerDialog, NbBundle.getMessage(GameDesignOverViewPanel.class, (String)"GameDesignOverViewPanel.dialogNewTiledLayer.txt"));
                dialogDescriptor.setButtonListener((ActionListener)tiledLayerDialog);
                dialogDescriptor.setValid(false);
                tiledLayerDialog.setDialogDescriptor(dialogDescriptor);
                Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
                dialog.setVisible(true);
            }
        });
        jComponent.add(jLabel);
    }

    private void populateSpritePreviewList(JComponent jComponent) {
        List<Sprite> list = this.gameDesign.getSprites();
        for (Sprite sprite : list) {
            ImagePreviewComponent imagePreviewComponent = new ImagePreviewComponent(true);
            imagePreviewComponent.setPreviewable(sprite.getDefaultSequence().getFrame(0));
            GameDesignPreviewComponent gameDesignPreviewComponent = new GameDesignPreviewComponent(this.gameDesign, imagePreviewComponent, sprite.getName(), sprite);
            jComponent.add(gameDesignPreviewComponent);
            this.spritePreviews.put(sprite, gameDesignPreviewComponent);
        }
        final JLabel jLabel = new JLabel(NbBundle.getMessage(GameDesignOverViewPanel.class, (String)"GameDesignOverViewPanel.labelNewSprite.txt"));
        jLabel.setPreferredSize(new Dimension(jLabel.getPreferredSize().width + 15, 40));
        jLabel.setForeground(new Color(100, 123, 156));
        jLabel.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent mouseEvent) {
                jLabel.setFont(jLabel.getFont().deriveFont(1));
            }

            public void mouseExited(MouseEvent mouseEvent) {
                jLabel.setFont(jLabel.getFont().deriveFont(0));
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                SpriteDialog spriteDialog = new SpriteDialog(GameDesignOverViewPanel.this.gameDesign);
                DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)spriteDialog, NbBundle.getMessage(GameDesignOverViewPanel.class, (String)"GameDesignOverViewPanel.dialogNewSprite.txt"));
                dialogDescriptor.setButtonListener((ActionListener)spriteDialog);
                dialogDescriptor.setValid(false);
                spriteDialog.setDialogDescriptor(dialogDescriptor);
                Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
                dialog.setVisible(true);
            }
        });
        jComponent.add(jLabel);
    }

    private void populateScenePreviewList(JComponent jComponent) {
        List<Scene> list = this.gameDesign.getScenes();
        for (Scene scene : list) {
            GameDesignPreviewComponent gameDesignPreviewComponent = new GameDesignPreviewComponent(this.gameDesign, scene.getPreview(), scene.getName(), scene);
            jComponent.add(gameDesignPreviewComponent);
            this.scenePreviews.put(scene, gameDesignPreviewComponent);
        }
        final JLabel jLabel = new JLabel(NbBundle.getMessage(GameDesignOverViewPanel.class, (String)"GameDesignOverViewPanel.labelNewScene.txt"));
        jLabel.setPreferredSize(new Dimension(jLabel.getPreferredSize().width + 15, 40));
        jLabel.setForeground(new Color(100, 123, 156));
        jLabel.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent mouseEvent) {
                jLabel.setFont(jLabel.getFont().deriveFont(1));
            }

            public void mouseExited(MouseEvent mouseEvent) {
                jLabel.setFont(jLabel.getFont().deriveFont(0));
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                NewSceneDialog newSceneDialog = new NewSceneDialog(GameDesignOverViewPanel.this.gameDesign);
                DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)newSceneDialog, NbBundle.getMessage(GameDesignOverViewPanel.class, (String)"GameDesignOverViewPanel.dialogNewScene.txt"));
                dialogDescriptor.setButtonListener((ActionListener)newSceneDialog);
                dialogDescriptor.setValid(false);
                newSceneDialog.setDialogDescriptor(dialogDescriptor);
                Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
                dialog.setVisible(true);
            }
        });
        jComponent.add(jLabel);
    }

    private void resizeLabels() {
        Dimension dimension = this.labelTiledLayers.getPreferredSize();
        this.labelTiledLayers.setPreferredSize(new Dimension(this.getWidth(), dimension.getSize().height));
        dimension = this.labelSprites.getPreferredSize();
        this.labelSprites.setPreferredSize(new Dimension(this.getWidth(), dimension.getSize().height));
        dimension = this.labelScenes.getPreferredSize();
        this.labelScenes.setPreferredSize(new Dimension(this.getWidth(), dimension.getSize().height));
    }

    public void componentResized(ComponentEvent componentEvent) {
        this.resizeLabels();
    }

    public void componentMoved(ComponentEvent componentEvent) {
        this.resizeLabels();
    }

    public void componentShown(ComponentEvent componentEvent) {
        this.resizeLabels();
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }
}

