/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.monitor.client;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.netbeans.modules.web.monitor.client.DisplayTable;
import org.netbeans.modules.web.monitor.client.SortButton;
import org.netbeans.modules.web.monitor.data.Param;
import org.openide.awt.Mnemonics;

public abstract class DataDisplay
extends JPanel {
    static final Insets zeroInsets = new Insets(0, 0, 0, 0);
    static final Insets tableInsets = new Insets(0, 18, 12, 12);
    static final Insets labelInsets = new Insets(0, 6, 0, 0);
    static final Insets buttonInsets = new Insets(6, 0, 5, 6);
    static final Insets sortButtonInsets = new Insets(0, 12, 0, 0);
    static final Insets indentInsets = new Insets(0, 18, 0, 0);
    static final Insets topSpacerInsets = new Insets(12, 0, 0, 0);
    static final int fullGridWidth = 0;
    static final double tableWeightX = 1.0;
    static final double tableWeightY = 0.0;

    public DataDisplay() {
        this.setLayout(new GridBagLayout());
    }

    void addGridBagComponent(Container container, Component component, int n, int n2, int n3, int n4, double d, double d2, int n5, int n6, Insets insets, int n7, int n8) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.weightx = d;
        gridBagConstraints.weighty = d2;
        gridBagConstraints.anchor = n5;
        gridBagConstraints.fill = n6;
        gridBagConstraints.insets = insets;
        gridBagConstraints.ipadx = n7;
        gridBagConstraints.ipady = n8;
        container.add(component, gridBagConstraints);
    }

    static JButton createSortButton(DisplayTable displayTable) {
        SortButton sortButton = new SortButton(displayTable);
        return sortButton;
    }

    static Component createTopSpacer() {
        return Box.createVerticalStrut(1);
    }

    static Component createRigidArea() {
        return Box.createRigidArea(new Dimension(0, 5));
    }

    static Component createGlue() {
        return Box.createGlue();
    }

    static JLabel createHeaderLabel(String string) {
        return DataDisplay.createHeaderLabel(string, null, null);
    }

    static JLabel createHeaderLabel(String string, String string2, Component component) {
        JLabel jLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)jLabel, (String)string);
        Font font = jLabel.getFont();
        Font font2 = font.deriveFont(1);
        jLabel.setFont(font2);
        if (string2 != null) {
            jLabel.getAccessibleContext().setAccessibleDescription(string2);
        }
        if (component != null) {
            jLabel.setLabelFor(component);
        }
        return jLabel;
    }

    static JLabel createDataLabel(String string) {
        JLabel jLabel = new JLabel(string);
        return jLabel;
    }

    static Component createSortButtonLabel(String string, DisplayTable displayTable, String string2) {
        JPanel jPanel = new JPanel();
        jPanel.add(DataDisplay.createHeaderLabel(string, string2, displayTable));
        jPanel.add(DataDisplay.createSortButton(displayTable));
        return jPanel;
    }

    void log(String string) {
        System.out.println("DataDisplay::" + string);
    }

    Param findParam(Param[] paramArray, String string, String string2) {
        for (int i = 0; i < paramArray.length; ++i) {
            Param param = paramArray[i];
            if (!string.equals(param.getName()) || !string2.equals(param.getValue())) continue;
            return param;
        }
        return null;
    }
}

