/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.queries;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.maven.project.MavenProject;
import org.netbeans.api.java.queries.BinaryForSourceQuery;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.spi.java.queries.BinaryForSourceQueryImplementation;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

public class MavenBinaryForSourceQueryImpl
implements BinaryForSourceQueryImplementation {
    private final NbMavenProjectImpl project;
    private HashMap<URL, Res> results;

    public MavenBinaryForSourceQueryImpl(NbMavenProjectImpl nbMavenProjectImpl) {
        this.project = nbMavenProjectImpl;
        this.results = new HashMap();
    }

    public BinaryForSourceQuery.Result findBinaryRoots(URL uRL) {
        if (this.results.containsKey(uRL)) {
            return this.results.get(uRL);
        }
        if ("file".equals(uRL.getProtocol())) {
            try {
                Res res = null;
                File file = new File(uRL.toURI());
                file = FileUtil.normalizeFile((File)file);
                MavenProject mavenProject = this.project.getOriginalMavenProject();
                String string = mavenProject.getBuild() != null ? mavenProject.getBuild().getSourceDirectory() : null;
                String string2 = mavenProject.getBuild() != null ? mavenProject.getBuild().getTestSourceDirectory() : null;
                File file2 = string != null ? FileUtil.normalizeFile((File)new File(string)) : null;
                File file3 = string2 != null ? FileUtil.normalizeFile((File)new File(string2)) : null;
                res = this.checkRoot(file, file2, file3);
                if (res == null) {
                    URI uRI;
                    URI[] uRIArray;
                    URI[] uRIArray2 = uRIArray = this.project.getGeneratedSourceRoots();
                    int n = uRIArray2.length;
                    for (int i = 0; i < n && (res = this.checkRoot(file, uRI = uRIArray2[i], null)) == null; ++i) {
                    }
                }
                if (res == null) {
                    res = this.checkRoot(file, this.project.getScalaDirectory(false), this.project.getScalaDirectory(true));
                }
                if (res == null) {
                    res = this.checkRoot(file, this.project.getGroovyDirectory(false), this.project.getGroovyDirectory(true));
                }
                if (res != null) {
                    this.results.put(uRL, res);
                }
                return res;
            }
            catch (URISyntaxException uRISyntaxException) {
                Exceptions.printStackTrace((Throwable)uRISyntaxException);
            }
        }
        return null;
    }

    private Res checkRoot(File file, File file2, File file3) {
        if (file2 != null && file2.equals(file)) {
            return new Res(false, this.project);
        }
        if (file3 != null && file3.equals(file)) {
            return new Res(true, this.project);
        }
        return null;
    }

    private Res checkRoot(File file, URI uRI, URI uRI2) {
        return this.checkRoot(file, uRI != null ? FileUtil.normalizeFile((File)new File(uRI)) : null, uRI2 != null ? FileUtil.normalizeFile((File)new File(uRI2)) : null);
    }

    private static class Res
    implements BinaryForSourceQuery.Result {
        private final List<ChangeListener> listeners = new ArrayList<ChangeListener>();
        private NbMavenProjectImpl project;
        private boolean isTest;

        Res(boolean bl, NbMavenProjectImpl nbMavenProjectImpl) {
            this.isTest = bl;
            this.project = nbMavenProjectImpl;
        }

        public URL[] getRoots() {
            try {
                String string = this.isTest ? this.project.getOriginalMavenProject().getBuild().getTestOutputDirectory() : this.project.getOriginalMavenProject().getBuild().getOutputDirectory();
                File file = FileUtil.normalizeFile((File)new File(string));
                return new URL[]{file.toURI().toURL()};
            }
            catch (MalformedURLException malformedURLException) {
                Exceptions.printStackTrace((Throwable)malformedURLException);
                return new URL[0];
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addChangeListener(ChangeListener changeListener) {
            List<ChangeListener> list = this.listeners;
            synchronized (list) {
                this.listeners.add(changeListener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeChangeListener(ChangeListener changeListener) {
            List<ChangeListener> list = this.listeners;
            synchronized (list) {
                this.listeners.remove(changeListener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void fireChanged() {
            ArrayList<ChangeListener> arrayList = new ArrayList<ChangeListener>();
            List<ChangeListener> list = this.listeners;
            synchronized (list) {
                arrayList.addAll(this.listeners);
            }
            for (ChangeListener changeListener : arrayList) {
                changeListener.stateChanged(new ChangeEvent(this));
            }
        }
    }
}

