/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.grails.api;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.platform.Specification;
import org.netbeans.api.project.Project;
import org.netbeans.modules.groovy.grails.api.GrailsEnvironment;
import org.netbeans.modules.groovy.grails.api.GrailsPlatform;
import org.netbeans.modules.groovy.grails.settings.GrailsSettings;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.WeakListeners;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GrailsProjectConfig {
    public static final String GRAILS_PORT_PROPERTY = "grails.port";
    public static final String GRAILS_ENVIRONMENT_PROPERTY = "grails.environment";
    public static final String GRAILS_JAVA_PLATFORM_PROPERTY = "grails.java.platform";
    public static final String GRAILS_PLATFORM_PROPERTY = "grails.platform";
    public static final String GRAILS_DEBUG_BROWSER_PROPERTY = "grails.debug.browser";
    public static final String GRAILS_DISPLAY_BROWSER_PROPERTY = "grails.display.browser";
    public static final String GRAILS_PROJECT_PLUGINS_DIR_PROPERTY = "grails.project.plugins.dir";
    public static final String GRAILS_GLOBAL_PLUGINS_DIR_PROPERTY = "grails.global.plugins.dir";
    public static final String GRAILS_LOCAL_PLUGINS_PROPERTY = "grails.local.plugins";
    public static final String GRAILS_VM_OPTIONS_PROPERTY = "grails.vm.options";
    private static final String DEFAULT_PORT = "8080";
    private static final JavaPlatformManager PLATFORM_MANAGER = JavaPlatformManager.getDefault();
    private final Project prj;
    private final GrailsSettings settings = GrailsSettings.getInstance();
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private final PlatformChangeListener platformChangeListener = new PlatformChangeListener(this.propertyChangeSupport);

    public GrailsProjectConfig(Project project) {
        this.prj = project;
    }

    public void initListeners() {
        GrailsPlatform grailsPlatform = GrailsPlatform.getDefault();
        grailsPlatform.addChangeListener(WeakListeners.change((ChangeListener)this.platformChangeListener, (Object)grailsPlatform));
    }

    public static GrailsProjectConfig forProject(Project project) {
        GrailsProjectConfig grailsProjectConfig = (GrailsProjectConfig)project.getLookup().lookup(GrailsProjectConfig.class);
        return grailsProjectConfig;
    }

    public Project getProject() {
        return this.prj;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPort() {
        GrailsSettings grailsSettings = this.settings;
        synchronized (grailsSettings) {
            String string = this.settings.getPortForProject(this.prj);
            if (string == null) {
                string = DEFAULT_PORT;
            }
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPort(String string) {
        String string2;
        assert (string != null);
        GrailsSettings grailsSettings = this.settings;
        synchronized (grailsSettings) {
            string2 = this.getPort();
            this.settings.setPortForProject(this.prj, string);
        }
        this.propertyChangeSupport.firePropertyChange(GRAILS_PORT_PROPERTY, string2, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getVmOptions() {
        GrailsSettings grailsSettings = this.settings;
        synchronized (grailsSettings) {
            String string = this.settings.getVmOptionsForProject(this.prj);
            if (string == null) {
                string = "";
            }
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVmOptions(String string) {
        String string2;
        assert (string != null);
        GrailsSettings grailsSettings = this.settings;
        synchronized (grailsSettings) {
            string2 = this.getPort();
            this.settings.setVmOptionsForProject(this.prj, string);
        }
        this.propertyChangeSupport.firePropertyChange(GRAILS_VM_OPTIONS_PROPERTY, string2, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GrailsEnvironment getEnvironment() {
        GrailsSettings grailsSettings = this.settings;
        synchronized (grailsSettings) {
            return this.settings.getEnvForProject(this.prj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEnvironment(GrailsEnvironment grailsEnvironment) {
        GrailsEnvironment grailsEnvironment2;
        assert (grailsEnvironment != null);
        GrailsSettings grailsSettings = this.settings;
        synchronized (grailsSettings) {
            grailsEnvironment2 = this.getEnvironment();
            this.settings.setEnvForProject(this.prj, grailsEnvironment);
        }
        this.propertyChangeSupport.firePropertyChange(GRAILS_ENVIRONMENT_PROPERTY, grailsEnvironment2, grailsEnvironment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDebugBrowser() {
        GrailsSettings grailsSettings = this.settings;
        synchronized (grailsSettings) {
            return this.settings.getDebugBrowserForProject(this.prj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDebugBrowser(String string) {
        String string2;
        assert (string != null);
        GrailsSettings grailsSettings = this.settings;
        synchronized (grailsSettings) {
            string2 = this.getDebugBrowser();
            this.settings.setDebugBrowserProject(this.prj, string);
        }
        this.propertyChangeSupport.firePropertyChange(GRAILS_DEBUG_BROWSER_PROPERTY, string2, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JavaPlatform getJavaPlatform() {
        JavaPlatform[] javaPlatformArray = this.settings;
        synchronized (this.settings) {
            String string = this.settings.getJavaPlatformForProject(this.prj);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            if (string == null) {
                return JavaPlatform.getDefault();
            }
            for (JavaPlatform javaPlatform : javaPlatformArray = PLATFORM_MANAGER.getPlatforms(null, new Specification("j2se", null))) {
                String string2;
                if (javaPlatform.getInstallFolders().size() <= 0 || !string.equals(string2 = (String)javaPlatform.getProperties().get("platform.ant.name"))) continue;
                return javaPlatform;
            }
            return JavaPlatform.getDefault();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setJavaPlatform(JavaPlatform javaPlatform) {
        JavaPlatform javaPlatform2;
        assert (javaPlatform != null);
        GrailsSettings grailsSettings = this.settings;
        synchronized (grailsSettings) {
            javaPlatform2 = this.getJavaPlatform();
            this.settings.setJavaPlatformForProject(this.prj, (String)javaPlatform.getProperties().get("platform.ant.name"));
        }
        this.propertyChangeSupport.firePropertyChange(GRAILS_JAVA_PLATFORM_PROPERTY, javaPlatform2, javaPlatform);
    }

    public GrailsPlatform getGrailsPlatform() {
        GrailsPlatform grailsPlatform = GrailsPlatform.getDefault();
        return grailsPlatform;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getDisplayBrowser() {
        GrailsSettings grailsSettings = this.settings;
        synchronized (grailsSettings) {
            return this.settings.getDisplayBrowserForProject(this.prj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDisplayBrowser(boolean bl) {
        boolean bl2;
        GrailsProjectConfig grailsProjectConfig = this;
        synchronized (grailsProjectConfig) {
            bl2 = this.getDisplayBrowser();
            this.settings.setDisplayBrowserForProject(this.prj, bl);
        }
        this.propertyChangeSupport.firePropertyChange(GRAILS_DISPLAY_BROWSER_PROPERTY, bl2, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getProjectPluginsDir() {
        GrailsSettings grailsSettings = this.settings;
        synchronized (grailsSettings) {
            String string = this.settings.getProjectPluginsDirForProject(this.prj);
            if (string != null) {
                return new File(string);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProjectPluginsDir(File file) {
        File file2;
        assert (FileUtil.normalizeFile((File)file).equals(file));
        GrailsProjectConfig grailsProjectConfig = this;
        synchronized (grailsProjectConfig) {
            file2 = this.getProjectPluginsDir();
            this.settings.setProjectPluginsDirForProject(this.prj, file.getAbsolutePath());
        }
        this.propertyChangeSupport.firePropertyChange(GRAILS_PROJECT_PLUGINS_DIR_PROPERTY, file2, file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getGlobalPluginsDir() {
        GrailsSettings grailsSettings = this.settings;
        synchronized (grailsSettings) {
            String string = this.settings.getGlobalPluginsDirForProject(this.prj);
            if (string != null) {
                return new File(string);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGlobalPluginsDir(File file) {
        File file2;
        assert (FileUtil.normalizeFile((File)file).equals(file));
        GrailsProjectConfig grailsProjectConfig = this;
        synchronized (grailsProjectConfig) {
            file2 = this.getGlobalPluginsDir();
            this.settings.setGlobalPluginsDirForProject(this.prj, file.getAbsolutePath());
        }
        this.propertyChangeSupport.firePropertyChange(GRAILS_GLOBAL_PLUGINS_DIR_PROPERTY, file2, file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, File> getLocalPlugins() {
        GrailsSettings grailsSettings = this.settings;
        synchronized (grailsSettings) {
            Map<String, String> map = this.settings.getLocalPluginsForProject(this.prj);
            if (map != null) {
                File file = FileUtil.toFile((FileObject)this.prj.getProjectDirectory());
                HashMap<String, File> hashMap = new HashMap<String, File>();
                for (Map.Entry<String, String> entry : map.entrySet()) {
                    File file2 = new File(entry.getValue());
                    if (!file2.isAbsolute()) {
                        file2 = new File(file, entry.getValue());
                    }
                    hashMap.put(entry.getKey(), file2);
                }
                return hashMap;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLocalPlugins(Map<String, File> map) {
        Map<String, File> map2;
        boolean bl = false;
        GrailsProjectConfig grailsProjectConfig = this;
        synchronized (grailsProjectConfig) {
            map2 = this.getLocalPlugins();
            HashMap<String, String> hashMap = new HashMap<String, String>();
            for (Map.Entry<String, File> entry : map.entrySet()) {
                hashMap.put(entry.getKey(), entry.getValue().getAbsolutePath());
                File file = map2.remove(entry.getKey());
                if (file != null && file.equals(entry.getValue())) continue;
                bl = true;
            }
            this.settings.setLocalPluginsForProject(this.prj, hashMap);
        }
        if (bl || !map2.isEmpty()) {
            this.propertyChangeSupport.firePropertyChange(GRAILS_LOCAL_PLUGINS_PROPERTY, map2, map);
        }
    }

    private static class PlatformChangeListener
    implements ChangeListener {
        private final PropertyChangeSupport propertyChangeSupport;

        public PlatformChangeListener(PropertyChangeSupport propertyChangeSupport) {
            this.propertyChangeSupport = propertyChangeSupport;
        }

        public void stateChanged(ChangeEvent changeEvent) {
            this.propertyChangeSupport.firePropertyChange(GrailsProjectConfig.GRAILS_PLATFORM_PROPERTY, null, null);
        }
    }
}

