/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.dd.impl.common.annotation;

import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.netbeans.modules.j2ee.dd.api.common.EjbLocalRef;
import org.netbeans.modules.j2ee.dd.api.common.EjbRef;
import org.netbeans.modules.j2ee.dd.impl.common.annotation.EjbLocalRefImpl;
import org.netbeans.modules.j2ee.dd.impl.common.annotation.EjbRefImpl;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.AnnotationHandler;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.AnnotationModelHelper;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.parser.AnnotationParser;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.parser.ArrayValueHandler;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.parser.ParseResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EjbRefHelper {
    private static final String EJB_ANN = "javax.ejb.EJB";
    private static final String EJBS_ANN = "javax.ejb.EJBs";

    private EjbRefHelper() {
    }

    public static void setEjbRefs(final AnnotationModelHelper annotationModelHelper, final List<EjbRef> list, final List<EjbLocalRef> list2) {
        try {
            annotationModelHelper.getAnnotationScanner().findAnnotations(EJBS_ANN, EnumSet.of(ElementKind.CLASS), new AnnotationHandler(){

                public void handleAnnotation(TypeElement typeElement, Element element, AnnotationMirror annotationMirror) {
                    EjbRefHelper.parseEJBsAnnotation(annotationModelHelper, typeElement, list, list2);
                }
            });
            annotationModelHelper.getAnnotationScanner().findAnnotations(EJB_ANN, EnumSet.of(ElementKind.CLASS, ElementKind.METHOD, ElementKind.FIELD), new AnnotationHandler(){

                public void handleAnnotation(TypeElement typeElement, Element element, AnnotationMirror annotationMirror) {
                    EjbRefHelper.parseElement(annotationModelHelper, typeElement, element, list, list2);
                }
            });
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void setEjbRefsForClass(AnnotationModelHelper annotationModelHelper, TypeElement typeElement, List<EjbRef> list, List<EjbLocalRef> list2) {
        assert (annotationModelHelper != null);
        assert (list != null);
        assert (list2 != null);
        EjbRefHelper.parseEJBsAnnotation(annotationModelHelper, typeElement, list, list2);
        if (annotationModelHelper.hasAnnotation(typeElement.getAnnotationMirrors(), EJB_ANN)) {
            EjbRefHelper.parseElement(annotationModelHelper, typeElement, typeElement, list, list2);
        }
        for (VariableElement element : ElementFilter.fieldsIn(typeElement.getEnclosedElements())) {
            if (!annotationModelHelper.hasAnnotation(element.getAnnotationMirrors(), EJB_ANN)) continue;
            EjbRefHelper.parseElement(annotationModelHelper, typeElement, element, list, list2);
        }
        for (ExecutableElement executableElement : ElementFilter.methodsIn(typeElement.getEnclosedElements())) {
            if (!annotationModelHelper.hasAnnotation(executableElement.getAnnotationMirrors(), EJB_ANN)) continue;
            EjbRefHelper.parseElement(annotationModelHelper, typeElement, executableElement, list, list2);
        }
    }

    private static void parseEJBsAnnotation(final AnnotationModelHelper annotationModelHelper, TypeElement typeElement, final List<EjbRef> list, final List<EjbLocalRef> list2) {
        Map map = annotationModelHelper.getAnnotationsByType(typeElement.getAnnotationMirrors());
        AnnotationMirror annotationMirror = (AnnotationMirror)map.get(EJBS_ANN);
        AnnotationParser annotationParser = AnnotationParser.create((AnnotationModelHelper)annotationModelHelper);
        annotationParser.expectAnnotationArray("value", annotationModelHelper.resolveType(EJB_ANN), new ArrayValueHandler(){

            public Object handleArray(List<AnnotationValue> list3) {
                for (AnnotationValue annotationValue : list3) {
                    Object object = annotationValue.getValue();
                    if (!(object instanceof AnnotationMirror)) continue;
                    EjbRefHelper.parseAnnotation(annotationModelHelper, (AnnotationMirror)object, list, list2);
                }
                return null;
            }
        }, null);
        annotationParser.parse(annotationMirror);
    }

    private static void parseElement(AnnotationModelHelper annotationModelHelper, TypeElement typeElement, Element element, List<EjbRef> list, List<EjbLocalRef> list2) {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        TypeElement typeElement2 = null;
        Map map = annotationModelHelper.getAnnotationsByType(element.getAnnotationMirrors());
        if (ElementKind.CLASS == element.getKind()) {
            AnnotationParser annotationParser = AnnotationParser.create((AnnotationModelHelper)annotationModelHelper);
            annotationParser.expectString("name", null);
            annotationParser.expectClass("beanInterface", null);
            annotationParser.expectString("beanName", null);
            annotationParser.expectString("mappedName", null);
            annotationParser.expectString("description", null);
            ParseResult parseResult = annotationParser.parse((AnnotationMirror)map.get(EJB_ANN));
            string = (String)parseResult.get("name", String.class);
            string2 = (String)parseResult.get("beanInterface", String.class);
            string3 = (String)parseResult.get("beanName", String.class);
            string4 = (String)parseResult.get("mappedName", String.class);
            string5 = (String)parseResult.get("description", String.class);
            if (string2 != null) {
                typeElement2 = annotationModelHelper.getCompilationController().getElements().getTypeElement(string2);
            }
        } else if (ElementKind.FIELD == element.getKind() || ElementKind.METHOD == element.getKind()) {
            Element element2;
            Object object;
            TypeMirror typeMirror = element.asType();
            AnnotationParser annotationParser = AnnotationParser.create((AnnotationModelHelper)annotationModelHelper);
            if (ElementKind.METHOD == element.getKind()) {
                object = element.getSimpleName().toString();
                object = Character.toLowerCase(((String)object).charAt(3)) + ((String)object).substring(4);
                annotationParser.expectString("name", AnnotationParser.defaultValue((Object)("java:comp/env/" + typeElement.getQualifiedName() + '/' + (String)object)));
                if (!element.getSimpleName().toString().startsWith("set")) {
                    return;
                }
                element2 = (ExecutableElement)element;
                List<? extends VariableElement> list3 = element2.getParameters();
                if (list3.size() != 1) {
                    return;
                }
                typeMirror = list3.get(0).asType();
            } else {
                annotationParser.expectString("name", AnnotationParser.defaultValue((Object)("java:comp/env/" + typeElement.getQualifiedName() + '/' + element.getSimpleName())));
            }
            if (TypeKind.DECLARED == typeMirror.getKind() && ElementKind.INTERFACE == (element2 = (object = (DeclaredType)typeMirror).asElement()).getKind()) {
                typeElement2 = (TypeElement)element2;
                string2 = typeElement2.getQualifiedName().toString();
            }
            object = annotationParser.parse((AnnotationMirror)map.get(EJB_ANN));
            string = (String)object.get("name", String.class);
        } else {
            return;
        }
        if (typeElement2 != null) {
            EjbRefHelper.createReference(annotationModelHelper, typeElement2, list, list2, string, string2, string3, string4, string5);
        }
    }

    private static void parseAnnotation(AnnotationModelHelper annotationModelHelper, AnnotationMirror annotationMirror, List<EjbRef> list, List<EjbLocalRef> list2) {
        AnnotationParser annotationParser = AnnotationParser.create((AnnotationModelHelper)annotationModelHelper);
        annotationParser.expectString("name", null);
        annotationParser.expectClass("beanInterface", null);
        annotationParser.expectString("beanName", null);
        annotationParser.expectString("mappedName", null);
        annotationParser.expectString("description", null);
        ParseResult parseResult = annotationParser.parse(annotationMirror);
        String string = (String)parseResult.get("name", String.class);
        String string2 = (String)parseResult.get("beanInterface", String.class);
        String string3 = (String)parseResult.get("beanName", String.class);
        String string4 = (String)parseResult.get("mappedName", String.class);
        String string5 = (String)parseResult.get("description", String.class);
        TypeElement typeElement = annotationModelHelper.getCompilationController().getElements().getTypeElement(string2);
        EjbRefHelper.createReference(annotationModelHelper, typeElement, list, list2, string, string2, string3, string4, string5);
    }

    private static void createReference(AnnotationModelHelper annotationModelHelper, TypeElement typeElement, List<EjbRef> list, List<EjbLocalRef> list2, String string, String string2, String string3, String string4, String string5) {
        boolean bl = true;
        Map map = annotationModelHelper.getAnnotationsByType(typeElement.getAnnotationMirrors());
        if (map.get("javax.ejb.Remote") != null) {
            bl = false;
        }
        if (list2 != null && bl) {
            list2.add(new EjbLocalRefImpl(string, string2, string3, string4, string5));
        } else if (list != null && !bl) {
            list.add(new EjbRefImpl(string, string2, string3, string4, string5));
        }
    }
}

