/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.dd.api.web;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.j2ee.dd.api.web.WebFragment;
import org.netbeans.modules.j2ee.dd.impl.web.WebParseUtils;
import org.openide.filesystems.FileObject;
import org.openide.util.Parameters;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class WebFragmentProvider {
    private static final Logger LOG = Logger.getLogger(WebFragmentProvider.class.getName());
    private static WebFragmentProvider instance;

    private WebFragmentProvider() {
    }

    public static WebFragmentProvider getDefault() {
        if (instance == null) {
            instance = new WebFragmentProvider();
        }
        return instance;
    }

    public WebFragment getWebFragmentRoot(FileObject fileObject) throws IOException, FileNotFoundException {
        Parameters.notNull((CharSequence)"fo", (Object)fileObject);
        try {
            String string = WebParseUtils.getVersion(fileObject.getInputStream());
            SAXParseException sAXParseException = WebParseUtils.parse(fileObject);
            if (sAXParseException != null) {
                throw sAXParseException;
            }
            return this.createWebFragment(fileObject.getInputStream(), string);
        }
        catch (SAXException sAXException) {
            LOG.log(Level.SEVERE, "Parsing failed!", sAXException);
            throw new IOException("Parsing failed: " + sAXException);
        }
    }

    private WebFragment createWebFragment(InputStream inputStream, String string) throws IOException, SAXException {
        try {
            if ("3.0".equals(string)) {
                return org.netbeans.modules.j2ee.dd.impl.web.model_3_0_frag.WebFragment.createGraph(inputStream);
            }
            throw new IOException("Unsupported version of web-fragment.xml found! Version: " + string);
        }
        catch (RuntimeException runtimeException) {
            throw new SAXException(runtimeException);
        }
    }
}

