/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.welcome.content;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.border.EmptyBorder;
import org.netbeans.modules.welcome.content.Constants;
import org.netbeans.modules.welcome.content.Utils;
import org.openide.util.ImageUtilities;

public abstract class LinkButton
extends JButton
implements Constants,
MouseListener,
ActionListener,
FocusListener {
    private boolean underline = false;
    final ImageIcon BULLET_ICON = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/welcome/resources/bullet.png", (boolean)false);
    private final Color defaultForeground;

    public LinkButton(String string, boolean bl) {
        this(string, bl, Utils.getColor("LinkColor"));
    }

    public LinkButton(String string, boolean bl, Color color) {
        super(string);
        this.defaultForeground = color;
        this.setForeground(this.defaultForeground);
        this.setFont(BUTTON_FONT);
        this.setBorder(new EmptyBorder(1, 1, 1, 1));
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.setHorizontalAlignment(2);
        this.addMouseListener(this);
        this.setFocusable(true);
        if (bl) {
            this.setIcon(this.BULLET_ICON);
        }
        this.setMargin(new Insets(0, 0, 0, 0));
        this.setBorderPainted(false);
        this.setFocusPainted(false);
        this.setRolloverEnabled(true);
        this.setContentAreaFilled(false);
        this.addActionListener(this);
        this.addFocusListener(this);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        if (this.isEnabled()) {
            this.underline = true;
            this.setForeground(Utils.getColor("LinkInFocusColor"));
            this.repaint();
            this.onMouseEntered(mouseEvent);
            this.setForeground(Utils.getColor("MouseOverLinkColor"));
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (this.isEnabled()) {
            this.underline = false;
            this.setForeground(this.isVisited() ? Utils.getColor("VisitedLinkColor") : this.defaultForeground);
            this.repaint();
            this.onMouseExited(mouseEvent);
        }
    }

    protected void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = Utils.prepareGraphics(graphics);
        super.paintComponent(graphics2D);
        Dimension dimension = this.getSize();
        if (this.hasFocus() && this.isEnabled()) {
            graphics2D.setStroke(LINK_IN_FOCUS_STROKE);
            graphics2D.setColor(Utils.getColor("LinkInFocusColor"));
            graphics2D.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
        }
    }

    public void focusLost(FocusEvent focusEvent) {
    }

    public void focusGained(FocusEvent focusEvent) {
        Rectangle rectangle = this.getBounds();
        rectangle.grow(0, FONT_SIZE);
        this.scrollRectToVisible(rectangle);
    }

    protected void onMouseExited(MouseEvent mouseEvent) {
    }

    protected void onMouseEntered(MouseEvent mouseEvent) {
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.underline && this.isEnabled()) {
            Font font = this.getFont();
            FontMetrics fontMetrics = this.getFontMetrics(font);
            int n = 0;
            if (null != this.getIcon()) {
                n = this.getIcon().getIconWidth() + this.getIconTextGap();
            }
            int n2 = n;
            int n3 = fontMetrics.getHeight();
            int n4 = fontMetrics.stringWidth(this.getText()) + n;
            if (this.getText().length() > 0) {
                graphics.drawLine(n2, n3, n4, n3);
            }
        }
    }

    protected boolean isVisited() {
        return false;
    }
}

