/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.ui;

import java.awt.event.ActionEvent;
import java.io.File;
import java.text.MessageFormat;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.kenai.ui.KenaiTopComponent;
import org.netbeans.modules.kenai.ui.NbProjectHandleImpl;
import org.netbeans.modules.kenai.ui.NewKenaiProjectAction;
import org.netbeans.modules.kenai.ui.NewKenaiProjectWizardIterator;
import org.netbeans.modules.kenai.ui.SourceAccessorImpl;
import org.netbeans.modules.kenai.ui.dashboard.DashboardImpl;
import org.netbeans.modules.kenai.ui.spi.NbProjectHandle;
import org.netbeans.modules.kenai.ui.spi.ProjectHandle;
import org.netbeans.modules.kenai.ui.spi.SourceHandle;
import org.netbeans.modules.subversion.api.Subversion;
import org.netbeans.modules.versioning.spi.VersioningSupport;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.Presenter;
import org.openide.windows.WindowManager;

public final class ShareAction
extends AbstractAction
implements ContextAwareAction {
    private static ShareAction inst = null;

    private ShareAction() {
    }

    public static synchronized ShareAction getDefault() {
        if (inst == null) {
            inst = new ShareAction();
        }
        return inst;
    }

    public static void actionPerformed(Node[] nodeArray) {
        ContextShareAction.actionPerformed(nodeArray);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        assert (false);
    }

    public Action createContextAwareInstance(Lookup lookup) {
        return new ContextShareAction();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ContextShareAction
    extends AbstractAction
    implements Presenter.Popup {
        public ContextShareAction() {
            this.putValue("Name", NbBundle.getMessage(ShareAction.class, (String)"CTL_ShareAction"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Node[] nodeArray = WindowManager.getDefault().getRegistry().getActivatedNodes();
            if (nodeArray.length > 0) {
                ContextShareAction.actionPerformed(nodeArray);
            } else {
                ContextShareAction.actionPerformed(null);
            }
        }

        public static void actionPerformed(Node[] wizardDescriptor) {
            if (wizardDescriptor != null) {
                for (WizardDescriptor wizardDescriptor2 : wizardDescriptor) {
                    File file;
                    Project project = (Project)wizardDescriptor2.getLookup().lookup(Project.class);
                    if (project == null || VersioningSupport.getOwner((File)(file = FileUtil.toFile((FileObject)project.getProjectDirectory()))) == null) continue;
                    JOptionPane.showMessageDialog(WindowManager.getDefault().getMainWindow(), NbBundle.getMessage(ShareAction.class, (String)"NameAndLicenseWizardPanelGUI.versioningNotSupported", (Object)ProjectUtils.getInformation((Project)project).getDisplayName()));
                    return;
                }
            }
            if (Subversion.isClientAvailable((boolean)true)) {
                int n;
                WizardDescriptor wizardDescriptor3 = new WizardDescriptor((WizardDescriptor.Iterator)new NewKenaiProjectWizardIterator((Node[])wizardDescriptor));
                wizardDescriptor3.setTitleFormat(new MessageFormat("{0}"));
                wizardDescriptor3.setTitle(NbBundle.getMessage(NewKenaiProjectAction.class, (String)"NewKenaiProjectAction.dialogTitle"));
                DialogDisplayer.getDefault().notify((NotifyDescriptor)wizardDescriptor3);
                int n2 = n = wizardDescriptor3.getValue() != WizardDescriptor.FINISH_OPTION ? 1 : 0;
                if (n == 0) {
                    Set set = wizardDescriptor3.getInstantiatedObjects();
                    ContextShareAction.showDashboard(set);
                }
            }
        }

        public static void showDashboard(Set<NewKenaiProjectWizardIterator.CreatedProjectInfo> set) {
            KenaiTopComponent kenaiTopComponent = KenaiTopComponent.findInstance();
            kenaiTopComponent.open();
            kenaiTopComponent.requestActive();
            DashboardImpl.getInstance().selectAndExpand(set.iterator().next().project);
        }

        private boolean inDashboard(Project project) {
            assert (project != null);
            ProjectHandle[] projectHandleArray = DashboardImpl.getInstance().getOpenProjects();
            for (int i = 0; i < projectHandleArray.length; ++i) {
                ProjectHandle projectHandle = projectHandleArray[i];
                if (projectHandle == null) continue;
                List<SourceHandle> list = SourceAccessorImpl.getDefault().getSources(projectHandle);
                for (SourceHandle sourceHandle : list) {
                    if (sourceHandle == null) continue;
                    for (NbProjectHandle nbProjectHandle : sourceHandle.getRecentProjects()) {
                        if (!((NbProjectHandleImpl)nbProjectHandle).getProject().equals(project)) continue;
                        return true;
                    }
                }
            }
            return false;
        }

        public JMenuItem getPopupPresenter() {
            Node[] nodeArray = WindowManager.getDefault().getRegistry().getActivatedNodes();
            if (nodeArray.length > 0) {
                if (nodeArray.length == 1 && this.inDashboard((Project)nodeArray[0].getLookup().lookup(Project.class))) {
                    JMenuItem jMenuItem = new JMenuItem();
                    jMenuItem.setVisible(false);
                    return jMenuItem;
                }
                return new JMenuItem(this);
            }
            JMenuItem jMenuItem = new JMenuItem();
            jMenuItem.setVisible(false);
            return jMenuItem;
        }
    }
}

