/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.netbeans.api.options.OptionsDisplayer;
import org.netbeans.modules.kenai.api.Kenai;
import org.netbeans.modules.kenai.api.KenaiException;
import org.netbeans.modules.kenai.api.KenaiFeature;
import org.netbeans.modules.kenai.api.KenaiProject;
import org.netbeans.modules.kenai.api.KenaiService;
import org.netbeans.modules.kenai.ui.KenaiDialogDescriptor;
import org.netbeans.modules.kenai.ui.KenaiFeatureCellRenderer;
import org.netbeans.modules.kenai.ui.KenaiSearchPanel;
import org.netbeans.modules.kenai.ui.KenaiTopComponent;
import org.netbeans.modules.kenai.ui.SourceAccessorImpl;
import org.netbeans.modules.kenai.ui.Utilities;
import org.netbeans.modules.kenai.ui.spi.Dashboard;
import org.netbeans.modules.kenai.ui.spi.ProjectHandle;
import org.netbeans.modules.kenai.ui.spi.UIUtils;
import org.netbeans.modules.subversion.api.Subversion;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class GetSourcesFromKenaiPanel
extends JPanel {
    private SourceAccessorImpl.ProjectAndFeature prjAndFeature;
    private boolean localFolderPathEdited = false;
    private DefaultComboBoxModel comboModel;
    private JButton browseKenaiButton;
    private JButton browseLocalButton;
    private JButton browseRepoButton;
    private JPanel emptySpace;
    private JComboBox kenaiRepoComboBox;
    private JLabel kenaiRepoLabel;
    private JLabel localFolderDescLabel;
    private JLabel localFolderLabel;
    private JTextField localFolderTextField;
    private JLabel loggedInLabel;
    private JButton loginButton;
    private JLabel projectPreviewLabel;
    private JButton proxyConfigButton;
    private JLabel repoFolderLabel;
    private JTextField repoFolderTextField;
    private JLabel usernameLabel;

    public GetSourcesFromKenaiPanel(SourceAccessorImpl.ProjectAndFeature projectAndFeature) {
        this.prjAndFeature = projectAndFeature;
        this.initComponents();
        this.refreshUsername();
        this.comboModel = new KenaiRepositoriesComboModel();
        this.kenaiRepoComboBox.setModel(this.comboModel);
        this.kenaiRepoComboBox.setRenderer(new KenaiFeatureCellRenderer());
        this.updatePanelUI();
        this.updateRepoPath();
        Kenai.getDefault().addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("login".equals(propertyChangeEvent.getPropertyName())) {
                    if (Kenai.getDefault().getPasswordAuthentication() != null) {
                        GetSourcesFromKenaiPanel.this.loginButton.setEnabled(false);
                    } else {
                        GetSourcesFromKenaiPanel.this.loginButton.setEnabled(true);
                    }
                }
            }
        });
    }

    public GetSourcesFromKenaiPanel() {
        this((SourceAccessorImpl.ProjectAndFeature)null);
    }

    public GetSourcesInfo getSelectedSourcesInfo() {
        String[] stringArray;
        StringTokenizer stringTokenizer = new StringTokenizer(this.repoFolderTextField.getText(), ",");
        ArrayList<String> arrayList = new ArrayList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken().trim());
        }
        if (arrayList.size() == 0) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "";
        } else {
            stringArray = arrayList.toArray(new String[arrayList.size()]);
        }
        String[] stringArray3 = stringArray;
        KenaiFeatureListItem kenaiFeatureListItem = (KenaiFeatureListItem)this.kenaiRepoComboBox.getSelectedItem();
        return kenaiFeatureListItem != null ? new GetSourcesInfo(kenaiFeatureListItem.feature, this.localFolderTextField.getText(), stringArray3) : null;
    }

    private void initComponents() {
        this.loggedInLabel = new JLabel();
        this.usernameLabel = new JLabel();
        this.loginButton = new JButton();
        this.kenaiRepoLabel = new JLabel();
        this.kenaiRepoComboBox = new JComboBox();
        this.browseKenaiButton = new JButton();
        this.projectPreviewLabel = new JLabel();
        this.repoFolderLabel = new JLabel();
        this.repoFolderTextField = new JTextField();
        this.browseRepoButton = new JButton();
        this.localFolderDescLabel = new JLabel();
        this.localFolderLabel = new JLabel();
        this.localFolderTextField = new JTextField();
        this.browseLocalButton = new JButton();
        this.proxyConfigButton = new JButton();
        this.emptySpace = new JPanel();
        this.setBorder(BorderFactory.createEmptyBorder(10, 12, 0, 12));
        this.setPreferredSize(new Dimension(700, 250));
        this.setRequestFocusEnabled(false);
        this.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.loggedInLabel, (String)NbBundle.getMessage(GetSourcesFromKenaiPanel.class, (String)"GetSourcesFromKenaiPanel.loggedInLabel.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 0, 12, 4);
        this.add((Component)this.loggedInLabel, gridBagConstraints);
        this.loggedInLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GetSourcesFromKenaiPanel.class, (String)"GetSourcesFromKenaiPanel.loggedInLabel.AccessibleContext.accessibleDescription"));
        Mnemonics.setLocalizedText((JLabel)this.usernameLabel, (String)NbBundle.getMessage(GetSourcesFromKenaiPanel.class, (String)"GetFromKenaiPanel.notLoggedIn"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 12, 0);
        this.add((Component)this.usernameLabel, gridBagConstraints);
        this.usernameLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(GetSourcesFromKenaiPanel.class, (String)"GetSourcesFromKenaiPanel.usernameLabel.AccessibleContext.accessibleName"));
        this.usernameLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GetSourcesFromKenaiPanel.class, (String)"GetSourcesFromKenaiPanel.usernameLabel.AccessibleContext.accessibleDescription"));
        Mnemonics.setLocalizedText((AbstractButton)this.loginButton, (String)NbBundle.getMessage(GetSourcesFromKenaiPanel.class, (String)"GetSourcesFromKenaiPanel.loginButton.text"));
        this.loginButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GetSourcesFromKenaiPanel.this.loginButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 0, 12, 0);
        this.add((Component)this.loginButton, gridBagConstraints);
        this.loginButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GetSourcesFromKenaiPanel.class, (String)"GetSourcesFromKenaiPanel.loginButton.AccessibleContext.accessibleDescription"));
        this.kenaiRepoLabel.setLabelFor(this.kenaiRepoComboBox);
        Mnemonics.setLocalizedText((JLabel)this.kenaiRepoLabel, (String)NbBundle.getMessage(GetSourcesFromKenaiPanel.class, (String)"GetSourcesFromKenaiPanel.kenaiRepoLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 4);
        this.add((Component)this.kenaiRepoLabel, gridBagConstraints);
        this.kenaiRepoLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GetSourcesFromKenaiPanel.class, (String)"GetSourcesFromKenaiPanel.kenaiRepoLabel.AccessibleContext.accessibleDescription"));
        this.kenaiRepoComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GetSourcesFromKenaiPanel.this.kenaiRepoComboBoxActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.kenaiRepoComboBox, gridBagConstraints);
        this.kenaiRepoComboBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(GetSourcesFromKenaiPanel.class, (String)"GetSourcesFromKenaiPanel.kenaiRepoComboBox.AccessibleContext.accessibleName"));
        this.kenaiRepoComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GetSourcesFromKenaiPanel.class, (String)"GetSourcesFromKenaiPanel.kenaiRepoComboBox.AccessibleContext.accessibleDescription"));
        Mnemonics.setLocalizedText((AbstractButton)this.browseKenaiButton, (String)NbBundle.getMessage(GetSourcesFromKenaiPanel.class, (String)"GetSourcesFromKenaiPanel.browseKenaiButton.text"));
        this.browseKenaiButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GetSourcesFromKenaiPanel.this.browseKenaiButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.add((Component)this.browseKenaiButton, gridBagConstraints);
        this.browseKenaiButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GetSourcesFromKenaiPanel.class, (String)"GetSourcesFromKenaiPanel.browseKenaiButton.AccessibleContext.accessibleDescription"));
        Mnemonics.setLocalizedText((JLabel)this.projectPreviewLabel, (String)NbBundle.getMessage(GetSourcesFromKenaiPanel.class, (String)"GetSourcesFromKenaiPanel.projectPreviewLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 6, 16, 0);
        this.add((Component)this.projectPreviewLabel, gridBagConstraints);
        this.repoFolderLabel.setLabelFor(this.repoFolderTextField);
        Mnemonics.setLocalizedText((JLabel)this.repoFolderLabel, (String)NbBundle.getMessage(GetSourcesFromKenaiPanel.class, (String)"GetSourcesFromKenaiPanel.repoFolderLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 4);
        this.add((Component)this.repoFolderLabel, gridBagConstraints);
        this.repoFolderLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GetSourcesFromKenaiPanel.class, (String)"GetSourcesFromKenaiPanel.repoFolderLabel.AccessibleContext.accessibleDescription"));
        this.repoFolderTextField.setText(NbBundle.getMessage(GetSourcesFromKenaiPanel.class, (String)"GetSourcesFromKenaiPanel.repoFolderTextField.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.repoFolderTextField, gridBagConstraints);
        this.repoFolderTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(GetSourcesFromKenaiPanel.class, (String)"GetSourcesFromKenaiPanel.repoFolderTextField.AccessibleContext.accessibleName"));
        this.repoFolderTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GetSourcesFromKenaiPanel.class, (String)"GetSourcesFromKenaiPanel.repoFolderTextField.AccessibleContext.accessibleDescription"));
        Mnemonics.setLocalizedText((AbstractButton)this.browseRepoButton, (String)NbBundle.getMessage(GetSourcesFromKenaiPanel.class, (String)"GetSourcesFromKenaiPanel.browseRepoButton.text"));
        this.browseRepoButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GetSourcesFromKenaiPanel.this.browseRepoButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.add((Component)this.browseRepoButton, gridBagConstraints);
        this.browseRepoButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GetSourcesFromKenaiPanel.class, (String)"GetSourcesFromKenaiPanel.browseRepoButton.AccessibleContext.accessibleDescription"));
        Mnemonics.setLocalizedText((JLabel)this.localFolderDescLabel, (String)NbBundle.getMessage(GetSourcesFromKenaiPanel.class, (String)"GetSourcesFromKenaiPanel.localFolderDescLabel.svnText"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(24, 0, 6, 0);
        this.add((Component)this.localFolderDescLabel, gridBagConstraints);
        this.localFolderDescLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GetSourcesFromKenaiPanel.class, (String)"GetSourcesFromKenaiPanel.localFolderDescLabel.AccessibleContext.accessibleDescription"));
        this.localFolderLabel.setLabelFor(this.localFolderTextField);
        Mnemonics.setLocalizedText((JLabel)this.localFolderLabel, (String)NbBundle.getMessage(GetSourcesFromKenaiPanel.class, (String)"GetSourcesFromKenaiPanel.localFolderLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 4);
        this.add((Component)this.localFolderLabel, gridBagConstraints);
        this.localFolderLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GetSourcesFromKenaiPanel.class, (String)"GetSourcesFromKenaiPanel.localFolderLabel.AccessibleContext.accessibleDescription"));
        this.localFolderTextField.setText(NbBundle.getMessage(GetSourcesFromKenaiPanel.class, (String)"GetSourcesFromKenaiPanel.localFolderTextField.text"));
        this.localFolderTextField.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent keyEvent) {
                GetSourcesFromKenaiPanel.this.localFolderTextFieldKeyTyped(keyEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.localFolderTextField, gridBagConstraints);
        this.localFolderTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(GetSourcesFromKenaiPanel.class, (String)"GetSourcesFromKenaiPanel.localFolderTextField.AccessibleContext.accessibleName"));
        this.localFolderTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GetSourcesFromKenaiPanel.class, (String)"GetSourcesFromKenaiPanel.localFolderTextField.AccessibleContext.accessibleDescription"));
        Mnemonics.setLocalizedText((AbstractButton)this.browseLocalButton, (String)NbBundle.getMessage(GetSourcesFromKenaiPanel.class, (String)"GetSourcesFromKenaiPanel.browseLocalButton.text"));
        this.browseLocalButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GetSourcesFromKenaiPanel.this.browseLocalButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.add((Component)this.browseLocalButton, gridBagConstraints);
        this.browseLocalButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GetSourcesFromKenaiPanel.class, (String)"GetSourcesFromKenaiPanel.browseLocalButton.AccessibleContext.accessibleDescription"));
        Mnemonics.setLocalizedText((AbstractButton)this.proxyConfigButton, (String)NbBundle.getMessage(GetSourcesFromKenaiPanel.class, (String)"GetSourcesFromKenaiPanel.proxyConfigButton.text"));
        this.proxyConfigButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GetSourcesFromKenaiPanel.this.proxyConfigButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 16;
        this.add((Component)this.proxyConfigButton, gridBagConstraints);
        this.proxyConfigButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GetSourcesFromKenaiPanel.class, (String)"GetSourcesFromKenaiPanel.proxyConfigButton.AccessibleContext.accessibleDescription"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.emptySpace, gridBagConstraints);
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(GetSourcesFromKenaiPanel.class, (String)"GetSourcesFromKenaiPanel.AccessibleContext.accessibleName"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GetSourcesFromKenaiPanel.class, (String)"GetSourcesFromKenaiPanel.AccessibleContext.accessibleDescription"));
    }

    private void loginButtonActionPerformed(ActionEvent actionEvent) {
        boolean bl = UIUtils.showLogin();
        if (bl) {
            this.refreshUsername();
            KenaiTopComponent.findInstance().open();
            KenaiTopComponent.findInstance().requestActive();
        }
    }

    private void proxyConfigButtonActionPerformed(ActionEvent actionEvent) {
        OptionsDisplayer.getDefault().open("General");
    }

    private void browseKenaiButtonActionPerformed(ActionEvent actionEvent) {
        KenaiSearchPanel kenaiSearchPanel = new KenaiSearchPanel(KenaiSearchPanel.PanelType.BROWSE, false);
        String string = NbBundle.getMessage(GetSourcesFromKenaiPanel.class, (String)"GetSourcesFromKenaiPanel.BrowseKenaiProjectsTitle");
        KenaiDialogDescriptor kenaiDialogDescriptor = new KenaiDialogDescriptor(kenaiSearchPanel, string, true, null);
        Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)kenaiDialogDescriptor);
        if (NotifyDescriptor.OK_OPTION.equals(object)) {
            KenaiSearchPanel.KenaiProjectSearchInfo kenaiProjectSearchInfo = kenaiSearchPanel.getSelectedProjectSearchInfo();
            int n = this.comboModel.getSize();
            boolean bl = false;
            KenaiFeatureListItem kenaiFeatureListItem = null;
            for (int i = 0; i < n; ++i) {
                kenaiFeatureListItem = (KenaiFeatureListItem)this.comboModel.getElementAt(i);
                if (!kenaiFeatureListItem.project.getName().equals(kenaiProjectSearchInfo.kenaiProject.getName()) || !kenaiFeatureListItem.feature.getName().equals(kenaiProjectSearchInfo.kenaiFeature.getName())) continue;
                bl = true;
                break;
            }
            if (kenaiProjectSearchInfo != null && !bl) {
                KenaiFeatureListItem kenaiFeatureListItem2 = new KenaiFeatureListItem(kenaiProjectSearchInfo.kenaiProject, kenaiProjectSearchInfo.kenaiFeature);
                this.comboModel.addElement(kenaiFeatureListItem2);
                this.comboModel.setSelectedItem(kenaiFeatureListItem2);
            } else if (bl && kenaiFeatureListItem != null) {
                this.comboModel.setSelectedItem(kenaiFeatureListItem);
            }
        }
    }

    private void browseRepoButtonActionPerformed(ActionEvent actionEvent) {
        if (Subversion.isClientAvailable((boolean)true)) {
            String[] stringArray;
            block6: {
                PasswordAuthentication passwordAuthentication = Kenai.getDefault().getPasswordAuthentication();
                KenaiFeatureListItem kenaiFeatureListItem = (KenaiFeatureListItem)this.kenaiRepoComboBox.getSelectedItem();
                stringArray = null;
                if (kenaiFeatureListItem != null) {
                    String string = NbBundle.getMessage(GetSourcesFromKenaiPanel.class, (String)"GetSourcesFromKenaiPanel.SelectRepositoryFolderTitle");
                    String string2 = kenaiFeatureListItem.feature.getLocation();
                    try {
                        stringArray = passwordAuthentication != null ? Subversion.selectRepositoryFolders((String)string, (String)string2, (String)passwordAuthentication.getUserName(), (String)new String(passwordAuthentication.getPassword())) : Subversion.selectRepositoryFolders((String)string, (String)string2);
                    }
                    catch (MalformedURLException malformedURLException) {
                        Exceptions.printStackTrace((Throwable)malformedURLException);
                    }
                    catch (IOException iOException) {
                        if ("SVN client unavailable".equals(iOException.getMessage())) break block6;
                        Exceptions.printStackTrace((Throwable)iOException);
                    }
                }
            }
            if (stringArray != null) {
                this.repoFolderTextField.setText((String)stringArray[0]);
            }
        }
    }

    private void browseLocalButtonActionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = new JFileChooser();
        File file = new File(this.localFolderTextField.getText());
        if (file.exists()) {
            jFileChooser.setCurrentDirectory(FileUtil.normalizeFile((File)file));
        }
        jFileChooser.setFileSelectionMode(1);
        int n = jFileChooser.showOpenDialog(this);
        if (n == 0) {
            File file2 = jFileChooser.getSelectedFile();
            this.localFolderTextField.setText(file2.getAbsolutePath());
        }
    }

    private void kenaiRepoComboBoxActionPerformed(ActionEvent actionEvent) {
        this.updatePanelUI();
        this.updateRepoPath();
    }

    private void localFolderTextFieldKeyTyped(KeyEvent keyEvent) {
        this.localFolderPathEdited = true;
    }

    private void updatePanelUI() {
        KenaiFeatureListItem kenaiFeatureListItem = (KenaiFeatureListItem)this.kenaiRepoComboBox.getSelectedItem();
        if (kenaiFeatureListItem != null) {
            String string = kenaiFeatureListItem.feature.getService();
            String string2 = NbBundle.getMessage(GetSourcesFromKenaiPanel.class, (String)"GetSourcesFromKenaiPanel.RepositoryLabel");
            if ("subversion".equals(string)) {
                this.enableFolderToGetUI(true);
                this.localFolderDescLabel.setText(NbBundle.getMessage(GetSourcesFromKenaiPanel.class, (String)"GetSourcesFromKenaiPanel.localFolderDescLabel.svnText"));
                this.projectPreviewLabel.setText("(" + kenaiFeatureListItem.project.getDisplayName() + "; Subversion " + string2 + ")");
            } else if ("mercurial".equals(string)) {
                this.enableFolderToGetUI(false);
                this.localFolderDescLabel.setText(NbBundle.getMessage(GetSourcesFromKenaiPanel.class, (String)"GetSourcesFromKenaiPanel.localFolderDescLabel.hgText"));
                this.projectPreviewLabel.setText("(" + kenaiFeatureListItem.project.getDisplayName() + "; Mercurial " + string2 + ")");
            } else {
                this.enableFolderToGetUI(false);
            }
        }
    }

    private void updateRepoPath() {
        KenaiFeatureListItem kenaiFeatureListItem = (KenaiFeatureListItem)this.kenaiRepoComboBox.getSelectedItem();
        if (!this.localFolderPathEdited && kenaiFeatureListItem != null) {
            String string = kenaiFeatureListItem.feature.getLocation();
            String string2 = string.substring(string.lastIndexOf("/") + 1);
            this.localFolderTextField.setText(Utilities.getDefaultRepoFolder().getPath() + File.separator + string2);
        }
    }

    private void refreshUsername() {
        PasswordAuthentication passwordAuthentication = Kenai.getDefault().getPasswordAuthentication();
        if (passwordAuthentication != null) {
            this.setUsername(passwordAuthentication.getUserName());
            this.loginButton.setEnabled(false);
        } else {
            this.setUsername(null);
            this.loginButton.setEnabled(true);
        }
    }

    private void setUsername(String string) {
        if (string != null) {
            this.usernameLabel.setText(string);
            this.usernameLabel.setForeground(new Color(0, 102, 0));
            this.usernameLabel.setEnabled(true);
        } else {
            this.usernameLabel.setText(NbBundle.getMessage(GetSourcesFromKenaiPanel.class, (String)"GetFromKenaiPanel.notLoggedIn"));
            this.usernameLabel.setForeground(Color.BLACK);
            this.usernameLabel.setEnabled(false);
        }
    }

    private synchronized void setComboModel(DefaultComboBoxModel defaultComboBoxModel) {
        this.comboModel = defaultComboBoxModel;
    }

    private synchronized DefaultComboBoxModel getComboModel() {
        return this.comboModel;
    }

    private void enableFolderToGetUI(boolean bl) {
        this.repoFolderLabel.setEnabled(bl);
        this.repoFolderTextField.setEnabled(bl);
        this.browseRepoButton.setEnabled(bl);
    }

    public static class GetSourcesInfo {
        public KenaiFeature feature;
        public String localFolderPath;
        public String[] relativePaths;

        public GetSourcesInfo(KenaiFeature kenaiFeature, String string, String[] stringArray) {
            this.feature = kenaiFeature;
            this.localFolderPath = string;
            this.relativePaths = stringArray;
        }
    }

    public static class KenaiFeatureListItem {
        KenaiProject project;
        KenaiFeature feature;

        public KenaiFeatureListItem(KenaiProject kenaiProject, KenaiFeature kenaiFeature) {
            this.project = kenaiProject;
            this.feature = kenaiFeature;
        }

        public String toString() {
            return this.feature.getLocation();
        }
    }

    private class KenaiRepositoriesComboModel
    extends DefaultComboBoxModel
    implements PropertyChangeListener {
        public KenaiRepositoriesComboModel() {
            Dashboard.getDefault().addPropertyChangeListener(this);
            this.addOpenedProjects();
        }

        private void addOpenedProjects() {
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    ProjectHandle[] projectHandleArray;
                    for (ProjectHandle projectHandle : projectHandleArray = Dashboard.getDefault().getOpenProjects()) {
                        KenaiProject kenaiProject;
                        KenaiProject kenaiProject2 = null;
                        if (projectHandle != null) {
                            try {
                                kenaiProject2 = Kenai.getDefault().getProject(projectHandle.getId());
                            }
                            catch (KenaiException kenaiException) {
                                Exceptions.printStackTrace((Throwable)kenaiException);
                            }
                        }
                        if ((kenaiProject = kenaiProject2) == null) continue;
                        try {
                            KenaiFeature[] kenaiFeatureArray;
                            for (final KenaiFeature kenaiFeature : kenaiFeatureArray = kenaiProject.getFeatures(KenaiService.Type.SOURCE)) {
                                EventQueue.invokeLater(new Runnable(){

                                    public void run() {
                                        if ("mercurial".equals(kenaiFeature.getService()) || "subversion".equals(kenaiFeature.getService())) {
                                            KenaiFeatureListItem kenaiFeatureListItem = new KenaiFeatureListItem(kenaiProject, kenaiFeature);
                                            KenaiRepositoriesComboModel.this.addElement(kenaiFeatureListItem);
                                            if (GetSourcesFromKenaiPanel.this.prjAndFeature != null && ((GetSourcesFromKenaiPanel)GetSourcesFromKenaiPanel.this).prjAndFeature.projectName.equals(kenaiProject.getName()) && ((GetSourcesFromKenaiPanel)GetSourcesFromKenaiPanel.this).prjAndFeature.feature.equals(kenaiFeature)) {
                                                KenaiRepositoriesComboModel.this.setSelectedItem(kenaiFeatureListItem);
                                            }
                                        }
                                    }
                                });
                            }
                        }
                        catch (KenaiException kenaiException) {
                            Exceptions.printStackTrace((Throwable)kenaiException);
                        }
                    }
                }
            });
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("openedProjects".equals(propertyChangeEvent.getPropertyName())) {
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        KenaiRepositoriesComboModel.this.removeAllElements();
                    }
                });
                this.addOpenedProjects();
            }
        }
    }
}

