/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.collab.chat;

import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.netbeans.modules.kenai.api.Kenai;
import org.netbeans.modules.kenai.api.KenaiException;
import org.netbeans.modules.kenai.collab.chat.ChatNotifications;
import org.netbeans.modules.kenai.collab.chat.ChatTopComponent;
import org.netbeans.modules.kenai.collab.chat.ContactListItem;
import org.netbeans.modules.kenai.collab.chat.FakeRosterGroup;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class GroupListItem
implements ContactListItem {
    private FakeRosterGroup group;
    private static ImageIcon GROUP = new ImageIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/kenai/collab/resources/chatroom_online.png"));

    public GroupListItem(FakeRosterGroup fakeRosterGroup) {
        this.group = fakeRosterGroup;
    }

    public String toString() {
        try {
            return NbBundle.getMessage(GroupListItem.class, (String)"ChatRoomRenderer", (Object)Kenai.getDefault().getProject(this.group.getName()).getDisplayName());
        }
        catch (KenaiException kenaiException) {
            Exceptions.printStackTrace((Throwable)kenaiException);
            return null;
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        GroupListItem groupListItem = (GroupListItem)object;
        return this.group == groupListItem.group || this.group != null && this.group.equals(groupListItem.group);
    }

    public int hashCode() {
        int n = 7;
        n = 47 * n + (this.group != null ? this.group.hashCode() : 0);
        return n;
    }

    public void openChat() {
        ChatTopComponent.findInstance().setActiveGroup(this.group.getName());
    }

    public Icon getIcon() {
        return GROUP;
    }

    public boolean hasMessages() {
        return ChatNotifications.getDefault().getMessagingHandle(this.group.getName()).getMessageCount() > 0;
    }
}

