/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.clientproject.ui;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.CharConversionException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.j2ee.clientproject.AppClientProject;
import org.netbeans.modules.j2ee.clientproject.Utils;
import org.netbeans.modules.j2ee.clientproject.ui.customizer.AppClientProjectProperties;
import org.netbeans.modules.j2ee.common.ui.BrokenServerSupport;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.InstanceListener;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.java.api.common.SourceRoots;
import org.netbeans.modules.java.api.common.ant.UpdateHelper;
import org.netbeans.modules.java.api.common.project.ProjectProperties;
import org.netbeans.modules.java.api.common.project.ui.LogicalViewProvider2;
import org.netbeans.spi.java.project.support.ui.BrokenReferencesSupport;
import org.netbeans.spi.java.project.support.ui.PackageView;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.netbeans.spi.project.ui.support.CommonProjectActions;
import org.netbeans.spi.project.ui.support.DefaultProjectOperations;
import org.netbeans.spi.project.ui.support.NodeFactorySupport;
import org.netbeans.spi.project.ui.support.ProjectSensitiveActions;
import org.openide.actions.FindAction;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.SpecificationVersion;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;
import org.openide.xml.XMLUtil;

public class AppClientLogicalViewProvider
implements LogicalViewProvider2 {
    private static final RequestProcessor BROKEN_LINKS_RP = new RequestProcessor("AppClientLogicalViewProvider.BROKEN_LINKS_RP");
    private final AppClientProject project;
    private final UpdateHelper helper;
    private final PropertyEvaluator evaluator;
    private final ReferenceHelper resolver;
    private List<ChangeListener> changeListeners;
    private static final Object KEY_SERVICE_REFS = "serviceRefs";
    private static final String KEY_SETUP_DIR = "setupDir";
    private static final String KEY_CONF_DIR = "confDir";
    private static final String[] BREAKABLE_PROPERTIES = new String[]{"javac.classpath", "debug.classpath", "run.test.classpath", "debug.test.classpath", "endorsed.classpath", "javac.test.classpath"};

    public AppClientLogicalViewProvider(AppClientProject appClientProject, UpdateHelper updateHelper, PropertyEvaluator propertyEvaluator, ReferenceHelper referenceHelper) {
        this.project = appClientProject;
        assert (appClientProject != null);
        this.helper = updateHelper;
        assert (updateHelper != null);
        this.evaluator = propertyEvaluator;
        assert (propertyEvaluator != null);
        this.resolver = referenceHelper;
    }

    public Node createLogicalView() {
        return new AppClientLogicalViewRootNode();
    }

    public Node findPath(Node node, Object object) {
        Project project = (Project)node.getLookup().lookup(Project.class);
        if (project == null) {
            return null;
        }
        if (object instanceof FileObject) {
            FileObject fileObject = (FileObject)object;
            Project project2 = FileOwnerQuery.getOwner((FileObject)fileObject);
            if (!project.equals(project2)) {
                return null;
            }
            Node[] nodeArray = node.getChildren().getNodes(true);
            for (int i = 0; i < nodeArray.length; ++i) {
                Node node2 = PackageView.findPath((Node)nodeArray[i], (Object)object);
                if (node2 == null) continue;
                return node2;
            }
        }
        return null;
    }

    public synchronized void addChangeListener(ChangeListener changeListener) {
        if (this.changeListeners == null) {
            this.changeListeners = new ArrayList<ChangeListener>();
        }
        this.changeListeners.add(changeListener);
    }

    public synchronized void removeChangeListener(ChangeListener changeListener) {
        if (this.changeListeners == null) {
            return;
        }
        this.changeListeners.remove(changeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBroken() {
        ChangeListener[] changeListenerArray;
        Object object = this;
        synchronized (object) {
            if (this.changeListeners == null) {
                return;
            }
            changeListenerArray = this.changeListeners.toArray(new ChangeListener[this.changeListeners.size()]);
        }
        object = new ChangeEvent(this);
        for (int i = 0; i < changeListenerArray.length; ++i) {
            changeListenerArray[i].stateChanged((ChangeEvent)object);
        }
    }

    public boolean hasBrokenLinks() {
        return BrokenReferencesSupport.isBroken((AntProjectHelper)this.helper.getAntProjectHelper(), (ReferenceHelper)this.resolver, (String[])this.getBreakableProperties(), (String[])new String[]{"platform.active"});
    }

    public boolean hasInvalidJdkVersion() {
        String string = this.evaluator.getProperty("javac.source");
        String string2 = this.evaluator.getProperty("javac.target");
        if (string == null && string2 == null) {
            return false;
        }
        String string3 = this.evaluator.getProperty("platform.active");
        JavaPlatform javaPlatform = Utils.getActivePlatform(string3);
        if (javaPlatform == null) {
            return true;
        }
        SpecificationVersion specificationVersion = javaPlatform.getSpecification().getVersion();
        try {
            return string != null && new SpecificationVersion(string).compareTo((Object)specificationVersion) > 0 || string2 != null && new SpecificationVersion(string2).compareTo((Object)specificationVersion) > 0;
        }
        catch (NumberFormatException numberFormatException) {
            Logger.getLogger("global").log(Level.INFO, "Invalid javac.source: " + string + " or javac.target: " + string2 + " of project:" + this.project.getProjectDirectory().getPath());
            return true;
        }
    }

    private String[] getBreakableProperties() {
        SourceRoots sourceRoots = this.project.getSourceRoots();
        String[] stringArray = sourceRoots.getRootProperties();
        sourceRoots = this.project.getTestSourceRoots();
        String[] stringArray2 = sourceRoots.getRootProperties();
        String[] stringArray3 = new String[BREAKABLE_PROPERTIES.length + stringArray.length + stringArray2.length];
        System.arraycopy(BREAKABLE_PROPERTIES, 0, stringArray3, 0, BREAKABLE_PROPERTIES.length);
        System.arraycopy(stringArray, 0, stringArray3, BREAKABLE_PROPERTIES.length, stringArray.length);
        System.arraycopy(stringArray2, 0, stringArray3, BREAKABLE_PROPERTIES.length + stringArray.length, stringArray2.length);
        return stringArray3;
    }

    private final class AppClientLogicalViewRootNode
    extends AbstractNode {
        private Action brokenLinksAction;
        private BrokenServerAction brokenServerAction;
        private boolean broken;
        private boolean illegalState;

        public AppClientLogicalViewRootNode() {
            super(NodeFactorySupport.createCompositeChildren((Project)AppClientLogicalViewProvider.this.project, (String)"Projects/org-netbeans-modules-j2ee-clientproject/Nodes"), Lookups.singleton((Object)AppClientLogicalViewProvider.this.project));
            this.setIconBaseWithExtension("org/netbeans/modules/j2ee/clientproject/ui/resources/appclient.gif");
            super.setName(ProjectUtils.getInformation((Project)AppClientLogicalViewProvider.this.project).getDisplayName());
            if (AppClientLogicalViewProvider.this.hasBrokenLinks()) {
                this.broken = true;
            } else if (AppClientLogicalViewProvider.this.hasInvalidJdkVersion()) {
                this.illegalState = true;
            }
            this.brokenLinksAction = new BrokenLinksAction();
            this.brokenServerAction = new BrokenServerAction();
            J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)AppClientLogicalViewProvider.this.project.getLookup().lookup(J2eeModuleProvider.class);
            j2eeModuleProvider.addInstanceListener((InstanceListener)WeakListeners.create(InstanceListener.class, (EventListener)this.brokenServerAction, (Object)j2eeModuleProvider));
        }

        public String getHtmlDisplayName() {
            String string = super.getDisplayName();
            try {
                string = XMLUtil.toElementContent((String)string);
            }
            catch (CharConversionException charConversionException) {
                return string;
            }
            return this.broken || this.illegalState || this.brokenServerAction.isEnabled() ? "<font color=\"#A40000\">" + string + "</font>" : null;
        }

        public Image getIcon(int n) {
            Image image = super.getIcon(n);
            return this.broken || this.illegalState || this.brokenServerAction.isEnabled() ? ImageUtilities.mergeImages((Image)image, (Image)ProjectProperties.ICON_BROKEN_BADGE.getImage(), (int)8, (int)0) : image;
        }

        public Image getOpenedIcon(int n) {
            Image image = super.getOpenedIcon(n);
            return this.broken || this.illegalState || this.brokenServerAction.isEnabled() ? ImageUtilities.mergeImages((Image)image, (Image)ProjectProperties.ICON_BROKEN_BADGE.getImage(), (int)8, (int)0) : image;
        }

        public String getShortDescription() {
            String string = FileUtil.getFileDisplayName((FileObject)AppClientLogicalViewProvider.this.project.getProjectDirectory());
            return NbBundle.getMessage(AppClientLogicalViewProvider.class, (String)"HINT_project_root_node", (Object)string);
        }

        public Action[] getActions(boolean bl) {
            return this.getAdditionalActions();
        }

        public boolean canRename() {
            return true;
        }

        public void setName(String string) {
            DefaultProjectOperations.performDefaultRenameOperation((Project)AppClientLogicalViewProvider.this.project, (String)string);
        }

        private Action[] getAdditionalActions() {
            ResourceBundle resourceBundle = NbBundle.getBundle(AppClientLogicalViewProvider.class);
            ArrayList<Action> arrayList = new ArrayList<Action>(30);
            J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)AppClientLogicalViewProvider.this.project.getLookup().lookup(J2eeModuleProvider.class);
            arrayList.add(CommonProjectActions.newFileAction());
            arrayList.add(null);
            arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"build", (String)resourceBundle.getString("LBL_BuildAction_Name"), null));
            arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"rebuild", (String)resourceBundle.getString("LBL_RebuildAction_Name"), null));
            arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"clean", (String)resourceBundle.getString("LBL_CleanAction_Name"), null));
            if (j2eeModuleProvider != null && j2eeModuleProvider.hasVerifierSupport()) {
                arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"verify", (String)resourceBundle.getString("LBL_VerifyAction_Name"), null));
            }
            arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"javadoc", (String)resourceBundle.getString("LBL_JavadocAction_Name"), null));
            arrayList.add(null);
            arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"run", (String)resourceBundle.getString("LBL_RunAction_Name"), null));
            arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"redeploy", (String)resourceBundle.getString("LBL_RedeployAction_Name"), null));
            arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"debug", (String)resourceBundle.getString("LBL_DebugAction_Name"), null));
            arrayList.add(ProjectSensitiveActions.projectCommandAction((String)"test", (String)resourceBundle.getString("LBL_TestAction_Name"), null));
            arrayList.add(null);
            arrayList.add(CommonProjectActions.setAsMainProjectAction());
            arrayList.add(CommonProjectActions.openSubprojectsAction());
            arrayList.add(CommonProjectActions.closeProjectAction());
            arrayList.add(null);
            arrayList.add(CommonProjectActions.renameProjectAction());
            arrayList.add(CommonProjectActions.moveProjectAction());
            arrayList.add(CommonProjectActions.copyProjectAction());
            arrayList.add(CommonProjectActions.deleteProjectAction());
            arrayList.add(null);
            arrayList.add((Action)SystemAction.get(FindAction.class));
            arrayList.add(null);
            arrayList.addAll(Utilities.actionsForPath((String)"Projects/Actions"));
            arrayList.add(null);
            if (this.brokenLinksAction != null && this.brokenLinksAction.isEnabled()) {
                arrayList.add(this.brokenLinksAction);
            }
            if (this.brokenServerAction.isEnabled()) {
                arrayList.add(this.brokenServerAction);
            }
            arrayList.add(CommonProjectActions.customizeProjectAction());
            return arrayList.toArray(new Action[arrayList.size()]);
        }

        private void setBroken(boolean bl) {
            this.broken = bl;
            this.brokenLinksAction.setEnabled(bl);
            this.fireIconChange();
            this.fireOpenedIconChange();
            this.fireDisplayNameChange(null, null);
        }

        private void setIllegalState(boolean bl) {
            this.illegalState = bl;
            this.fireIconChange();
            this.fireOpenedIconChange();
            this.fireDisplayNameChange(null, null);
        }

        private class BrokenServerAction
        extends AbstractAction
        implements InstanceListener,
        PropertyChangeListener {
            private static final long serialVersionUID = 1L;
            private RequestProcessor.Task task = null;
            private boolean brokenServer;

            public BrokenServerAction() {
                this.putValue("Name", NbBundle.getMessage(AppClientLogicalViewProvider.class, (String)"LBL_Fix_Missing_Server_Action"));
                AppClientLogicalViewProvider.this.evaluator.addPropertyChangeListener((PropertyChangeListener)this);
                this.checkMissingServer();
            }

            public boolean isEnabled() {
                return this.brokenServer;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                String string;
                Profile profile = Profile.fromPropertiesString((String)AppClientLogicalViewProvider.this.project.evaluator().getProperty("j2ee.platform"));
                if (profile == null) {
                    profile = Profile.JAVA_EE_6_FULL;
                    Logger.getLogger(AppClientLogicalViewProvider.class.getName()).warning("project [" + AppClientLogicalViewProvider.this.project.getProjectDirectory() + "] is missing " + "j2ee.platform" + ". " + "default value will be used instead: " + profile);
                    this.updateJ2EESpec(AppClientLogicalViewProvider.this.project, AppClientLogicalViewProvider.this.project.getAntProjectHelper(), profile);
                }
                if ((string = BrokenServerSupport.selectServer((Profile)profile, (J2eeModule.Type)J2eeModule.Type.CAR)) != null) {
                    AppClientProjectProperties.setServerInstance(AppClientLogicalViewProvider.this.project, AppClientLogicalViewProvider.this.helper.getAntProjectHelper(), string);
                }
                this.checkMissingServer();
            }

            private void updateJ2EESpec(final Project project, final AntProjectHelper antProjectHelper, final Profile profile) {
                ProjectManager.mutex().postWriteRequest(new Runnable(){

                    public void run() {
                        try {
                            EditableProperties editableProperties = antProjectHelper.getProperties("nbproject/project.properties");
                            editableProperties.put("j2ee.platform", profile.toPropertiesString());
                            antProjectHelper.putProperties("nbproject/project.properties", editableProperties);
                            ProjectManager.getDefault().saveProject(project);
                        }
                        catch (IOException iOException) {
                            Exceptions.printStackTrace((Throwable)iOException);
                        }
                    }
                });
            }

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("j2ee.server.instance".equals(propertyChangeEvent.getPropertyName())) {
                    this.checkMissingServer();
                }
            }

            public void changeDefaultInstance(String string, String string2) {
            }

            public void instanceAdded(String string) {
                this.checkMissingServer();
            }

            public void instanceRemoved(String string) {
                this.checkMissingServer();
            }

            private void checkMissingServer() {
                boolean bl = this.brokenServer;
                String string = AppClientLogicalViewProvider.this.project.evaluator().getProperty("j2ee.server.instance");
                this.brokenServer = BrokenServerSupport.isBroken((String)string);
                if (bl != this.brokenServer) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            AppClientLogicalViewRootNode.this.fireIconChange();
                            AppClientLogicalViewRootNode.this.fireOpenedIconChange();
                            AppClientLogicalViewRootNode.this.fireDisplayNameChange(null, null);
                        }
                    });
                }
            }
        }

        private class BrokenLinksAction
        extends AbstractAction
        implements PropertyChangeListener,
        ChangeListener,
        Runnable {
            private static final long serialVersionUID = 1L;
            private RequestProcessor.Task task = null;
            private final PropertyChangeListener weakPCL;

            public BrokenLinksAction() {
                this.putValue("Name", NbBundle.getMessage(AppClientLogicalViewProvider.class, (String)"LBL_Fix_Broken_Links_Action"));
                this.setEnabled(AppClientLogicalViewRootNode.this.broken);
                AppClientLogicalViewProvider.this.evaluator.addPropertyChangeListener((PropertyChangeListener)this);
                this.weakPCL = WeakListeners.propertyChange((PropertyChangeListener)this, (Object)JavaPlatformManager.getDefault());
                JavaPlatformManager.getDefault().addPropertyChangeListener(this.weakPCL);
                AppClientLogicalViewProvider.this.addChangeListener(WeakListeners.change((ChangeListener)this, (Object)AppClientLogicalViewProvider.this));
            }

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    AppClientLogicalViewProvider.this.helper.requestUpdate();
                    BrokenReferencesSupport.showCustomizer((AntProjectHelper)AppClientLogicalViewProvider.this.helper.getAntProjectHelper(), (ReferenceHelper)AppClientLogicalViewProvider.this.resolver, (String[])AppClientLogicalViewProvider.this.getBreakableProperties(), (String[])new String[]{"platform.active"});
                    this.run();
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                this.refsMayChanged();
            }

            public void stateChanged(ChangeEvent changeEvent) {
                this.refsMayChanged();
            }

            public synchronized void run() {
                boolean bl;
                boolean bl2 = AppClientLogicalViewRootNode.this.broken;
                if (bl2 != (bl = AppClientLogicalViewProvider.this.hasBrokenLinks())) {
                    AppClientLogicalViewRootNode.this.setBroken(bl);
                }
                if ((bl2 = AppClientLogicalViewRootNode.this.illegalState) != (bl = AppClientLogicalViewProvider.this.hasInvalidJdkVersion())) {
                    AppClientLogicalViewRootNode.this.setIllegalState(bl);
                }
            }

            private void refsMayChanged() {
                if (this.task == null) {
                    this.task = BROKEN_LINKS_RP.create((Runnable)this);
                }
                this.task.schedule(100);
            }
        }
    }
}

