/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.syncview;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import javax.swing.Action;
import org.netbeans.modules.versioning.system.cvss.CvsFileNode;
import org.netbeans.modules.versioning.system.cvss.CvsVersioningSystem;
import org.netbeans.modules.versioning.system.cvss.FileInformation;
import org.netbeans.modules.versioning.system.cvss.ui.actions.diff.DiffAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.diff.ResolveConflictsAction;
import org.netbeans.modules.versioning.system.cvss.util.Utils;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;

public class SyncFileNode
extends AbstractNode {
    private CvsFileNode node;
    static final String COLUMN_NAME_NAME = "name";
    static final String COLUMN_NAME_PATH = "path";
    static final String COLUMN_NAME_STATUS = "status";
    static final String COLUMN_NAME_STICKY = "sticky";
    private String htmlDisplayName;
    private String sticky;
    private static final String[] zeros = new String[]{"", "00", "0", ""};

    public SyncFileNode(CvsFileNode cvsFileNode) {
        this(Children.LEAF, cvsFileNode);
    }

    private SyncFileNode(Children children, CvsFileNode cvsFileNode) {
        super(children, Lookups.fixed((Object[])cvsFileNode.getLookupObjects()));
        this.node = cvsFileNode;
        this.initProperties();
        this.refreshHtmlDisplayName();
    }

    public File getFile() {
        return this.node.getFile();
    }

    public FileInformation getFileInformation() {
        return this.node.getInformation();
    }

    public String getName() {
        return this.node.getName();
    }

    public Action getPreferredAction() {
        if (this.node.getInformation().getStatus() == 64) {
            return SystemAction.get(ResolveConflictsAction.class);
        }
        return SystemAction.get(DiffAction.class);
    }

    public Node.Cookie getCookie(Class clazz) {
        FileObject fileObject = FileUtil.toFileObject((File)this.getFile());
        if (fileObject != null) {
            try {
                DataObject dataObject = DataObject.find((FileObject)fileObject);
                if (fileObject.equals(dataObject.getPrimaryFile())) {
                    return dataObject.getCookie(clazz);
                }
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                // empty catch block
            }
        }
        return super.getCookie(clazz);
    }

    private void initProperties() {
        if (this.node.getFile().isDirectory()) {
            this.setIconBaseWithExtension("org/openide/loaders/defaultFolder.gif");
        }
        Sheet sheet = Sheet.createDefault();
        Sheet.Set set = Sheet.createPropertiesSet();
        set.put((Node.Property)new NameProperty());
        set.put((Node.Property)new PathProperty());
        set.put((Node.Property)new StatusProperty());
        set.put((Node.Property)new StickyProperty());
        sheet.put(set);
        this.setSheet(sheet);
    }

    private void refreshHtmlDisplayName() {
        FileInformation fileInformation = this.node.getInformation();
        int n = fileInformation.getStatus();
        if (n == 128) {
            n = 64;
        }
        this.htmlDisplayName = CvsVersioningSystem.getInstance().getAnnotator().annotateNameHtml(this.node.getFile().getName(), fileInformation, null);
        this.fireDisplayNameChange(this.node.getName(), this.node.getName());
    }

    public String getHtmlDisplayName() {
        return this.htmlDisplayName;
    }

    public void refresh() {
        this.refreshHtmlDisplayName();
    }

    public String getSticky() {
        if (this.sticky == null && (this.sticky = Utils.getSticky(this.node.getFile())) == null) {
            this.sticky = "";
        }
        return this.sticky == null || this.sticky.length() == 0 ? "" : this.sticky;
    }

    private class StatusProperty
    extends SyncFileProperty {
        public StatusProperty() {
            super(SyncFileNode.COLUMN_NAME_STATUS, String.class, NbBundle.getMessage(SyncFileNode.class, (String)"BK2007"), NbBundle.getMessage(SyncFileNode.class, (String)"BK2008"));
            String string = Utils.getRelativePath(SyncFileNode.this.node.getFile());
            String string2 = Integer.toString(Utils.getComparableStatus(SyncFileNode.this.node.getInformation().getStatus()));
            this.setValue("sortkey", zeros[string2.length()] + string2 + "\t" + string + "\t" + SyncFileNode.this.getName());
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return SyncFileNode.this.node.getInformation().getStatusText();
        }
    }

    private class NameProperty
    extends SyncFileProperty {
        public NameProperty() {
            super(SyncFileNode.COLUMN_NAME_NAME, String.class, NbBundle.getMessage(SyncFileNode.class, (String)"BK2005"), NbBundle.getMessage(SyncFileNode.class, (String)"BK2006"));
            this.setValue("sortkey", SyncFileNode.this.getName());
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return SyncFileNode.this.getDisplayName();
        }
    }

    private class PathProperty
    extends SyncFileProperty {
        private String shortPath;

        public PathProperty() {
            super(SyncFileNode.COLUMN_NAME_PATH, String.class, NbBundle.getMessage(SyncFileNode.class, (String)"BK2003"), NbBundle.getMessage(SyncFileNode.class, (String)"BK2004"));
            this.shortPath = Utils.getRelativePath(SyncFileNode.this.node.getFile());
            this.setValue("sortkey", this.shortPath + "\t" + SyncFileNode.this.getName());
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.shortPath;
        }
    }

    private class StickyProperty
    extends SyncFileProperty {
        public StickyProperty() {
            super(SyncFileNode.COLUMN_NAME_STICKY, String.class, NbBundle.getMessage(SyncFileNode.class, (String)"BK2001"), NbBundle.getMessage(SyncFileNode.class, (String)"BK2002"));
        }

        public Object getValue() {
            return SyncFileNode.this.getSticky();
        }
    }

    private abstract class SyncFileProperty
    extends PropertySupport.ReadOnly {
        protected SyncFileProperty(String string, Class clazz, String string2, String string3) {
            super(string, clazz, string2, string3);
        }

        public String toString() {
            try {
                return this.getValue().toString();
            }
            catch (Exception exception) {
                ErrorManager.getDefault().notify(1, (Throwable)exception);
                return exception.getLocalizedMessage();
            }
        }
    }
}

