/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.actions.add;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import org.netbeans.lib.cvsclient.command.Command;
import org.netbeans.lib.cvsclient.command.GlobalOptions;
import org.netbeans.lib.cvsclient.command.add.AddCommand;
import org.netbeans.lib.cvsclient.command.add.AddInformation;
import org.netbeans.modules.versioning.system.cvss.ClientRuntime;
import org.netbeans.modules.versioning.system.cvss.CvsVersioningSystem;
import org.netbeans.modules.versioning.system.cvss.ExecutorSupport;
import org.netbeans.modules.versioning.system.cvss.FileStatusCache;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;

public class AddExecutor
extends ExecutorSupport {
    private static final Comparator byLengthComparator = new Comparator(){

        public int compare(Object object, Object object2) {
            File file = (File)object;
            File file2 = (File)object2;
            return file.getAbsolutePath().length() - file2.getAbsolutePath().length();
        }
    };

    public static AddExecutor[] splitCommand(AddCommand addCommand, CvsVersioningSystem cvsVersioningSystem, GlobalOptions globalOptions) {
        int n;
        File[][] fileArray;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        File[] fileArray2 = AddExecutor.getNewDirectories(addCommand.getFiles());
        if (fileArray2.length > 0) {
            try {
                fileArray = AddExecutor.splitFiles(fileArray2);
                for (n = 0; n < fileArray.length; ++n) {
                    File[] fileArray3 = fileArray[n];
                    Arrays.sort(fileArray3, byLengthComparator);
                    arrayList.add(fileArray3);
                }
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
                return null;
            }
        }
        try {
            fileArray = AddExecutor.splitFiles(addCommand.getFiles());
            arrayList.addAll(Arrays.asList(fileArray));
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
            return null;
        }
        fileArray = new AddCommand[arrayList.size()];
        for (n = 0; n < fileArray.length; ++n) {
            fileArray[n] = (AddCommand)addCommand.clone();
            fileArray[n].setFiles((File[])arrayList.get(n));
        }
        AddExecutor[] addExecutorArray = new AddExecutor[fileArray.length];
        for (int i = 0; i < fileArray.length; ++i) {
            File[] fileArray4 = fileArray[i];
            int n2 = fileArray4.getFiles().length;
            String string = n2 == 1 ? fileArray4.getFiles()[0].getName() : NbBundle.getMessage(AddExecutor.class, (String)"MSG_AddExecutor_CmdDisplayXfiles", (Object)Integer.toString(n2));
            fileArray4.setDisplayName(NbBundle.getMessage(AddExecutor.class, (String)"MSG_AddExecutor_CmdDisplayName", (Object)string));
            addExecutorArray[i] = new AddExecutor(cvsVersioningSystem, (AddCommand)fileArray4, globalOptions);
        }
        return addExecutorArray;
    }

    private static File[] getNewDirectories(File[] fileArray) {
        FileStatusCache fileStatusCache = CvsVersioningSystem.getInstance().getStatusCache();
        HashSet<File> hashSet = new HashSet<File>();
        for (int i = 0; i < fileArray.length; ++i) {
            File file = fileArray[i].getParentFile();
            while (fileStatusCache.getStatus(file).getStatus() == 4) {
                hashSet.add(file);
                if ((file = file.getParentFile()) != null) continue;
            }
        }
        ArrayList arrayList = new ArrayList(hashSet);
        return arrayList.toArray(new File[arrayList.size()]);
    }

    private AddExecutor(CvsVersioningSystem cvsVersioningSystem, AddCommand addCommand, GlobalOptions globalOptions) {
        super(cvsVersioningSystem, (Command)addCommand, globalOptions);
    }

    protected void commandFinished(ClientRuntime.Result result) {
        HashSet<File> hashSet = new HashSet<File>();
        for (AddInformation object : this.toRefresh) {
            File file = object.getFile();
            this.cache.refreshCached(file, object.getType().charAt(0));
            hashSet.add(file.getParentFile());
        }
        this.toRefresh.clear();
        for (File file : hashSet) {
            this.cache.refreshCached(file, 0);
        }
    }
}

