/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.embedder.exec;

import java.util.Stack;
import org.apache.maven.wagon.events.TransferEvent;
import org.apache.maven.wagon.events.TransferListener;
import org.apache.maven.wagon.resource.Resource;
import org.netbeans.api.progress.aggregate.AggregateProgressFactory;
import org.netbeans.api.progress.aggregate.AggregateProgressHandle;
import org.netbeans.api.progress.aggregate.ProgressContributor;
import org.openide.util.NbBundle;

public class ProgressTransferListener
implements TransferListener {
    private static ThreadLocal<Integer> lengthRef = new ThreadLocal();
    private static ThreadLocal<Integer> countRef = new ThreadLocal();
    private static ThreadLocal<ProgressContributor> contribRef = new ThreadLocal();
    private static ThreadLocal<ProgressContributor> pomcontribRef = new ThreadLocal();
    private static ThreadLocal<Integer> pomCountRef = new ThreadLocal();
    private static ThreadLocal<Stack<ProgressContributor>> contribStackRef = new ThreadLocal();
    private static ThreadLocal<AggregateProgressHandle> handleRef = new ThreadLocal();
    private static final int POM_MAX = 20;

    public static void setAggregateHandle(AggregateProgressHandle aggregateProgressHandle) {
        handleRef.set(aggregateProgressHandle);
        contribStackRef.set(new Stack());
        ProgressContributor progressContributor = AggregateProgressFactory.createProgressContributor((String)"Pom files");
        aggregateProgressHandle.addContributor(progressContributor);
        progressContributor.start(20);
        pomCountRef.set(new Integer(0));
        pomcontribRef.set(progressContributor);
    }

    public static void clearAggregateHandle() {
        handleRef.remove();
        contribRef.remove();
        contribStackRef.remove();
        pomcontribRef.remove();
        pomCountRef.remove();
    }

    private String getResourceName(Resource resource) {
        int n = resource.getName().lastIndexOf("/");
        return n > -1 ? resource.getName().substring(n + 1) : resource.getName();
    }

    public void transferInitiated(TransferEvent transferEvent) {
        if (handleRef.get() == null || contribStackRef.get() == null) {
            return;
        }
        assert (handleRef.get() != null);
        assert (contribStackRef.get() != null);
        Resource resource = transferEvent.getResource();
        String string = this.getResourceName(resource);
        if (!string.endsWith(".pom")) {
            ProgressContributor progressContributor;
            Stack<ProgressContributor> stack = contribStackRef.get();
            ProgressContributor progressContributor2 = progressContributor = stack != null && !stack.empty() ? stack.pop() : null;
            if (progressContributor == null) {
                String string2 = transferEvent.getRequestType() == 5 ? NbBundle.getMessage(ProgressTransferListener.class, (String)"TXT_Download", (Object)string) : NbBundle.getMessage(ProgressTransferListener.class, (String)"TXT_Uploading", (Object)string);
                progressContributor = AggregateProgressFactory.createProgressContributor((String)string2);
                handleRef.get().addContributor(progressContributor);
            }
            contribRef.set(progressContributor);
        } else {
            String string3 = transferEvent.getRequestType() == 5 ? NbBundle.getMessage(ProgressTransferListener.class, (String)"TXT_Download", (Object)string) : NbBundle.getMessage(ProgressTransferListener.class, (String)"TXT_Uploading", (Object)string);
            ProgressContributor progressContributor = AggregateProgressFactory.createProgressContributor((String)string3);
            contribStackRef.get().add(progressContributor);
            handleRef.get().addContributor(progressContributor);
            int n = pomCountRef.get();
            if (n < 19) {
                pomcontribRef.get().progress(NbBundle.getMessage(ProgressTransferListener.class, (String)"TXT_Started", (Object)string), ++n);
                pomCountRef.set(new Integer(n));
            } else {
                pomcontribRef.get().progress(NbBundle.getMessage(ProgressTransferListener.class, (String)"TXT_Started", (Object)string));
            }
        }
    }

    public void transferStarted(TransferEvent transferEvent) {
        if (contribRef.get() == null || handleRef.get() == null) {
            return;
        }
        Resource resource = transferEvent.getResource();
        int n = (int)Math.min(Integer.MAX_VALUE, resource.getContentLength());
        if (n < 0) {
            contribRef.get().start(0);
        } else {
            contribRef.get().start(n);
        }
        lengthRef.set(n);
        countRef.set(0);
        contribRef.get().progress(NbBundle.getMessage(ProgressTransferListener.class, (String)"TXT_Started", (Object)this.getResourceName(resource)));
    }

    public void transferProgress(TransferEvent transferEvent, byte[] byArray, int n) {
        if (contribRef.get() == null) {
            return;
        }
        long l = countRef.get().intValue();
        if (n > 0) {
            l += (long)n;
        }
        l = Math.min(Integer.MAX_VALUE, l);
        if (lengthRef.get() < 0) {
            contribRef.get().progress(NbBundle.getMessage(ProgressTransferListener.class, (String)"TXT_Transferring", (Object)this.getResourceName(transferEvent.getResource())));
        } else {
            l = Math.min(l, (long)lengthRef.get().intValue());
            contribRef.get().progress(NbBundle.getMessage(ProgressTransferListener.class, (String)"TXT_Transferred", (Object)this.getResourceName(transferEvent.getResource()), (Object)l), (int)l);
        }
        countRef.set((int)l);
    }

    public void transferCompleted(TransferEvent transferEvent) {
        if (contribRef.get() == null) {
            return;
        }
        contribRef.get().finish();
        contribRef.remove();
    }

    public void transferError(TransferEvent transferEvent) {
        this.transferCompleted(transferEvent);
    }

    public void debug(String string) {
    }
}

