/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.sql;

import java.util.prefs.Preferences;
import javax.swing.text.Document;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.php.editor.sql.PHPSQLCompletion;
import org.netbeans.modules.php.editor.sql.ui.SelectConnectionPanel;
import org.openide.filesystems.FileObject;

public class DatabaseConnectionSupport {
    private static final String PROP_DBCONN = "dbconn";

    public static DatabaseConnection selectDatabaseConnection(Document document, boolean bl, boolean bl2) {
        DatabaseConnection databaseConnection = DatabaseConnectionSupport.getDatabaseConnection(document, false);
        databaseConnection = SelectConnectionPanel.selectConnection(databaseConnection, bl, bl2);
        DatabaseConnectionSupport.setDatabaseConnection(document, databaseConnection, true);
        return databaseConnection;
    }

    public static DatabaseConnection selectDatabaseConnection() {
        return DatabaseConnectionSupport.selectDatabaseConnection(null, false, false);
    }

    public static DatabaseConnection selectDatabaseConnection(boolean bl, boolean bl2) {
        return DatabaseConnectionSupport.selectDatabaseConnection(null, bl, bl2);
    }

    public static DatabaseConnection selectDatabaseConnection(Document document) {
        return DatabaseConnectionSupport.selectDatabaseConnection(document, false, false);
    }

    private static DatabaseConnection getDatabaseConnection(String string, boolean bl) {
        DatabaseConnection databaseConnection = null;
        if (string != null) {
            databaseConnection = ConnectionManager.getDefault().getConnection(string);
        }
        if (databaseConnection != null && databaseConnection.getJDBCConnection() == null && bl) {
            ConnectionManager.getDefault().showConnectionDialog(databaseConnection);
        }
        return databaseConnection;
    }

    public static DatabaseConnection getDatabaseConnection(Document document, boolean bl) {
        if (document == null) {
            return null;
        }
        Project project = DatabaseConnectionSupport.getProject(document);
        String string = project != null ? DatabaseConnectionSupport.getProjectPreferences(project).get(PROP_DBCONN, null) : null;
        return DatabaseConnectionSupport.getDatabaseConnection(string, bl);
    }

    private static Preferences getProjectPreferences(Project project) {
        return ProjectUtils.getPreferences((Project)project, PHPSQLCompletion.class, (boolean)false);
    }

    private static Project getProject(Document document) {
        if (document == null) {
            return null;
        }
        FileObject fileObject = NbEditorUtilities.getFileObject((Document)document);
        if (fileObject != null) {
            return FileOwnerQuery.getOwner((FileObject)fileObject);
        }
        return null;
    }

    private static void setDatabaseConnection(Project project, DatabaseConnection databaseConnection) {
        if (project == null) {
            return;
        }
        Preferences preferences = DatabaseConnectionSupport.getProjectPreferences(project);
        if (databaseConnection != null) {
            preferences.put(PROP_DBCONN, databaseConnection.getName());
        } else {
            preferences.remove(PROP_DBCONN);
        }
    }

    private static void setDatabaseConnection(Document document, DatabaseConnection databaseConnection, boolean bl) {
        Project project = DatabaseConnectionSupport.getProject(document);
        if (project != null) {
            DatabaseConnectionSupport.setDatabaseConnection(DatabaseConnectionSupport.getProject(document), databaseConnection);
        }
    }
}

