/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.indent;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.lexer.TokenUtilities;
import org.netbeans.modules.editor.indent.spi.Context;
import org.netbeans.modules.php.editor.indent.CodeStyle;
import org.netbeans.modules.php.editor.lexer.LexUtilities;
import org.netbeans.modules.php.editor.lexer.PHPTokenId;
import org.netbeans.modules.php.editor.parser.astnodes.Block;
import org.netbeans.modules.php.editor.parser.astnodes.ForStatement;
import org.netbeans.modules.php.editor.parser.astnodes.NamespaceDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultTreePathVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class WSTransformer
extends DefaultTreePathVisitor {
    private String newLineReplacement = "\n";
    private Context context;
    private List<Replacement> replacements = new LinkedList<Replacement>();
    private Collection<CodeRange> unbreakableRanges = new TreeSet<CodeRange>();
    private Collection<Integer> breakPins = new LinkedList<Integer>();
    private Collection<PHPTokenId> WS_AND_COMMENT_TOKENS = Arrays.asList(PHPTokenId.PHPDOC_COMMENT_START, PHPTokenId.PHPDOC_COMMENT_END, PHPTokenId.PHPDOC_COMMENT, PHPTokenId.WHITESPACE, PHPTokenId.PHP_COMMENT_START, PHPTokenId.PHP_COMMENT_END, PHPTokenId.PHP_COMMENT, PHPTokenId.PHP_LINE_COMMENT);
    private Collection<PHPTokenId> NO_BREAK_B4_TKNS = Arrays.asList(PHPTokenId.PHP_CLOSETAG, PHPTokenId.PHP_ELSE, PHPTokenId.PHP_ELSEIF, PHPTokenId.PHP_ELSE, PHPTokenId.PHP_CATCH, PHPTokenId.PHP_WHILE);

    public WSTransformer(Context context) {
        this.context = context;
        String string = CodeStyle.get(context.document()).getOpeningBraceStyle();
        this.newLineReplacement = "ob.new_line".equals(string) ? "\n" : " ";
    }

    @Override
    public void visit(Block block) {
        if (this.getPath().get(0) instanceof NamespaceDeclaration) {
            super.visit(block);
            return;
        }
        if (block.isCurly()) {
            int n;
            TokenSequence<PHPTokenId> tokenSequence = this.tokenSequence(block.getStartOffset());
            tokenSequence.move(block.getStartOffset());
            if (tokenSequence.moveNext() && tokenSequence.token().id() == PHPTokenId.PHP_CURLY_OPEN) {
                boolean bl;
                n = tokenSequence.offset();
                int n2 = 0;
                if (tokenSequence.movePrevious() && tokenSequence.token().id() == PHPTokenId.WHITESPACE) {
                    n2 = tokenSequence.token().length();
                }
                boolean bl2 = bl = tokenSequence.token().id() == PHPTokenId.PHP_OPENTAG;
                if (!bl && n2 > 0 && tokenSequence.movePrevious()) {
                    boolean bl3 = bl = tokenSequence.token().id() == PHPTokenId.PHP_OPENTAG;
                }
                if (!bl) {
                    Replacement replacement = new Replacement(n, n2, this.newLineReplacement);
                    this.replacements.add(replacement);
                }
            }
            tokenSequence.move(block.getStartOffset());
            if (tokenSequence.moveNext() && !this.doNotSplitLine(tokenSequence, true)) {
                Replacement replacement = new Replacement(tokenSequence.offset() + tokenSequence.token().length(), 0, "\n");
                this.replacements.add(replacement);
            }
            tokenSequence.move(block.getEndOffset());
            if (tokenSequence.movePrevious()) {
                n = tokenSequence.offset();
                if (!this.doNotSplitLine(tokenSequence, false)) {
                    tokenSequence.movePrevious();
                    if (tokenSequence.token().id() != PHPTokenId.PHP_SEMICOLON && tokenSequence.token().id() != PHPTokenId.PHP_OPENTAG) {
                        Replacement replacement = new Replacement(n, 0, "\n");
                        this.replacements.add(replacement);
                    }
                    tokenSequence.moveNext();
                }
                tokenSequence.move(block.getEndOffset());
                if (tokenSequence.movePrevious() && !this.doNotSplitLine(tokenSequence, true)) {
                    tokenSequence.move(block.getEndOffset());
                    if (tokenSequence.moveNext()) {
                        PHPTokenId pHPTokenId;
                        if (tokenSequence.token().id() == PHPTokenId.WHITESPACE) {
                            tokenSequence.moveNext();
                        }
                        if (!((pHPTokenId = (PHPTokenId)tokenSequence.token().id()) == PHPTokenId.PHP_SEMICOLON || pHPTokenId == PHPTokenId.PHP_TOKEN && TokenUtilities.equals((CharSequence)tokenSequence.token().text(), (Object)","))) {
                            Replacement replacement = new Replacement(tokenSequence.offset() + tokenSequence.token().length(), 0, "\n");
                            this.replacements.add(replacement);
                        }
                    }
                }
            }
        }
        super.visit(block);
    }

    @Override
    public void visit(ForStatement forStatement) {
        int n = forStatement.getStartOffset();
        int n2 = forStatement.getBody().getStartOffset();
        this.unbreakableRanges.add(new CodeRange(n, n2));
        super.visit(forStatement);
    }

    public void tokenScan() {
        TokenSequence<PHPTokenId> tokenSequence = this.tokenSequence(0);
        tokenSequence.moveStart();
        while (tokenSequence.moveNext()) {
            if (this.isWithinUnbreakableRange(tokenSequence.offset()) || !this.splitTrigger(tokenSequence)) continue;
            int n = tokenSequence.offset() + 1;
            if (this.doNotSplitLine(tokenSequence, true)) continue;
            Replacement replacement = new Replacement(n, 0, "\n");
            this.replacements.add(replacement);
        }
    }

    private boolean splitTrigger(TokenSequence<PHPTokenId> tokenSequence) {
        PHPTokenId pHPTokenId = (PHPTokenId)tokenSequence.token().id();
        return pHPTokenId == PHPTokenId.PHP_SEMICOLON;
    }

    private boolean doNotSplitLine(TokenSequence<PHPTokenId> tokenSequence, boolean bl) {
        boolean bl2 = false;
        while (bl && tokenSequence.moveNext() || !bl && tokenSequence.movePrevious()) {
            if (this.WS_AND_COMMENT_TOKENS.contains(tokenSequence.token().id())) {
                if (!WSTransformer.textContainsBreak(tokenSequence.token().text())) continue;
                bl2 = true;
                break;
            }
            bl2 = this.NO_BREAK_B4_TKNS.contains(tokenSequence.token().id());
            if (bl) {
                tokenSequence.movePrevious();
                break;
            }
            tokenSequence.moveNext();
            break;
        }
        return bl2;
    }

    private static final boolean textContainsBreak(CharSequence charSequence) {
        for (int i = 0; i < charSequence.length(); ++i) {
            if (charSequence.charAt(i) != '\n') continue;
            return true;
        }
        return false;
    }

    private boolean isWithinUnbreakableRange(int n) {
        for (CodeRange codeRange : this.unbreakableRanges) {
            if (!codeRange.contains(n)) continue;
            return true;
        }
        return false;
    }

    List<Replacement> getReplacements() {
        return this.replacements;
    }

    private TokenSequence<PHPTokenId> tokenSequence(int n) {
        return LexUtilities.getPHPTokenSequence(this.context.document(), n);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class CodeRange
    implements Comparable<CodeRange> {
        private Integer start;
        private Integer end;

        public CodeRange(int n, int n2) {
            this.start = n;
            this.end = n2;
        }

        boolean contains(int n) {
            return n >= this.start && n <= this.end;
        }

        @Override
        public int compareTo(CodeRange codeRange) {
            int n = this.start.compareTo(codeRange.start);
            if (n == 0) {
                return this.end.compareTo(codeRange.end);
            }
            return n;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Replacement
    implements Comparable<Replacement> {
        private Integer offset;
        private int length;
        private String newString;

        public Replacement(int n, int n2, String string) {
            this.offset = n;
            this.length = n2;
            this.newString = string;
        }

        public int length() {
            return this.length;
        }

        public String newString() {
            return this.newString;
        }

        public int offset() {
            return this.offset;
        }

        @Override
        public int compareTo(Replacement replacement) {
            return this.offset.compareTo(replacement.offset);
        }
    }
}

