/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.codegen;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.text.Document;
import org.netbeans.lib.editor.codetemplates.spi.CodeTemplateInsertRequest;
import org.netbeans.lib.editor.codetemplates.spi.CodeTemplateParameter;
import org.netbeans.lib.editor.codetemplates.spi.CodeTemplateProcessor;
import org.netbeans.lib.editor.codetemplates.spi.CodeTemplateProcessorFactory;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.editor.codegen.ASTNodeUtilities;
import org.netbeans.modules.php.editor.model.Model;
import org.netbeans.modules.php.editor.model.ModelElement;
import org.netbeans.modules.php.editor.model.ModelUtils;
import org.netbeans.modules.php.editor.model.TypeScope;
import org.netbeans.modules.php.editor.model.VariableName;
import org.netbeans.modules.php.editor.model.VariableScope;
import org.netbeans.modules.php.editor.nav.NavUtils;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.Assignment;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultVisitor;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PHPCodeTemplateProcessor
implements CodeTemplateProcessor {
    private static final String NEW_VAR_NAME = "newVarName";
    private static final String VARIABLE_FROM_NEXT_ASSIGNMENT_NAME = "variableFromNextAssignmentName";
    private static final String VARIABLE_FROM_NEXT_ASSIGNMENT_TYPE = "variableFromNextAssignmentType";
    private static final String VARIABLE_FROM_PREVIOUS_ASSIGNMENT = "variableFromPreviousAssignment";
    private static final String INSTANCE_OF = "instanceof";
    private final CodeTemplateInsertRequest request;
    private ParserResult info;

    public PHPCodeTemplateProcessor(CodeTemplateInsertRequest codeTemplateInsertRequest) {
        this.request = codeTemplateInsertRequest;
    }

    public void updateDefaultValues() {
        for (CodeTemplateParameter codeTemplateParameter : this.request.getMasterParameters()) {
            String string = this.getProposedValue(codeTemplateParameter);
            if (string == null || string.equals(codeTemplateParameter.getValue())) continue;
            codeTemplateParameter.setValue(string);
        }
    }

    public void parameterValueChanged(CodeTemplateParameter codeTemplateParameter, boolean bl) {
    }

    public void release() {
    }

    private String getNextVariableType() {
        List<? extends VariableName> list;
        VariableName variableName;
        int n = this.request.getComponent().getCaretPosition();
        Collection<? extends VariableName> collection = this.getDeclaredVariables(n);
        String string = this.getNextVariableName();
        if (string == null || collection == null) {
            return null;
        }
        if (string.charAt(0) != '$') {
            string = "$" + string;
        }
        if ((variableName = ModelUtils.getFirst(list = ModelUtils.filter(collection, string))) != null) {
            String string2 = StringUtils.implode(this.getUniqueTypeNames(variableName, n), (String)"|");
            if (!StringUtils.hasText((String)string2)) {
                return null;
            }
            return string2;
        }
        return null;
    }

    private String getProposedValue(CodeTemplateParameter codeTemplateParameter) {
        String string = null;
        boolean bl = false;
        boolean bl2 = false;
        String string2 = null;
        for (Map.Entry entry : codeTemplateParameter.getHints().entrySet()) {
            String string3 = (String)entry.getKey();
            if ("default".equals(string3)) {
                assert (string == null) : "default already set to " + string;
                string = codeTemplateParameter.getValue();
                continue;
            }
            if (NEW_VAR_NAME.equals(string3)) {
                assert (!bl) : "newVarName already set";
                bl = true;
                continue;
            }
            if (VARIABLE_FROM_NEXT_ASSIGNMENT_NAME.equals(string3)) {
                return this.getNextVariableName();
            }
            if (VARIABLE_FROM_NEXT_ASSIGNMENT_TYPE.equals(string3)) {
                return this.getNextVariableType();
            }
            if (VARIABLE_FROM_PREVIOUS_ASSIGNMENT.equals(string3)) {
                assert (!bl2) : "previousVariable already set";
                bl2 = true;
                continue;
            }
            if (!INSTANCE_OF.equals(string3)) continue;
            assert (string2 == null) : "type already set to " + string2;
            string2 = (String)entry.getValue();
        }
        if (bl) {
            return this.newVarName(string);
        }
        if (bl2) {
            return this.getPreviousVariable(string2);
        }
        return null;
    }

    private String getNextVariableName() {
        if (!this.initParsing()) {
            return null;
        }
        int n = this.request.getComponent().getCaretPosition();
        ModelElement modelElement = null;
        Collection<? extends VariableName> collection = this.getDeclaredVariables(n);
        if (collection != null) {
            for (VariableName variableName : collection) {
                int n2;
                if (modelElement == null) {
                    modelElement = variableName;
                    continue;
                }
                int n3 = Math.abs(variableName.getNameRange().getStart() - n);
                if (n3 >= (n2 = Math.abs(modelElement.getNameRange().getStart() - n))) continue;
                modelElement = variableName;
            }
        }
        return modelElement != null ? modelElement.getName().substring(1) : null;
    }

    private String getPreviousVariable(String string) {
        if (!this.initParsing()) {
            return null;
        }
        int n = this.request.getComponent().getCaretPosition();
        ModelElement modelElement = null;
        Collection<? extends VariableName> collection = this.getDeclaredVariables(n);
        if (collection != null) {
            for (VariableName variableName : collection) {
                int n2 = variableName.getNameRange().getStart() - n;
                if (n2 >= 0 || !this.hasType(variableName, n, string)) continue;
                if (modelElement == null) {
                    modelElement = variableName;
                    continue;
                }
                int n3 = modelElement.getNameRange().getStart() - n;
                assert (n3 < 0);
                if (n2 <= n3) continue;
                modelElement = variableName;
            }
        }
        return modelElement != null ? modelElement.getName() : null;
    }

    private boolean hasType(VariableName variableName, int n, String string) {
        if (string == null) {
            return true;
        }
        return variableName.getTypeNames(n).contains(string);
    }

    private List<String> getUniqueTypeNames(VariableName variableName, int n) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (TypeScope typeScope : variableName.getTypes(n)) {
            if (arrayList.contains(typeScope.getName())) continue;
            arrayList.add(typeScope.getName());
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String newVarName(String string) {
        if (!this.initParsing()) {
            return null;
        }
        int n = this.request.getComponent().getCaretPosition();
        int n2 = 0;
        final String[] stringArray = new String[]{null};
        PHPCodeTemplateProcessor pHPCodeTemplateProcessor = this;
        synchronized (pHPCodeTemplateProcessor) {
            while (true) {
                stringArray[0] = string + (n2 > 0 ? String.valueOf(n2) : "");
                Set<String> set = ASTNodeUtilities.getVariablesInScope(this.info, n, new ASTNodeUtilities.VariableAcceptor(){

                    public boolean acceptVariable(String string) {
                        return stringArray[0].equals(string);
                    }
                });
                if (set.isEmpty()) break;
                ++n2;
            }
        }
        return stringArray[0];
    }

    private synchronized boolean initParsing() {
        if (this.info != null) {
            return true;
        }
        Document document = this.request.getComponent().getDocument();
        FileObject fileObject = NavUtils.getFile(document);
        if (fileObject == null) {
            return false;
        }
        try {
            ParserManager.parse(Collections.singleton(Source.create((Document)document)), (UserTask)new UserTask(){

                public void run(ResultIterator resultIterator) throws Exception {
                    PHPCodeTemplateProcessor.this.info = (PHPParseResult)resultIterator.getParserResult();
                }
            });
        }
        catch (ParseException parseException) {
            Exceptions.printStackTrace((Throwable)parseException);
            this.info = null;
            return false;
        }
        return true;
    }

    private Collection<? extends VariableName> getDeclaredVariables(int n) {
        Model model = ((PHPParseResult)this.info).getModel();
        VariableScope variableScope = model.getVariableScope(n);
        if (variableScope != null) {
            return variableScope.getDeclaredVariables();
        }
        return null;
    }

    private static final class AssignmentLocator
    extends DefaultVisitor {
        private int offset;
        protected Assignment node = null;

        private AssignmentLocator() {
        }

        public Assignment locate(ASTNode aSTNode, int n) {
            this.offset = n;
            this.scan(aSTNode);
            return this.node;
        }

        public void scan(ASTNode aSTNode) {
            if (this.node == null && aSTNode != null) {
                aSTNode.accept(this);
            }
        }

        public void visit(Assignment assignment) {
            if (assignment != null && assignment.getStartOffset() > this.offset) {
                this.node = assignment;
            }
        }
    }

    public static final class Factory
    implements CodeTemplateProcessorFactory {
        public CodeTemplateProcessor createProcessor(CodeTemplateInsertRequest codeTemplateInsertRequest) {
            return new PHPCodeTemplateProcessor(codeTemplateInsertRequest);
        }
    }
}

