/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.debugger.model;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.Action;
import org.netbeans.modules.ruby.debugger.ContextProviderWrapper;
import org.netbeans.modules.ruby.debugger.RubySession;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.NodeActionsProvider;
import org.netbeans.spi.viewmodel.NodeModel;
import org.netbeans.spi.viewmodel.TableModel;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.NbBundle;
import org.rubyforge.debugcommons.model.RubyThreadInfo;

public final class ThreadsModel
implements TreeModel,
TableModel,
NodeModel,
NodeActionsProvider {
    private static final String CURRENT = "org/netbeans/modules/debugger/resources/threadsView/CurrentThread";
    private static final String RUNNING = "org/netbeans/modules/debugger/resources/threadsView/RunningThread";
    private static final String SUSPENDED = "org/netbeans/modules/debugger/resources/threadsView/SuspendedThread";
    private ContextProviderWrapper contextProvider;
    private final RubySession rubySession;
    private final List<ModelListener> listeners;

    public ThreadsModel(ContextProvider contextProvider) {
        this.contextProvider = new ContextProviderWrapper(contextProvider);
        this.rubySession = this.contextProvider.getRubySession();
        this.listeners = new CopyOnWriteArrayList<ModelListener>();
    }

    public Object getRoot() {
        return "Root";
    }

    public Object[] getChildren(Object object, int n, int n2) throws UnknownTypeException {
        if (object == "Root") {
            return this.rubySession.getThreadInfos();
        }
        throw new UnknownTypeException(object);
    }

    public boolean isLeaf(Object object) throws UnknownTypeException {
        if (object == "Root") {
            return false;
        }
        if (object instanceof RubyThreadInfo) {
            return true;
        }
        throw new UnknownTypeException(object);
    }

    public int getChildrenCount(Object object) throws UnknownTypeException {
        if (object == "Root") {
            return this.rubySession.getThreadInfos().length;
        }
        throw new UnknownTypeException(object);
    }

    public void addModelListener(ModelListener modelListener) {
        this.listeners.add(modelListener);
    }

    public void removeModelListener(ModelListener modelListener) {
        this.listeners.remove(modelListener);
    }

    public void fireChanges() {
        for (ModelListener modelListener : this.listeners) {
            modelListener.modelChanged((ModelEvent)new ModelEvent.TreeChanged((Object)this));
        }
    }

    public String getDisplayName(Object object) throws UnknownTypeException {
        if (object == "Root") {
            return NbBundle.getMessage(ThreadsModel.class, (String)"CTL_ThreadsModel.Column.Name.Name");
        }
        if (object instanceof RubyThreadInfo) {
            RubyThreadInfo rubyThreadInfo = (RubyThreadInfo)object;
            String string = this.getThreadName(rubyThreadInfo);
            return this.rubySession.isActiveThread(rubyThreadInfo.getId()) ? "<html><b>" + string + "</b></html>" : string;
        }
        throw new UnknownTypeException(object);
    }

    public String getIconBase(Object object) throws UnknownTypeException {
        if (object == "Root" || object instanceof RubyThreadInfo) {
            RubyThreadInfo rubyThreadInfo = (RubyThreadInfo)object;
            if (this.rubySession.isActiveThread(rubyThreadInfo.getId())) {
                return CURRENT;
            }
            if (this.rubySession.isSuspended(rubyThreadInfo)) {
                return SUSPENDED;
            }
            return RUNNING;
        }
        throw new UnknownTypeException(object);
    }

    public String getShortDescription(Object object) throws UnknownTypeException {
        if (object == "Root") {
            return NbBundle.getMessage(ThreadsModel.class, (String)"CTL_ThreadsModel.Column.Name.Desc");
        }
        if (object instanceof RubyThreadInfo) {
            return this.getThreadName((RubyThreadInfo)object);
        }
        throw new UnknownTypeException(object);
    }

    public Object getValueAt(Object object, String string) throws UnknownTypeException {
        if (object instanceof RubyThreadInfo && "ThreadState".equals(string)) {
            return ((RubyThreadInfo)object).getStatus();
        }
        throw new UnknownTypeException(object);
    }

    public boolean isReadOnly(Object object, String string) throws UnknownTypeException {
        if (object instanceof RubyThreadInfo && "ThreadState".equals(string)) {
            return true;
        }
        throw new UnknownTypeException(object);
    }

    public void setValueAt(Object object, String string, Object object2) throws UnknownTypeException {
        throw new UnknownTypeException(object);
    }

    public void performDefaultAction(Object object) throws UnknownTypeException {
        if (!(object instanceof RubyThreadInfo)) {
            throw new UnknownTypeException(object);
        }
        RubyThreadInfo rubyThreadInfo = (RubyThreadInfo)object;
        this.rubySession.switchThread(rubyThreadInfo.getId(), this.contextProvider);
    }

    public Action[] getActions(Object object) throws UnknownTypeException {
        return new Action[0];
    }

    private String getThreadName(RubyThreadInfo rubyThreadInfo) {
        return "RubyThread - " + rubyThreadInfo.getId();
    }
}

