/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ui.stp;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.lang.ref.WeakReference;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.lib.profiler.ui.components.JExtendedSpinner;
import org.netbeans.modules.profiler.actions.JavaPlatformSelector;
import org.netbeans.modules.profiler.ui.HyperlinkLabel;
import org.netbeans.modules.profiler.ui.stp.DefaultSettingsPanel;
import org.netbeans.modules.profiler.ui.stp.Utils;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class CPUSettingsAdvancedPanel
extends DefaultSettingsPanel
implements HelpCtx.Provider {
    private static final String SCHEME_COMBOBOX_ITEM_LAZY = NbBundle.getMessage(CPUSettingsAdvancedPanel.class, (String)"CPUSettingsAdvancedPanel_SchemeComboBoxItemLazy");
    private static final String SCHEME_COMBOBOX_ITEM_EAGER = NbBundle.getMessage(CPUSettingsAdvancedPanel.class, (String)"CPUSettingsAdvancedPanel_SchemeComboBoxItemEager");
    private static final String SCHEME_COMBOBOX_ITEM_TOTAL = NbBundle.getMessage(CPUSettingsAdvancedPanel.class, (String)"CPUSettingsAdvancedPanel_SchemeComboBoxItemTotal");
    private static final String DO_NOT_OVERRIDE_STRING = NbBundle.getMessage(CPUSettingsAdvancedPanel.class, (String)"CPUSettingsAdvancedPanel_DoNotOverrideString");
    private static final String CHOOSE_WORKDIR_DIALOG_CAPTION = NbBundle.getMessage(CPUSettingsAdvancedPanel.class, (String)"CPUSettingsAdvancedPanel_ChooseWorkDirDialogCaption");
    private static final String SETTINGS_CAPTION = NbBundle.getMessage(CPUSettingsAdvancedPanel.class, (String)"CPUSettingsAdvancedPanel_SettingsCaption");
    private static final String METHODS_TRACKING_LABEL_TEXT = NbBundle.getMessage(CPUSettingsAdvancedPanel.class, (String)"CPUSettingsAdvancedPanel_MethodsTrackingLabelText");
    private static final String INSTR_RADIO_TEXT = NbBundle.getMessage(CPUSettingsAdvancedPanel.class, (String)"CPUSettingsAdvancedPanel_InstrRadioText");
    private static final String SAMPLING_RADIO_TEXT = NbBundle.getMessage(CPUSettingsAdvancedPanel.class, (String)"CPUSettingsAdvancedPanel_SamplingRadioText");
    private static final String EXCLUDE_TIME_CHECKBOX_TEXT = NbBundle.getMessage(CPUSettingsAdvancedPanel.class, (String)"CPUSettingsAdvancedPanel_ExcludeTimeCheckboxText");
    private static final String PROFILE_FRAMEWORK_CHECKBOX_TEXT = NbBundle.getMessage(CPUSettingsAdvancedPanel.class, (String)"CPUSettingsAdvancedPanel_ProfileFrameworkCheckboxText");
    private static final String PROFILE_THREADS_CHECKBOX_TEXT = NbBundle.getMessage(CPUSettingsAdvancedPanel.class, (String)"CPUSettingsAdvancedPanel_ProfileThreadsCheckboxText");
    private static final String LIMIT_THREADS_CHECKBOX_TEXT = NbBundle.getMessage(CPUSettingsAdvancedPanel.class, (String)"CPUSettingsAdvancedPanel_LimitThreadsCheckboxText");
    private static final String THREAD_TIMER_CHECKBOX_TEXT = NbBundle.getMessage(CPUSettingsAdvancedPanel.class, (String)"CPUSettingsAdvancedPanel_ThreadTimerCheckboxText");
    private static final String INSTR_SCHEME_LABEL_TEXT = NbBundle.getMessage(CPUSettingsAdvancedPanel.class, (String)"CPUSettingsAdvancedPanel_InstrSchemeLabelText");
    private static final String INSTRUMENT_LABEL_TEXT = NbBundle.getMessage(CPUSettingsAdvancedPanel.class, (String)"CPUSettingsAdvancedPanel_InstrumentLabelText");
    private static final String METHOD_INVOKE_CHECKBOX_TEXT = NbBundle.getMessage(CPUSettingsAdvancedPanel.class, (String)"CPUSettingsAdvancedPanel_MethodInvokeCheckboxText");
    private static final String GETTER_SETTER_CHECKBOX_TEXT = NbBundle.getMessage(CPUSettingsAdvancedPanel.class, (String)"CPUSettingsAdvancedPanel_GetterSetterCheckboxText");
    private static final String EMPTY_METHODS_CHECKBOX_TEXT = NbBundle.getMessage(CPUSettingsAdvancedPanel.class, (String)"CPUSettingsAdvancedPanel_EmptyMethodsCheckboxText");
    private static final String THREADS_CAPTION = NbBundle.getMessage(CPUSettingsAdvancedPanel.class, (String)"CPUSettingsAdvancedPanel_ThreadsCaption");
    private static final String ENABLE_THREADS_CHECKBOX_TEXT = NbBundle.getMessage(CPUSettingsAdvancedPanel.class, (String)"CPUSettingsAdvancedPanel_EnableThreadsCheckboxText");
    private static final String GLOBAL_SETTINGS_CAPTION = NbBundle.getMessage(CPUSettingsAdvancedPanel.class, (String)"CPUSettingsAdvancedPanel_GlobalSettingsCaption");
    private static final String OVERRIDE_SETTINGS_CHECKBOX_TEXT = NbBundle.getMessage(CPUSettingsAdvancedPanel.class, (String)"CPUSettingsAdvancedPanel_OverrideSettingsCheckboxText");
    private static final String WORKDIR_LABEL_TEXT = NbBundle.getMessage(CPUSettingsAdvancedPanel.class, (String)"CPUSettingsAdvancedPanel_WorkDirLabelText");
    private static final String CHOOSE_WORKDIR_LINK_TEXT = NbBundle.getMessage(CPUSettingsAdvancedPanel.class, (String)"CPUSettingsAdvancedPanel_ChooseWorkDirLinkText");
    private static final String JAVA_PLATFORM_LABEL_TEXT = NbBundle.getMessage(CPUSettingsAdvancedPanel.class, (String)"CPUSettingsAdvancedPanel_JavaPlatformLabelText");
    private static final String JVM_ARGUMENTS_LABEL_TEXT = NbBundle.getMessage(CPUSettingsAdvancedPanel.class, (String)"CPUSettingsAdvancedPanel_JvmArgumentsLabelText");
    private static final String STP_MONITOR_TOOLTIP = NbBundle.getMessage(CPUSettingsAdvancedPanel.class, (String)"StpMonitorTooltip");
    private static final String STP_OVERRIDE_TOOLTIP = NbBundle.getMessage(CPUSettingsAdvancedPanel.class, (String)"StpOverrideTooltip");
    private static final String STP_WORKDIR_TOOLTIP = NbBundle.getMessage(CPUSettingsAdvancedPanel.class, (String)"StpWorkDirTooltip");
    private static final String STP_JPLATFORM_TOOLTIP = NbBundle.getMessage(CPUSettingsAdvancedPanel.class, (String)"StpJPlatformTooltip");
    private static final String STP_VMARGS_TOOLTIP = NbBundle.getMessage(CPUSettingsAdvancedPanel.class, (String)"StpVmArgsTooltip");
    private static final String STP_EXACTTIMING_TOOLTIP = NbBundle.getMessage(CPUSettingsAdvancedPanel.class, (String)"StpExactTimingTooltip");
    private static final String STP_SAMPLEDTIMING_TOOLTIP = NbBundle.getMessage(CPUSettingsAdvancedPanel.class, (String)"StpSampledTimingTooltip");
    private static final String STP_SLEEPWAIT_TOOLTIP = NbBundle.getMessage(CPUSettingsAdvancedPanel.class, (String)"StpSleepWaitTooltip");
    private static final String STP_FRAMEWORK_TOOLTIP = NbBundle.getMessage(CPUSettingsAdvancedPanel.class, (String)"StpFrameworkTooltip");
    private static final String STP_SPAWNED_TOOLTIP = NbBundle.getMessage(CPUSettingsAdvancedPanel.class, (String)"StpSpawnedTooltip");
    private static final String STP_LIMITTHREADS_TOOLTIP = NbBundle.getMessage(CPUSettingsAdvancedPanel.class, (String)"StpLimitThreadsTooltip");
    private static final String STP_CPUTIMER_TOOLTIP = NbBundle.getMessage(CPUSettingsAdvancedPanel.class, (String)"StpCpuTimerTooltip");
    private static final String STP_INSTRSCHEME_TOOLTIP = NbBundle.getMessage(CPUSettingsAdvancedPanel.class, (String)"StpInstrSchemeTooltip");
    private static final String STP_METHODINVOKE_TOOLTIP = NbBundle.getMessage(CPUSettingsAdvancedPanel.class, (String)"StpMethodInvokeTooltip");
    private static final String STP_GETTERSETTER_TOOLTIP = NbBundle.getMessage(CPUSettingsAdvancedPanel.class, (String)"StpGetterSetterTooltip");
    private static final String STP_EMPTYMETHODS_TOOLTIP = NbBundle.getMessage(CPUSettingsAdvancedPanel.class, (String)"StpEmptyMethodsTooltip");
    private static final String HELP_CTX_KEY = "CPUSettings.Advanced.HelpCtx";
    private static final HelpCtx HELP_CTX = new HelpCtx("CPUSettings.Advanced.HelpCtx");
    private HyperlinkLabel workingDirectorySelectLink;
    private JCheckBox excludeTimeCheckbox;
    private JCheckBox instrumentEmptyMethodsCheckbox;
    private JCheckBox instrumentGettersSettersCheckbox;
    private JCheckBox instrumentMethodInvokeCheckbox;
    private JCheckBox limitThreadsCheckbox;
    private JCheckBox overrideSettingsCheckbox;
    private JCheckBox profileFrameworkCheckbox;
    private JCheckBox profileSpawnedThreadsCheckbox;
    private JCheckBox threadsMonitoringCheckbox;
    private JCheckBox useCPUTimerCheckbox;
    private JComboBox instrumentationSchemeCombo;
    private JComboBox javaPlatformCombo;
    private JLabel instrumentLabel;
    private JLabel instrumentationSchemeLabel;
    private JLabel javaPlatformLabel;
    private JLabel methodsTrackingLabel;
    private JLabel sampledTimingLabel;
    private JLabel vmArgumentsLabel;
    private JLabel workingDirectoryLabel;
    private JPanel globalSettingsPanel;
    private JPanel settingsPanel;
    private JPanel threadsSettingsPanel;
    private JRadioButton exactTimingRadio;
    private JRadioButton sampledTimingRadio;
    private JSpinner limitThreadsSpinner;
    private JSpinner sampledTimingSpinner;
    private JTextField vmArgumentsTextField;
    private JTextField workingDirectoryTextField;
    private WeakReference<JFileChooser> workingDirectoryChooserReference;

    public CPUSettingsAdvancedPanel() {
        this.initComponents();
    }

    public void setCPUProfilingType(int n) {
        this.exactTimingRadio.setSelected(n == 0);
        this.sampledTimingRadio.setSelected(n == 1);
        this.sampledTimingSpinner.setEnabled(this.sampledTimingRadio.isSelected());
    }

    public int getCPUProfilingType() {
        if (this.exactTimingRadio.isSelected()) {
            return 0;
        }
        return 1;
    }

    public void setEntireAppDefaults(boolean bl) {
        if (bl) {
            this.profileSpawnedThreadsCheckbox.setSelected(false);
        }
        if (bl) {
            this.instrumentationSchemeCombo.setSelectedItem(SCHEME_COMBOBOX_ITEM_TOTAL);
        }
        if (bl) {
            this.profileFrameworkCheckbox.setSelected(false);
        }
        if (!bl) {
            this.profileFrameworkCheckbox.setEnabled(true);
        }
    }

    public void setExcludeThreadTime(boolean bl) {
        this.excludeTimeCheckbox.setSelected(bl);
    }

    public boolean getExcludeThreadTime() {
        return this.excludeTimeCheckbox.isSelected();
    }

    public HelpCtx getHelpCtx() {
        return HELP_CTX;
    }

    public void setInstrumentEmptyMethods(boolean bl) {
        this.instrumentEmptyMethodsCheckbox.setSelected(bl);
    }

    public boolean getInstrumentEmptyMethods() {
        return this.instrumentEmptyMethodsCheckbox.isSelected();
    }

    public void setInstrumentGettersSetters(boolean bl) {
        this.instrumentGettersSettersCheckbox.setSelected(bl);
    }

    public boolean getInstrumentGettersSetters() {
        return this.instrumentGettersSettersCheckbox.isSelected();
    }

    public void setInstrumentMethodInvoke(boolean bl) {
        this.instrumentMethodInvokeCheckbox.setSelected(bl);
    }

    public boolean getInstrumentMethodInvoke() {
        return this.instrumentMethodInvokeCheckbox.isSelected();
    }

    public void setInstrumentationScheme(int n) {
        if (n == 1) {
            this.instrumentationSchemeCombo.setSelectedItem(SCHEME_COMBOBOX_ITEM_LAZY);
        } else if (n == 2) {
            this.instrumentationSchemeCombo.setSelectedItem(SCHEME_COMBOBOX_ITEM_EAGER);
        } else {
            this.instrumentationSchemeCombo.setSelectedItem(SCHEME_COMBOBOX_ITEM_TOTAL);
        }
    }

    public int getInstrumentationScheme() {
        Object object = this.instrumentationSchemeCombo.getSelectedItem();
        if (object == SCHEME_COMBOBOX_ITEM_LAZY) {
            return 1;
        }
        if (object == SCHEME_COMBOBOX_ITEM_EAGER) {
            return 2;
        }
        return 3;
    }

    public void setJavaPlatformName(String string) {
        this.updateJavaPlatformCombo(string);
    }

    public String getJavaPlatformName() {
        int n = this.javaPlatformCombo.getSelectedIndex();
        if (n == 0) {
            return null;
        }
        return this.javaPlatformCombo.getSelectedItem().toString();
    }

    public void setOverrideAvailable(boolean bl) {
        this.overrideSettingsCheckbox.setEnabled(bl);
        this.workingDirectoryLabel.setEnabled(bl);
        this.workingDirectoryTextField.setEnabled(bl);
        this.workingDirectorySelectLink.setEnabled(bl);
        this.javaPlatformLabel.setEnabled(bl);
        this.javaPlatformCombo.setEnabled(bl);
        this.vmArgumentsLabel.setEnabled(bl);
        this.vmArgumentsTextField.setEnabled(bl);
    }

    public void setOverrideSettings(boolean bl) {
        this.overrideSettingsCheckbox.setSelected(bl);
        this.updateEnabling();
    }

    public boolean getOverrideSettings() {
        return this.overrideSettingsCheckbox.isSelected();
    }

    public void setPartOfAppDefaults(boolean bl) {
        if (bl) {
            this.profileSpawnedThreadsCheckbox.setSelected(false);
        }
        if (bl) {
            this.instrumentationSchemeCombo.setSelectedItem(SCHEME_COMBOBOX_ITEM_LAZY);
        }
        this.profileFrameworkCheckbox.setSelected(false);
        this.profileFrameworkCheckbox.setEnabled(false);
    }

    public void setProfileFramework(boolean bl) {
        this.profileFrameworkCheckbox.setSelected(bl);
    }

    public boolean getProfileFramework() {
        return this.profileFrameworkCheckbox.isSelected();
    }

    public void setProfileSpawnedThreads(boolean bl) {
        this.profileSpawnedThreadsCheckbox.setSelected(bl);
    }

    public boolean getProfileSpawnedThreads() {
        return this.profileSpawnedThreadsCheckbox.isSelected();
    }

    public void setProfiledThreadsLimit(int n) {
        this.limitThreadsCheckbox.setSelected(n > 0);
        this.limitThreadsSpinner.setValue(Math.abs(n));
        this.limitThreadsSpinner.setEnabled(this.limitThreadsCheckbox.isSelected());
    }

    public int getProfiledThreadsLimit() {
        if (this.limitThreadsCheckbox.isSelected()) {
            return (Integer)this.limitThreadsSpinner.getValue();
        }
        return -((Integer)this.limitThreadsSpinner.getValue()).intValue();
    }

    public void setSamplingInterval(int n) {
        this.sampledTimingSpinner.setValue(n);
    }

    public int getSamplingInterval() {
        return (Integer)this.sampledTimingSpinner.getValue();
    }

    public void setThreadsMonitoring(boolean bl) {
        this.threadsMonitoringCheckbox.setSelected(bl);
    }

    public boolean getThreadsMonitoring() {
        return this.threadsMonitoringCheckbox.isSelected();
    }

    public void setUseCPUTimer(boolean bl, boolean bl2) {
        this.useCPUTimerCheckbox.setSelected(bl);
        this.useCPUTimerCheckbox.setEnabled(bl2);
    }

    public boolean getUseCPUTimer() {
        return this.useCPUTimerCheckbox.isSelected();
    }

    public void setVMArguments(String string) {
        this.vmArgumentsTextField.setText(string);
    }

    public String getVMArguments() {
        return this.vmArgumentsTextField.getText().trim();
    }

    public void setWorkingDirectory(String string) {
        this.workingDirectoryTextField.setText(string);
    }

    public String getWorkingDirectory() {
        return this.workingDirectoryTextField.getText().trim();
    }

    public void disableAll() {
        this.methodsTrackingLabel.setEnabled(false);
        this.exactTimingRadio.setEnabled(false);
        this.sampledTimingRadio.setEnabled(false);
        this.sampledTimingSpinner.setEnabled(false);
        this.sampledTimingLabel.setEnabled(false);
        this.excludeTimeCheckbox.setEnabled(false);
        this.profileFrameworkCheckbox.setEnabled(false);
        this.profileSpawnedThreadsCheckbox.setEnabled(false);
        this.limitThreadsCheckbox.setEnabled(false);
        this.limitThreadsSpinner.setEnabled(false);
        this.useCPUTimerCheckbox.setEnabled(false);
        this.instrumentationSchemeLabel.setEnabled(false);
        this.instrumentationSchemeCombo.setEnabled(false);
        this.instrumentLabel.setEnabled(false);
        this.instrumentMethodInvokeCheckbox.setEnabled(false);
        this.instrumentGettersSettersCheckbox.setEnabled(false);
        this.instrumentEmptyMethodsCheckbox.setEnabled(false);
        this.threadsSettingsPanel.setEnabled(false);
        this.threadsMonitoringCheckbox.setEnabled(false);
        this.globalSettingsPanel.setEnabled(false);
        this.overrideSettingsCheckbox.setEnabled(false);
        this.workingDirectoryLabel.setEnabled(false);
        this.workingDirectoryTextField.setEnabled(false);
        this.workingDirectorySelectLink.setEnabled(false);
        this.javaPlatformLabel.setEnabled(false);
        this.javaPlatformCombo.setEnabled(false);
        this.vmArgumentsLabel.setEnabled(false);
        this.vmArgumentsTextField.setEnabled(false);
    }

    public void enableAll() {
        this.methodsTrackingLabel.setEnabled(true);
        this.exactTimingRadio.setEnabled(true);
        this.sampledTimingRadio.setEnabled(true);
        this.sampledTimingSpinner.setEnabled(true);
        this.sampledTimingLabel.setEnabled(true);
        this.excludeTimeCheckbox.setEnabled(true);
        this.profileFrameworkCheckbox.setEnabled(true);
        this.profileSpawnedThreadsCheckbox.setEnabled(true);
        this.limitThreadsCheckbox.setEnabled(true);
        this.limitThreadsSpinner.setEnabled(true);
        this.useCPUTimerCheckbox.setEnabled(true);
        this.instrumentationSchemeLabel.setEnabled(true);
        this.instrumentationSchemeCombo.setEnabled(true);
        this.instrumentLabel.setEnabled(true);
        this.instrumentMethodInvokeCheckbox.setEnabled(true);
        this.instrumentGettersSettersCheckbox.setEnabled(true);
        this.instrumentEmptyMethodsCheckbox.setEnabled(true);
        this.threadsSettingsPanel.setEnabled(true);
        this.threadsMonitoringCheckbox.setEnabled(true);
        this.globalSettingsPanel.setEnabled(true);
        this.overrideSettingsCheckbox.setEnabled(true);
        this.workingDirectoryLabel.setEnabled(true);
        this.workingDirectoryTextField.setEnabled(true);
        this.workingDirectorySelectLink.setEnabled(true);
        this.javaPlatformLabel.setEnabled(true);
        this.javaPlatformCombo.setEnabled(true);
        this.vmArgumentsLabel.setEnabled(true);
        this.vmArgumentsTextField.setEnabled(true);
    }

    public static void main(String[] stringArray) {
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
        }
        catch (Exception exception) {
            // empty catch block
        }
        JFrame jFrame = new JFrame("Tester Frame");
        CPUSettingsAdvancedPanel cPUSettingsAdvancedPanel = new CPUSettingsAdvancedPanel();
        cPUSettingsAdvancedPanel.setPreferredSize(new Dimension(375, 255));
        jFrame.getContentPane().add(cPUSettingsAdvancedPanel);
        jFrame.setDefaultCloseOperation(3);
        jFrame.pack();
        jFrame.setVisible(true);
    }

    private JFileChooser getFileChooser() {
        JFileChooser jFileChooser;
        if (this.workingDirectoryChooserReference == null || this.workingDirectoryChooserReference.get() == null) {
            jFileChooser = new JFileChooser();
            jFileChooser.setFileSelectionMode(1);
            jFileChooser.setMultiSelectionEnabled(false);
            jFileChooser.setAcceptAllFileFilterUsed(false);
            jFileChooser.setDialogType(0);
            jFileChooser.setDialogTitle(CHOOSE_WORKDIR_DIALOG_CAPTION);
            this.workingDirectoryChooserReference = new WeakReference<JFileChooser>(jFileChooser);
        } else {
            jFileChooser = (JFileChooser)this.workingDirectoryChooserReference.get();
        }
        return jFileChooser;
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        ButtonGroup buttonGroup = new ButtonGroup();
        this.settingsPanel = new JPanel(new GridBagLayout());
        this.settingsPanel.setOpaque(false);
        this.settingsPanel.setBorder(BorderFactory.createTitledBorder(SETTINGS_CAPTION));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 5, 10, 5);
        this.add((Component)this.settingsPanel, gridBagConstraints);
        this.methodsTrackingLabel = new JLabel(METHODS_TRACKING_LABEL_TEXT);
        this.methodsTrackingLabel.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 7, 0, 0);
        this.settingsPanel.add((Component)this.methodsTrackingLabel, gridBagConstraints);
        this.exactTimingRadio = new JRadioButton();
        Mnemonics.setLocalizedText((AbstractButton)this.exactTimingRadio, (String)INSTR_RADIO_TEXT);
        this.exactTimingRadio.setToolTipText(STP_EXACTTIMING_TOOLTIP);
        buttonGroup.add(this.exactTimingRadio);
        this.exactTimingRadio.addActionListener(this.getSettingsChangeListener());
        this.exactTimingRadio.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 19, 0, 0);
        this.settingsPanel.add((Component)this.exactTimingRadio, gridBagConstraints);
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.sampledTimingRadio = new JRadioButton();
        Mnemonics.setLocalizedText((AbstractButton)this.sampledTimingRadio, (String)SAMPLING_RADIO_TEXT);
        this.sampledTimingRadio.setToolTipText(STP_SAMPLEDTIMING_TOOLTIP);
        buttonGroup.add(this.sampledTimingRadio);
        this.sampledTimingRadio.setOpaque(false);
        this.sampledTimingRadio.setSelected(true);
        this.sampledTimingRadio.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                CPUSettingsAdvancedPanel.this.sampledTimingSpinner.setEnabled(CPUSettingsAdvancedPanel.this.sampledTimingRadio.isSelected());
                CPUSettingsAdvancedPanel.this.sampledTimingLabel.setEnabled(CPUSettingsAdvancedPanel.this.sampledTimingRadio.isSelected());
            }
        });
        this.sampledTimingRadio.addActionListener(this.getSettingsChangeListener());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        jPanel.add((Component)this.sampledTimingRadio, gridBagConstraints);
        this.sampledTimingSpinner = new JExtendedSpinner(new SpinnerNumberModel(10, 1, Integer.MAX_VALUE, 1)){

            public Dimension getPreferredSize() {
                return new Dimension(55, Utils.getDefaultSpinnerHeight());
            }

            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        this.sampledTimingSpinner.addChangeListener(this.getSettingsChangeListener());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)this.sampledTimingSpinner, gridBagConstraints);
        this.sampledTimingLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.sampledTimingLabel, (String)"&ms");
        this.sampledTimingLabel.setLabelFor(this.sampledTimingSpinner);
        this.sampledTimingSpinner.setToolTipText(STP_SAMPLEDTIMING_TOOLTIP);
        this.sampledTimingLabel.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        jPanel.add((Component)this.sampledTimingLabel, gridBagConstraints);
        jPanel.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 19, 5, 0);
        this.settingsPanel.add((Component)jPanel, gridBagConstraints);
        this.excludeTimeCheckbox = new JCheckBox();
        Mnemonics.setLocalizedText((AbstractButton)this.excludeTimeCheckbox, (String)EXCLUDE_TIME_CHECKBOX_TEXT);
        this.excludeTimeCheckbox.setToolTipText(STP_SLEEPWAIT_TOOLTIP);
        this.excludeTimeCheckbox.addActionListener(this.getSettingsChangeListener());
        this.excludeTimeCheckbox.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 7, 0, 0);
        this.settingsPanel.add((Component)this.excludeTimeCheckbox, gridBagConstraints);
        this.profileFrameworkCheckbox = new JCheckBox();
        Mnemonics.setLocalizedText((AbstractButton)this.profileFrameworkCheckbox, (String)PROFILE_FRAMEWORK_CHECKBOX_TEXT);
        this.profileFrameworkCheckbox.setToolTipText(STP_FRAMEWORK_TOOLTIP);
        this.profileFrameworkCheckbox.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                CPUSettingsAdvancedPanel.this.updateEnabling();
            }
        });
        this.profileFrameworkCheckbox.addActionListener(this.getSettingsChangeListener());
        this.profileFrameworkCheckbox.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 7, 0, 0);
        this.settingsPanel.add((Component)this.profileFrameworkCheckbox, gridBagConstraints);
        this.profileSpawnedThreadsCheckbox = new JCheckBox();
        Mnemonics.setLocalizedText((AbstractButton)this.profileSpawnedThreadsCheckbox, (String)PROFILE_THREADS_CHECKBOX_TEXT);
        this.profileSpawnedThreadsCheckbox.setToolTipText(STP_SPAWNED_TOOLTIP);
        this.profileSpawnedThreadsCheckbox.addActionListener(this.getSettingsChangeListener());
        this.profileSpawnedThreadsCheckbox.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 7, 0, 0);
        this.settingsPanel.add((Component)this.profileSpawnedThreadsCheckbox, gridBagConstraints);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        this.limitThreadsCheckbox = new JCheckBox();
        Mnemonics.setLocalizedText((AbstractButton)this.limitThreadsCheckbox, (String)LIMIT_THREADS_CHECKBOX_TEXT);
        this.limitThreadsCheckbox.setToolTipText(STP_LIMITTHREADS_TOOLTIP);
        this.limitThreadsCheckbox.addActionListener(this.getSettingsChangeListener());
        this.limitThreadsCheckbox.setOpaque(false);
        this.limitThreadsCheckbox.setSelected(true);
        this.limitThreadsCheckbox.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                CPUSettingsAdvancedPanel.this.limitThreadsSpinner.setEnabled(CPUSettingsAdvancedPanel.this.limitThreadsCheckbox.isSelected());
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        jPanel2.add((Component)this.limitThreadsCheckbox, gridBagConstraints);
        this.limitThreadsSpinner = new JExtendedSpinner(new SpinnerNumberModel(50, 1, Integer.MAX_VALUE, 1)){

            public Dimension getPreferredSize() {
                return new Dimension(55, Utils.getDefaultSpinnerHeight());
            }

            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        this.limitThreadsSpinner.setToolTipText(STP_LIMITTHREADS_TOOLTIP);
        this.limitThreadsSpinner.addChangeListener(this.getSettingsChangeListener());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel2.add((Component)this.limitThreadsSpinner, gridBagConstraints);
        jPanel2.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 7, 0, 0);
        this.settingsPanel.add((Component)jPanel2, gridBagConstraints);
        this.useCPUTimerCheckbox = new JCheckBox();
        Mnemonics.setLocalizedText((AbstractButton)this.useCPUTimerCheckbox, (String)THREAD_TIMER_CHECKBOX_TEXT);
        this.useCPUTimerCheckbox.setToolTipText(STP_CPUTIMER_TOOLTIP);
        this.useCPUTimerCheckbox.addActionListener(this.getSettingsChangeListener());
        this.useCPUTimerCheckbox.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 7, 0, 0);
        this.settingsPanel.add((Component)this.useCPUTimerCheckbox, gridBagConstraints);
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        this.instrumentationSchemeLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.instrumentationSchemeLabel, (String)INSTR_SCHEME_LABEL_TEXT);
        this.instrumentationSchemeLabel.setToolTipText(STP_INSTRSCHEME_TOOLTIP);
        this.instrumentationSchemeLabel.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        jPanel3.add((Component)this.instrumentationSchemeLabel, gridBagConstraints);
        this.instrumentationSchemeCombo = new JComboBox(new String[]{SCHEME_COMBOBOX_ITEM_LAZY, SCHEME_COMBOBOX_ITEM_EAGER, SCHEME_COMBOBOX_ITEM_TOTAL}){

            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        this.instrumentationSchemeLabel.setLabelFor(this.instrumentationSchemeCombo);
        this.instrumentationSchemeCombo.setToolTipText(STP_INSTRSCHEME_TOOLTIP);
        this.instrumentationSchemeCombo.addActionListener(this.getSettingsChangeListener());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel3.add((Component)this.instrumentationSchemeCombo, gridBagConstraints);
        jPanel3.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 7, 2, 0);
        this.settingsPanel.add((Component)jPanel3, gridBagConstraints);
        this.instrumentLabel = new JLabel(INSTRUMENT_LABEL_TEXT);
        this.instrumentLabel.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 7, 0, 0);
        this.settingsPanel.add((Component)this.instrumentLabel, gridBagConstraints);
        this.instrumentMethodInvokeCheckbox = new JCheckBox();
        Mnemonics.setLocalizedText((AbstractButton)this.instrumentMethodInvokeCheckbox, (String)METHOD_INVOKE_CHECKBOX_TEXT);
        this.instrumentMethodInvokeCheckbox.setToolTipText(STP_METHODINVOKE_TOOLTIP);
        this.instrumentMethodInvokeCheckbox.addActionListener(this.getSettingsChangeListener());
        this.instrumentMethodInvokeCheckbox.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 19, 0, 0);
        this.settingsPanel.add((Component)this.instrumentMethodInvokeCheckbox, gridBagConstraints);
        this.instrumentGettersSettersCheckbox = new JCheckBox();
        Mnemonics.setLocalizedText((AbstractButton)this.instrumentGettersSettersCheckbox, (String)GETTER_SETTER_CHECKBOX_TEXT);
        this.instrumentGettersSettersCheckbox.setToolTipText(STP_GETTERSETTER_TOOLTIP);
        this.instrumentGettersSettersCheckbox.addActionListener(this.getSettingsChangeListener());
        this.instrumentGettersSettersCheckbox.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 19, 0, 0);
        this.settingsPanel.add((Component)this.instrumentGettersSettersCheckbox, gridBagConstraints);
        this.instrumentEmptyMethodsCheckbox = new JCheckBox();
        Mnemonics.setLocalizedText((AbstractButton)this.instrumentEmptyMethodsCheckbox, (String)EMPTY_METHODS_CHECKBOX_TEXT);
        this.instrumentEmptyMethodsCheckbox.setToolTipText(STP_EMPTYMETHODS_TOOLTIP);
        this.instrumentEmptyMethodsCheckbox.addActionListener(this.getSettingsChangeListener());
        this.instrumentEmptyMethodsCheckbox.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 19, 3, 0);
        this.settingsPanel.add((Component)this.instrumentEmptyMethodsCheckbox, gridBagConstraints);
        this.threadsSettingsPanel = new JPanel(new GridBagLayout());
        this.threadsSettingsPanel.setOpaque(false);
        this.threadsSettingsPanel.setBorder(BorderFactory.createTitledBorder(THREADS_CAPTION));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 5, 10, 5);
        this.add((Component)this.threadsSettingsPanel, gridBagConstraints);
        this.threadsMonitoringCheckbox = new JCheckBox();
        Mnemonics.setLocalizedText((AbstractButton)this.threadsMonitoringCheckbox, (String)ENABLE_THREADS_CHECKBOX_TEXT);
        this.threadsMonitoringCheckbox.setToolTipText(STP_MONITOR_TOOLTIP);
        this.threadsMonitoringCheckbox.addActionListener(this.getSettingsChangeListener());
        this.threadsMonitoringCheckbox.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 7, 3, 0);
        this.threadsSettingsPanel.add((Component)this.threadsMonitoringCheckbox, gridBagConstraints);
        this.globalSettingsPanel = new JPanel(new GridBagLayout());
        this.globalSettingsPanel.setOpaque(false);
        this.globalSettingsPanel.setBorder(BorderFactory.createTitledBorder(GLOBAL_SETTINGS_CAPTION));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.add((Component)this.globalSettingsPanel, gridBagConstraints);
        this.overrideSettingsCheckbox = new JCheckBox();
        Mnemonics.setLocalizedText((AbstractButton)this.overrideSettingsCheckbox, (String)OVERRIDE_SETTINGS_CHECKBOX_TEXT);
        this.overrideSettingsCheckbox.setToolTipText(STP_OVERRIDE_TOOLTIP);
        this.overrideSettingsCheckbox.setOpaque(false);
        this.overrideSettingsCheckbox.setSelected(true);
        this.overrideSettingsCheckbox.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                CPUSettingsAdvancedPanel.this.updateEnabling();
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 7, 0, 0);
        this.globalSettingsPanel.add((Component)this.overrideSettingsCheckbox, gridBagConstraints);
        this.workingDirectoryLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.workingDirectoryLabel, (String)WORKDIR_LABEL_TEXT);
        this.workingDirectoryLabel.setToolTipText(STP_WORKDIR_TOOLTIP);
        this.workingDirectoryLabel.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 19, 0, 0);
        this.globalSettingsPanel.add((Component)this.workingDirectoryLabel, gridBagConstraints);
        this.workingDirectoryTextField = new JTextField(){

            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        this.workingDirectoryLabel.setLabelFor(this.workingDirectoryTextField);
        this.workingDirectoryTextField.setToolTipText(STP_WORKDIR_TOOLTIP);
        this.workingDirectoryTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                CPUSettingsAdvancedPanel.this.checkWorkingDirectory();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                CPUSettingsAdvancedPanel.this.checkWorkingDirectory();
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                CPUSettingsAdvancedPanel.this.checkWorkingDirectory();
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.globalSettingsPanel.add((Component)this.workingDirectoryTextField, gridBagConstraints);
        Color color = Color.RED;
        String string = "rgb(" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + ")";
        this.workingDirectorySelectLink = new HyperlinkLabel("<a href='#'>" + CHOOSE_WORKDIR_LINK_TEXT + "</a>", "<a href='#' color=\"" + string + "\">" + CHOOSE_WORKDIR_LINK_TEXT + "</a>", new Runnable(){

            public void run() {
                JFileChooser jFileChooser = CPUSettingsAdvancedPanel.this.getFileChooser();
                jFileChooser.setCurrentDirectory(new File(CPUSettingsAdvancedPanel.this.workingDirectoryTextField.getText().trim()));
                if (jFileChooser.showOpenDialog(null) == 0) {
                    CPUSettingsAdvancedPanel.this.workingDirectoryTextField.setText(jFileChooser.getSelectedFile().getAbsolutePath());
                }
            }
        });
        this.workingDirectorySelectLink.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 4, 0, 3);
        this.globalSettingsPanel.add((Component)((Object)this.workingDirectorySelectLink), gridBagConstraints);
        this.javaPlatformLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.javaPlatformLabel, (String)JAVA_PLATFORM_LABEL_TEXT);
        this.javaPlatformLabel.setToolTipText(STP_JPLATFORM_TOOLTIP);
        this.javaPlatformLabel.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 19, 0, 0);
        this.globalSettingsPanel.add((Component)this.javaPlatformLabel, gridBagConstraints);
        this.javaPlatformCombo = new JComboBox(new Object[]{DO_NOT_OVERRIDE_STRING}){

            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        this.javaPlatformLabel.setLabelFor(this.javaPlatformCombo);
        this.javaPlatformCombo.setToolTipText(STP_JPLATFORM_TOOLTIP);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.globalSettingsPanel.add((Component)this.javaPlatformCombo, gridBagConstraints);
        this.vmArgumentsLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.vmArgumentsLabel, (String)JVM_ARGUMENTS_LABEL_TEXT);
        this.vmArgumentsLabel.setToolTipText(STP_VMARGS_TOOLTIP);
        this.vmArgumentsLabel.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 19, 8, 0);
        this.globalSettingsPanel.add((Component)this.vmArgumentsLabel, gridBagConstraints);
        this.vmArgumentsTextField = new JTextField(){

            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        this.vmArgumentsLabel.setLabelFor(this.vmArgumentsTextField);
        this.vmArgumentsTextField.setToolTipText(STP_VMARGS_TOOLTIP);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 8, 0);
        this.globalSettingsPanel.add((Component)this.vmArgumentsTextField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)Utils.createFillerPanel(), gridBagConstraints);
    }

    private void updateEnabling() {
        boolean bl = this.overrideSettingsCheckbox.isSelected() && this.overrideSettingsCheckbox.isEnabled();
        this.workingDirectoryLabel.setEnabled(bl);
        this.workingDirectoryTextField.setEnabled(bl);
        this.workingDirectorySelectLink.setEnabled(bl);
        this.javaPlatformLabel.setEnabled(bl);
        this.javaPlatformCombo.setEnabled(bl);
        this.vmArgumentsLabel.setEnabled(bl);
        this.vmArgumentsTextField.setEnabled(bl);
        if (this.profileFrameworkCheckbox.isSelected()) {
            this.profileSpawnedThreadsCheckbox.setSelected(true);
            this.profileSpawnedThreadsCheckbox.setEnabled(false);
            this.instrumentationSchemeCombo.setSelectedItem(SCHEME_COMBOBOX_ITEM_TOTAL);
            this.instrumentationSchemeCombo.setEnabled(false);
        } else {
            this.profileSpawnedThreadsCheckbox.setEnabled(this.methodsTrackingLabel.isEnabled());
            this.instrumentationSchemeCombo.setEnabled(this.methodsTrackingLabel.isEnabled());
        }
    }

    private void checkWorkingDirectory() {
        String string = this.workingDirectoryTextField.getText().trim();
        if (string.length() == 0 || new File(string).exists()) {
            this.workingDirectoryTextField.setForeground(UIManager.getColor("TextField.foreground"));
        } else {
            this.workingDirectoryTextField.setForeground(Color.RED);
        }
    }

    private void updateJavaPlatformCombo(String string) {
        List list = JavaPlatformSelector.getSupportedPlatforms();
        String[] stringArray = new String[list.size() + 1];
        stringArray[0] = DO_NOT_OVERRIDE_STRING;
        for (int i = 1; i < stringArray.length; ++i) {
            stringArray[i] = ((JavaPlatform)list.get(i - 1)).getDisplayName();
        }
        this.javaPlatformCombo.setModel(new DefaultComboBoxModel<String>(stringArray));
        if (string != null) {
            this.javaPlatformCombo.setSelectedItem(string);
        } else {
            this.javaPlatformCombo.setSelectedIndex(0);
        }
    }
}

