/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ui.stats;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import org.netbeans.api.project.Project;
import org.netbeans.lib.profiler.marker.Mark;
import org.netbeans.lib.profiler.results.cpu.TimingAdjusterOld;
import org.netbeans.lib.profiler.results.cpu.cct.CPUCCTVisitor;
import org.netbeans.lib.profiler.results.cpu.cct.CPUCCTVisitorAdapter;
import org.netbeans.lib.profiler.results.cpu.cct.CompositeCPUCCTWalker;
import org.netbeans.lib.profiler.results.cpu.cct.RuntimeCPUCCTNodeVisitor;
import org.netbeans.lib.profiler.results.cpu.cct.nodes.MarkedCPUCCTNode;
import org.netbeans.lib.profiler.results.cpu.cct.nodes.MethodCPUCCTNode;
import org.netbeans.lib.profiler.results.cpu.cct.nodes.RuntimeCPUCCTNode;
import org.netbeans.lib.profiler.ui.cpu.statistics.StatisticalModule;
import org.netbeans.lib.profiler.utils.StringUtils;
import org.netbeans.modules.profiler.NetBeansProfiler;
import org.netbeans.modules.profiler.categories.Categorization;
import org.netbeans.modules.profiler.categories.Category;
import org.netbeans.modules.profiler.utilities.Visitable;
import org.netbeans.modules.profiler.utilities.Visitor;
import org.openide.util.NbBundle;

public class ForwardCategoryDistributionPanel
extends StatisticalModule {
    private static final String NO_METHOD_LABEL_TEXT = NbBundle.getMessage(ForwardCategoryDistributionPanel.class, (String)"ForwardCategoryDistributionPanel_NoMethodLabelText");
    private static final String NO_DATA_LABEL_TEXT = NbBundle.getMessage(ForwardCategoryDistributionPanel.class, (String)"ForwardCategoryDistributionPanel_NoDataLabelText");
    private static final String METHOD_CATEGORIES_STRING = NbBundle.getMessage(ForwardCategoryDistributionPanel.class, (String)"ForwardCategoryDistributionPanel_MethodCategoriesString");
    private static final String DESCR_STRING = NbBundle.getMessage(ForwardCategoryDistributionPanel.class, (String)"ForwardCategoryDistributionPanel_DescrString");
    private CompositeCPUCCTWalker walker;
    private JLabel noData = new JLabel(NO_DATA_LABEL_TEXT);
    private JLabel noMethods = new JLabel(NO_METHOD_LABEL_TEXT);
    private Model model;
    private RuntimeCPUCCTNode lastAppNode;

    public ForwardCategoryDistributionPanel() {
        this.initComponents();
        this.model = new Model();
        this.walker = new CompositeCPUCCTWalker();
        this.walker.add(0, (CPUCCTVisitor)this.model);
    }

    private Project getProject() {
        return NetBeansProfiler.getDefaultNB().getProfiledProject();
    }

    public void setSelectedMethodId(int n) {
        int n2 = this.getSelectedMethodId();
        super.setSelectedMethodId(n);
        if (n2 != n) {
            n2 = n;
            this.refresh(this.lastAppNode);
        }
    }

    public synchronized void refresh(RuntimeCPUCCTNode runtimeCPUCCTNode) {
        if (runtimeCPUCCTNode != null) {
            if (this.walker != null) {
                runtimeCPUCCTNode.accept((RuntimeCPUCCTNodeVisitor)this.walker);
            }
            this.lastAppNode = runtimeCPUCCTNode;
        }
    }

    private void initComponents() {
        BoxLayout boxLayout = new BoxLayout((Container)((Object)this), 1);
        this.setLayout(boxLayout);
        this.setOpaque(false);
        this.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        this.noMethods.setOpaque(false);
        this.noMethods.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 7, 0, 0), this.noMethods.getBorder()));
        this.noData.setOpaque(false);
        this.noData.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 7, 0, 0), this.noData.getBorder()));
        this.add(this.noMethods);
        this.setName(METHOD_CATEGORIES_STRING);
        this.setToolTipText(DESCR_STRING);
    }

    private void refreshData() {
        if (this.model == null) {
            return;
        }
        Runnable runnable = null;
        if (this.getSelectedMethodId() == -1) {
            runnable = new Runnable(){

                public void run() {
                    ForwardCategoryDistributionPanel.this.removeAll();
                    ForwardCategoryDistributionPanel.this.add(ForwardCategoryDistributionPanel.this.noMethods);
                    ForwardCategoryDistributionPanel.this.revalidate();
                    ForwardCategoryDistributionPanel.this.repaint();
                }
            };
        } else {
            Map<Mark, Long> map = this.model.getDistribution();
            if (map == null || map.isEmpty()) {
                runnable = new Runnable(){

                    public void run() {
                        ForwardCategoryDistributionPanel.this.removeAll();
                        ForwardCategoryDistributionPanel.this.add(ForwardCategoryDistributionPanel.this.noData);
                        ForwardCategoryDistributionPanel.this.revalidate();
                        ForwardCategoryDistributionPanel.this.repaint();
                    }
                };
            } else {
                long l = 0L;
                long l2 = 0L;
                final ArrayList<MarkTime> arrayList = new ArrayList<MarkTime>();
                for (Map.Entry<Mark, Long> entry : map.entrySet()) {
                    if (!map.keySet().contains(entry.getKey())) continue;
                    long l3 = entry.getValue();
                    l2 += l3;
                    arrayList.add(new MarkTime(entry.getKey(), l3));
                }
                final long l4 = l > l2 ? l : l2;
                Collections.sort(arrayList, MarkTime.COMPARATOR);
                runnable = new Runnable(){

                    public void run() {
                        if (!Categorization.isAvailable(ForwardCategoryDistributionPanel.this.getProject())) {
                            return;
                        }
                        final Categorization categorization = new Categorization(ForwardCategoryDistributionPanel.this.getProject());
                        ForwardCategoryDistributionPanel.this.removeAll();
                        for (final MarkTime markTime : arrayList) {
                            float f = (float)markTime.time / (float)l4;
                            float f2 = 100.0f * f;
                            JPanel jPanel = new JPanel(new BorderLayout());
                            jPanel.setOpaque(false);
                            Category category = categorization.getCategoryForMark(markTime.mark);
                            StringBuilder stringBuilder = new StringBuilder();
                            if (category != null) {
                                categorization.getRoot().accept((Visitor)new Visitor<Visitable<Category>, Void, StringBuilder>(){

                                    public Void visit(Visitable<Category> visitable, StringBuilder stringBuilder) {
                                        if (categorization.getAllMarks((Category)visitable.getValue()).contains(markTime.mark)) {
                                            if (stringBuilder.length() > 0) {
                                                stringBuilder.append("/");
                                            }
                                            stringBuilder.append(((Category)visitable.getValue()).getLabel());
                                        }
                                        return null;
                                    }
                                }, stringBuilder);
                            } else {
                                stringBuilder.append("Not categorized");
                            }
                            JLabel jLabel = new JLabel(stringBuilder.toString() + " (" + StringUtils.floatPerCentToString((float)f2) + "%)");
                            jLabel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 7, 0, 0), jLabel.getBorder()));
                            jLabel.setOpaque(false);
                            jPanel.add((Component)jLabel, "West");
                            JProgressBar jProgressBar = new JProgressBar(0, 0, 100);
                            jProgressBar.setOpaque(false);
                            jProgressBar.setPreferredSize(new Dimension(120, jLabel.getPreferredSize().height + 2));
                            jProgressBar.setMaximumSize(jProgressBar.getPreferredSize());
                            jProgressBar.setMinimumSize(jProgressBar.getPreferredSize());
                            jProgressBar.setForeground(new Color(Color.HSBtoRGB(100.0f, f, 0.7f)));
                            jProgressBar.setString("");
                            jProgressBar.setStringPainted(true);
                            jProgressBar.setValue((int)f2);
                            JPanel jPanel2 = new JPanel(new FlowLayout(0, 2, 3));
                            jPanel2.setOpaque(false);
                            jPanel2.add(jProgressBar);
                            jPanel.add((Component)jPanel2, "East");
                            ForwardCategoryDistributionPanel.this.add(jPanel);
                        }
                        ForwardCategoryDistributionPanel.this.revalidate();
                        ForwardCategoryDistributionPanel.this.repaint();
                    }
                };
            }
        }
        if (EventQueue.isDispatchThread()) {
            runnable.run();
        } else {
            EventQueue.invokeLater(runnable);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Model
    extends CPUCCTVisitorAdapter {
        private Map<Mark, Long> markMap = new HashMap<Mark, Long>();
        private Mark usedMark;
        private Stack<Mark> markStack = new Stack();
        private int inCalls;
        private int lastCalls;
        private int outCalls;
        private long time0;
        private long time1;

        private Model() {
        }

        public Map<Mark, Long> getDistribution() {
            return new HashMap<Mark, Long>(this.markMap);
        }

        public void afterWalk() {
            ForwardCategoryDistributionPanel.this.refreshData();
        }

        public void beforeWalk() {
            this.markStack.clear();
            this.markMap.clear();
            this.usedMark = Mark.DEFAULT;
        }

        public void visit(MarkedCPUCCTNode markedCPUCCTNode) {
            if (this.time0 > 0L) {
                long l;
                Long l2 = this.markMap.get(this.usedMark);
                if (l2 == null) {
                    l2 = 0L;
                }
                if ((l = (long)TimingAdjusterOld.getDefault().adjustTime(this.time0, this.inCalls - this.lastCalls, this.outCalls, false)) > 0L) {
                    this.markMap.put(this.usedMark, l2 + l);
                }
            }
            this.outCalls = 0;
            this.inCalls = 0;
            this.lastCalls = 0;
            this.time0 = 0L;
            this.time1 = 0L;
            this.markStack.push(this.usedMark);
            this.usedMark = markedCPUCCTNode.getMark();
        }

        public void visit(MethodCPUCCTNode methodCPUCCTNode) {
            if (methodCPUCCTNode.getMethodId() != ForwardCategoryDistributionPanel.this.getSelectedMethodId()) {
                return;
            }
            this.time0 += methodCPUCCTNode.getNetTime0();
            this.time1 += methodCPUCCTNode.getNetTime1();
            this.inCalls += methodCPUCCTNode.getNCalls();
            this.outCalls += methodCPUCCTNode.getNCalls();
            this.lastCalls = methodCPUCCTNode.getNCalls();
        }

        public void visitPost(MarkedCPUCCTNode markedCPUCCTNode) {
            if (this.time0 > 0L) {
                long l;
                Long l2 = this.markMap.get(this.usedMark);
                if (l2 == null) {
                    l2 = 0L;
                }
                if ((l = (long)TimingAdjusterOld.getDefault().adjustTime(this.time0, this.inCalls, this.outCalls - this.lastCalls, false)) > 0L) {
                    this.markMap.put(this.usedMark, l2 + l);
                }
            }
            this.outCalls = 0;
            this.inCalls = 0;
            this.lastCalls = 0;
            this.time0 = 0L;
            this.time1 = 0L;
            this.usedMark = this.markStack.pop();
        }
    }

    private static class MarkTime {
        public static final Comparator COMPARATOR = new Comparator(){

            public int compare(Object object, Object object2) {
                if (object == null || object2 == null) {
                    return 0;
                }
                if (!(object instanceof MarkTime) || !(object2 instanceof MarkTime)) {
                    return 0;
                }
                if (((MarkTime)object).time < ((MarkTime)object2).time) {
                    return 1;
                }
                if (((MarkTime)object).time > ((MarkTime)object2).time) {
                    return -1;
                }
                return 0;
            }
        };
        public Mark mark;
        public long time;

        public MarkTime(Mark mark, long l) {
            this.mark = mark;
            this.time = l;
        }
    }
}

