/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.java.project.support.ui;

import java.awt.EventQueue;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.spi.java.project.support.ui.IncludeExcludeVisualizerPanel;
import org.netbeans.spi.project.support.ant.PathMatcher;
import org.openide.util.Parameters;
import org.openide.util.RequestProcessor;

public class IncludeExcludeVisualizer {
    private File[] roots = new File[0];
    private String includes = "**";
    private String excludes = "";
    private final List<ChangeListener> listeners = new ArrayList<ChangeListener>(1);
    private IncludeExcludeVisualizerPanel panel;
    private SortedSet<File> included = new TreeSet<File>();
    private SortedSet<File> excluded = new TreeSet<File>();
    private boolean busy = false;
    private boolean interrupted = false;
    private static final RequestProcessor RP = new RequestProcessor(IncludeExcludeVisualizer.class.getName());
    private final RequestProcessor.Task task = RP.create((Runnable)new RecalculateTask());
    private static final int DELAY = 200;
    private int scanCounter;
    private static final int GRANULARITY = 1000;

    public synchronized void setRoots(File[] fileArray) throws IllegalArgumentException {
        Parameters.notNull((CharSequence)"roots", (Object)fileArray);
        for (File file : fileArray) {
            if (file.isDirectory()) continue;
            throw new IllegalArgumentException(file.getAbsolutePath());
        }
        this.roots = fileArray;
        this.recalculate();
    }

    public synchronized String getIncludePattern() {
        return this.includes;
    }

    public synchronized void setIncludePattern(String string) {
        Parameters.notNull((CharSequence)"pattern", (Object)string);
        this.includes = string;
        this.updateIncludesExcludes();
        this.recalculate();
    }

    public synchronized String getExcludePattern() {
        return this.excludes;
    }

    public synchronized void setExcludePattern(String string) {
        Parameters.notNull((CharSequence)"pattern", (Object)string);
        this.excludes = string;
        this.updateIncludesExcludes();
        this.recalculate();
    }

    private synchronized void updateIncludesExcludes() {
        if (this.panel != null) {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    IncludeExcludeVisualizer.this.panel.setFields(IncludeExcludeVisualizer.this.includes, IncludeExcludeVisualizer.this.excludes);
                }
            });
        }
    }

    public synchronized void addChangeListener(ChangeListener changeListener) {
        this.listeners.add(changeListener);
    }

    public synchronized void removeChangeListener(ChangeListener changeListener) {
        this.listeners.remove(changeListener);
    }

    synchronized void changedPatterns(String string, String string2) {
        this.includes = string;
        this.excludes = string2;
        this.recalculate();
        this.fireChange();
    }

    private synchronized void fireChange() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (ChangeListener changeListener : this.listeners) {
            changeListener.stateChanged(changeEvent);
        }
    }

    public synchronized JComponent getVisualizerPanel() {
        if (!EventQueue.isDispatchThread()) {
            throw new IllegalThreadStateException("must be called in EQ");
        }
        if (this.panel == null) {
            this.panel = new IncludeExcludeVisualizerPanel(this);
            this.panel.setFields(this.includes, this.excludes);
            this.updatePanelFiles();
        }
        return this.panel;
    }

    private void updatePanelFiles() {
        this.panel.setFiles(this.included.toArray(new File[this.included.size()]), this.excluded.toArray(new File[this.excluded.size()]), this.busy, this.roots.length == 1 ? this.roots[0] : null);
    }

    private synchronized void recalculate() {
        this.interrupted = true;
        this.task.schedule(200);
    }

    private void updateFiles() {
        assert (Thread.holdsLock(this));
        EventQueue.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                IncludeExcludeVisualizer includeExcludeVisualizer = IncludeExcludeVisualizer.this;
                synchronized (includeExcludeVisualizer) {
                    if (IncludeExcludeVisualizer.this.panel != null) {
                        IncludeExcludeVisualizer.this.updatePanelFiles();
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scan(File file, String string, PathMatcher pathMatcher) {
        String[] stringArray = file.list();
        if (stringArray == null) {
            return;
        }
        for (String string2 : stringArray) {
            File file2 = new File(file, string2);
            if (!VisibilityQuery.getDefault().isVisible(file2)) continue;
            boolean bl = file2.isDirectory();
            if (bl) {
                this.scan(file2, string + string2 + "/", pathMatcher);
                continue;
            }
            IncludeExcludeVisualizer includeExcludeVisualizer = this;
            synchronized (includeExcludeVisualizer) {
                if (this.interrupted) {
                    return;
                }
                if (pathMatcher.matches(string + string2, false)) {
                    this.included.add(file2);
                } else {
                    this.excluded.add(file2);
                }
                if (++this.scanCounter % 1000 == 0) {
                    this.updateFiles();
                }
            }
        }
    }

    private final class RecalculateTask
    implements Runnable {
        private RecalculateTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            String string;
            String string2;
            File[] fileArray;
            IncludeExcludeVisualizer includeExcludeVisualizer = IncludeExcludeVisualizer.this;
            synchronized (includeExcludeVisualizer) {
                IncludeExcludeVisualizer.this.busy = true;
                IncludeExcludeVisualizer.this.included.clear();
                IncludeExcludeVisualizer.this.excluded.clear();
                fileArray = (File[])IncludeExcludeVisualizer.this.roots.clone();
                string2 = IncludeExcludeVisualizer.this.includes;
                string = IncludeExcludeVisualizer.this.excludes;
                IncludeExcludeVisualizer.this.interrupted = false;
                IncludeExcludeVisualizer.this.updateFiles();
            }
            includeExcludeVisualizer = new PathMatcher(string2, string, null);
            for (File file : fileArray) {
                IncludeExcludeVisualizer.this.scan(file, "", (PathMatcher)includeExcludeVisualizer);
            }
            IncludeExcludeVisualizer includeExcludeVisualizer2 = IncludeExcludeVisualizer.this;
            synchronized (includeExcludeVisualizer2) {
                IncludeExcludeVisualizer.this.busy = false;
                IncludeExcludeVisualizer.this.updateFiles();
            }
        }
    }
}

