/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.project;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.module.spi.AntEvent;
import org.apache.tools.ant.module.spi.AntLogger;
import org.apache.tools.ant.module.spi.AntSession;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.windows.IOColorPrint;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputListener;
import org.openide.windows.OutputWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JavaAntLogger
extends AntLogger {
    private static final String JIDENT = "[\\p{javaJavaIdentifierStart}][\\p{javaJavaIdentifierPart}]*";
    private static final Pattern STACK_TRACE = Pattern.compile("(.*?((?:[\\p{javaJavaIdentifierStart}][\\p{javaJavaIdentifierPart}]*[.])*)([\\p{javaJavaIdentifierStart}][\\p{javaJavaIdentifierPart}]*)[.](?:[\\p{javaJavaIdentifierStart}][\\p{javaJavaIdentifierPart}]*|<init>|<clinit>)[(])(([\\p{javaJavaIdentifierStart}][\\p{javaJavaIdentifierPart}]*[.]java):([0-9]+)|Unknown Source)([)].*)");
    private static final Pattern EXCEPTION_MESSAGE = Pattern.compile("(?:Exception in thread \"(?:main|Main Thread)\" )?(?:(?:[\\p{javaJavaIdentifierStart}][\\p{javaJavaIdentifierPart}]*\\.)+)([\\p{javaJavaIdentifierStart}][\\p{javaJavaIdentifierPart}]*(?:: .+)?)");
    private static final Pattern CLASSPATH_ARGS = Pattern.compile("\r?\n'-classpath'\r?\n'(.*)'\r?\n");
    private static final Pattern JAVA_EXECUTABLE = Pattern.compile("^Executing '(.*)' with arguments:$", 8);
    private static final String[] TASKS_OF_INTEREST = new String[]{"java", "junit", "testng", "exec", "nb-run"};
    private static final int[] LEVELS_OF_INTEREST = new int[]{3, 2, 1, 0};

    static StackTraceParse parseStackTraceLine(String string) {
        Matcher matcher = STACK_TRACE.matcher(string);
        if (matcher.matches()) {
            int n;
            String string2 = matcher.group(2);
            String string3 = matcher.group(5);
            if (string3 == null) {
                string3 = matcher.group(3).replaceFirst("[$].+", "") + ".java";
                n = 1;
            } else {
                n = Integer.parseInt(matcher.group(6));
            }
            return new StackTraceParse(string, string2.replace('.', '/') + string3, n, matcher.group(1), matcher.group(4), matcher.group(7));
        }
        return null;
    }

    public boolean interestedInSession(AntSession antSession) {
        return true;
    }

    public boolean interestedInAllScripts(AntSession antSession) {
        return true;
    }

    public String[] interestedInTargets(AntSession antSession) {
        return AntLogger.ALL_TARGETS;
    }

    public String[] interestedInTasks(AntSession antSession) {
        return TASKS_OF_INTEREST;
    }

    public int[] interestedInLogLevels(AntSession antSession) {
        return LEVELS_OF_INTEREST;
    }

    private SessionData getSessionData(AntSession antSession) {
        SessionData sessionData = (SessionData)antSession.getCustomData((AntLogger)this);
        if (sessionData == null) {
            sessionData = new SessionData();
            antSession.putCustomData((AntLogger)this, (Object)sessionData);
        }
        return sessionData;
    }

    public void messageLogged(AntEvent antEvent) {
        Object object;
        FileObject fileObject;
        AntSession antSession = antEvent.getSession();
        int n = antEvent.getLogLevel();
        int n2 = antSession.getVerbosity();
        SessionData sessionData = this.getSessionData(antSession);
        String string = antEvent.getMessage();
        assert (string != null);
        StackTraceParse stackTraceParse = JavaAntLogger.parseStackTraceLine(string);
        if (stackTraceParse != null) {
            for (Object object2 : JavaAntLogger.getCurrentSourceRootsForClasspath(sessionData)) {
                fileObject = object2.getFileObject(stackTraceParse.resource);
                if (fileObject == null) continue;
                stackTraceParse.hyperlink(antSession, antEvent, fileObject, n, n2, sessionData);
                break;
            }
            if (!antEvent.isConsumed()) {
                object = GlobalPathRegistry.getDefault().findResource(stackTraceParse.resource);
                if (object != null) {
                    stackTraceParse.hyperlink(antSession, antEvent, (FileObject)object, n, n2, sessionData);
                } else if (n <= n2 && "java".equals(antEvent.getTaskName())) {
                    antEvent.consume();
                    antSession.println(string, antEvent.getLogLevel() <= 1, null);
                }
            }
        } else {
            sessionData.possibleExceptionText = string;
            sessionData.lastExceptionMessage = null;
        }
        if (n == 3) {
            Object object2;
            object = CLASSPATH_ARGS.matcher(string);
            if (((Matcher)object).find()) {
                object2 = ((Matcher)object).group(1);
                sessionData.setClasspath((String)object2);
            }
            if (((Matcher)(object = JAVA_EXECUTABLE.matcher(string))).find() && (fileObject = this.findPlatformSources((String)(object2 = ((Matcher)object).group(1)))) != null) {
                sessionData.setPlatformSources((ClassPath)fileObject);
            }
        }
    }

    private ClassPath findPlatformSources(String string) {
        for (JavaPlatform javaPlatform : JavaPlatformManager.getDefault().getInstalledPlatforms()) {
            File file;
            FileObject fileObject = javaPlatform.findTool("java");
            if (fileObject == null || !(file = FileUtil.toFile((FileObject)fileObject)).getAbsolutePath().startsWith(string)) continue;
            return javaPlatform.getSourceFolders();
        }
        return null;
    }

    private static Collection<FileObject> getCurrentSourceRootsForClasspath(SessionData sessionData) {
        if (sessionData.classpath == null) {
            return Collections.emptySet();
        }
        if (sessionData.classpathSourceRoots == null) {
            String string;
            sessionData.classpathSourceRoots = new LinkedHashSet<FileObject>();
            StringTokenizer stringTokenizer = new StringTokenizer(sessionData.classpath, File.pathSeparator);
            while (stringTokenizer.hasMoreTokens()) {
                string = stringTokenizer.nextToken();
                File file = FileUtil.normalizeFile((File)new File(string));
                URL uRL = FileUtil.urlForArchiveOrDir((File)file);
                if (uRL == null) continue;
                FileObject[] fileObjectArray = SourceForBinaryQuery.findSourceRoots((URL)uRL).getRoots();
                sessionData.classpathSourceRoots.addAll(Arrays.asList(fileObjectArray));
            }
            if (sessionData.platformSources != null) {
                sessionData.classpathSourceRoots.addAll(Arrays.asList(sessionData.platformSources.getRoots()));
            } else {
                string = JavaPlatform.getDefault();
                if (string != null) {
                    sessionData.classpathSourceRoots.addAll(Arrays.asList(string.getSourceFolders().getRoots()));
                }
            }
        }
        return sessionData.classpathSourceRoots;
    }

    private static String guessExceptionMessage(SessionData sessionData) {
        if (sessionData.possibleExceptionText != null) {
            if (sessionData.lastExceptionMessage == null) {
                Matcher matcher = EXCEPTION_MESSAGE.matcher(sessionData.possibleExceptionText);
                if (matcher.matches()) {
                    sessionData.lastExceptionMessage = matcher.group(1);
                } else {
                    sessionData.possibleExceptionText = null;
                }
            }
            return sessionData.lastExceptionMessage;
        }
        return null;
    }

    private static final class SessionData {
        public ClassPath platformSources = null;
        public String classpath = null;
        public Collection<FileObject> classpathSourceRoots = null;
        public String possibleExceptionText = null;
        public String lastExceptionMessage = null;

        public void setClasspath(String string) {
            this.classpath = string;
            this.classpathSourceRoots = null;
        }

        public void setPlatformSources(ClassPath classPath) {
            this.platformSources = classPath;
            this.classpathSourceRoots = null;
        }
    }

    static final class StackTraceParse {
        final String line;
        final String resource;
        final int lineNumber;
        final String prePart;
        final String midPart;
        final String endPart;

        StackTraceParse(String string, String string2, int n, String string3, String string4, String string5) {
            this.line = string;
            this.resource = string2;
            this.lineNumber = n;
            this.prePart = string3;
            this.midPart = string4;
            this.endPart = string5;
        }

        public String toString() {
            return this.resource + ":" + this.lineNumber;
        }

        void hyperlink(AntSession antSession, AntEvent antEvent, FileObject fileObject, int n, int n2, SessionData sessionData) {
            if (n <= n2 && !antEvent.isConsumed()) {
                OutputListener outputListener;
                try {
                    outputListener = antSession.createStandardHyperlink(fileObject.getURL(), JavaAntLogger.guessExceptionMessage(sessionData), this.lineNumber, -1, -1, -1);
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    assert (false) : fileStateInvalidException;
                    return;
                }
                antEvent.consume();
                InputOutput inputOutput = antSession.getIO();
                if (IOColorPrint.isSupported((InputOutput)inputOutput)) {
                    try {
                        OutputWriter outputWriter = n <= 1 ? inputOutput.getErr() : inputOutput.getOut();
                        boolean bl = this.prePart.contains("at ");
                        outputWriter.print(this.prePart);
                        IOColorPrint.print((InputOutput)inputOutput, (CharSequence)this.midPart, (OutputListener)outputListener, (boolean)bl, null);
                        outputWriter.println(this.endPart);
                        return;
                    }
                    catch (IOException iOException) {
                        Exceptions.printStackTrace((Throwable)iOException);
                    }
                }
                antSession.println(this.line, true, outputListener);
            }
        }
    }
}

