/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.charts;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import org.netbeans.lib.profiler.ui.charts.ChartModelListener;
import org.netbeans.lib.profiler.ui.charts.DynamicPieChartModel;
import org.netbeans.lib.profiler.ui.charts.PieChartModel;

public class PieChart
extends JComponent
implements ComponentListener,
ChartModelListener,
Accessible {
    private static Color evenSelectionSegmentsColor = Color.WHITE;
    private static Stroke evenSelectionSegmentsStroke = new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{5.0f, 5.0f}, 0.0f);
    private static Color oddSelectionSegmentColor = Color.BLACK;
    private static Stroke oddSelectionSegmentStroke = new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{5.0f, 5.0f}, 5.0f);
    private AccessibleContext accessibleContext;
    private Area pieArea;
    private Graphics2D offScreenGraphics;
    private Image offScreenImage;
    private Insets insets = new Insets(0, 0, 0, 0);
    private PieChartModel model;
    private Vector arcs = new Vector();
    private Vector bottoms = new Vector();
    private Vector selectedItems = new Vector();
    private boolean draw3D = true;
    private boolean offScreenImageInvalid;
    private boolean offScreenImageSizeInvalid = true;
    private int chartHeight = 15;
    private int drawHeight;
    private int drawWidth;
    private int focusedItem = -1;
    private int initialAngle = 0;
    private int pieCenterY;
    private int pieHeight;

    public PieChart() {
        this.addComponentListener(this);
    }

    public void setAccessibleContext(AccessibleContext accessibleContext) {
        this.accessibleContext = accessibleContext;
    }

    public AccessibleContext getAccessibleContext() {
        return this.accessibleContext;
    }

    public void setChartHeight(int n) {
        this.chartHeight = n;
        this.draw3D = n > 0;
    }

    public int getChartHeight() {
        return this.chartHeight;
    }

    public void setFocusedItem(int n) {
        if (this.focusedItem != n) {
            this.focusedItem = n;
            this.offScreenImageInvalid = true;
            this.repaint();
        }
    }

    public int getItemIndexAt(int n, int n2) {
        int n3;
        n -= this.insets.left;
        n2 -= this.insets.top;
        for (n3 = 0; n3 < this.arcs.size(); ++n3) {
            if (!((Arc2D)this.arcs.get(n3)).contains(n, n2)) continue;
            return n3;
        }
        if (this.draw3D) {
            for (n3 = 0; n3 < this.bottoms.size(); ++n3) {
                Area area = (Area)this.bottoms.get(n3);
                if (area == null || !area.contains(n, n2)) continue;
                return n3;
            }
        }
        return -1;
    }

    public void setModel(PieChartModel pieChartModel) {
        if (this.model != null) {
            this.model.removeChartModelListener(this);
        }
        if (pieChartModel != null) {
            pieChartModel.addChartModelListener(this);
        }
        this.model = pieChartModel;
        this.chartDataChanged();
    }

    public PieChartModel getModel() {
        return this.model;
    }

    public void setSelectedItem(int n) {
        if (this.selectedItems.contains(n) && this.selectedItems.size() == 1) {
            return;
        }
        this.selectedItems.clear();
        this.selectedItems.add(n);
        this.offScreenImageInvalid = true;
        this.repaint();
    }

    public int[] getSelectedItems() {
        int[] nArray = new int[this.selectedItems.size()];
        for (int i = 0; i < this.selectedItems.size(); ++i) {
            nArray[i] = (Integer)this.selectedItems.get(i);
        }
        return nArray;
    }

    public void setStartAngle(int n) {
        this.initialAngle = n;
    }

    public int getStartAngle() {
        return this.initialAngle;
    }

    public void addSelectedItem(int n) {
        if (this.selectedItems.contains(n)) {
            return;
        }
        this.selectedItems.add(n);
        this.offScreenImageInvalid = true;
        this.repaint();
    }

    public void chartDataChanged() {
        this.selectAllItems();
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentResized(ComponentEvent componentEvent) {
        this.offScreenImageSizeInvalid = true;
        this.repaint();
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void deselectAllItems() {
        this.selectedItems.clear();
        this.offScreenImageInvalid = true;
        this.repaint();
    }

    public static void main(String[] stringArray) {
        final PieChart pieChart = new PieChart();
        pieChart.setBorder(BorderFactory.createEmptyBorder(5, 20, 5, 20));
        pieChart.setPreferredSize(new Dimension(300, 200));
        DynamicPieChartModel dynamicPieChartModel = new DynamicPieChartModel();
        dynamicPieChartModel.setupModel(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}, new Color[]{Color.RED, Color.GREEN, Color.BLUE, Color.YELLOW});
        dynamicPieChartModel.setItemValues(new double[]{10.0, 5.0, 15.0, 7.0});
        JFrame jFrame = new JFrame("PieChart Tester");
        jFrame.getContentPane().add(pieChart);
        jFrame.setDefaultCloseOperation(3);
        jFrame.pack();
        jFrame.setVisible(true);
        pieChart.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                int n = pieChart.getItemIndexAt(mouseEvent.getX(), mouseEvent.getY());
                pieChart.toggleItemSelection(n);
            }
        });
        pieChart.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent mouseEvent) {
                int n = pieChart.getItemIndexAt(mouseEvent.getX(), mouseEvent.getY());
                if (n != -1) {
                    pieChart.setCursor(Cursor.getPredefinedCursor(12));
                } else {
                    pieChart.setCursor(Cursor.getDefaultCursor());
                }
                pieChart.setFocusedItem(n);
            }
        });
        pieChart.setModel(dynamicPieChartModel);
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.model == null) {
            return;
        }
        if (this.offScreenImageSizeInvalid) {
            this.updateOffScreenImageSize();
        }
        if (this.offScreenImageInvalid) {
            this.drawChart(this.offScreenGraphics);
        }
        graphics.drawImage(this.offScreenImage, this.insets.left, this.insets.top, this);
    }

    public void removeSelectedItem(int n) {
        if (!this.selectedItems.contains(n)) {
            return;
        }
        this.selectedItems.remove((Object)n);
        this.offScreenImageInvalid = true;
        this.repaint();
    }

    public void resetFocusedItem() {
        if (this.focusedItem != -1) {
            this.focusedItem = -1;
            this.offScreenImageInvalid = true;
            this.repaint();
        }
    }

    public void selectAllItems() {
        for (int i = 0; i < this.model.getItemCount(); ++i) {
            this.selectedItems.add(i);
        }
        this.offScreenImageInvalid = true;
        this.repaint();
    }

    public void toggleItemSelection(int n) {
        if (this.selectedItems.contains(n)) {
            this.removeSelectedItem(n);
        } else {
            this.addSelectedItem(n);
        }
    }

    protected Color getDisabledColor(Color color) {
        int n = color.getRed();
        int n2 = color.getGreen();
        int n3 = color.getBlue();
        return new Color(n, n2, n3, 50);
    }

    protected void drawChart(Graphics2D graphics2D) {
        this.arcs.clear();
        this.bottoms.clear();
        Area area = null;
        graphics2D.setColor(this.getBackground());
        graphics2D.fillRect(0, 0, this.drawWidth + 1, this.drawHeight + 1);
        graphics2D.setStroke(new BasicStroke(0.5f));
        if (!this.model.hasData()) {
            Area area2 = new Area(new Rectangle2D.Double(0.0, this.pieCenterY + 1, this.drawWidth - 1, this.pieCenterY + this.pieHeight));
            area2.subtract(this.pieArea);
            Area area3 = new Area(area2);
            area3.transform(AffineTransform.getTranslateInstance(0.0, this.chartHeight));
            area2.subtract(area3);
            graphics2D.setPaint(Color.BLACK);
            graphics2D.draw(area2);
            graphics2D.drawArc(0, 0, this.drawWidth - 1, this.pieHeight, 0, 180);
        } else {
            int n = this.initialAngle;
            double d = 0.0;
            double d2 = 0.0;
            double d3 = 0.0;
            double d4 = 0.0;
            double d5 = 0.0;
            double d6 = 0.0;
            int n2 = this.model.getItemCount();
            for (int i = 0; i < n2; ++i) {
                int n3;
                if (this.model.getItemValueRel(i) == 0.0 || (n3 = (int)Math.min(Math.ceil(this.model.getItemValueRel(i) * 360.0), (double)(360 - n))) == 0) continue;
                Arc2D.Double double_ = new Arc2D.Double(0.0, 1.0, this.drawWidth - 1, this.pieHeight, n, n3, 2);
                this.arcs.add(double_);
                if (i == this.focusedItem) {
                    area = n2 == 1 ? new Area(new Ellipse2D.Double(0.0, 1.0, this.drawWidth - 1, this.pieHeight)) : new Area(double_);
                }
                if (this.draw3D) {
                    Area area4;
                    boolean bl;
                    Point2D point2D = double_.getStartPoint();
                    Point2D point2D2 = double_.getEndPoint();
                    boolean bl2 = n < 0 || n > 180;
                    boolean bl3 = bl = n + n3 < 0 || n + n3 > 180;
                    if (bl2 && bl) {
                        if (point2D.getX() < point2D2.getX()) {
                            d = point2D.getX();
                            d2 = point2D2.getX();
                            d3 = d2 - d;
                            d4 = Math.min(point2D.getY(), point2D2.getY()) - 1.0;
                            d5 = this.drawHeight;
                            d6 = d5 - d4;
                            area4 = this.drawChartPartSide(graphics2D, this.pieArea, d, d4, d3, d6, this.selectedItems.contains(i) ? this.model.getItemColor(i).darker() : this.getDisabledColor(this.model.getItemColor(i).darker()));
                            this.bottoms.add(area4);
                            if (i == this.focusedItem && area != null) {
                                area.add(area4);
                            }
                        } else {
                            d = point2D.getX();
                            d2 = this.drawWidth - 1;
                            d3 = d2 - d;
                            d4 = this.pieCenterY + 1;
                            d5 = this.drawHeight;
                            d6 = d5 - d4;
                            area4 = this.drawChartPartSide(graphics2D, this.pieArea, d, d4, d3, d6, this.selectedItems.contains(i) ? this.model.getItemColor(i).darker() : this.getDisabledColor(this.model.getItemColor(i).darker()));
                            d = 0.0;
                            d2 = point2D2.getX();
                            d3 = d2 - d;
                            d4 = this.pieCenterY + 1;
                            d5 = this.drawHeight;
                            d6 = d5 - d4;
                            Area area5 = this.drawChartPartSide(graphics2D, this.pieArea, d, d4, d3, d6, this.selectedItems.contains(i) ? this.model.getItemColor(i).darker() : this.getDisabledColor(this.model.getItemColor(i).darker()));
                            area4.add(area5);
                            this.bottoms.add(area4);
                            if (i == this.focusedItem && area != null) {
                                area.add(area4);
                            }
                        }
                    } else if (bl2 || bl) {
                        if (bl2 && !bl) {
                            d = point2D.getX();
                            d2 = this.drawWidth - 1;
                            d3 = d2 - d;
                            d4 = this.pieCenterY + 1;
                            d5 = this.drawHeight;
                            d6 = d5 - d4;
                            area4 = this.drawChartPartSide(graphics2D, this.pieArea, d, d4, d3, d6, this.selectedItems.contains(i) ? this.model.getItemColor(i).darker() : this.getDisabledColor(this.model.getItemColor(i).darker()));
                            this.bottoms.add(area4);
                            if (i == this.focusedItem && area != null) {
                                area.add(area4);
                            }
                        } else {
                            d = 0.0;
                            d2 = point2D2.getX();
                            d3 = d2 - d;
                            d4 = this.pieCenterY + 1;
                            d5 = this.drawHeight;
                            d6 = d5 - d4;
                            area4 = this.drawChartPartSide(graphics2D, this.pieArea, d, d4, d3, d6, this.selectedItems.contains(i) ? this.model.getItemColor(i).darker() : this.getDisabledColor(this.model.getItemColor(i).darker()));
                            this.bottoms.add(area4);
                            if (i == this.focusedItem && area != null) {
                                area.add(area4);
                            }
                        }
                    } else if (n3 >= 180) {
                        d = 0.0;
                        d2 = this.drawWidth - 1;
                        d3 = d2 - d;
                        d4 = this.pieCenterY + 1;
                        d5 = this.drawHeight;
                        d6 = d5 - d4;
                        area4 = this.drawChartPartSide(graphics2D, this.pieArea, d, d4, d3, d6, this.selectedItems.contains(i) ? this.model.getItemColor(i).darker() : this.getDisabledColor(this.model.getItemColor(i).darker()));
                        this.bottoms.add(area4);
                        if (i == this.focusedItem && area != null) {
                            area.add(area4);
                        }
                    } else {
                        this.bottoms.add(null);
                    }
                }
                graphics2D.setPaint(this.selectedItems.contains(i) ? this.model.getItemColor(i) : this.getDisabledColor(this.model.getItemColor(i)));
                graphics2D.fill(double_);
                n += n3;
            }
        }
        if (area != null) {
            graphics2D.setColor(evenSelectionSegmentsColor);
            graphics2D.setStroke(evenSelectionSegmentsStroke);
            graphics2D.draw(area);
            graphics2D.setColor(oddSelectionSegmentColor);
            graphics2D.setStroke(oddSelectionSegmentStroke);
            graphics2D.draw(area);
        }
        this.offScreenImageInvalid = false;
    }

    protected Area drawChartPartSide(Graphics2D graphics2D, Area area, double d, double d2, double d3, double d4, Color color) {
        Area area2 = new Area(new Rectangle2D.Double(d, d2, d3, d4));
        area2.subtract(area);
        Area area3 = new Area(area2);
        area3.transform(AffineTransform.getTranslateInstance(0.0, this.chartHeight));
        area2.subtract(area3);
        area2.transform(AffineTransform.getTranslateInstance(0.0, -1.0));
        area2.subtract(area);
        graphics2D.setPaint(color);
        graphics2D.fill(area2);
        return area2;
    }

    protected void updateOffScreenImageSize() {
        this.insets = this.getInsets();
        this.drawWidth = this.getWidth() - this.insets.left - this.insets.right;
        this.drawHeight = this.getHeight() - this.insets.top - this.insets.bottom - 1;
        this.pieHeight = this.drawHeight - this.chartHeight;
        this.pieCenterY = this.pieHeight / 2;
        this.offScreenImage = this.createImage(this.drawWidth + 1, this.drawHeight + 1);
        this.offScreenGraphics = (Graphics2D)this.offScreenImage.getGraphics();
        this.offScreenGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.offScreenImageSizeInvalid = false;
        this.offScreenImageInvalid = true;
        this.pieArea = new Area(new Ellipse2D.Double(0.0, 0.0, this.drawWidth - 1, this.pieHeight));
    }
}

