/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.properties;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import org.netbeans.modules.properties.BundleStructure;
import org.netbeans.modules.properties.PropertiesDataNode;
import org.netbeans.modules.properties.PropertiesDataObject;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.FileEntry;
import org.openide.loaders.MultiDataObject;
import org.openide.util.NbBundle;

public final class Util {
    public static final String HELP_ID_PROPERTIES = "propfiles.prop";
    public static final String HELP_ID_CREATING = "propfiles.creating";
    public static final String HELP_ID_ADDING = "propfiles.adding";
    public static final String HELP_ID_MODIFYING = "propfiles.modifying";
    public static final String HELP_ID_ADDLOCALE = "propfiles.addlocale";
    public static final String HELP_ID_EDITLOCALE = "propfiles.editlocale";
    public static final char PRB_SEPARATOR_CHAR = '_';
    public static final int LABEL_FIRST_PART_LENGTH = 10;

    public static String stringToKey(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        block3: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': 
                case ':': 
                case '=': {
                    stringBuffer.append('_');
                    continue block3;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    public static String assembleName(String string, String string2) {
        if (string2.length() == 0) {
            return string;
        }
        if (string2.charAt(0) != '_') {
            StringBuffer stringBuffer = new StringBuffer().append(string).append('_').append(string2);
            return stringBuffer.toString();
        }
        return string + string2;
    }

    public static String getLocaleSuffix(MultiDataObject.Entry entry) {
        String string;
        FileObject fileObject = entry.getFile();
        String string2 = fileObject.getName();
        if (string2.equals(string = Util.getBaseName(string2))) {
            return "";
        }
        return string2.substring(string.length());
    }

    private static boolean isValidLocaleSuffix(String string) {
        HashSet<String> hashSet;
        String string2;
        int n = string.length();
        if (n != 3 && (n <= 3 || string.charAt(3) != '_')) {
            return false;
        }
        String string3 = string.substring(1, 3).toLowerCase();
        if (n == 3) {
            string2 = null;
        } else if (n == 6 || n > 6 && string.charAt(6) == '_') {
            string2 = string.substring(4, 6).toUpperCase();
        } else {
            return false;
        }
        HashSet<String> hashSet2 = new HashSet<String>(Arrays.asList(Locale.getISOLanguages()));
        if (!hashSet2.contains(string3)) {
            return false;
        }
        return string2 == null || (hashSet = new HashSet<String>(Arrays.asList(Locale.getISOCountries()))).contains(string2);
    }

    public static String getLanguage(String string) {
        return Util.getFirstPart(string);
    }

    public static String getCountry(String string) {
        if (string.length() == 0) {
            return null;
        }
        int n = string.indexOf(95, 1);
        return n != -1 ? Util.getFirstPart(string.substring(n)) : "";
    }

    public static String getVariant(String string) {
        if (string.length() == 0) {
            return null;
        }
        int n = string.indexOf(95, 1);
        if (n == -1) {
            return "";
        }
        return (n = string.indexOf(95, n + 1)) != -1 ? string.substring(n + 1) : "";
    }

    private static String getFirstPart(String string) {
        if (string.length() == 0) {
            return null;
        }
        assert (string.charAt(0) == '_');
        int n = string.indexOf(95, 1);
        return n != -1 ? string.substring(1, n) : string.substring(1);
    }

    public static String getLocaleLabel(MultiDataObject.Entry entry) {
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        String string6 = Util.getLocaleSuffix(entry);
        if (string6.length() == 0) {
            string5 = "";
            string4 = "";
            string3 = "";
        } else {
            string5 = Util.getLanguage(string6);
            string4 = Util.getCountry(string6);
            string3 = Util.getVariant(string6);
            string5 = string5.length() != 0 ? string5 : "";
            string4 = string4.length() != 0 ? string4 : "";
            string3 = string3.length() != 0 ? string3 : "";
        }
        String string7 = null;
        if (string5 == "") {
            string7 = NbBundle.getMessage(Util.class, (String)"LAB_defaultLanguage");
        }
        if (string5 == "" && string4 == "" && string3 == "") {
            return string7;
        }
        String string8 = string6.substring(1);
        Locale locale = new Locale(string5, string4, string3);
        if (string5 == "") {
            string2 = string7;
        } else {
            string2 = locale.getDisplayLanguage();
            if (string2.equals(string5)) {
                string2 = NbBundle.getMessage(Util.class, (String)"LAB_unknownLanguage", (Object)string5);
            }
        }
        if (string4 == "" && string3 == "") {
            return NbBundle.getMessage(Util.class, (String)"LAB_localeSpecLang", (Object)string8, (Object)string2);
        }
        String string9 = "";
        if (string4 != "" && (string9 = locale.getDisplayCountry()).equals(string4)) {
            string9 = NbBundle.getMessage(Util.class, (String)"LAB_unknownCountry", (Object)string4);
        }
        String string10 = string = string3 == "" ? "" : locale.getDisplayVariant();
        String string11 = string == "" ? string9 : (string9 == "" ? string : string9 + ", " + string);
        return NbBundle.getMessage(Util.class, (String)"LAB_localeSpecLangCountry", (Object)string8, (Object)string2, (Object)string11);
    }

    private static void notifyError(String string) {
        NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)MessageFormat.format(NbBundle.getBundle(PropertiesDataNode.class).getString("MSG_LangExists"), string), 0);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
    }

    public static PropertiesDataObject createPropertiesDataObject(FileObject fileObject, String string) throws IOException {
        Object object;
        int n = string.lastIndexOf(47);
        if (n > 0) {
            object = string.substring(0, n);
            fileObject = FileUtil.createFolder((FileObject)fileObject, (String)object);
            string = string.substring(n + 1);
        }
        object = Repository.getDefault().getDefaultFileSystem();
        FileObject fileObject2 = object.findResource("Templates/Other/properties.properties");
        DataObject dataObject = DataObject.find((FileObject)fileObject2);
        return (PropertiesDataObject)dataObject.createFromTemplate(DataFolder.findFolder((FileObject)fileObject), string);
    }

    public static void createLocaleFile(PropertiesDataObject propertiesDataObject, String string, boolean bl) {
        try {
            if (string.length() == 0) {
                Util.notifyError(string);
                return;
            }
            if (propertiesDataObject != null) {
                FileObject fileObject;
                String string2;
                FileObject fileObject2 = propertiesDataObject.getBundleStructure().getNthEntry(0).getFile();
                if (!fileObject2.hasExt(string2 = "properties") && fileObject2.getMIMEType().equalsIgnoreCase("text/x-properties")) {
                    string2 = fileObject2.getExt();
                }
                final String string3 = Util.getBaseName(fileObject2.getName()) + '_' + string;
                final FileObject fileObject3 = fileObject2.getParent();
                Iterator iterator = propertiesDataObject.secondaryEntries().iterator();
                while (iterator.hasNext()) {
                    fileObject = ((FileEntry)iterator.next()).getFile();
                    if (!string3.startsWith(fileObject.getName()) || fileObject.getName().length() <= fileObject2.getName().length()) continue;
                    fileObject2 = fileObject;
                }
                if (fileObject2.getName().equals(string3)) {
                    return;
                }
                if (bl) {
                    if (fileObject3.getFileObject(string3, string2) == null) {
                        fileObject = (SaveCookie)propertiesDataObject.getCookie(SaveCookie.class);
                        if (fileObject != null) {
                            fileObject.save();
                        }
                        final FileObject fileObject4 = fileObject2;
                        final String string4 = string2;
                        fileObject3.getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

                            public void run() throws IOException {
                                fileObject4.copy(fileObject3, string3, string4);
                            }
                        });
                        PropertiesDataObject propertiesDataObject2 = (PropertiesDataObject)DataObject.find((FileObject)fileObject3.getFileObject(string3, string2));
                        propertiesDataObject2.setBundleStructure(propertiesDataObject.getBundleStructure());
                        propertiesDataObject.getBundleStructure().updateEntries();
                        propertiesDataObject.getOpenSupport().addDataObject(propertiesDataObject2);
                        propertiesDataObject.getBundleStructure().notifyOneFileChanged(fileObject3.getFileObject(string3, string2));
                    }
                } else {
                    DataObject.find((FileObject)fileObject3.createData(string3, string2));
                    propertiesDataObject.getBundleStructure().updateEntries();
                }
            }
        }
        catch (IOException iOException) {
            if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                iOException.printStackTrace();
            }
            Util.notifyError(string);
        }
    }

    static PropertiesDataObject findPrimaryDataObject(PropertiesDataObject propertiesDataObject) throws DataObjectNotFoundException {
        FileObject fileObject = propertiesDataObject.getPrimaryFile();
        assert (fileObject != null) : "Object " + (Object)((Object)propertiesDataObject) + " cannot have null primary file";
        String string = fileObject.getName();
        String string2 = Util.getBaseName(string);
        FileObject fileObject2 = fileObject.getParent();
        int n = string.indexOf(95);
        while (n != -1) {
            FileObject fileObject3 = fileObject2.getFileObject(string.substring(0, n), fileObject.getExt());
            if (fileObject3 != null && Util.isValidLocaleSuffix(string.substring(n))) {
                return (PropertiesDataObject)DataObject.find((FileObject)fileObject3);
            }
            if (fileObject3 == null) {
                for (FileObject fileObject4 : fileObject2.getChildren()) {
                    if (!fileObject4.hasExt("properties") || fileObject4.getName().indexOf(string2) == -1 || !Util.isValidLocaleSuffix(fileObject4.getName().substring(n))) continue;
                    return (PropertiesDataObject)DataObject.find((FileObject)fileObject4);
                }
            }
            n = string.indexOf(95, n + 1);
        }
        return propertiesDataObject;
    }

    static BundleStructure findBundleStructure(FileObject fileObject, FileObject fileObject2, String string) throws DataObjectNotFoundException {
        PropertiesDataObject propertiesDataObject = null;
        String string2 = "properties";
        if (!fileObject.hasExt(string2) && fileObject.getMIMEType().equalsIgnoreCase("text/x-properties")) {
            string2 = fileObject.getExt();
        }
        for (FileObject fileObject3 : fileObject2.getChildren()) {
            BundleStructure bundleStructure;
            if (!fileObject3.hasExt(string2) || fileObject3.equals(fileObject)) continue;
            String string3 = fileObject3.getName();
            if (string3.equals(string) && fileObject3.isValid()) {
                propertiesDataObject = (PropertiesDataObject)DataObject.find((FileObject)fileObject3);
                if (propertiesDataObject == null || (bundleStructure = propertiesDataObject.getBundleStructureOrNull()) == null) continue;
                return bundleStructure;
            }
            if (string3.indexOf(string) == -1) continue;
            int n = string3.indexOf(95);
            if (string.length() != n) continue;
            while (n != -1) {
                FileObject fileObject4 = fileObject3;
                if (fileObject4 != null && Util.isValidLocaleSuffix(string3.substring(n)) && fileObject3.isValid()) {
                    DataObject dataObject = DataObject.find((FileObject)fileObject4);
                    if (dataObject instanceof PropertiesDataObject) {
                        propertiesDataObject = (PropertiesDataObject)DataObject.find((FileObject)fileObject4);
                    } else {
                        n = -1;
                    }
                    if (propertiesDataObject == null) continue;
                    bundleStructure = propertiesDataObject.getBundleStructureOrNull();
                    if (bundleStructure != null) {
                        return bundleStructure;
                    }
                }
                n = string3.indexOf(95, n + 1);
            }
        }
        return null;
    }

    static String getBaseName(String string) {
        String string2 = null;
        int n = string.indexOf(95);
        while (n != -1) {
            string2 = string.substring(0, n);
            if (string2 != null && Util.isValidLocaleSuffix(string.substring(n))) {
                return string2;
            }
            n = string.indexOf(95, n + 1);
        }
        return string;
    }
}

