/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.api.flow;

import java.util.Collection;
import java.util.Collections;
import org.netbeans.modules.vmd.api.flow.FlowPresenter;
import org.netbeans.modules.vmd.api.flow.visual.FlowBadgeDescriptor;
import org.netbeans.modules.vmd.api.flow.visual.FlowDescriptor;
import org.netbeans.modules.vmd.api.flow.visual.FlowNodeDescriptor;
import org.netbeans.modules.vmd.api.flow.visual.FlowPinDescriptor;
import org.netbeans.modules.vmd.api.flow.visual.FlowScene;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FlowNodeBadgePresenter
extends FlowPresenter
implements FlowPresenter.FlowUIResolver {
    private FlowNodeDescriptor node = null;
    private FlowBadgeDescriptor badge = null;
    private FlowNodeDescriptor oldNode;
    private boolean removeAdd;

    @Override
    public final void resolveRemoveBadge() {
        FlowBadgeDescriptor flowBadgeDescriptor;
        FlowNodeDescriptor flowNodeDescriptor;
        FlowScene flowScene = this.getScene();
        if (this.isVisible()) {
            flowNodeDescriptor = this.getNodeDescriptor();
            flowBadgeDescriptor = flowNodeDescriptor != null ? this.getPinBadgeDescriptor() : null;
        } else {
            flowNodeDescriptor = null;
            flowBadgeDescriptor = null;
        }
        boolean bl = this.removeAdd = !FlowNodeBadgePresenter.equals(this.node, flowNodeDescriptor) || !FlowNodeBadgePresenter.equals(this.badge, flowBadgeDescriptor);
        if (this.removeAdd) {
            if (this.badge != null) {
                flowScene.removeBadge(this.node, this.badge);
                flowScene.unregisterUI(this.badge, (FlowPresenter.FlowUIResolver)this);
            }
            this.oldNode = this.node;
            this.node = flowNodeDescriptor;
            this.badge = flowBadgeDescriptor;
        } else {
            this.oldNode = null;
        }
    }

    @Override
    public final void resolveRemoveEdge() {
    }

    @Override
    public final void resolveRemovePin() {
    }

    @Override
    public final void resolveRemoveNode() {
    }

    @Override
    public final void resolveAddNode() {
    }

    @Override
    public final void resolveAddPin() {
    }

    @Override
    public final void resolveAddEdge() {
    }

    @Override
    public final void resolveAddBadge() {
        if (this.removeAdd && this.badge != null) {
            FlowScene flowScene = this.getScene();
            flowScene.registerUI(this.badge, (FlowPresenter.FlowUIResolver)this);
            flowScene.addBadge(this.oldNode, this.badge);
        }
    }

    @Override
    public final void resolveUpdate() {
        FlowScene flowScene = this.getScene();
        if (this.node != null) {
            flowScene.updateBadges(this.node);
        }
        if (this.oldNode != null) {
            flowScene.updateBadges(this.oldNode);
        }
        this.oldNode = null;
    }

    @Override
    public final Collection<? extends FlowDescriptor> getFlowDescriptors() {
        return Collections.emptySet();
    }

    protected abstract FlowNodeDescriptor getNodeDescriptor();

    protected abstract FlowPinDescriptor getPinDescriptor();

    protected abstract FlowBadgeDescriptor getPinBadgeDescriptor();

    @Override
    public abstract FlowBadgeDescriptor.BadgeDecorator getDecorator();

    @Override
    public abstract FlowBadgeDescriptor.BadgeBehaviour getBehaviour();
}

