/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jboss4.config;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.j2ee.deployment.common.api.ConfigurationException;
import org.netbeans.modules.schema2beans.BaseBean;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.text.NbDocument;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class ResourceConfigurationHelper {
    private ResourceConfigurationHelper() {
    }

    public static void writeFile(final File file, final BaseBean baseBean) throws ConfigurationException {
        assert (file != null) : "File to write can't be null";
        assert (file.getParentFile() != null) : "File parent folder can't be null";
        try {
            FileObject fileObject = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file.getParentFile()));
            if (fileObject == null) {
                try {
                    fileObject = FileUtil.createFolder((File)FileUtil.normalizeFile((File)file.getParentFile()));
                }
                catch (IOException iOException) {
                    throw new ConfigurationException(NbBundle.getMessage(ResourceConfigurationHelper.class, (String)"MSG_FailedToCreateConfigFolder", (Object)file.getParentFile().getAbsolutePath()));
                }
            }
            final FileObject fileObject2 = fileObject;
            FileSystem fileSystem = fileObject2.getFileSystem();
            fileSystem.runAtomicAction(new FileSystem.AtomicAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() throws IOException {
                    OutputStream outputStream = null;
                    FileLock fileLock = null;
                    try {
                        String string = file.getName();
                        FileObject fileObject = fileObject2.getFileObject(string);
                        if (fileObject == null) {
                            fileObject = fileObject2.createData(string);
                        }
                        fileLock = fileObject.lock();
                        outputStream = new BufferedOutputStream(fileObject.getOutputStream(fileLock), 4086);
                        if (baseBean != null) {
                            baseBean.write(outputStream);
                        }
                    }
                    finally {
                        if (outputStream != null) {
                            try {
                                outputStream.close();
                            }
                            catch (IOException iOException) {}
                        }
                        if (fileLock != null) {
                            fileLock.releaseLock();
                        }
                    }
                }
            });
        }
        catch (IOException iOException) {
            throw new ConfigurationException(iOException.getLocalizedMessage());
        }
    }

    public static void replaceDocument(final StyledDocument styledDocument, BaseBean baseBean) {
        final ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            baseBean.write((OutputStream)byteArrayOutputStream);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        NbDocument.runAtomic((StyledDocument)styledDocument, (Runnable)new Runnable(){

            public void run() {
                try {
                    styledDocument.remove(0, styledDocument.getLength());
                    styledDocument.insertString(0, byteArrayOutputStream.toString(), null);
                }
                catch (BadLocationException badLocationException) {
                    Exceptions.printStackTrace((Throwable)badLocationException);
                }
            }
        });
    }
}

