/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.editor;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openide.ErrorManager;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.NbBundle;

public class CssHelpResolver {
    private static CssHelpResolver INSTANCE = new CssHelpResolver("org/netbeans/modules/css/resources/css_property_help");
    private static Pattern NAV_BAR = Pattern.compile("<div\\s+class\\s*=\\s*\"navbar\"", 8);
    private Pattern END_SEARCH = Pattern.compile("<[hH][1-5]>|<a\\s+name=\"propdef-", 8);
    private Pattern PROP_DEF_PATTERN = Pattern.compile("<div\\s+class\\s*=\\s*\"propdef\"");
    private static final String HELP_LOCATION = "docs/css21-spec.zip";
    private static URL HELP_ZIP_URL;
    private WeakHashMap<String, String> pages_cache = new WeakHashMap();
    private Map<String, PropertyDescriptor> properties;

    public static CssHelpResolver instance() {
        return INSTANCE;
    }

    private CssHelpResolver(String string) {
        this.parseSource(string);
    }

    public String getPropertyHelp(String string) {
        URL uRL = this.getPropertyHelpURL(string);
        if (uRL == null) {
            return NbBundle.getMessage(CssHelpResolver.class, (String)"MISSING_HELP_FILE_MSG");
        }
        return this.getHelpText(uRL);
    }

    public String getHelpText(URL uRL) {
        int n;
        String string;
        int n2;
        Object object;
        Object object2;
        Object object3;
        if (uRL == null) {
            return null;
        }
        String string2 = uRL.getPath();
        String string3 = this.pages_cache.get(string2);
        if (string3 == null) {
            try {
                object3 = uRL.openStream();
                object2 = new byte[1000];
                object = new ByteArrayOutputStream();
                n2 = 0;
                do {
                    if ((n2 = ((InputStream)object3).read((byte[])object2)) <= 0) continue;
                    ((ByteArrayOutputStream)object).write((byte[])object2, 0, n2);
                } while (n2 > 0);
                ((InputStream)object3).close();
                string3 = ((ByteArrayOutputStream)object).toString();
                ((ByteArrayOutputStream)object).close();
            }
            catch (IOException iOException) {
                Logger.global.log(Level.WARNING, "Cannot read css help file.", iOException);
            }
            this.pages_cache.put(string2, string3);
        }
        object3 = uRL.getRef();
        object2 = Pattern.compile("^.*<a\\s+name=\"" + (String)object3 + "\".*$", 8);
        object = ((Pattern)object2).matcher(string3);
        n2 = 0;
        int n3 = 0;
        if (((Matcher)object).find()) {
            n2 = ((Matcher)object).start();
            n3 = ((Matcher)object).end();
        }
        n2 = this.findSectionStart(n2, string3);
        int n4 = string3.length();
        object = this.END_SEARCH.matcher(string3.subSequence(n3, string3.length()));
        if (((Matcher)object).find()) {
            n4 = ((Matcher)object).start() + n3;
        }
        if (((Matcher)(object = NAV_BAR.matcher(string = string3.substring(n2, n4)))).find()) {
            string = string.substring(0, ((Matcher)object).start());
        }
        if ((n = string.indexOf("\n")) > 0) {
            String string4 = string.substring(0, n);
            string4 = string4.replaceAll("<strong>'", "<strong style=\"font-size: large\">");
            string4 = string4.replaceAll("'</strong>", "</strong>");
            string = string4 + string.substring(n + 1);
        }
        return string;
    }

    public URL getPropertyHelpURL(String string) {
        String string2 = CssHelpResolver.getHelpZIPURLasString();
        if (string2 == null) {
            return null;
        }
        PropertyDescriptor propertyDescriptor = this.getPD(string);
        if (propertyDescriptor == null) {
            return null;
        }
        try {
            return new URL(string2 + propertyDescriptor.helpLink);
        }
        catch (MalformedURLException malformedURLException) {
            Logger.global.log(Level.WARNING, "Error creating URL for property " + string, malformedURLException);
            return null;
        }
    }

    private PropertyDescriptor getPD(String string) {
        PropertyDescriptor propertyDescriptor = this.properties.get(string.toLowerCase());
        if (propertyDescriptor == null) {
            Logger.global.warning("No such property: " + string);
            return null;
        }
        return propertyDescriptor;
    }

    private int findSectionStart(int n, String string) {
        int n2;
        for (n2 = n; n2 >= 0; --n2) {
            char c;
            char c2 = string.charAt(n2);
            if (c2 != '<' || (c = string.charAt(n2 + 1)) != 'h' && c != 'H' || !Character.isDigit(string.charAt(n2 + 2))) continue;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(c2);
            stringBuilder.append(c);
            stringBuilder.append("\\d");
            stringBuilder.append('>');
            Pattern pattern = Pattern.compile(stringBuilder.toString());
            Matcher matcher = pattern.matcher(string);
            if (matcher.find(n2)) break;
        }
        if (n2 > 0) {
            String string2 = string.substring(n2, n);
            Matcher matcher = this.PROP_DEF_PATTERN.matcher(string2);
            int n3 = 0;
            while (matcher.find()) {
                n3 = matcher.start();
            }
            return n2 + n3;
        }
        return n;
    }

    private void parseSource(String string) {
        ResourceBundle resourceBundle = NbBundle.getBundle((String)string);
        this.properties = new HashMap<String, PropertyDescriptor>();
        Enumeration<String> enumeration = resourceBundle.getKeys();
        while (enumeration.hasMoreElements()) {
            Object object;
            String string2 = enumeration.nextElement();
            int n = string2.indexOf(45);
            String string3 = string2.substring(n + 1);
            String string4 = resourceBundle.getString(string2);
            StringTokenizer stringTokenizer = new StringTokenizer(string4, ";");
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            while (stringTokenizer.hasMoreTokens()) {
                object = stringTokenizer.nextToken();
                int n2 = string2.indexOf(45);
                String string5 = string2.substring(n2 + 1);
                hashMap.put(string5, object);
            }
            object = new PropertyDescriptor(string3, string2, hashMap);
            this.properties.put(string3, (PropertyDescriptor)object);
        }
    }

    public static synchronized String getHelpZIPURLasString() {
        return CssHelpResolver.getHelpZIPURL().toString();
    }

    public static synchronized URL getHelpZIPURL() {
        File file;
        if (HELP_ZIP_URL == null && (file = InstalledFileLocator.getDefault().locate(HELP_LOCATION, null, false)) != null) {
            try {
                URL uRL = file.toURL();
                HELP_ZIP_URL = FileUtil.getArchiveRoot((URL)uRL);
            }
            catch (MalformedURLException malformedURLException) {
                ErrorManager.getDefault().notify((Throwable)malformedURLException);
            }
        }
        return HELP_ZIP_URL;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PropertyDescriptor {
        String propertyName;
        String helpLink;
        Map<String, String> values;

        private PropertyDescriptor(String string, String string2, Map<String, String> map) {
            this.propertyName = string;
            this.helpLink = string2;
            this.values = map;
        }
    }
}

