/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelutil;

import java.awt.Container;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.BufferUnderflowException;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.lexer.InputAttributes;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.JumpList;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.cnd.api.model.CsmClassifier;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmFunctionDefinition;
import org.netbeans.modules.cnd.api.model.CsmMember;
import org.netbeans.modules.cnd.api.model.CsmMethod;
import org.netbeans.modules.cnd.api.model.CsmModelAccessor;
import org.netbeans.modules.cnd.api.model.CsmNamedElement;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmParameter;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmTemplate;
import org.netbeans.modules.cnd.api.model.CsmType;
import org.netbeans.modules.cnd.api.model.CsmVariable;
import org.netbeans.modules.cnd.api.model.CsmVisibility;
import org.netbeans.modules.cnd.api.model.deep.CsmStatement;
import org.netbeans.modules.cnd.api.model.services.CsmClassifierResolver;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.project.NativeFileItem;
import org.netbeans.modules.cnd.api.project.NativeFileItemSet;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.openide.awt.StatusDisplayer;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.NbDocument;
import org.openide.text.PositionBounds;
import org.openide.text.PositionRef;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CsmUtilities {
    public static final int PUBLIC = 1;
    public static final int PRIVATE = 2;
    public static final int PROTECTED = 4;
    public static final int STATIC = 8;
    public static final int LOCAL_MEMBER_BIT = 256;
    public static final int PUBLIC_LEVEL = 2;
    public static final int PROTECTED_LEVEL = 1;
    public static final int PRIVATE_LEVEL = 0;
    public static final int CONST_MEMBER_BIT = 512;
    public static final int ENUMERATOR = 1024;
    public static final int CONSTRUCTOR = 2048;
    public static final int GLOBAL = 4096;
    public static final int LOCAL = 8192;
    public static final int FILE_LOCAL = 16384;
    public static final int MEMBER = 32768;
    public static final int MACRO = 65536;
    public static final int DESTRUCTOR = 131072;
    public static final int OPERATOR = 262144;
    public static final int EXTERN = 524288;
    public static final int FORWARD = 0x100000;
    public static final boolean DEBUG = Boolean.getBoolean("csm.utilities.trace.summary") || Boolean.getBoolean("csm.utilities.trace");
    private static final CsmOffsetable.Position DUMMY_POSITION = new CsmOffsetable.Position(){

        public int getOffset() {
            return -1;
        }

        public int getLine() {
            return -1;
        }

        public int getColumn() {
            return -1;
        }
    };

    public static int getModifiers(CsmObject csmObject) {
        CsmFunctionDefinition csmFunctionDefinition;
        int n = 0;
        if (CsmKindUtilities.isClassMember((CsmObject)csmObject)) {
            n |= CsmUtilities.getMemberModifiers((CsmMember)csmObject);
        } else if (CsmKindUtilities.isFunctionDefinition((CsmObject)csmObject)) {
            csmFunctionDefinition = (CsmFunctionDefinition)csmObject;
            CsmFunction csmFunction = csmFunctionDefinition.getDeclaration();
            if (CsmKindUtilities.isClassMember((CsmObject)csmFunction)) {
                n |= CsmUtilities.getMemberModifiers((CsmMember)csmFunction);
            } else {
                if (csmFunction == null) {
                    csmFunction = csmFunctionDefinition;
                }
                if (CsmKindUtilities.isGlobalFunction((CsmObject)csmObject)) {
                    n |= 0x1000;
                }
                if (CsmKindUtilities.isFileLocalFunction((CsmObject)csmFunction)) {
                    n |= 0x4000;
                }
            }
        } else {
            if (CsmKindUtilities.isGlobalVariable((CsmObject)csmObject) || CsmKindUtilities.isGlobalFunction((CsmObject)csmObject)) {
                n |= 0x1000;
            }
            if (CsmKindUtilities.isFileLocalVariable((CsmObject)csmObject) || CsmKindUtilities.isFileLocalFunction((CsmObject)csmObject)) {
                n |= 0x4000;
            }
            if (CsmKindUtilities.isEnumerator((Object)csmObject)) {
                n |= 0x400;
            }
        }
        if (CsmClassifierResolver.getDefault().isForwardClass(csmObject)) {
            n |= 0x100000;
        }
        if (CsmKindUtilities.isOperator((CsmObject)csmObject)) {
            n |= 0x40000;
        }
        if (CsmKindUtilities.isVariable((CsmObject)csmObject)) {
            csmFunctionDefinition = (CsmVariable)csmObject;
            n |= csmFunctionDefinition.getType() != null && csmFunctionDefinition.getType().isConst() ? 512 : 0;
            if (csmFunctionDefinition.isExtern()) {
                n |= 0x80000;
            }
        }
        return n;
    }

    public static int getMemberModifiers(CsmMember csmMember) {
        int n = 0;
        CsmVisibility csmVisibility = csmMember.getVisibility();
        if (CsmVisibility.PRIVATE == csmVisibility) {
            n = 2;
        } else if (CsmVisibility.PROTECTED == csmVisibility) {
            n = 4;
        } else if (CsmVisibility.PUBLIC == csmVisibility) {
            n = 1;
        }
        if (csmMember.isStatic()) {
            n |= 8;
        }
        n |= 0x8000;
        if (CsmKindUtilities.isConstructor((CsmObject)csmMember)) {
            n |= 0x800;
        } else if (CsmKindUtilities.isDestructor((CsmObject)csmMember)) {
            n |= 0x20000;
        }
        return n;
    }

    public static int getLevel(int n) {
        if ((n & 1) != 0) {
            return 2;
        }
        if ((n & 4) != 0) {
            return 1;
        }
        return 0;
    }

    public static boolean isPrimitiveClass(CsmClassifier csmClassifier) {
        return csmClassifier.getKind() == CsmDeclaration.Kind.BUILT_IN;
    }

    public static CsmFile getCsmFile(Node node, boolean bl) {
        return CsmUtilities.getCsmFile((DataObject)node.getLookup().lookup(DataObject.class), bl);
    }

    public static JEditorPane findRecentEditorPaneInEQ(final EditorCookie editorCookie) {
        assert (editorCookie != null);
        final JEditorPane[] jEditorPaneArray = new JEditorPane[]{null};
        if (SwingUtilities.isEventDispatchThread()) {
            jEditorPaneArray[0] = NbDocument.findRecentEditorPane((EditorCookie)editorCookie);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        jEditorPaneArray[0] = NbDocument.findRecentEditorPane((EditorCookie)editorCookie);
                    }
                });
            }
            catch (InterruptedException interruptedException) {
                Exceptions.printStackTrace((Throwable)interruptedException);
            }
            catch (InvocationTargetException invocationTargetException) {
                Exceptions.printStackTrace((Throwable)invocationTargetException);
            }
        }
        return jEditorPaneArray[0];
    }

    public static TopComponent getTopComponentInEQ(final String string) {
        assert (string != null);
        final TopComponent[] topComponentArray = new TopComponent[]{null};
        if (SwingUtilities.isEventDispatchThread()) {
            topComponentArray[0] = WindowManager.getDefault().findTopComponent(string);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        topComponentArray[0] = WindowManager.getDefault().findTopComponent(string);
                    }
                });
            }
            catch (InterruptedException interruptedException) {
                Exceptions.printStackTrace((Throwable)interruptedException);
            }
            catch (InvocationTargetException invocationTargetException) {
                Exceptions.printStackTrace((Throwable)invocationTargetException);
            }
        }
        return topComponentArray[0];
    }

    public static File getFile(Document document) {
        FileObject fileObject;
        DataObject dataObject = NbEditorUtilities.getDataObject((Document)document);
        if (dataObject != null && dataObject.isValid() && (fileObject = dataObject.getPrimaryFile()) != null) {
            File file = FileUtil.toFile((FileObject)fileObject);
            return file;
        }
        return null;
    }

    public static CsmFile getCsmFile(JTextComponent jTextComponent, boolean bl) {
        return jTextComponent == null ? null : CsmUtilities.getCsmFile(jTextComponent.getDocument(), bl);
    }

    public static CsmFile getCsmFile(Document document, boolean bl) {
        CsmFile csmFile = null;
        if (document != null) {
            try {
                LanguagePath languagePath;
                FileObject fileObject;
                InputAttributes inputAttributes;
                String string;
                csmFile = (CsmFile)document.getProperty(CsmFile.class);
                if (csmFile == null) {
                    csmFile = CsmUtilities.getCsmFile(NbEditorUtilities.getDataObject((Document)document), bl);
                }
                if (csmFile == null && "text/x-dialog-binding".equals(string = (String)document.getProperty("mimeType")) && (inputAttributes = (InputAttributes)document.getProperty(InputAttributes.class)) != null && (csmFile = CsmUtilities.getCsmFile(fileObject = (FileObject)inputAttributes.getValue(languagePath = LanguagePath.get((Language)((Language)MimeLookup.getLookup((String)string).lookup(Language.class))), (Object)"dialogBinding.fileObject"), bl)) == null) {
                    Document document2 = (Document)inputAttributes.getValue(languagePath, (Object)"dialogBinding.document");
                    csmFile = document2 == null ? null : CsmUtilities.getCsmFile(document2, bl);
                }
            }
            catch (NullPointerException nullPointerException) {
                nullPointerException.printStackTrace();
            }
        }
        return csmFile;
    }

    public static CsmProject getCsmProject(Document document) {
        CsmProject csmProject = null;
        try {
            csmProject = CsmUtilities.getCsmFile(document, false).getProject();
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace();
        }
        return csmProject;
    }

    public static CsmProject getCsmProject(FileObject fileObject) {
        File file = FileUtil.toFile((FileObject)fileObject);
        if (file != null) {
            String string = file.getPath();
            for (CsmProject csmProject : CsmModelAccessor.getModel().projects()) {
                NativeProject nativeProject;
                Object object = csmProject.getPlatformProject();
                if (!(object instanceof NativeProject) || !string.startsWith((nativeProject = (NativeProject)object).getProjectRoot() + File.separator)) continue;
                return csmProject;
            }
        }
        return null;
    }

    public static boolean isAnyNativeProjectOpened() {
        Project[] projectArray = OpenProjects.getDefault().getOpenProjects();
        for (int i = 0; i < projectArray.length; ++i) {
            if (projectArray[i].getLookup().lookup(NativeProject.class) == null) continue;
            return true;
        }
        return false;
    }

    public static CsmFile[] getCsmFiles(DataObject dataObject) {
        if (dataObject != null && dataObject.isValid()) {
            try {
                CsmFile csmFile;
                String string;
                File file;
                Object object;
                ArrayList<CsmFile> arrayList = new ArrayList<CsmFile>();
                NativeFileItemSet nativeFileItemSet = (NativeFileItemSet)dataObject.getLookup().lookup(NativeFileItemSet.class);
                if (nativeFileItemSet != null && !nativeFileItemSet.isEmpty()) {
                    object = nativeFileItemSet.getItems().iterator();
                    while (object.hasNext()) {
                        file = (NativeFileItem)object.next();
                        string = CsmModelAccessor.getModel().getProject((Object)file.getNativeProject());
                        if (string == null || (csmFile = string.findFile((Object)file)) == null) continue;
                        arrayList.add(csmFile);
                    }
                }
                if (arrayList.isEmpty() && (object = dataObject.getPrimaryFile()) != null && (file = FileUtil.toFile((FileObject)object)) != null) {
                    string = CndFileUtils.normalizeAbsolutePath((String)file.getAbsolutePath());
                    csmFile = CsmModelAccessor.getModel().findFile((CharSequence)string);
                    if (csmFile != null) {
                        arrayList.add(csmFile);
                    }
                }
                return arrayList.toArray(new CsmFile[arrayList.size()]);
            }
            catch (BufferUnderflowException bufferUnderflowException) {
            }
            catch (AssertionError assertionError) {
                ((Throwable)((Object)assertionError)).printStackTrace();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        return new CsmFile[0];
    }

    public static CsmFile[] getCsmFiles(FileObject fileObject) {
        try {
            return CsmUtilities.getCsmFiles(DataObject.find((FileObject)fileObject));
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            return new CsmFile[0];
        }
    }

    public static CsmFile getCsmFile(DataObject dataObject, boolean bl) {
        CsmFile[] csmFileArray = CsmUtilities.getCsmFiles(dataObject);
        if (csmFileArray == null || csmFileArray.length == 0) {
            return null;
        }
        if (bl) {
            try {
                csmFileArray[0].scheduleParsing(true);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return csmFileArray[0];
    }

    public static CsmFile getCsmFile(FileObject fileObject, boolean bl) {
        if (fileObject == null) {
            return null;
        }
        try {
            return CsmUtilities.getCsmFile(DataObject.find((FileObject)fileObject), bl);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            return null;
        }
    }

    public static FileObject getFileObject(CsmFile csmFile) {
        FileObject fileObject = null;
        if (csmFile != null) {
            try {
                try {
                    File file = new File(((Object)csmFile.getAbsolutePath()).toString());
                    fileObject = FileUtil.toFileObject((File)file);
                    if (fileObject == null) {
                        fileObject = FileUtil.toFileObject((File)file.getCanonicalFile());
                    }
                }
                catch (IOException iOException) {
                    fileObject = FileUtil.toFileObject((File)CndFileUtils.normalizeFile((File)new File(((Object)csmFile.getAbsolutePath()).toString())));
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                illegalArgumentException.printStackTrace();
            }
        }
        return fileObject;
    }

    public static FileObject getFileObject(Document document) {
        CsmFile csmFile;
        FileObject fileObject = (FileObject)document.getProperty(FileObject.class);
        if (fileObject == null && (csmFile = CsmUtilities.getCsmFile(document, false)) != null) {
            fileObject = CsmUtilities.getFileObject(csmFile);
        }
        return fileObject;
    }

    public static DataObject getDataObject(CsmFile csmFile) {
        return CsmUtilities.getDataObject(CsmUtilities.getFileObject(csmFile));
    }

    public static DataObject getDataObject(FileObject fileObject) {
        DataObject dataObject = null;
        if (fileObject != null) {
            try {
                dataObject = DataObject.find((FileObject)fileObject);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                // empty catch block
            }
        }
        return dataObject;
    }

    public static Document getDocument(FileObject fileObject) {
        if (fileObject != null && fileObject.isValid()) {
            try {
                EditorCookie editorCookie;
                DataObject dataObject = DataObject.find((FileObject)fileObject);
                if (dataObject != null && dataObject.isValid() && (editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class)) != null) {
                    return editorCookie.getDocument();
                }
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                Exceptions.printStackTrace((Throwable)dataObjectNotFoundException);
            }
        }
        return null;
    }

    public static Document getDocument(CsmFile csmFile) {
        FileObject fileObject = CsmUtilities.getFileObject(csmFile);
        if (fileObject != null) {
            return CsmUtilities.getDocument(fileObject);
        }
        return null;
    }

    public static PositionBounds createPositionBounds(CsmOffsetable csmOffsetable) {
        if (csmOffsetable == null) {
            return null;
        }
        CloneableEditorSupport cloneableEditorSupport = CsmUtilities.findCloneableEditorSupport(csmOffsetable.getContainingFile());
        if (cloneableEditorSupport != null) {
            PositionRef positionRef = cloneableEditorSupport.createPositionRef(csmOffsetable.getStartOffset(), Position.Bias.Forward);
            PositionRef positionRef2 = cloneableEditorSupport.createPositionRef(csmOffsetable.getEndOffset(), Position.Bias.Backward);
            return new PositionBounds(positionRef, positionRef2);
        }
        return null;
    }

    public static CloneableEditorSupport findCloneableEditorSupport(CsmFile csmFile) {
        DataObject dataObject = CsmUtilities.getDataObject(csmFile);
        return CsmUtilities.findCloneableEditorSupport(dataObject);
    }

    public static CloneableEditorSupport findCloneableEditorSupport(DataObject dataObject) {
        if (dataObject == null) {
            return null;
        }
        Node.Cookie cookie = dataObject.getCookie(OpenCookie.class);
        if (cookie instanceof CloneableEditorSupport) {
            return (CloneableEditorSupport)cookie;
        }
        cookie = dataObject.getCookie(EditorCookie.class);
        if (cookie instanceof CloneableEditorSupport) {
            return (CloneableEditorSupport)cookie;
        }
        return null;
    }

    public static boolean openSource(CsmObject csmObject) {
        if (CsmKindUtilities.isOffsetable((Object)csmObject)) {
            return CsmUtilities.openAtElement((CsmOffsetable)csmObject);
        }
        if (CsmKindUtilities.isFile((CsmObject)csmObject)) {
            CsmFile csmFile = (CsmFile)csmObject;
            FileTarget fileTarget = new FileTarget(csmFile);
            return CsmUtilities.openAtElement(fileTarget);
        }
        return false;
    }

    public static boolean openSource(CsmFile csmFile, int n, int n2) {
        return CsmUtilities.openAtElement(CsmUtilities.getDataObject(csmFile), new PointOrOffsetable(new Point(n, n2)));
    }

    public static boolean openSource(FileObject fileObject, int n) {
        try {
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            return CsmUtilities.openAtElement(dataObject, new PointOrOffsetable(n));
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            return false;
        }
    }

    public static boolean openSource(PositionBounds positionBounds) {
        CloneableEditorSupport cloneableEditorSupport = positionBounds.getBegin().getCloneableEditorSupport();
        cloneableEditorSupport.edit();
        JEditorPane[] jEditorPaneArray = cloneableEditorSupport.getOpenedPanes();
        if (jEditorPaneArray != null) {
            Container container;
            JumpList.checkAddEntry();
            JEditorPane jEditorPane = jEditorPaneArray[0];
            jEditorPane.setCaretPosition(positionBounds.getBegin().getOffset());
            for (container = jEditorPane; container != null && !(container instanceof TopComponent); container = container.getParent()) {
            }
            if (container != null) {
                ((TopComponent)container).requestActive();
            }
        }
        return false;
    }

    private static boolean openAtElement(CsmOffsetable csmOffsetable) {
        return CsmUtilities.openAtElement(CsmUtilities.getDataObject(csmOffsetable.getContainingFile()), new PointOrOffsetable(csmOffsetable));
    }

    private static boolean openAtElement(DataObject dataObject, final PointOrOffsetable pointOrOffsetable) {
        if (dataObject != null) {
            final EditorCookie.Observable observable = (EditorCookie.Observable)dataObject.getCookie(EditorCookie.Observable.class);
            if (observable != null) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        boolean bl;
                        JumpList.checkAddEntry();
                        JEditorPane jEditorPane = CsmUtilities.findRecentEditorPaneInEQ((EditorCookie)observable);
                        if (jEditorPane != null) {
                            bl = true;
                        } else {
                            bl = false;
                            observable.open();
                            JEditorPane[] jEditorPaneArray = observable.getOpenedPanes();
                            if (jEditorPaneArray != null && jEditorPaneArray.length > 0) {
                                jEditorPane = jEditorPaneArray[0];
                            }
                        }
                        if (jEditorPane != null) {
                            CsmUtilities.selectElementInPane(jEditorPane, pointOrOffsetable, !bl);
                        }
                    }
                });
            }
            return true;
        }
        return false;
    }

    private static void selectElementInPane(final JEditorPane jEditorPane, final PointOrOffsetable pointOrOffsetable, boolean bl) {
        Container container;
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                CsmUtilities.jumpToElement(jEditorPane, pointOrOffsetable);
            }
        });
        for (container = jEditorPane; container != null && !(container instanceof TopComponent); container = container.getParent()) {
        }
        if (container instanceof TopComponent) {
            ((TopComponent)container).open();
            ((TopComponent)container).requestActive();
            ((TopComponent)container).requestVisible();
        }
    }

    private static void jumpToElement(JEditorPane jEditorPane, PointOrOffsetable pointOrOffsetable) {
        int n;
        Offsetable offsetable = pointOrOffsetable.getOffsetable();
        Point point = pointOrOffsetable.getPoint();
        if (offsetable == null) {
            n = Utilities.getRowStartFromLineOffset((BaseDocument)((BaseDocument)jEditorPane.getDocument()), (int)(point.line - 1));
            n += point.column;
        } else {
            n = offsetable.getOffset();
        }
        if (jEditorPane.getDocument() != null && n >= 0 && n < jEditorPane.getDocument().getLength()) {
            jEditorPane.setCaretPosition(n);
            if (DEBUG) {
                System.err.println("I'm going to " + n + " for element " + pointOrOffsetable);
            }
        }
        StatusDisplayer.getDefault().setStatusText("");
    }

    private static int lineToPosition(JEditorPane jEditorPane, int n) {
        Document document = jEditorPane.getDocument();
        int n2 = 0;
        if (document instanceof BaseDocument) {
            n2 = Utilities.getRowStartFromLineOffset((BaseDocument)((BaseDocument)document), (int)n);
        } else {
            int n3 = document.getLength();
            try {
                String string = document.getText(0, n3);
                boolean bl = false;
                for (int i = 0; i < n3; ++i) {
                    char c = string.charAt(i);
                    if (c == '\n') {
                        if (--n == 0) {
                            return n2;
                        }
                        bl = true;
                        continue;
                    }
                    if (!bl) continue;
                    n2 = i;
                    bl = false;
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return n2;
    }

    public static String getElementJumpName(CsmObject csmObject) {
        String string = "";
        if (csmObject != null) {
            if (CsmKindUtilities.isNamedElement((CsmObject)csmObject)) {
                string = ((Object)((CsmNamedElement)csmObject).getName()).toString();
            } else if (CsmKindUtilities.isStatement((CsmObject)csmObject)) {
                string = ((Object)((CsmStatement)csmObject).getText()).toString();
            } else if (CsmKindUtilities.isOffsetable((Object)csmObject)) {
                string = ((Object)((CsmOffsetable)csmObject).getText()).toString();
            }
            if (string.length() > 0) {
                string = "\"" + string + "\"";
            }
        }
        return string;
    }

    public static <T> Collection<T> merge(Collection<T> arrayList, Collection<T> collection) {
        ArrayList<T> arrayList2 = arrayList = arrayList != null ? arrayList : new ArrayList<T>();
        if (collection != null && collection.size() > 0) {
            arrayList.addAll(collection);
        }
        return arrayList;
    }

    public static <T> boolean removeAll(Collection<T> collection, Collection<T> collection2) {
        if (collection != null && collection2 != null) {
            return collection.removeAll(collection2);
        }
        return false;
    }

    public static String getCsmName(CsmObject csmObject) {
        Object object;
        StringBuilder stringBuilder = new StringBuilder();
        if (CsmKindUtilities.isNamedElement((CsmObject)csmObject)) {
            object = (CsmNamedElement)csmObject;
            stringBuilder.append(" [name] ").append(object.getName());
        } else {
            object = csmObject.getClass().getName();
            object = ((String)object).substring(((String)object).lastIndexOf(".") + 1);
            stringBuilder.append(" [class] ").append((String)object);
        }
        if (CsmKindUtilities.isDeclaration((CsmObject)csmObject)) {
            object = (CsmDeclaration)csmObject;
            stringBuilder.append(" [kind] ").append(object.getKind());
        }
        return stringBuilder.toString();
    }

    public static String getSignature(CsmFunction csmFunction) {
        return CsmUtilities.getSignature(csmFunction, true);
    }

    public static String getSignature(CsmFunction csmFunction, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder(CsmKindUtilities.isTemplate((CsmObject)csmFunction) ? ((CsmTemplate)csmFunction).getDisplayName() : csmFunction.getName());
        stringBuilder.append('(');
        boolean bl2 = false;
        for (CsmParameter csmParameter : csmFunction.getParameters()) {
            if (bl2) {
                stringBuilder.append(", ");
            } else {
                bl2 = true;
            }
            if (bl) {
                stringBuilder.append(csmParameter.getDisplayText());
                continue;
            }
            CsmType csmType = csmParameter.getType();
            if (csmType != null) {
                stringBuilder.append(csmType.getText());
                continue;
            }
            if (!csmParameter.isVarArgs()) continue;
            stringBuilder.append("...");
        }
        stringBuilder.append(')');
        if (CsmKindUtilities.isMethodDeclaration((CsmObject)csmFunction) && ((CsmMethod)csmFunction).isConst()) {
            stringBuilder.append(" const");
        }
        return stringBuilder.toString();
    }

    private CsmUtilities() {
    }

    private static final class FileTarget
    implements CsmOffsetable {
        private CsmFile file;

        public FileTarget(CsmFile csmFile) {
            this.file = csmFile;
        }

        public CsmFile getContainingFile() {
            return this.file;
        }

        public int getStartOffset() {
            return DUMMY_POSITION.getOffset();
        }

        public int getEndOffset() {
            return DUMMY_POSITION.getOffset();
        }

        public CsmOffsetable.Position getStartPosition() {
            return DUMMY_POSITION;
        }

        public CsmOffsetable.Position getEndPosition() {
            return DUMMY_POSITION;
        }

        public String getText() {
            return "";
        }
    }

    private static class PointOrOffsetable {
        private final Object content;

        public PointOrOffsetable(Point point) {
            this.content = point;
        }

        public PointOrOffsetable(final CsmOffsetable csmOffsetable) {
            this.content = new Offsetable(){

                public int getOffset() {
                    return csmOffsetable.getStartOffset();
                }
            };
        }

        public PointOrOffsetable(final int n) {
            this.content = new Offsetable(){

                public int getOffset() {
                    return n;
                }
            };
        }

        public Point getPoint() {
            return this.content instanceof Point ? (Point)this.content : null;
        }

        public Offsetable getOffsetable() {
            return this.content instanceof Offsetable ? (Offsetable)this.content : null;
        }

        public String toString() {
            if (this.content instanceof Point) {
                Point point = (Point)this.content;
                return String.format("[%d:%d]", point.line, point.column);
            }
            return String.format("[%d]", ((Offsetable)this.content).getOffset());
        }
    }

    private static interface Offsetable {
        public int getOffset();
    }

    private static class Point {
        public final int line;
        public final int column;

        public Point(int n, int n2) {
            this.line = n;
            this.column = n2;
        }
    }
}

