/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.wizards;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.util.Collections;
import java.util.Set;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.php.project.connections.TransferFile;
import org.netbeans.modules.php.project.connections.ui.TransferFileTableChangeListener;
import org.netbeans.modules.php.project.connections.ui.TransferFilter;
import org.netbeans.modules.php.project.ui.wizards.RemoteConfirmationPanel;
import org.openide.WizardDescriptor;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteConfirmationPanelVisual
extends JPanel {
    private static final long serialVersionUID = 3753241413078222434L;
    private static final int STEP_INDEX = 2;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private final TransferFileTableChangeListener transferFilterListener;
    private TransferFilter transferFilter;
    private State state = null;
    private JLabel downloadInfoLabel;
    private JPanel filesPanel;
    private JLabel statusLabel;
    private JLabel uploadInfoLabel;

    public RemoteConfirmationPanelVisual(RemoteConfirmationPanel remoteConfirmationPanel, WizardDescriptor wizardDescriptor) {
        assert (remoteConfirmationPanel != null);
        assert (wizardDescriptor != null);
        this.setName(remoteConfirmationPanel.getSteps()[2]);
        this.putClientProperty("WizardPanel_contentSelectedIndex", 2);
        this.putClientProperty("WizardPanel_contentData", remoteConfirmationPanel.getSteps());
        this.initComponents();
        this.setFetchingFiles();
        this.uploadInfoLabel.setText(NbBundle.getMessage(RemoteConfirmationPanelVisual.class, (String)"TXT_UploadInfo"));
        this.transferFilterListener = new TransferFileTableChangeListener(){

            public void updateUnitsChanged() {
                RemoteConfirmationPanelVisual.this.changeSupport.fireChange();
            }

            public void filterChanged() {
            }
        };
    }

    public void addRemoteConfirmationListener(ChangeListener changeListener) {
        this.changeSupport.addChangeListener(changeListener);
    }

    public void removeRemoteConfirmationListener(ChangeListener changeListener) {
        this.changeSupport.removeChangeListener(changeListener);
    }

    public void setRemoteFiles(Set<TransferFile> set) {
        assert (SwingUtilities.isEventDispatchThread()) : "Must be run in EDT";
        assert (set != null);
        this.state = State.FILES;
        this.transferFilter = TransferFilter.getEmbeddableDownloadDialog(set);
        this.transferFilter.addUpdateUnitListener(this.transferFilterListener);
        this.filesPanel.removeAll();
        this.filesPanel.add(this.transferFilter);
        this.statusLabel.setText(NbBundle.getMessage(RemoteConfirmationPanelVisual.class, (String)"LBL_Confirmation"));
        this.setState(true);
    }

    public void setNoFiles(String string) {
        assert (SwingUtilities.isEventDispatchThread()) : "Must be run in EDT";
        this.state = State.NO_FILES;
        this.resetTransferFilter();
        this.statusLabel.setText(NbBundle.getMessage(RemoteConfirmationPanelVisual.class, (String)"LBL_NoFiles", (Object)string));
        this.setState(false);
    }

    public void setFetchingFiles() {
        assert (SwingUtilities.isEventDispatchThread()) : "Must be run in EDT";
        this.state = State.FETCHING;
        this.resetTransferFilter();
        this.statusLabel.setText(NbBundle.getMessage(RemoteConfirmationPanelVisual.class, (String)"LBL_FetchingRemoteFiles"));
        this.setState(false);
    }

    public Set<TransferFile> getRemoteFiles() {
        if (this.transferFilter == null) {
            return Collections.emptySet();
        }
        return TransferFilter.getSelectedFiles(this.transferFilter);
    }

    State getState() {
        return this.state;
    }

    private void setState(boolean bl) {
        this.downloadInfoLabel.setVisible(bl);
        this.uploadInfoLabel.setVisible(bl);
        this.filesPanel.setVisible(bl);
    }

    private void resetTransferFilter() {
        if (this.transferFilter != null) {
            this.transferFilter.removeUpdateUnitListener(this.transferFilterListener);
        }
        this.transferFilter = null;
    }

    private void initComponents() {
        this.statusLabel = new JLabel();
        this.downloadInfoLabel = new JLabel();
        this.uploadInfoLabel = new JLabel();
        this.filesPanel = new JPanel();
        this.statusLabel.setFont(this.statusLabel.getFont().deriveFont(this.statusLabel.getFont().getStyle() | 1));
        this.statusLabel.setText("DUMMY");
        this.downloadInfoLabel.setText(NbBundle.getMessage(RemoteConfirmationPanelVisual.class, (String)"RemoteConfirmationPanelVisual.downloadInfoLabel.text"));
        this.uploadInfoLabel.setText("DUMMY");
        this.filesPanel.setLayout(new BoxLayout(this.filesPanel, 2));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.statusLabel).add((Component)this.downloadInfoLabel).add((Component)this.uploadInfoLabel)).addContainerGap(27, Short.MAX_VALUE)).add((Component)this.filesPanel, -1, 409, Short.MAX_VALUE));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.statusLabel).addPreferredGap(1).add((Component)this.downloadInfoLabel).addPreferredGap(0).add((Component)this.filesPanel, -1, 201, Short.MAX_VALUE).add(18, 18, 18).add((Component)this.uploadInfoLabel)));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum State {
        FETCHING,
        NO_FILES,
        FILES;

    }
}

