/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.wizards;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.MutableComboBoxModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.php.project.ProjectPropertiesSupport;
import org.netbeans.modules.php.project.api.PhpLanguageOptions;
import org.netbeans.modules.php.project.environment.PhpEnvironment;
import org.netbeans.modules.php.project.ui.LocalServer;
import org.netbeans.modules.php.project.ui.SourcesFolderProvider;
import org.netbeans.modules.php.project.ui.Utils;
import org.netbeans.modules.php.project.ui.wizards.CancelablePanel;
import org.netbeans.modules.php.project.ui.wizards.ConfigurableProjectPanel;
import org.netbeans.modules.php.project.ui.wizards.ConfigureExistingProjectPanelVisual;
import org.netbeans.modules.php.project.ui.wizards.ConfigureNewProjectPanelVisual;
import org.netbeans.modules.php.project.ui.wizards.NewPhpProjectWizardIterator;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigureProjectPanel
implements WizardDescriptor.Panel<WizardDescriptor>,
WizardDescriptor.FinishablePanel<WizardDescriptor>,
SourcesFolderProvider,
ChangeListener,
CancelablePanel {
    static final String PROJECT_NAME = "projectName";
    static final String PROJECT_DIR = "projectDir";
    static final String IS_PROJECT_DIR_USED = "isProjectDirUsed";
    static final String SET_AS_MAIN = "setAsMain";
    static final String SOURCES_FOLDER = "sourcesFolder";
    static final String LOCAL_SERVERS = "localServers";
    static final String PHP_VERSION = "phpVersion";
    static final String ENCODING = "encoding";
    static final String ROOTS = "roots";
    private final String[] steps;
    private final NewPhpProjectWizardIterator.WizardType wizardType;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private ConfigurableProjectPanel configureProjectPanelVisual = null;
    private WizardDescriptor descriptor = null;
    private String originalProjectName = null;
    private String originalSources = null;
    private volatile boolean canceled;

    public ConfigureProjectPanel(String[] stringArray, NewPhpProjectWizardIterator.WizardType wizardType) {
        this.steps = stringArray;
        this.wizardType = wizardType;
    }

    public Component getComponent() {
        if (this.configureProjectPanelVisual == null) {
            switch (this.wizardType) {
                case NEW: 
                case REMOTE: {
                    this.configureProjectPanelVisual = new ConfigureNewProjectPanelVisual(this);
                    break;
                }
                case EXISTING: {
                    this.configureProjectPanelVisual = new ConfigureExistingProjectPanelVisual(this);
                    break;
                }
                default: {
                    assert (false) : "Unknown wizard type: " + (Object)((Object)this.wizardType);
                    break;
                }
            }
            this.addListeners();
        }
        return this.configureProjectPanelVisual;
    }

    public HelpCtx getHelp() {
        return new HelpCtx(ConfigureProjectPanel.class.getName() + "." + (Object)((Object)this.wizardType));
    }

    public void readSettings(WizardDescriptor wizardDescriptor) {
        this.getComponent();
        this.descriptor = wizardDescriptor;
        switch (this.wizardType) {
            case NEW: 
            case REMOTE: {
                MutableComboBoxModel mutableComboBoxModel = this.getLocalServers();
                if (mutableComboBoxModel != null) {
                    this.configureProjectPanelVisual.setLocalServerModel(mutableComboBoxModel);
                } else {
                    this.configureProjectPanelVisual.setLocalServerModel(new LocalServer.ComboBoxModel(LocalServer.PENDING_LOCAL_SERVER));
                    this.configureProjectPanelVisual.setState(false);
                    this.canceled = false;
                    PhpEnvironment.get().readDocumentRoots(new PhpEnvironment.ReadDocumentRootsNotifier(){

                        @Override
                        public void finished(final List<PhpEnvironment.DocumentRoot> list) {
                            SwingUtilities.invokeLater(new Runnable(){

                                public void run() {
                                    ConfigureProjectPanel.this.initLocalServers(list);
                                }
                            });
                        }
                    });
                }
                LocalServer localServer = this.getLocalServer();
                if (localServer == null) break;
                this.configureProjectPanelVisual.selectSourcesLocation(localServer);
                break;
            }
            case EXISTING: {
                break;
            }
            default: {
                assert (false) : "Unknown wizard type: " + (Object)((Object)this.wizardType);
                break;
            }
        }
        this.configureProjectPanelVisual.setProjectFolder(this.getProjectFolder().getAbsolutePath());
        this.configureProjectPanelVisual.setPhpVersion(this.getPhpVersion());
        this.configureProjectPanelVisual.setEncoding(this.getEncoding());
    }

    private void addListeners() {
        this.configureProjectPanelVisual.addConfigureProjectListener(this);
    }

    private void removeListeners() {
        this.configureProjectPanelVisual.removeConfigureProjectListener(this);
    }

    public void storeSettings(WizardDescriptor wizardDescriptor) {
        File file = this.getProjectFolderFile();
        if (file != null) {
            file = FileUtil.normalizeFile((File)file);
        }
        wizardDescriptor.putProperty(IS_PROJECT_DIR_USED, (Object)this.configureProjectPanelVisual.isProjectFolderUsed());
        wizardDescriptor.putProperty(PROJECT_DIR, (Object)file);
        wizardDescriptor.putProperty(PROJECT_NAME, (Object)this.configureProjectPanelVisual.getProjectName());
        wizardDescriptor.putProperty(SOURCES_FOLDER, (Object)this.configureProjectPanelVisual.getSourcesLocation());
        wizardDescriptor.putProperty(LOCAL_SERVERS, (Object)this.configureProjectPanelVisual.getLocalServerModel());
        wizardDescriptor.putProperty(PHP_VERSION, (Object)this.configureProjectPanelVisual.getPhpVersion());
        wizardDescriptor.putProperty(ENCODING, (Object)this.configureProjectPanelVisual.getEncoding());
        wizardDescriptor.putProperty(SET_AS_MAIN, (Object)false);
    }

    public File getProjectFolderFile() {
        String string = this.configureProjectPanelVisual.getProjectFolder();
        if (string.length() == 0) {
            return null;
        }
        return new File(string);
    }

    public boolean isFinishPanel() {
        if (this.wizardType == NewPhpProjectWizardIterator.WizardType.REMOTE) {
            return false;
        }
        return this.areOtherStepsValid();
    }

    public boolean isValid() {
        this.getComponent();
        if (!this.configureProjectPanelVisual.getState()) {
            return false;
        }
        this.descriptor.putProperty("WizardPanel_errorMessage", (Object)" ");
        String string = null;
        switch (this.wizardType) {
            case NEW: 
            case REMOTE: {
                if (this.descriptor.getProperty(ROOTS) == null) {
                    return false;
                }
                string = this.validateProject();
                if (string != null) {
                    this.descriptor.putProperty("WizardPanel_errorMessage", (Object)string);
                    return false;
                }
                string = this.validateSources(false);
                if (string != null) {
                    this.descriptor.putProperty("WizardPanel_errorMessage", (Object)string);
                    return false;
                }
                string = this.validateProjectDirectory();
                if (string == null) break;
                this.descriptor.putProperty("WizardPanel_errorMessage", (Object)string);
                return false;
            }
            case EXISTING: {
                String string2 = this.configureProjectPanelVisual.getSourcesFolder();
                if (string2 == null || string2.trim().length() == 0) {
                    this.descriptor.putProperty("WizardPanel_infoMessage", (Object)NbBundle.getMessage(ConfigureProjectPanel.class, (String)"MSG_EmptySources"));
                    return false;
                }
                string = this.validateSources(true);
                if (string != null) {
                    this.descriptor.putProperty("WizardPanel_errorMessage", (Object)string);
                    return false;
                }
                string = this.validateProject();
                if (string != null) {
                    this.descriptor.putProperty("WizardPanel_errorMessage", (Object)string);
                    return false;
                }
                string = this.validateProjectDirectory();
                if (string == null) break;
                this.descriptor.putProperty("WizardPanel_errorMessage", (Object)string);
                return false;
            }
            default: {
                assert (false) : "Unknown wizard type: " + (Object)((Object)this.wizardType);
                break;
            }
        }
        return true;
    }

    @Override
    public void addChangeListener(ChangeListener changeListener) {
        this.changeSupport.addChangeListener(changeListener);
    }

    @Override
    public void removeChangeListener(ChangeListener changeListener) {
        this.changeSupport.removeChangeListener(changeListener);
    }

    @Override
    public File getSourcesFolder() {
        this.getComponent();
        return FileUtil.normalizeFile((File)new File(this.configureProjectPanelVisual.getSourcesLocation().getSrcRoot()));
    }

    @Override
    public String getSourcesFolderName() {
        this.getComponent();
        return this.configureProjectPanelVisual.getProjectName();
    }

    final void fireChangeEvent() {
        this.changeSupport.fireChange();
    }

    String[] getSteps() {
        return this.steps;
    }

    String getProjectName() {
        String string = (String)this.descriptor.getProperty(PROJECT_NAME);
        if (string == null) {
            string = this.getDefaultFreeName(ProjectChooser.getProjectsFolder());
            this.descriptor.putProperty(PROJECT_NAME, (Object)string);
        }
        return string;
    }

    private File getProjectFolder(String string) {
        return new File(this.getProjectFolder().getParentFile(), string);
    }

    private File getProjectFolder() {
        File file = (File)this.descriptor.getProperty(PROJECT_DIR);
        if (file == null) {
            file = new File(ProjectChooser.getProjectsFolder(), this.getProjectName());
            this.descriptor.putProperty(PROJECT_DIR, (Object)file);
        }
        return file;
    }

    private String getDefaultFreeName(File file) {
        String string;
        int n = 1;
        while ((string = this.validFreeProjectName(file, n++)) == null) {
        }
        return string;
    }

    private PhpLanguageOptions.PhpVersion getPhpVersion() {
        PhpLanguageOptions.PhpVersion phpVersion = (PhpLanguageOptions.PhpVersion)((Object)this.descriptor.getProperty(PHP_VERSION));
        if (phpVersion == null) {
            phpVersion = ProjectPropertiesSupport.getDefaultPhpVersion();
        }
        return phpVersion;
    }

    private Charset getEncoding() {
        Charset charset = (Charset)this.descriptor.getProperty(ENCODING);
        if (charset == null) {
            charset = FileEncodingQuery.getDefaultEncoding();
        }
        return charset;
    }

    private LocalServer getLocalServer() {
        return (LocalServer)this.descriptor.getProperty(SOURCES_FOLDER);
    }

    private MutableComboBoxModel getLocalServers() {
        return (MutableComboBoxModel)this.descriptor.getProperty(LOCAL_SERVERS);
    }

    /*
     * WARNING - void declaration
     */
    private void initLocalServers(List<PhpEnvironment.DocumentRoot> list) {
        void var7_10;
        Object object;
        if (this.canceled) {
            return;
        }
        File file = ProjectChooser.getProjectsFolder();
        for (PhpEnvironment.DocumentRoot documentRoot : list) {
            if (!documentRoot.isPreferred()) continue;
            file = new File(documentRoot.getDocumentRoot());
            break;
        }
        this.descriptor.putProperty(ROOTS, list);
        String string = this.getDefaultFreeName(file);
        this.descriptor.putProperty(PROJECT_NAME, (Object)string);
        int n = list.size();
        ArrayList<LocalServer> arrayList = new ArrayList<LocalServer>(n);
        for (PhpEnvironment.DocumentRoot object22 : list) {
            object = new File(object22.getDocumentRoot(), string).getAbsolutePath();
            LocalServer localServer = new LocalServer(null, object22.getUrl(), object22.getDocumentRoot(), (String)object, true);
            arrayList.add(localServer);
        }
        this.descriptor.putProperty("copySrcTargets", (Object)new LocalServer.ComboBoxModel(arrayList.toArray(new LocalServer[n])));
        File file2 = FileUtil.normalizeFile((File)this.getProjectFolder(string));
        LocalServer localServer = new LocalServer(file2.getAbsolutePath());
        object = new LocalServer.ComboBoxModel(localServer);
        for (PhpEnvironment.DocumentRoot documentRoot : list) {
            LocalServer localServer2 = new LocalServer(documentRoot.getDocumentRoot() + File.separator + (String)string);
            localServer2.setHint(documentRoot.getHint());
            object.addElement(localServer2);
            if (!documentRoot.isPreferred()) continue;
            LocalServer localServer3 = localServer2;
        }
        object.setSelectedItem(var7_10);
        this.descriptor.putProperty(SOURCES_FOLDER, (Object)var7_10);
        this.descriptor.putProperty(LOCAL_SERVERS, object);
        this.descriptor.putProperty(PROJECT_DIR, (Object)file2);
        this.configureProjectPanelVisual.setLocalServerModel((MutableComboBoxModel)object);
        this.configureProjectPanelVisual.setProjectName(string);
        this.configureProjectPanelVisual.setProjectFolder(file2.getAbsolutePath());
        this.configureProjectPanelVisual.setState(true);
        this.fireChangeEvent();
    }

    private String validFreeProjectName(File file, int n) {
        String string = MessageFormat.format(NbBundle.getMessage(ConfigureProjectPanel.class, (String)"TXT_DefaultProjectName"), n);
        File file2 = new File(file, string);
        if (file2.exists()) {
            return null;
        }
        return string;
    }

    private String validateProject() {
        String string = this.configureProjectPanelVisual.getProjectName();
        if (string.trim().length() == 0) {
            return NbBundle.getMessage(ConfigureProjectPanel.class, (String)"MSG_IllegalProjectName");
        }
        if (!this.configureProjectPanelVisual.isProjectFolderUsed()) {
            return null;
        }
        File file = this.getProjectFolderFile();
        if (file == null || !Utils.isValidFileName(file)) {
            return NbBundle.getMessage(ConfigureProjectPanel.class, (String)"MSG_IllegalProjectFolder");
        }
        String string2 = Utils.validateProjectDirectory(file, "Project", true, false);
        if (string2 != null) {
            return string2;
        }
        if (this.isProjectAlready(file)) {
            return NbBundle.getMessage(ConfigureProjectPanel.class, (String)"MSG_ProjectAlreadyProject");
        }
        this.warnIfNotEmpty(file.getAbsolutePath(), "Project");
        return null;
    }

    private boolean isProjectAlready(File file) {
        boolean bl;
        Project project;
        block4: {
            if (!file.exists()) {
                return false;
            }
            project = null;
            bl = false;
            try {
                project = ProjectManager.getDefault().findProject(FileUtil.toFileObject((File)file));
            }
            catch (IOException iOException) {
                bl = true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if ($assertionsDisabled) break block4;
                throw new AssertionError((Object)"Should not get here");
            }
        }
        return project != null || bl;
    }

    private String validateSources(boolean bl) {
        String string = null;
        LocalServer localServer = this.configureProjectPanelVisual.getSourcesLocation();
        String string2 = localServer.getSrcRoot();
        File file = FileUtil.normalizeFile((File)new File(string2));
        if (string2.trim().length() == 0 || !Utils.isValidFileName(file)) {
            return NbBundle.getMessage(ConfigureProjectPanel.class, (String)"MSG_IllegalSourcesName");
        }
        string = Utils.validateProjectDirectory(string2, "Sources", true, true);
        if (string != null) {
            return string;
        }
        if (bl && !file.isDirectory()) {
            return NbBundle.getMessage(ConfigureProjectPanel.class, (String)"MSG_IllegalSourcesName");
        }
        if (!this.configureProjectPanelVisual.isProjectFolderUsed() && this.isProjectAlready(file)) {
            return NbBundle.getMessage(ConfigureProjectPanel.class, (String)"MSG_SourcesAlreadyProject");
        }
        string = this.validateSourcesAndCopyTarget();
        if (string != null) {
            return string;
        }
        switch (this.wizardType) {
            case NEW: 
            case REMOTE: {
                this.warnIfNotEmpty(string2, "Sources");
                break;
            }
            case EXISTING: {
                this.warnIfEmptySources(string2);
            }
        }
        return null;
    }

    private String validateSourcesAndCopyTarget() {
        if (!this.areOtherStepsValid()) {
            return null;
        }
        Boolean bl = (Boolean)this.descriptor.getProperty("copySrcFiles");
        if (bl == null || !bl.booleanValue()) {
            return null;
        }
        LocalServer localServer = this.configureProjectPanelVisual.getSourcesLocation();
        String string = localServer.getSrcRoot();
        LocalServer localServer2 = (LocalServer)this.descriptor.getProperty("copySrcTarget");
        File file = FileUtil.normalizeFile((File)new File(localServer2.getSrcRoot()));
        String string2 = file.getAbsolutePath();
        return Utils.validateSourcesAndCopyTarget(string, string2);
    }

    private String validateProjectDirectory() {
        File file;
        File[] fileArray = File.listRoots();
        if (fileArray == null || fileArray.length == 0) {
            return null;
        }
        File file2 = file = this.configureProjectPanelVisual.isProjectFolderUsed() ? this.getProjectFolderFile() : this.getSourcesFolder();
        assert (file != null);
        if (Arrays.asList(fileArray).contains(file)) {
            return NbBundle.getMessage(ConfigureProjectPanel.class, (String)"MSG_ProjectFolderIsRoot");
        }
        return null;
    }

    private boolean areOtherStepsValid() {
        Boolean bl = (Boolean)this.descriptor.getProperty("RunConfigurationPanel.valid");
        if (bl != null && !bl.booleanValue()) {
            return false;
        }
        bl = (Boolean)this.descriptor.getProperty("PhpFrameworksPanel.valid");
        return bl == null || bl != false;
    }

    private void warnIfNotEmpty(String string, String string2) {
        File file = new File(string);
        File[] fileArray = file.listFiles();
        if (file.exists() && fileArray != null && fileArray.length > 0) {
            String string3 = NbBundle.getMessage(ConfigureProjectPanel.class, (String)("MSG_" + string2 + "NotEmpty"));
            this.descriptor.putProperty("WizardPanel_errorMessage", (Object)string3);
        }
    }

    private void warnIfEmptySources(String string) {
        File file = new File(string);
        assert (file.isDirectory()) : "Sources directory must exist: " + string;
        File[] fileArray = file.listFiles();
        assert (fileArray != null) : "Sources directory should have children: " + string;
        if (fileArray.length == 0) {
            this.descriptor.putProperty("WizardPanel_warningMessage", (Object)NbBundle.getMessage(ConfigureProjectPanel.class, (String)"MSG_SourcesEmpty"));
        }
    }

    private void projectNameChanged() {
        String string = this.configureProjectPanelVisual.getProjectName();
        if (string.length() == 0) {
            return;
        }
        if (this.originalProjectName == null) {
            this.originalProjectName = string;
        }
        if (string.equals(this.originalProjectName)) {
            return;
        }
        this.adjustProjectFolder(this.originalProjectName, string);
        this.adjustSources(this.originalProjectName, string);
        this.originalProjectName = string;
    }

    private void adjustProjectFolder(String string, String string2) {
        File file = this.getProjectFolderFile();
        if (file == null) {
            return;
        }
        String string3 = file.getName();
        if (!string.equals(string3)) {
            return;
        }
        File file2 = new File(file.getParentFile(), string2);
        this.configureProjectPanelVisual.setProjectFolder(file2.getAbsolutePath());
    }

    private void adjustSources(String string, String string2) {
        LocalServer.ComboBoxModel comboBoxModel = (LocalServer.ComboBoxModel)this.configureProjectPanelVisual.getLocalServerModel();
        boolean bl = false;
        for (int i = 0; i < comboBoxModel.getSize(); ++i) {
            LocalServer localServer = comboBoxModel.getElementAt(i);
            File file = new File(localServer.getSrcRoot());
            if (!string.equals(file.getName())) continue;
            File file2 = new File(file.getParentFile(), string2);
            localServer.setSrcRoot(file2.getAbsolutePath());
            bl = true;
        }
        if (bl) {
            comboBoxModel.fireContentsChanged();
        }
    }

    private void sourceFolderChanged() {
        String string = this.configureProjectPanelVisual.getSourcesLocation().getSrcRoot();
        if (string.length() == 0) {
            return;
        }
        if (string.equals(this.originalSources)) {
            return;
        }
        this.adjustProjectName(this.originalSources, string);
        String string2 = new File(string).getName();
        String string3 = null;
        if (this.originalSources == null) {
            assert (this.getProjectFolderFile() != null);
            string3 = this.getProjectFolderFile().getName();
        } else {
            string3 = new File(this.originalSources).getName();
        }
        this.adjustProjectFolder(string3, string2);
        this.originalSources = string;
    }

    private void adjustProjectName(String string, String string2) {
        String string3;
        String string4;
        if (string != null && !(string4 = new File(string).getName()).equals(string3 = this.configureProjectPanelVisual.getProjectName())) {
            return;
        }
        string4 = new File(string2).getName();
        this.configureProjectPanelVisual.setProjectName(string4);
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.removeListeners();
        switch (this.wizardType) {
            case NEW: 
            case REMOTE: {
                this.projectNameChanged();
                break;
            }
            case EXISTING: {
                this.sourceFolderChanged();
                break;
            }
            default: {
                assert (false) : "Unknown wizard type: " + (Object)((Object)this.wizardType);
                break;
            }
        }
        this.addListeners();
        this.fireChangeEvent();
    }

    @Override
    public void cancel() {
        this.canceled = true;
    }
}

