/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.options;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.php.api.phpmodule.PhpInterpreter;
import org.netbeans.modules.php.project.ui.options.PhpOptions;
import org.netbeans.modules.php.project.ui.options.PhpOptionsPanel;
import org.netbeans.spi.options.OptionsPanelController;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class PhpOptionsPanelController
extends OptionsPanelController
implements ChangeListener {
    public static final String ID = "General";
    private PhpOptionsPanel phpOptionsPanel = null;
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private volatile boolean changed;

    public void update() {
        this.phpOptionsPanel.setPhpInterpreter(this.getPhpOptions().getPhpInterpreter());
        this.phpOptionsPanel.setOpenResultInOutputWindow(this.getPhpOptions().isOpenResultInOutputWindow());
        this.phpOptionsPanel.setOpenResultInBrowser(this.getPhpOptions().isOpenResultInBrowser());
        this.phpOptionsPanel.setOpenResultInEditor(this.getPhpOptions().isOpenResultInEditor());
        this.phpOptionsPanel.setDebuggerPort(this.getPhpOptions().getDebuggerPort());
        this.phpOptionsPanel.setDebuggerSessionId(this.getPhpOptions().getDebuggerSessionId());
        this.phpOptionsPanel.setDebuggerStoppedAtTheFirstLine(this.getPhpOptions().isDebuggerStoppedAtTheFirstLine());
        this.changed = false;
    }

    public void applyChanges() {
        this.getPhpOptions().setPhpInterpreter(this.phpOptionsPanel.getPhpInterpreter());
        this.getPhpOptions().setOpenResultInOutputWindow(this.phpOptionsPanel.isOpenResultInOutputWindow());
        this.getPhpOptions().setOpenResultInBrowser(this.phpOptionsPanel.isOpenResultInBrowser());
        this.getPhpOptions().setOpenResultInEditor(this.phpOptionsPanel.isOpenResultInEditor());
        this.getPhpOptions().setDebuggerPort(this.phpOptionsPanel.getDebuggerPort());
        this.getPhpOptions().setDebuggerSessionId(this.phpOptionsPanel.getDebuggerSessionId());
        this.getPhpOptions().setDebuggerStoppedAtTheFirstLine(this.phpOptionsPanel.isDebuggerStoppedAtTheFirstLine());
        this.getPhpOptions().setPhpGlobalIncludePath(this.phpOptionsPanel.getPhpGlobalIncludePath());
        this.changed = false;
    }

    public void cancel() {
    }

    public boolean isValid() {
        return this.validateComponent();
    }

    public boolean isChanged() {
        return this.changed;
    }

    public JComponent getComponent(Lookup lookup) {
        if (this.phpOptionsPanel == null) {
            this.phpOptionsPanel = new PhpOptionsPanel();
            this.phpOptionsPanel.addChangeListener(this);
        }
        return this.phpOptionsPanel;
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    private PhpOptions getPhpOptions() {
        return PhpOptions.getInstance();
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.changed();
    }

    private boolean validateComponent() {
        Integer n = this.phpOptionsPanel.getDebuggerPort();
        if (n == null || n < 1) {
            this.phpOptionsPanel.setError(NbBundle.getMessage(PhpOptionsPanelController.class, (String)"MSG_DebuggerInvalidPort"));
            return false;
        }
        String string = this.phpOptionsPanel.getDebuggerSessionId();
        if (string == null || string.trim().length() == 0 || string.contains(" ")) {
            this.phpOptionsPanel.setError(NbBundle.getMessage(PhpOptionsPanelController.class, (String)"MSG_DebuggerInvalidSessionId"));
            return false;
        }
        String string2 = PhpInterpreter.validate((String)this.phpOptionsPanel.getPhpInterpreter());
        if (string2 != null) {
            this.phpOptionsPanel.setWarning(string2);
            return true;
        }
        this.phpOptionsPanel.setError(" ");
        return true;
    }

    private void changed() {
        if (!this.changed) {
            this.changed = true;
            this.propertyChangeSupport.firePropertyChange("changed", false, true);
        }
        this.propertyChangeSupport.firePropertyChange("valid", null, null);
    }
}

