/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.customizer;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.netbeans.modules.php.api.phpmodule.PhpInterpreter;
import org.netbeans.modules.php.api.phpmodule.PhpProgram;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.project.ui.Utils;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public final class RunAsValidator {
    private static final String INVALID_SEPARATOR = "\\";

    private RunAsValidator() {
    }

    public static String validateWebFields(String string, File file, String string2, String string3) {
        String string4 = null;
        string4 = !Utils.isValidUrl(string) ? NbBundle.getMessage(RunAsValidator.class, (String)"MSG_InvalidUrl") : (!string.endsWith("/") ? NbBundle.getMessage(RunAsValidator.class, (String)"MSG_UrlNotTrailingSlash") : RunAsValidator.validateIndexFile(file, string2, string3));
        return string4;
    }

    public static String validateScriptFields(String string, File file, String string2, String string3) {
        try {
            PhpInterpreter.getCustom((String)string);
        }
        catch (PhpProgram.InvalidPhpProgramException invalidPhpProgramException) {
            return invalidPhpProgramException.getLocalizedMessage();
        }
        return RunAsValidator.validateIndexFile(file, string2, string3);
    }

    public static String validateUploadDirectory(String string, boolean bl) {
        if (bl && !StringUtils.hasText((String)string)) {
            return null;
        }
        if (!StringUtils.hasText((String)string)) {
            return NbBundle.getMessage(RunAsValidator.class, (String)"MSG_MissingUploadDirectory");
        }
        if (!string.startsWith("/")) {
            return NbBundle.getMessage(RunAsValidator.class, (String)"MSG_InvalidUploadDirectoryStart", (Object)"/");
        }
        if (string.contains(INVALID_SEPARATOR)) {
            return NbBundle.getMessage(RunAsValidator.class, (String)"MSG_InvalidUploadDirectoryContent", (Object)INVALID_SEPARATOR);
        }
        return null;
    }

    public static String sanitizeUploadDirectory(String string, boolean bl) {
        if (StringUtils.hasText((String)string)) {
            while (string.length() > 1 && string.endsWith("/")) {
                string = string.substring(0, string.length() - 1);
            }
        } else if (!bl) {
            string = "/";
        }
        if (bl && "/".equals(string)) {
            string = "";
        }
        return string;
    }

    public static String validateIndexFile(File file, String string, String string2) {
        assert (file != null);
        if (string != null) {
            if (!StringUtils.hasText((String)string)) {
                return NbBundle.getMessage(RunAsValidator.class, (String)"MSG_NoIndexFile");
            }
            string = string.trim();
            boolean bl = false;
            if (string.startsWith("/") || string.startsWith(INVALID_SEPARATOR)) {
                bl = true;
            } else if (Utilities.isWindows() && string.contains(File.separator)) {
                bl = true;
            } else {
                File file2 = new File(file, string.replace('/', File.separatorChar));
                if (!file2.isFile() || !file2.equals(FileUtil.normalizeFile((File)file2))) {
                    bl = true;
                }
            }
            if (bl) {
                return NbBundle.getMessage(RunAsValidator.class, (String)"MSG_IndexFileInvalid");
            }
        }
        return null;
    }

    public static String composeUrlHint(String string, String string2, String string3) throws InvalidUrlException {
        URL uRL = null;
        try {
            if (string != null && string.trim().length() > 0) {
                uRL = new URL(string);
            }
            if (uRL != null && string2 != null && string2.trim().length() > 0) {
                uRL = new URL(uRL, string2);
            }
            if (uRL != null && string3 != null && string3.trim().length() > 0) {
                uRL = new URI(uRL.getProtocol(), uRL.getUserInfo(), uRL.getHost(), uRL.getPort(), uRL.getPath(), string3, uRL.getRef()).toURL();
            }
        }
        catch (MalformedURLException malformedURLException) {
            throw new InvalidUrlException(NbBundle.getMessage(RunAsValidator.class, (String)"MSG_InvalidUrl"));
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new InvalidUrlException(NbBundle.getMessage(RunAsValidator.class, (String)"MSG_InvalidUrl"));
        }
        return uRL != null ? uRL.toExternalForm() : "";
    }

    public static final class InvalidUrlException
    extends Exception {
        private static final long serialVersionUID = 1234514014505423742L;

        public InvalidUrlException(String string) {
            super(string);
        }
    }
}

