/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.php.project.PhpVisibilityQuery;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.nodes.NodeNotFoundException;
import org.openide.nodes.NodeOp;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BrowseFolders
extends JPanel
implements ExplorerManager.Provider {
    private static final long serialVersionUID = -180677991433020051L;
    static final Comparator<FileObject> FILE_OBJECT_COMAPARTOR = new FileObjectComparator();
    private static final JScrollPane SAMPLE_SCROLL_PANE = new JScrollPane();
    private static final String NB_PROJECT_DIR = "nbproject";
    private final PhpVisibilityQuery phpVisibilityQuery;
    private final ExplorerManager manager;
    private final SourceGroup[] folders;
    private final Class<?> target;
    private final BeanTreeView btv;
    private JPanel folderPanel;
    private JLabel jLabel1;

    BrowseFolders(PhpVisibilityQuery phpVisibilityQuery, SourceGroup[] sourceGroupArray, Class<?> clazz, String string) {
        assert (phpVisibilityQuery != null);
        this.initComponents();
        String string2 = clazz == DataFolder.class ? "ACSD_BrowseFolders" : "ACSD_BrowseFiles";
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BrowseFolders.class, (String)string2));
        this.phpVisibilityQuery = phpVisibilityQuery;
        this.folders = sourceGroupArray;
        this.target = clazz;
        this.manager = new ExplorerManager();
        AbstractNode abstractNode = new AbstractNode((Children)new SourceGroupsChildren(sourceGroupArray));
        this.manager.setRootContext((Node)abstractNode);
        this.btv = new BeanTreeView();
        this.btv.setRootVisible(false);
        this.btv.setSelectionMode(1);
        this.btv.setBorder(SAMPLE_SCROLL_PANE.getBorder());
        this.expandSelection(string);
        this.folderPanel.add((Component)this.btv, "Center");
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }

    private void expandSelection(String string) {
        Node node = this.manager.getRootContext();
        Children children = node.getChildren();
        if (children == Children.LEAF) {
            return;
        }
        Node[] nodeArray = children.getNodes(true);
        Node node2 = null;
        if (string != null && string.length() > 0) {
            for (Node node3 : nodeArray) {
                try {
                    node2 = NodeOp.findPath((Node)node3, (String[])string.split("/"));
                    break;
                }
                catch (NodeNotFoundException nodeNotFoundException) {
                }
            }
        }
        if (node2 == null) {
            this.btv.expandNode(node);
            for (Node node3 : nodeArray) {
                this.btv.expandNode(node3);
                if (node2 != null) continue;
                node2 = node3;
            }
        }
        if (node2 != null) {
            try {
                this.manager.setSelectedNodes(new Node[]{node2});
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.folderPanel = new JPanel();
        this.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        this.setLayout(new GridBagLayout());
        this.jLabel1.setLabelFor(this.folderPanel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(BrowseFolders.class, (String)"LBL_Folders"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel1.getAccessibleContext().setAccessibleName(NbBundle.getMessage(BrowseFolders.class, (String)"BrowseFolders.jLabel1.AccessibleContext.accessibleName"));
        this.jLabel1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BrowseFolders.class, (String)"BrowseFolders.jLabel1.AccessibleContext.accessibleDescription"));
        this.folderPanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.folderPanel, gridBagConstraints);
        this.folderPanel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(BrowseFolders.class, (String)"BrowseFolders.folderPanel.AccessibleContext.accessibleName"));
        this.folderPanel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BrowseFolders.class, (String)"BrowseFolders.folderPanel.AccessibleContext.accessibleDescription"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(BrowseFolders.class, (String)"BrowseFolders.AccessibleContext.accessibleName"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BrowseFolders.class, (String)"BrowseFolders.AccessibleContext.accessibleDescription"));
    }

    public static FileObject showDialog(PhpVisibilityQuery phpVisibilityQuery, SourceGroup[] sourceGroupArray, Class<?> clazz, String string) {
        BrowseFolders browseFolders = new BrowseFolders(phpVisibilityQuery, sourceGroupArray, clazz, string);
        String string2 = clazz == DataFolder.class ? "LBL_SelectFolder" : "LBL_SelectFile";
        JButton jButton = new JButton(NbBundle.getMessage(BrowseFolders.class, (String)string2));
        String string3 = clazz == DataFolder.class ? "ACSD_SelectFolder" : "ACSD_SelectFile";
        jButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BrowseFolders.class, (String)string3));
        JButton jButton2 = new JButton(NbBundle.getMessage(BrowseFolders.class, (String)"LBL_Cancel"));
        jButton2.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BrowseFolders.class, (String)"ACSD_Cancel"));
        Object[] objectArray = new JButton[]{jButton, jButton2};
        OptionsListener optionsListener = new OptionsListener(browseFolders, clazz);
        objectArray[0].setActionCommand("SELECT");
        objectArray[0].addActionListener(optionsListener);
        objectArray[1].setActionCommand("CANCEL");
        objectArray[1].addActionListener(optionsListener);
        string2 = clazz == DataFolder.class ? "LBL_BrowseFolders" : "LBL_BrowseFiles";
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)browseFolders, NbBundle.getMessage(BrowseFolders.class, (String)string2), true, objectArray, (Object)objectArray[0], 0, null, null);
        dialogDescriptor.setClosingOptions(new Object[]{objectArray[0], objectArray[1]});
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
        return optionsListener.getResult();
    }

    public static FileObject showDialog(PhpVisibilityQuery phpVisibilityQuery, FileObject[] fileObjectArray, Class<?> clazz, String string) {
        SourceGroup[] sourceGroupArray = new SourceGroup[fileObjectArray.length];
        int n = 0;
        for (FileObject fileObject : fileObjectArray) {
            sourceGroupArray[n++] = new FOSourceGroup(fileObject);
        }
        return BrowseFolders.showDialog(phpVisibilityQuery, sourceGroupArray, clazz, string);
    }

    private static final class FOSourceGroup
    implements SourceGroup {
        private final FileObject fo;

        public FOSourceGroup(FileObject fileObject) {
            assert (fileObject.isFolder()) : "Directory must be provided";
            this.fo = fileObject;
        }

        public FileObject getRootFolder() {
            return this.fo;
        }

        public String getName() {
            return this.fo.getNameExt();
        }

        public String getDisplayName() {
            return this.fo.getNameExt();
        }

        public Icon getIcon(boolean bl) {
            return null;
        }

        public boolean contains(FileObject fileObject) throws IllegalArgumentException {
            return FileUtil.isParentOf((FileObject)this.fo, (FileObject)fileObject);
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        }
    }

    private static final class OptionsListener
    implements ActionListener {
        public static final String COMMAND_SELECT = "SELECT";
        public static final String COMMAND_CANCEL = "CANCEL";
        private final BrowseFolders browsePanel;
        private final Class target;
        private FileObject result;

        public OptionsListener(BrowseFolders browseFolders, Class clazz) {
            this.browsePanel = browseFolders;
            this.target = clazz;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DataObject dataObject;
            Node[] nodeArray;
            String string = actionEvent.getActionCommand();
            if (COMMAND_SELECT.equals(string) && (nodeArray = this.browsePanel.getExplorerManager().getSelectedNodes()) != null && nodeArray.length > 0 && (dataObject = (DataObject)nodeArray[0].getLookup().lookup(DataObject.class)) != null && this.target.isInstance(dataObject)) {
                this.result = dataObject.getPrimaryFile();
                if (DataObject.class == this.target && this.result.isFolder()) {
                    this.result = null;
                }
            }
        }

        public FileObject getResult() {
            return this.result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FileObjectComparator
    implements Comparator<FileObject> {
        private FileObjectComparator() {
        }

        @Override
        public int compare(FileObject fileObject, FileObject fileObject2) {
            return fileObject.getName().compareTo(fileObject2.getName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class SourceGroupsChildren
    extends Children.Keys<Key> {
        private final SourceGroup[] groups;
        private final SourceGroup group;
        private final FileObject fo;

        public SourceGroupsChildren(SourceGroup[] sourceGroupArray) {
            this.groups = sourceGroupArray;
            this.fo = null;
            this.group = null;
        }

        public SourceGroupsChildren(FileObject fileObject, SourceGroup sourceGroup) {
            this.fo = fileObject;
            this.group = sourceGroup;
            this.groups = null;
        }

        protected void addNotify() {
            super.addNotify();
            this.setKeys(this.getKeys());
        }

        protected void removeNotify() {
            this.setKeys(Collections.emptySet());
            super.removeNotify();
        }

        protected Node[] createNodes(Key key) {
            FileObject fileObject = key.folder;
            SourceGroup sourceGroup = key.group;
            boolean bl = !fileObject.isFolder();
            try {
                DataObject dataObject = DataObject.find((FileObject)fileObject);
                FilterNode filterNode = new FilterNode(dataObject.getNodeDelegate(), (Children)(bl ? Children.LEAF : new SourceGroupsChildren(fileObject, sourceGroup)));
                return new Node[]{filterNode};
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                return null;
            }
        }

        private Collection<Key> getKeys() {
            ArrayList<Key> arrayList = null;
            if (this.groups != null) {
                arrayList = new ArrayList<Key>(this.groups.length);
                for (SourceGroup sourceGroup : this.groups) {
                    arrayList.add(new Key(sourceGroup.getRootFolder(), sourceGroup));
                }
            } else {
                FileObject[] fileObjectArray = this.fo.getChildren();
                Arrays.sort(fileObjectArray, FILE_OBJECT_COMAPARTOR);
                arrayList = new ArrayList(fileObjectArray.length);
                if (BrowseFolders.this.target == DataFolder.class) {
                    for (FileObject fileObject : fileObjectArray) {
                        if (!fileObject.isFolder() || !this.isVisible(fileObject) || !this.group.contains(fileObject)) continue;
                        arrayList.add(new Key(fileObject, this.group));
                    }
                } else {
                    ArrayList<Key> arrayList2 = new ArrayList<Key>(fileObjectArray.length);
                    ArrayList<Key> arrayList3 = new ArrayList<Key>(fileObjectArray.length);
                    for (FileObject fileObject : fileObjectArray) {
                        if (!this.isVisible(fileObject) || !this.group.contains(fileObject)) continue;
                        if (fileObject.isFolder()) {
                            arrayList2.add(new Key(fileObject, this.group));
                            continue;
                        }
                        arrayList3.add(new Key(fileObject, this.group));
                    }
                    arrayList.addAll(arrayList2);
                    arrayList.addAll(arrayList3);
                }
            }
            return arrayList;
        }

        private boolean isVisible(FileObject fileObject) {
            assert (fileObject != null);
            if (fileObject.getNameExt().equals(BrowseFolders.NB_PROJECT_DIR)) {
                return false;
            }
            return BrowseFolders.this.phpVisibilityQuery.isVisible(fileObject);
        }

        private final class Key {
            final FileObject folder;
            final SourceGroup group;

            Key(FileObject fileObject, SourceGroup sourceGroup) {
                this.folder = fileObject;
                this.group = sourceGroup;
            }
        }
    }
}

