/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.phpunit;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.ExecutionService;
import org.netbeans.api.extexecution.ExternalProcessBuilder;
import org.netbeans.api.extexecution.input.InputProcessor;
import org.netbeans.api.extexecution.input.InputProcessors;
import org.netbeans.api.extexecution.input.LineProcessor;
import org.netbeans.modules.php.api.phpmodule.PhpProgram;
import org.netbeans.modules.php.api.util.Pair;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.ProjectPropertiesSupport;
import org.netbeans.modules.php.project.api.PhpLanguageOptions;
import org.netbeans.modules.php.project.phpunit.PhpUnit33;
import org.netbeans.modules.php.project.phpunit.PhpUnit34;
import org.netbeans.modules.php.project.phpunit.PhpUnitCustom;
import org.netbeans.modules.php.project.ui.options.PhpOptions;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.windows.InputOutput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PhpUnit
extends PhpProgram {
    public static final boolean KEEP_LOGS = Boolean.getBoolean(PhpUnit.class.getName() + ".keepLogs");
    public static final String OPTIONS_SUB_PATH = "PhpUnit";
    public static final String TEST_CLASS_SUFFIX = "Test";
    public static final String TEST_FILE_SUFFIX = "Test.php";
    private static final String REQUIRE_ONCE_TPL_START = "require_once '";
    private static final String REQUIRE_ONCE_TPL_END = "%s';";
    public static final String PARAM_VERSION = "--version";
    public static final String PARAM_COVERAGE_LOG = "--coverage-clover";
    public static final String PARAM_SKELETON = "--skeleton-test";
    public static final String PARAM_SKELETON_OLD = "--skeleton";
    public static final String PARAM_BOOTSTRAP = "--bootstrap";
    private static final String BOOTSTRAP_FILENAME = "bootstrap%s.php";
    public static final String PARAM_CONFIGURATION = "--configuration";
    private static final String CONFIGURATION_FILENAME = "configuration%s.xml";
    public static final File XML_LOG = new File(System.getProperty("java.io.tmpdir"), "nb-phpunit-log.xml");
    public static final File COVERAGE_LOG = new File(System.getProperty("java.io.tmpdir"), "nb-phpunit-coverage.xml");
    public static final File SUITE;
    public static final String SUITE_RUN = "run=%s";
    private static final String SUITE_NAME = "NetBeansSuite.php";
    public static final char DIRECTORY_SEPARATOR = '/';
    public static final String DIRNAME_FILE = ".dirname(__FILE__).'/";
    public static final String REQUIRE_ONCE_REL_PART = "'.dirname(__FILE__).'/";
    public static final Pattern LINE_PATTERN;
    static final int[] UNKNOWN_VERSION;
    static final int[] MINIMAL_VERSION;
    static final int[] MINIMAL_VERSION_PHP53;
    static volatile int[] version;

    PhpUnit(String string) {
        super(string);
    }

    public static PhpUnit getDefault() throws PhpProgram.InvalidPhpProgramException {
        String string = PhpOptions.getInstance().getPhpUnit();
        String string2 = PhpUnit.validate(string);
        if (string2 != null) {
            throw new PhpProgram.InvalidPhpProgramException(string2);
        }
        if (PhpUnit.hasValidVersion(new PhpUnitCustom(string)) && version[0] >= MINIMAL_VERSION_PHP53[0] && version[1] >= MINIMAL_VERSION_PHP53[1]) {
            return new PhpUnit34(string);
        }
        return new PhpUnit33(string);
    }

    public static PhpUnit getCustom(String string) throws PhpProgram.InvalidPhpProgramException {
        String string2 = PhpUnit.validate(string);
        if (string2 != null) {
            throw new PhpProgram.InvalidPhpProgramException(string2);
        }
        return new PhpUnitCustom(string);
    }

    public abstract String getXmlLogParam();

    public static boolean isRequireOnceSourceFile(String string, String string2) {
        return string.startsWith(REQUIRE_ONCE_TPL_START) && string.endsWith(String.format(REQUIRE_ONCE_TPL_END, string2));
    }

    public ExternalProcessBuilder getProcessBuilder() {
        return super.getProcessBuilder().workingDirectory(new File(this.getProgram()).getParentFile());
    }

    public File getWorkingDirectory(ConfigFiles configFiles, File file) {
        if (configFiles.configuration != null) {
            return configFiles.configuration.getParentFile();
        }
        return file;
    }

    public static String validateVersion(PhpUnit phpUnit) {
        if (phpUnit == null) {
            return NbBundle.getMessage(PhpUnit.class, (String)"MSG_NoPhpUnit");
        }
        String string = phpUnit.validate();
        if (string == null) {
            phpUnit.getVersion();
            if (version == null || version == UNKNOWN_VERSION || version[0] <= MINIMAL_VERSION[0] && version[1] < MINIMAL_VERSION[1]) {
                string = NbBundle.getMessage(PhpUnit.class, (String)"MSG_OldPhpUnit", (Object[])PhpUnit.getVersions(phpUnit));
            }
        }
        return string;
    }

    public static String validateVersion(PhpUnit phpUnit, PhpProject phpProject) {
        String string = PhpUnit.validateVersion(phpUnit);
        if (string != null) {
            return string;
        }
        PhpLanguageOptions.PhpVersion phpVersion = ProjectPropertiesSupport.getPhpVersion(phpProject);
        switch (phpVersion) {
            case PHP_53: {
                if (version[0] > MINIMAL_VERSION_PHP53[0] || version[1] >= MINIMAL_VERSION_PHP53[1]) break;
                string = NbBundle.getMessage(PhpUnit.class, (String)"MSG_OldPhpUnitPhp53", (Object[])PhpUnit.getVersions(phpUnit, phpProject));
                break;
            }
            case PHP_5: {
                break;
            }
            default: {
                throw new IllegalStateException("Unknown PHP version: " + (Object)((Object)phpVersion));
            }
        }
        return string;
    }

    public static boolean hasValidVersion(PhpUnit phpUnit) {
        return PhpUnit.validateVersion(phpUnit) == null;
    }

    public static boolean hasValidVersion(PhpUnit phpUnit, PhpProject phpProject) {
        return PhpUnit.validateVersion(phpUnit, phpProject) == null;
    }

    public static void resetVersion() {
        version = null;
    }

    private int[] getVersion() {
        if (!this.isValid()) {
            return UNKNOWN_VERSION;
        }
        if (version != null) {
            return version;
        }
        version = UNKNOWN_VERSION;
        ExternalProcessBuilder externalProcessBuilder = this.getProcessBuilder().addArgument(PARAM_VERSION);
        ExecutionDescriptor executionDescriptor = new ExecutionDescriptor().inputOutput(InputOutput.NULL).outProcessorFactory((ExecutionDescriptor.InputProcessorFactory)new OutputProcessorFactory());
        ExecutionService executionService = ExecutionService.newService((Callable)externalProcessBuilder, (ExecutionDescriptor)executionDescriptor, null);
        Future future = executionService.run();
        try {
            future.get();
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException executionException) {
            LOGGER.log(Level.INFO, null, executionException);
        }
        return version;
    }

    public static String[] getVersions(PhpUnit phpUnit) {
        return PhpUnit.getVersions(phpUnit, MINIMAL_VERSION);
    }

    public static String[] getVersions(PhpUnit phpUnit, PhpProject phpProject) {
        int[] nArray = null;
        PhpLanguageOptions.PhpVersion phpVersion = ProjectPropertiesSupport.getPhpVersion(phpProject);
        switch (phpVersion) {
            case PHP_53: {
                nArray = MINIMAL_VERSION_PHP53;
                break;
            }
            case PHP_5: {
                nArray = MINIMAL_VERSION;
                break;
            }
            default: {
                throw new IllegalStateException("Unknown PHP version: " + (Object)((Object)phpVersion));
            }
        }
        return PhpUnit.getVersions(phpUnit, nArray);
    }

    private static String[] getVersions(PhpUnit phpUnit, int[] nArray) {
        Integer n;
        int n2;
        int n3;
        Object object;
        ArrayList<Object> arrayList = new ArrayList<Object>(6);
        if (phpUnit == null || phpUnit.getVersion() == UNKNOWN_VERSION) {
            object = NbBundle.getMessage(PhpUnit.class, (String)"LBL_QuestionMark");
            arrayList.add(object);
            arrayList.add(object);
            arrayList.add(object);
        } else {
            object = phpUnit.getVersion();
            n3 = ((Object)object).length;
            for (n2 = 0; n2 < n3; ++n2) {
                n = (int)object[n2];
                arrayList.add(String.valueOf(n));
            }
        }
        object = nArray;
        n3 = ((Object)object).length;
        for (n2 = 0; n2 < n3; ++n2) {
            n = (int)object[n2];
            arrayList.add(String.valueOf(n));
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static ConfigFiles getConfigFiles(PhpProject phpProject, boolean bl) {
        File file;
        LinkedList<Pair<String, File>> linkedList = new LinkedList<Pair<String, File>>();
        File file2 = ProjectPropertiesSupport.getPhpUnitBootstrap(phpProject);
        if (file2 != null && !file2.isFile()) {
            linkedList.add(Pair.of((Object)NbBundle.getMessage(PhpUnit.class, (String)"LBL_Bootstrap"), (Object)file2));
            file2 = null;
        }
        if ((file = ProjectPropertiesSupport.getPhpUnitConfiguration(phpProject)) != null && !file.isFile()) {
            linkedList.add((Pair<String, File>)Pair.of((Object)NbBundle.getMessage(PhpUnit.class, (String)"LBL_XmlConfiguration"), (Object)file));
            file = null;
        }
        File file3 = null;
        if (bl && (file3 = ProjectPropertiesSupport.getPhpUnitSuite(phpProject)) != null && !file3.isFile()) {
            linkedList.add((Pair<String, File>)Pair.of((Object)NbBundle.getMessage(PhpUnit.class, (String)"LBL_TestSuite"), (Object)file3));
            file3 = null;
        }
        PhpUnit.warnAboutMissingFiles(linkedList);
        return new ConfigFiles(file2, file, file3);
    }

    public static File getCustomSuite(PhpProject phpProject) {
        File file = ProjectPropertiesSupport.getPhpUnitSuite(phpProject);
        if (file != null && file.isFile()) {
            return file;
        }
        return null;
    }

    public static File createBootstrapFile(final PhpProject phpProject) {
        FileObject fileObject = ProjectPropertiesSupport.getTestDirectory(phpProject, false);
        assert (fileObject != null) : "Test directory must already be set";
        final FileObject fileObject2 = FileUtil.getConfigFile((String)"Templates/PHPUnit/PHPUnitBootstrap");
        final DataFolder dataFolder = DataFolder.findFolder((FileObject)fileObject);
        final File file = new File(PhpUnit.getBootstrapFilepath(phpProject));
        final File[] fileArray = new File[1];
        FileUtil.runAtomicAction((Runnable)new Runnable(){

            public void run() {
                try {
                    DataObject dataObject = DataObject.find((FileObject)fileObject2);
                    DataObject dataObject2 = dataObject.createFromTemplate(dataFolder, file.getName() + "~");
                    assert (dataObject2 != null);
                    PhpUnit.moveAndAdjustBootstrap(phpProject, FileUtil.toFile((FileObject)dataObject2.getPrimaryFile()), file);
                    assert (file.isFile());
                    fileArray[0] = file;
                    PhpUnit.informAboutGeneratedFile(file.getName());
                }
                catch (IOException iOException) {
                    LOGGER.log(Level.WARNING, "Cannot create PHPUnit bootstrap file", iOException);
                }
            }
        });
        if (fileArray[0] == null) {
            PhpUnit.warnAboutNotGeneratedFile(file.getName());
        }
        return fileArray[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void moveAndAdjustBootstrap(PhpProject phpProject, File file, File file2) {
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            try {
                BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file2));
                try {
                    String string;
                    while ((string = bufferedReader.readLine()) != null) {
                        if (string.contains("%INCLUDE_PATH%")) {
                            if (string.startsWith("//")) continue;
                            string = PhpUnit.processIncludePath(file2, string, ProjectPropertiesSupport.getPropertyEvaluator(phpProject).getProperty("include.path"), FileUtil.toFile((FileObject)phpProject.getProjectDirectory()));
                        }
                        bufferedWriter.write(string);
                        bufferedWriter.newLine();
                    }
                    Object var7_7 = null;
                }
                catch (Throwable throwable) {
                    Object var7_8 = null;
                    bufferedWriter.flush();
                    bufferedWriter.close();
                    throw throwable;
                }
                bufferedWriter.flush();
                bufferedWriter.close();
                Object var9_10 = null;
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                bufferedReader.close();
                throw throwable;
            }
            bufferedReader.close();
            {
            }
        }
        catch (IOException iOException) {
            LOGGER.log(Level.WARNING, null, iOException);
        }
        if (!file.delete()) {
            LOGGER.info("Cannot delete temporary file " + file);
            file.deleteOnExit();
        }
        FileUtil.refreshFor((File[])new File[]{file2.getParentFile()});
    }

    static String processIncludePath(File file, String string, String string2, File file2) {
        if (StringUtils.hasText((String)string2)) {
            if (string2.startsWith(":")) {
                string2 = string2.substring(1);
            }
            StringBuilder stringBuilder = new StringBuilder(200);
            for (String string3 : PropertyUtils.tokenizePath((String)string2)) {
                File file3 = PropertyUtils.resolveFile((File)file2, (String)string3);
                stringBuilder.append(".PATH_SEPARATOR");
                stringBuilder.append(PhpUnit.getDirnameFile(file, file3));
            }
            string2 = stringBuilder.toString();
        } else {
            string = "//" + string;
        }
        string = string.replace("%INCLUDE_PATH%", string2);
        return string;
    }

    public static File createConfigurationFile(PhpProject phpProject) {
        FileObject fileObject = ProjectPropertiesSupport.getTestDirectory(phpProject, false);
        assert (fileObject != null) : "Test directory must already be set";
        FileObject fileObject2 = FileUtil.getConfigFile((String)"Templates/PHPUnit/PHPUnitConfiguration.xml");
        DataFolder dataFolder = DataFolder.findFolder((FileObject)fileObject);
        File file = new File(PhpUnit.getConfigurationFilepath(phpProject));
        File file2 = null;
        try {
            DataObject dataObject = DataObject.find((FileObject)fileObject2);
            DataObject dataObject2 = dataObject.createFromTemplate(dataFolder, file.getName().replace(".xml", ""));
            assert (dataObject2 != null);
            file2 = file;
            PhpUnit.informAboutGeneratedFile(file.getName());
        }
        catch (IOException iOException) {
            LOGGER.log(Level.WARNING, "Cannot create PHPUnit configuration file", iOException);
        }
        if (file2 == null) {
            PhpUnit.warnAboutNotGeneratedFile(file.getName());
        }
        return file2;
    }

    public static void informAboutGeneratedFile(String string) {
        DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(PhpUnit.class, (String)"MSG_FileGenerated", (Object)string)));
    }

    private static void warnAboutNotGeneratedFile(String string) {
        NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)NbBundle.getMessage(PhpUnit.class, (String)"MSG_NotGenerated", (Object)string), 2);
        DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)message);
    }

    private static void warnAboutMissingFiles(List<Pair<String, File>> list) {
        if (list.isEmpty()) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder(100);
        for (Pair<String, File> pair : list) {
            stringBuilder.append(NbBundle.getMessage(PhpUnit.class, (String)"LBL_MissingFile", (Object)pair.first, (Object)((File)pair.second).getAbsolutePath()));
            stringBuilder.append("\n");
        }
        NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)NbBundle.getMessage(PhpUnit.class, (String)"MSG_MissingFiles", (Object)stringBuilder.toString()), 2);
        DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)message);
    }

    private static String getDirnameFile(File file, File file2) {
        return PhpUnit.getRelPath(file, file2, ".'", DIRNAME_FILE, "'");
    }

    public static String getRequireOnce(File file, File file2) {
        return PhpUnit.getRelPath(file, file2, "", REQUIRE_ONCE_REL_PART, "");
    }

    private static String getRelPath(File file, File file2, String string, String string2, String string3) {
        return PhpUnit.getRelPath(file, file2, string, string2, string3, false);
    }

    static String getRelPath(File file, File file2, String string, String string2, String string3, boolean bl) {
        File file3 = file.getParentFile();
        String string4 = PropertyUtils.relativizeFile((File)file3, (File)file2);
        string4 = string4 == null || bl ? string + file2.getAbsolutePath() + string3 : string2 + string4 + string3;
        return string4.replace(File.separatorChar, '/');
    }

    private static String getBootstrapFilepath(PhpProject phpProject) {
        return PhpUnit.getFilepath(phpProject, BOOTSTRAP_FILENAME);
    }

    private static String getConfigurationFilepath(PhpProject phpProject) {
        return PhpUnit.getFilepath(phpProject, CONFIGURATION_FILENAME);
    }

    private static String getFilepath(PhpProject phpProject, String string) {
        FileObject fileObject = ProjectPropertiesSupport.getTestDirectory(phpProject, false);
        assert (fileObject != null) : "Test directory must already be set";
        File file = FileUtil.toFile((FileObject)fileObject);
        File file2 = null;
        int n = 0;
        while ((file2 = new File(file, PhpUnit.getFilename(string, n++))).isFile()) {
        }
        assert (!file2.isFile());
        return file2.getAbsolutePath();
    }

    private static String getFilename(String string, int n) {
        return String.format(string, n == 0 ? "" : Integer.valueOf(n));
    }

    public String validate() {
        if (!StringUtils.hasText((String)this.getProgram())) {
            return NbBundle.getMessage(PhpUnit.class, (String)"MSG_NoPhpUnit");
        }
        File file = new File(this.getProgram());
        if (!file.isAbsolute()) {
            return NbBundle.getMessage(PhpUnit.class, (String)"MSG_PhpUnitNotAbsolutePath");
        }
        if (!file.isFile()) {
            return NbBundle.getMessage(PhpUnit.class, (String)"MSG_PhpUnitNotFile");
        }
        if (!file.canRead()) {
            return NbBundle.getMessage(PhpUnit.class, (String)"MSG_PhpUnitCannotRead");
        }
        return null;
    }

    public static String validate(String string) {
        return new PhpUnitCustom(string).validate();
    }

    static {
        LINE_PATTERN = Pattern.compile("(?:.+\\(\\) )?(.+):(\\d+)");
        UNKNOWN_VERSION = new int[0];
        MINIMAL_VERSION = new int[]{3, 3, 0};
        MINIMAL_VERSION_PHP53 = new int[]{3, 4, 0};
        version = null;
        SUITE = InstalledFileLocator.getDefault().locate(SUITE_NAME, "org.netbeans.modules.php.project", false);
        if (SUITE == null || !SUITE.isFile()) {
            throw new IllegalStateException("Could not locate file NetBeansSuite.php");
        }
    }

    static final class OutputProcessorFactory
    implements ExecutionDescriptor.InputProcessorFactory {
        private static final Pattern PHPUNIT_VERSION = Pattern.compile("PHPUnit\\s+(\\d+)\\.(\\d+)\\.(\\d+)\\s+");

        OutputProcessorFactory() {
        }

        public InputProcessor newInputProcessor(final InputProcessor inputProcessor) {
            return InputProcessors.bridge((LineProcessor)new LineProcessor(){

                public void processLine(String string) {
                    int[] nArray = OutputProcessorFactory.match(string);
                    if (nArray != null) {
                        version = nArray;
                    }
                }

                public void reset() {
                    try {
                        inputProcessor.reset();
                    }
                    catch (IOException iOException) {
                        Exceptions.printStackTrace((Throwable)iOException);
                    }
                }

                public void close() {
                    try {
                        inputProcessor.close();
                    }
                    catch (IOException iOException) {
                        Exceptions.printStackTrace((Throwable)iOException);
                    }
                }
            });
        }

        static int[] match(String string) {
            Matcher matcher;
            assert (string != null);
            if (StringUtils.hasText((String)string) && (matcher = PHPUNIT_VERSION.matcher(string)).find()) {
                int n = Integer.parseInt(matcher.group(1));
                int n2 = Integer.parseInt(matcher.group(2));
                int n3 = Integer.parseInt(matcher.group(3));
                return new int[]{n, n2, n3};
            }
            return null;
        }
    }

    public static final class ConfigFiles {
        public final File bootstrap;
        public final File configuration;
        public final File suite;

        public ConfigFiles(File file, File file2, File file3) {
            this.bootstrap = file;
            this.configuration = file2;
            this.suite = file3;
        }
    }
}

