/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.discovery.wizard;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.discovery.api.DiscoveryProvider;
import org.netbeans.modules.cnd.discovery.api.ProjectProxy;
import org.netbeans.modules.cnd.discovery.projectimport.ImportProject;
import org.netbeans.modules.cnd.discovery.wizard.DiscoveryWizardDescriptor;
import org.netbeans.modules.cnd.discovery.wizard.SelectConfigurationPanel;
import org.netbeans.modules.cnd.discovery.wizard.api.DiscoveryDescriptor;
import org.netbeans.modules.cnd.discovery.wizard.bridge.DiscoveryProjectGenerator;
import org.netbeans.modules.cnd.makeproject.api.wizards.IteratorExtension;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiscoveryExtension
implements IteratorExtension {
    public Set<FileObject> createProject(WizardDescriptor wizardDescriptor) throws IOException {
        return new ImportProject(wizardDescriptor).create();
    }

    public void apply(WizardDescriptor wizardDescriptor, Project project) throws IOException {
        DiscoveryDescriptor discoveryDescriptor = DiscoveryWizardDescriptor.adaptee(wizardDescriptor);
        discoveryDescriptor.setProject(project);
        DiscoveryProjectGenerator discoveryProjectGenerator = new DiscoveryProjectGenerator(discoveryDescriptor);
        discoveryProjectGenerator.makeProject();
    }

    public void apply(Map<String, Object> map, Project project) throws IOException {
        DiscoveryDescriptor discoveryDescriptor = DiscoveryWizardDescriptor.adaptee(map);
        discoveryDescriptor.setProject(project);
        DiscoveryProjectGenerator discoveryProjectGenerator = new DiscoveryProjectGenerator(discoveryDescriptor);
        discoveryProjectGenerator.makeProject();
    }

    public Map<String, Object> clone(WizardDescriptor wizardDescriptor) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("DW:rootFolder", wizardDescriptor.getProperty("buildCommandWorkingDirTextField"));
        hashMap.put("DW:buildResult", wizardDescriptor.getProperty("outputTextField"));
        hashMap.put("DW:libraries", wizardDescriptor.getProperty("additionalLibraries"));
        hashMap.put("DW:consolidationLevel", wizardDescriptor.getProperty("consolidationLevel"));
        return hashMap;
    }

    public void uninitialize(WizardDescriptor wizardDescriptor) {
        DiscoveryDescriptor discoveryDescriptor = DiscoveryWizardDescriptor.adaptee(wizardDescriptor);
        discoveryDescriptor.clean();
    }

    public boolean isApplicable(DiscoveryDescriptor discoveryDescriptor) {
        if (this.isApplicableDwarfExecutable(discoveryDescriptor)) {
            return true;
        }
        if (this.isApplicableMakeLog(discoveryDescriptor)) {
            return true;
        }
        return this.isApplicableDwarfFolder(discoveryDescriptor);
    }

    private boolean isApplicableDwarfExecutable(DiscoveryDescriptor discoveryDescriptor) {
        String string = discoveryDescriptor.getBuildResult();
        if (string == null) {
            return false;
        }
        File file = new File(string);
        if (!file.exists()) {
            return false;
        }
        ProjectProxyImpl projectProxyImpl = new ProjectProxyImpl(discoveryDescriptor);
        DiscoveryProvider discoveryProvider = DiscoveryExtension.findProvider("dwarf-executable");
        if (discoveryProvider != null && discoveryProvider.isApplicable(projectProxyImpl)) {
            discoveryProvider.getProperty("executable").setValue(string);
            discoveryProvider.getProperty("libraries").setValue(new String[0]);
            if (discoveryProvider.canAnalyze(projectProxyImpl) > 0) {
                discoveryDescriptor.setProvider(discoveryProvider);
                return true;
            }
        }
        return false;
    }

    private boolean isApplicableDwarfFolder(DiscoveryDescriptor discoveryDescriptor) {
        String string = discoveryDescriptor.getRootFolder();
        if (string == null) {
            return false;
        }
        ProjectProxyImpl projectProxyImpl = new ProjectProxyImpl(discoveryDescriptor);
        DiscoveryProvider discoveryProvider = DiscoveryExtension.findProvider("dwarf-folder");
        if (discoveryProvider != null && discoveryProvider.isApplicable(projectProxyImpl)) {
            discoveryProvider.getProperty("folder").setValue(string);
            if (discoveryProvider.canAnalyze(projectProxyImpl) > 0) {
                discoveryDescriptor.setProvider(discoveryProvider);
                return true;
            }
        }
        return false;
    }

    private boolean isApplicableMakeLog(DiscoveryDescriptor discoveryDescriptor) {
        String string = discoveryDescriptor.getRootFolder();
        if (string == null) {
            return false;
        }
        String string2 = discoveryDescriptor.getBuildLog();
        ProjectProxyImpl projectProxyImpl = new ProjectProxyImpl(discoveryDescriptor);
        DiscoveryProvider discoveryProvider = DiscoveryExtension.findProvider("make-log");
        if (discoveryProvider != null && discoveryProvider.isApplicable(projectProxyImpl)) {
            discoveryProvider.getProperty("make-log-file").setValue(string2);
            if (discoveryProvider.canAnalyze(projectProxyImpl) > 0) {
                discoveryDescriptor.setProvider(discoveryProvider);
                return true;
            }
        }
        return false;
    }

    public boolean isApplicable(WizardDescriptor wizardDescriptor) {
        String string = (String)wizardDescriptor.getProperty("outputTextField");
        String string2 = (String)wizardDescriptor.getProperty("buildCommandWorkingDirTextField");
        DiscoveryDescriptor discoveryDescriptor = DiscoveryWizardDescriptor.adaptee(wizardDescriptor);
        discoveryDescriptor.setBuildResult(string);
        discoveryDescriptor.setRootFolder(string2);
        return this.isApplicable(discoveryDescriptor);
    }

    public String getProviderID(WizardDescriptor wizardDescriptor) {
        DiscoveryDescriptor discoveryDescriptor = DiscoveryWizardDescriptor.adaptee(wizardDescriptor);
        return discoveryDescriptor.getProviderID();
    }

    public boolean canApply(DiscoveryDescriptor discoveryDescriptor) {
        if (!this.isApplicable(discoveryDescriptor)) {
            return false;
        }
        String string = discoveryDescriptor.getLevel();
        if (string == null || string.length() == 0) {
            return false;
        }
        DiscoveryProvider discoveryProvider = discoveryDescriptor.getProvider();
        if (discoveryProvider == null) {
            return false;
        }
        if ("dwarf-executable".equals(discoveryProvider.getID())) {
            String string2 = discoveryDescriptor.getBuildResult();
            String string3 = discoveryDescriptor.getAditionalLibraries();
            discoveryProvider.getProperty("executable").setValue(string2);
            if (string3 != null && string3.length() > 0) {
                ArrayList<String> arrayList = new ArrayList<String>();
                StringTokenizer stringTokenizer = new StringTokenizer(string3, ";");
                while (stringTokenizer.hasMoreTokens()) {
                    arrayList.add(stringTokenizer.nextToken());
                }
                discoveryProvider.getProperty("libraries").setValue(arrayList.toArray(new String[arrayList.size()]));
            } else {
                discoveryProvider.getProperty("libraries").setValue(new String[0]);
            }
        } else if ("dwarf-folder".equals(discoveryProvider.getID())) {
            String string4 = discoveryDescriptor.getRootFolder();
            discoveryProvider.getProperty("folder").setValue(string4);
        } else if (!"make-log".equals(discoveryProvider.getID())) {
            return false;
        }
        SelectConfigurationPanel.buildModel(discoveryDescriptor);
        return !discoveryDescriptor.isInvokeProvider() && discoveryDescriptor.getConfigurations() != null && discoveryDescriptor.getConfigurations().size() > 0 && discoveryDescriptor.getIncludedFiles() != null;
    }

    public boolean canApply(WizardDescriptor wizardDescriptor, Project project) {
        String string = (String)wizardDescriptor.getProperty("outputTextField");
        String string2 = (String)wizardDescriptor.getProperty("additionalLibraries");
        String string3 = (String)wizardDescriptor.getProperty("consolidationLevel");
        DiscoveryDescriptor discoveryDescriptor = DiscoveryWizardDescriptor.adaptee(wizardDescriptor);
        discoveryDescriptor.setBuildResult(string);
        discoveryDescriptor.setAditionalLibraries(string2);
        discoveryDescriptor.setLevel(string3);
        discoveryDescriptor.setProject(project);
        return this.canApply(discoveryDescriptor);
    }

    public boolean canApply(Map<String, Object> map, Project project) {
        DiscoveryDescriptor discoveryDescriptor = DiscoveryWizardDescriptor.adaptee(map);
        discoveryDescriptor.setProject(project);
        return this.canApply(discoveryDescriptor);
    }

    static DiscoveryProvider findProvider(String string) {
        for (DiscoveryProvider discoveryProvider : Lookup.getDefault().lookupAll(DiscoveryProvider.class)) {
            if (!string.equals(discoveryProvider.getID())) continue;
            discoveryProvider.clean();
            return discoveryProvider;
        }
        return null;
    }

    private static class ProjectProxyImpl
    implements ProjectProxy {
        private DiscoveryDescriptor descriptor;

        private ProjectProxyImpl(DiscoveryDescriptor discoveryDescriptor) {
            this.descriptor = discoveryDescriptor;
        }

        public boolean createSubProjects() {
            return false;
        }

        public Project getProject() {
            return null;
        }

        public String getMakefile() {
            return null;
        }

        public String getSourceRoot() {
            return this.descriptor.getRootFolder();
        }

        public String getExecutable() {
            return this.descriptor.getBuildResult();
        }

        public String getWorkingFolder() {
            return null;
        }
    }
}

