/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.projectapi;

import java.nio.charset.Charset;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.spi.queries.FileEncodingQueryImplementation;
import org.openide.filesystems.FileObject;

public class ProjectFileEncodingQueryImplementation
extends FileEncodingQueryImplementation {
    private static final Logger LOG = Logger.getLogger(ProjectFileEncodingQueryImplementation.class.getName());

    public Charset getEncoding(FileObject fileObject) {
        Project project = FileOwnerQuery.getOwner(fileObject);
        if (project == null) {
            LOG.log(Level.FINER, "{0}: no owner", fileObject);
            return null;
        }
        FileEncodingQueryImplementation fileEncodingQueryImplementation = (FileEncodingQueryImplementation)project.getLookup().lookup(FileEncodingQueryImplementation.class);
        if (fileEncodingQueryImplementation == null) {
            LOG.log(Level.FINE, "{0}: no FEQI in {1}", new Object[]{fileObject, project});
            return null;
        }
        Charset charset = fileEncodingQueryImplementation.getEncoding(fileObject);
        LOG.log(Level.FINE, "{0}: got {1} from {2}", new Object[]{fileObject, charset, fileEncodingQueryImplementation});
        return charset;
    }
}

