/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.errors;

import com.sun.source.util.TreePath;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.java.hints.spi.ErrorRule;
import org.netbeans.modules.java.hints.spi.support.FixFactory;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SuppressWarningsFixer
implements ErrorRule<Void> {
    private static final Map<String, String> KEY2SUPRESS_KEY;

    @Override
    public Set<String> getCodes() {
        return KEY2SUPRESS_KEY.keySet();
    }

    @Override
    public List<Fix> run(CompilationInfo compilationInfo, String string, int n, TreePath treePath, ErrorRule.Data<Void> data) {
        String string2 = KEY2SUPRESS_KEY.get(string);
        if (string2 != null) {
            return FixFactory.createSuppressWarnings(compilationInfo, treePath, string2);
        }
        return Collections.emptyList();
    }

    @Override
    public void cancel() {
    }

    @Override
    public String getId() {
        return "SuppressWarningsFixer";
    }

    @Override
    public String getDisplayName() {
        return NbBundle.getMessage(SuppressWarningsFixer.class, (String)"LBL_Suppress_Waning");
    }

    public String getDescription() {
        return NbBundle.getMessage(SuppressWarningsFixer.class, (String)"LBL_Suppress_Waning");
    }

    static {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string = "unchecked";
        hashMap.put("compiler.warn.prob.found.req", string);
        hashMap.put("compiler.warn.unchecked.cast.to.type", string);
        hashMap.put("compiler.warn.unchecked.assign", string);
        hashMap.put("compiler.warn.unchecked.assign.to.var", string);
        hashMap.put("compiler.warn.unchecked.call.mbr.of.raw.type", string);
        hashMap.put("compiler.warn.unchecked.meth.invocation.applied", string);
        hashMap.put("compiler.warn.unchecked.generic.array.creation", string);
        String string2 = "fallthrough";
        hashMap.put("compiler.warn.possible.fall-through.into.case", string2);
        String string3 = "deprecation";
        hashMap.put("compiler.warn.has.been.deprecated", string3);
        KEY2SUPRESS_KEY = Collections.unmodifiableMap(hashMap);
    }
}

