/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.java.hints.spi.AbstractHint;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SuspiciousNamesCombination
extends AbstractHint {
    private List<List<String>> NAME_CATEGORIES = Arrays.asList(Arrays.asList("x", "width"), Arrays.asList("y", "height"));

    public SuspiciousNamesCombination() {
        super(false, false, AbstractHint.HintSeverity.WARNING, new String[0]);
    }

    @Override
    public Set<Tree.Kind> getTreeKinds() {
        return EnumSet.of(Tree.Kind.METHOD_INVOCATION, Tree.Kind.ASSIGNMENT, Tree.Kind.VARIABLE);
    }

    @Override
    public List<ErrorDescription> run(CompilationInfo compilationInfo, TreePath treePath) {
        switch (treePath.getLeaf().getKind()) {
            case METHOD_INVOCATION: {
                return this.handleMethodInvocation(compilationInfo, treePath);
            }
            case ASSIGNMENT: {
                return this.handleAssignment(compilationInfo, treePath);
            }
            case VARIABLE: {
                return this.handleVariable(compilationInfo, treePath);
            }
        }
        return null;
    }

    @Override
    public void cancel() {
    }

    private List<ErrorDescription> handleMethodInvocation(CompilationInfo compilationInfo, TreePath treePath) {
        Element element = compilationInfo.getTrees().getElement(treePath);
        if (element == null || element.getKind() != ElementKind.CONSTRUCTOR && element.getKind() != ElementKind.METHOD) {
            return null;
        }
        MethodInvocationTree methodInvocationTree = (MethodInvocationTree)treePath.getLeaf();
        ExecutableElement executableElement = (ExecutableElement)element;
        if (executableElement.getParameters().size() != methodInvocationTree.getArguments().size()) {
            return null;
        }
        ArrayList<ErrorDescription> arrayList = new ArrayList<ErrorDescription>();
        for (int i = 0; i < executableElement.getParameters().size(); ++i) {
            ExpressionTree expressionTree;
            String string;
            String string2 = executableElement.getParameters().get(i).getSimpleName().toString();
            if (!this.isConflicting(string2, string = SuspiciousNamesCombination.getName(expressionTree = methodInvocationTree.getArguments().get(i)))) continue;
            long l = compilationInfo.getTrees().getSourcePositions().getStartPosition(compilationInfo.getCompilationUnit(), expressionTree);
            long l2 = compilationInfo.getTrees().getSourcePositions().getEndPosition(compilationInfo.getCompilationUnit(), expressionTree);
            if (l == -1L || l2 == -1L) continue;
            arrayList.add(ErrorDescriptionFactory.createErrorDescription((Severity)this.getSeverity().toEditorSeverity(), (String)"Suspicious names combination", (FileObject)compilationInfo.getFileObject(), (int)((int)l), (int)((int)l2)));
        }
        return arrayList;
    }

    private List<ErrorDescription> handleAssignment(CompilationInfo compilationInfo, TreePath treePath) {
        String string;
        AssignmentTree assignmentTree = (AssignmentTree)treePath.getLeaf();
        String string2 = SuspiciousNamesCombination.getName(assignmentTree.getVariable());
        if (this.isConflicting(string2, string = SuspiciousNamesCombination.getName(assignmentTree.getExpression()))) {
            long l = compilationInfo.getTrees().getSourcePositions().getStartPosition(compilationInfo.getCompilationUnit(), assignmentTree.getVariable());
            long l2 = compilationInfo.getTrees().getSourcePositions().getEndPosition(compilationInfo.getCompilationUnit(), assignmentTree.getVariable());
            if (l != -1L && l2 != -1L) {
                return Collections.singletonList(ErrorDescriptionFactory.createErrorDescription((Severity)this.getSeverity().toEditorSeverity(), (String)"Suspicious names combination", (FileObject)compilationInfo.getFileObject(), (int)((int)l), (int)((int)l2)));
            }
        }
        return null;
    }

    private List<ErrorDescription> handleVariable(CompilationInfo compilationInfo, TreePath treePath) {
        int[] nArray;
        String string;
        VariableTree variableTree = (VariableTree)treePath.getLeaf();
        if (variableTree.getName() == null) {
            return null;
        }
        String string2 = variableTree.getName().toString();
        if (this.isConflicting(string2, string = SuspiciousNamesCombination.getName(variableTree.getInitializer())) && (nArray = compilationInfo.getTreeUtilities().findNameSpan(variableTree)) != null) {
            String string3 = NbBundle.getMessage(SuspiciousNamesCombination.class, (String)"HINT_SuspiciousNamesCombination");
            return Collections.singletonList(ErrorDescriptionFactory.createErrorDescription((Severity)this.getSeverity().toEditorSeverity(), (String)string3, (FileObject)compilationInfo.getFileObject(), (int)nArray[0], (int)nArray[1]));
        }
        return null;
    }

    static String getName(ExpressionTree expressionTree) {
        if (expressionTree == null) {
            return null;
        }
        switch (expressionTree.getKind()) {
            case IDENTIFIER: {
                return ((IdentifierTree)expressionTree).getName().toString();
            }
            case METHOD_INVOCATION: {
                return SuspiciousNamesCombination.getName(((MethodInvocationTree)expressionTree).getMethodSelect());
            }
            case MEMBER_SELECT: {
                return ((MemberSelectTree)expressionTree).getIdentifier().toString();
            }
        }
        return null;
    }

    private boolean isConflicting(String string, String string2) {
        int n;
        if (string == null || string2 == null) {
            return false;
        }
        int n2 = this.findCategory(string);
        return n2 != (n = this.findCategory(string2)) && n2 != -1 && n != -1;
    }

    private int findCategory(String string) {
        Set<String> set = SuspiciousNamesCombination.breakName(string);
        int n = 0;
        for (List<String> list : this.NAME_CATEGORIES) {
            HashSet<String> hashSet = new HashSet<String>(list);
            hashSet.retainAll(set);
            if (!hashSet.isEmpty()) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    static Set<String> breakName(String string) {
        int n;
        HashSet<String> hashSet = new HashSet<String>();
        int n2 = 0;
        for (n = 0; n < string.length(); ++n) {
            if (Character.isUpperCase(string.charAt(n))) {
                if (n2 < n) {
                    hashSet.add(string.substring(n2, n).toLowerCase());
                }
                n2 = n;
            }
            if (string.charAt(n) != '-') continue;
            if (n2 < n) {
                hashSet.add(string.substring(n2, n).toLowerCase());
            }
            n2 = n + 1;
        }
        if (n2 < n) {
            hashSet.add(string.substring(n2, n).toLowerCase());
        }
        return hashSet;
    }

    @Override
    public String getId() {
        return SuspiciousNamesCombination.class.getName();
    }

    @Override
    public String getDisplayName() {
        return NbBundle.getMessage(SuspiciousNamesCombination.class, (String)"DN_SuspiciousNamesCombination");
    }

    @Override
    public String getDescription() {
        return NbBundle.getMessage(SuspiciousNamesCombination.class, (String)"DESC_SuspiciousNamesCombination");
    }
}

