/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.editor.index;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.netbeans.editor.ext.html.parser.AstNode;
import org.netbeans.editor.ext.html.parser.AstNodeUtils;
import org.netbeans.editor.ext.html.parser.AstNodeVisitor;
import org.netbeans.modules.html.editor.api.gsf.HtmlParserResult;
import org.netbeans.modules.parsing.spi.indexing.support.IndexDocument;
import org.netbeans.modules.parsing.spi.indexing.support.IndexResult;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.jsf.editor.index.JsfPageModel;
import org.netbeans.modules.web.jsf.editor.index.JsfPageModelFactory;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeComponentModel
extends JsfPageModel {
    static final String LIBRARY_NAME_KEY = "library";
    static final String INTERFACE_ATTRIBUTES_KEY = "interface_attributes";
    static final String HAS_IMPLEMENTATION_KEY = "has_implementation";
    private static final String RESOURCES_FOLDER_NAME = "resources";
    private static final char VALUES_SEPARATOR = ',';
    private static final char ATTRIBUTES_SEPARATOR = ';';
    private static final char KEY_VALUE_SEPARATOR = '=';
    private static final Collection<String> COMPOSITE_ATTRIBUTE_TAG_ATTRIBUTES = Arrays.asList("name", "targets", "default", "displayName", "expert", "method-signature", "preferred", "required", "shortDescription", "type");
    protected Collection<Map<String, String>> attributes;
    protected boolean hasImplementation;
    protected FileObject sourceFile;
    protected String relativePath;

    public CompositeComponentModel(FileObject fileObject, Collection<Map<String, String>> collection, boolean bl) {
        this(fileObject, null, collection, bl);
    }

    public CompositeComponentModel(FileObject fileObject, String string, Collection<Map<String, String>> collection, boolean bl) {
        this.attributes = collection;
        this.hasImplementation = bl;
        this.sourceFile = fileObject;
        this.relativePath = string;
    }

    public String getComponentName() {
        return this.sourceFile.getName();
    }

    public FileObject getSourceFile() {
        return this.sourceFile;
    }

    public String getRelativePath() {
        return this.relativePath;
    }

    public boolean isHasImplementation() {
        return this.hasImplementation;
    }

    public Collection<Map<String, String>> getExistingInterfaceAttributes() {
        return this.attributes;
    }

    public Collection<String> getPossibleAttributeTagAttributes() {
        return COMPOSITE_ATTRIBUTE_TAG_ATTRIBUTES;
    }

    @Override
    public void storeToIndex(IndexDocument indexDocument) {
        String string = this.getLibraryPath();
        indexDocument.addPair(LIBRARY_NAME_KEY, string, true, true);
        StringBuffer stringBuffer = new StringBuffer();
        Iterator<Map<String, String>> iterator = this.attributes.iterator();
        while (iterator.hasNext()) {
            Map<String, String> map = iterator.next();
            Iterator<String> iterator2 = map.keySet().iterator();
            while (iterator2.hasNext()) {
                String string2 = iterator2.next();
                String string3 = map.get(string2);
                stringBuffer.append(string2);
                stringBuffer.append('=');
                stringBuffer.append(string3);
                if (!iterator2.hasNext()) continue;
                stringBuffer.append(',');
            }
            if (!iterator.hasNext()) continue;
            stringBuffer.append(';');
        }
        indexDocument.addPair(INTERFACE_ATTRIBUTES_KEY, stringBuffer.toString(), false, true);
        indexDocument.addPair(HAS_IMPLEMENTATION_KEY, Boolean.toString(this.hasImplementation), false, true);
    }

    private String getLibraryPath() {
        FileObject fileObject = this.sourceFile.getParent();
        FileObject fileObject2 = CompositeComponentModel.getResourcesDirectory(this.sourceFile);
        assert (fileObject2 != null);
        assert (!fileObject.equals(fileObject2));
        return FileUtil.getRelativePath((FileObject)fileObject2, (FileObject)fileObject);
    }

    private static boolean isCompositeLibraryMember(FileObject fileObject) {
        FileObject fileObject2 = CompositeComponentModel.getResourcesDirectory(fileObject);
        return fileObject2 != null && FileUtil.isParentOf((FileObject)fileObject2, (FileObject)fileObject);
    }

    private static FileObject getResourcesDirectory(FileObject fileObject) {
        WebModule webModule = WebModule.getWebModule((FileObject)fileObject);
        if (webModule != null) {
            FileObject fileObject2 = webModule.getDocumentBase();
            if (fileObject2 != null) {
                return CompositeComponentModel.getChild(fileObject2, RESOURCES_FOLDER_NAME);
            }
        } else {
            FileObject fileObject3 = fileObject;
            do {
                FileObject fileObject4;
                if (!fileObject3.getName().equalsIgnoreCase(RESOURCES_FOLDER_NAME) || (fileObject4 = fileObject3.getParent()) == null || !fileObject4.getNameExt().startsWith("META-INF")) continue;
                return fileObject3;
            } while ((fileObject3 = fileObject3.getParent()) != null);
        }
        return null;
    }

    private static FileObject getChild(FileObject fileObject, String string) {
        for (FileObject fileObject2 : fileObject.getChildren()) {
            if (!fileObject2.getName().equals(string)) continue;
            return fileObject2;
        }
        return null;
    }

    public static class Factory
    extends JsfPageModelFactory {
        private static final String COMPOSITE_ATTRIBUTE_TAG_NAME = "attribute";
        private static final String INTERFACE_TAG_NAME = "interface";
        private static final String IMPLEMENTATION_TAG_NAME = "implementation";

        public JsfPageModel getModel(HtmlParserResult htmlParserResult) {
            AstNode astNode = htmlParserResult.root("http://java.sun.com/jsf/composite");
            if (astNode == null) {
                return null;
            }
            FileObject fileObject = htmlParserResult.getSnapshot().getSource().getFileObject();
            if (!CompositeComponentModel.isCompositeLibraryMember(fileObject)) {
                return null;
            }
            final ArrayList<Map<String, String>> arrayList = new ArrayList<Map<String, String>>();
            final boolean[] blArray = new boolean[1];
            final boolean[] blArray2 = new boolean[1];
            AstNodeUtils.visitChildren((AstNode)astNode, (AstNodeVisitor)new AstNodeVisitor(){

                public void visit(AstNode astNode) {
                    if (astNode.getNameWithoutPrefix().equals(Factory.INTERFACE_TAG_NAME)) {
                        blArray[0] = true;
                        for (AstNode astNode2 : astNode.children()) {
                            if (!astNode2.getNameWithoutPrefix().equals(Factory.COMPOSITE_ATTRIBUTE_TAG_NAME)) continue;
                            HashMap<String, String> hashMap = new HashMap<String, String>();
                            for (String string : astNode2.getAttributeKeys()) {
                                hashMap.put(string, astNode2.getAttribute(string).unquotedValue());
                            }
                            arrayList.add(hashMap);
                        }
                    } else if (astNode.getNameWithoutPrefix().equals(Factory.IMPLEMENTATION_TAG_NAME)) {
                        blArray2[0] = true;
                    }
                }
            });
            return new CompositeComponentModel(fileObject, arrayList, blArray2[0]);
        }

        public JsfPageModel loadFromIndex(IndexResult indexResult) {
            String string = indexResult.getValue(CompositeComponentModel.INTERFACE_ATTRIBUTES_KEY);
            boolean bl = Boolean.parseBoolean(indexResult.getValue(CompositeComponentModel.HAS_IMPLEMENTATION_KEY));
            ArrayList<Map<String, String>> arrayList = new ArrayList<Map<String, String>>();
            StringTokenizer stringTokenizer = new StringTokenizer(string, Character.valueOf(';').toString());
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                HashMap<String, String> hashMap = new HashMap<String, String>();
                StringTokenizer stringTokenizer2 = new StringTokenizer(string2, Character.valueOf(',').toString());
                while (stringTokenizer2.hasMoreTokens()) {
                    String string3 = stringTokenizer2.nextToken();
                    String string4 = string3.substring(0, string3.indexOf(61));
                    String string5 = string3.substring(string3.indexOf(61) + 1);
                    hashMap.put(string4, string5);
                }
                arrayList.add(hashMap);
            }
            return new CompositeComponentModel(indexResult.getFile(), indexResult.getRelativePath(), arrayList, bl);
        }
    }
}

