/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.palette;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.spi.palette.PaletteController;
import org.netbeans.spi.palette.PaletteTopComponent;
import org.netbeans.spi.palette.PaletteVisibility;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataShadow;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class PaletteSwitch
implements Runnable,
LookupListener {
    static final String PROP_PALETTE_CONTENTS = "component_palette_contents";
    private static PaletteSwitch theInstance;
    private PropertyChangeListener registryListener;
    private PropertyChangeSupport propertySupport;
    private PaletteController currentPalette;
    private Lookup.Result lookupRes;
    private Object currentToken;
    private Map<TopComponent, Lookup.Result> watchedLkpResults = new WeakHashMap<TopComponent, Lookup.Result>(3);

    private PaletteSwitch() {
        this.propertySupport = new PropertyChangeSupport(this);
    }

    public static synchronized PaletteSwitch getDefault() {
        if (null == theInstance) {
            theInstance = new PaletteSwitch();
        }
        return theInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startListening() {
        PaletteSwitch paletteSwitch = theInstance;
        synchronized (paletteSwitch) {
            if (null == this.registryListener) {
                this.registryListener = this.createRegistryListener();
                TopComponent.getRegistry().addPropertyChangeListener(this.registryListener);
                this.switchLookupListener();
                this.run();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopListening() {
        PaletteSwitch paletteSwitch = theInstance;
        synchronized (paletteSwitch) {
            if (null != this.registryListener) {
                TopComponent.getRegistry().removePropertyChangeListener(this.registryListener);
                this.registryListener = null;
                this.currentPalette = null;
            }
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertySupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertySupport.removePropertyChangeListener(propertyChangeListener);
    }

    public PaletteController getCurrentPalette() {
        return this.currentPalette;
    }

    @Override
    public void run() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(this);
            return;
        }
        this.currentToken = new Object();
        TopComponent.Registry registry = TopComponent.getRegistry();
        final TopComponent topComponent = registry.getActivated();
        Set set = registry.getOpened();
        final HashSet<TopComponent> hashSet = new HashSet<TopComponent>(set.size());
        for (TopComponent topComponent2 : set) {
            if (!WindowManager.getDefault().isEditorTopComponent(topComponent2)) continue;
            hashSet.add(topComponent2);
        }
        final PaletteController paletteController = this.currentPalette;
        final boolean bl = this.isPaletteMaximized();
        final Object object = this.currentToken;
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                PaletteSwitch.this.findNewPalette(paletteController, topComponent, hashSet, bl, object);
            }
        });
    }

    private boolean isPaletteMaximized() {
        boolean bl = true;
        TopComponent.Registry registry = TopComponent.getRegistry();
        Set set = registry.getOpened();
        for (TopComponent topComponent : set) {
            if (!topComponent.isShowing() || topComponent instanceof PaletteTopComponent) continue;
            bl = false;
            break;
        }
        return bl;
    }

    PaletteController getPaletteFromTopComponent(TopComponent topComponent, boolean bl, boolean bl2) {
        DataObject dataObject;
        Node[] nodeArray;
        if (null == topComponent || !topComponent.isShowing() && bl) {
            return null;
        }
        PaletteController paletteController = (PaletteController)topComponent.getLookup().lookup(PaletteController.class);
        if (null == paletteController && bl2 && null != (nodeArray = topComponent.getActivatedNodes()) && nodeArray.length > 0 && null != (dataObject = (DataObject)nodeArray[0].getLookup().lookup(DataObject.class))) {
            while (dataObject instanceof DataShadow) {
                dataObject = ((DataShadow)dataObject).getOriginal();
            }
            FileObject fileObject = dataObject.getPrimaryFile();
            if (!fileObject.isVirtual()) {
                String string = fileObject.getMIMEType();
                paletteController = this.getPaletteFromMimeType(string);
            }
        }
        return paletteController;
    }

    PaletteController getPaletteFromMimeType(String string) {
        MimePath mimePath = MimePath.get((String)string);
        Lookup lookup = MimeLookup.getLookup((MimePath)mimePath);
        return (PaletteController)lookup.lookup(PaletteController.class);
    }

    private void showHidePaletteTopComponent(PaletteController paletteController, PaletteController paletteController2) {
        if (paletteController == paletteController2 && null != paletteController2) {
            return;
        }
        PaletteController paletteController3 = this.currentPalette;
        this.currentPalette = paletteController2;
        WindowManager windowManager = WindowManager.getDefault();
        TopComponent topComponent = windowManager.findTopComponent("CommonPalette");
        if (null == topComponent) {
            Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Cannot find CommonPalette component.");
            topComponent = PaletteTopComponent.getDefault();
        }
        if (PaletteVisibility.isVisible(paletteController2) || PaletteVisibility.isVisible(null)) {
            if (!topComponent.isOpened()) {
                topComponent.open();
            }
            PaletteVisibility.setVisible(paletteController2, true);
        } else if (topComponent.isOpened()) {
            topComponent.close();
        }
        this.propertySupport.firePropertyChange(PROP_PALETTE_CONTENTS, paletteController3, this.currentPalette);
    }

    private void switchLookupListener() {
        TopComponent topComponent = TopComponent.getRegistry().getActivated();
        if (null != this.lookupRes) {
            this.lookupRes.removeLookupListener((LookupListener)this);
            this.lookupRes = null;
        }
        if (null != topComponent) {
            this.lookupRes = topComponent.getLookup().lookup(new Lookup.Template(PaletteController.class));
            this.lookupRes.addLookupListener((LookupListener)this);
            this.lookupRes.allItems();
        }
    }

    private PropertyChangeListener createRegistryListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("currentNodes".equals(propertyChangeEvent.getPropertyName()) || "opened".equals(propertyChangeEvent.getPropertyName()) || "activated".equals(propertyChangeEvent.getPropertyName())) {
                    if ("activated".equals(propertyChangeEvent.getPropertyName()) || "opened".equals(propertyChangeEvent.getPropertyName())) {
                        PaletteSwitch.this.watchOpenedEditors();
                    }
                    if ("activated".equals(propertyChangeEvent.getPropertyName())) {
                        PaletteSwitch.this.switchLookupListener();
                    }
                    PaletteSwitch.this.run();
                }
            }
        };
    }

    public void resultChanged(LookupEvent lookupEvent) {
        this.run();
    }

    private void watchOpenedEditors() {
        Lookup.Result result;
        ArrayList<TopComponent> arrayList = this.findShowingEditors();
        ArrayList<TopComponent> arrayList2 = new ArrayList<TopComponent>(arrayList);
        arrayList2.removeAll(this.watchedLkpResults.keySet());
        ArrayList<TopComponent> arrayList3 = new ArrayList<TopComponent>(this.watchedLkpResults.keySet());
        arrayList3.removeAll(arrayList);
        for (TopComponent topComponent : arrayList3) {
            result = this.watchedLkpResults.get(topComponent);
            if (null == result) continue;
            result.removeLookupListener((LookupListener)this);
            this.watchedLkpResults.remove(topComponent);
        }
        for (TopComponent topComponent : arrayList2) {
            result = topComponent.getLookup().lookup(new Lookup.Template(PaletteController.class));
            result.addLookupListener((LookupListener)this);
            result.allItems();
            this.watchedLkpResults.put(topComponent, result);
        }
    }

    private ArrayList<TopComponent> findShowingEditors() {
        ArrayList<TopComponent> arrayList = new ArrayList<TopComponent>(3);
        WindowManager windowManager = WindowManager.getDefault();
        for (TopComponent topComponent : TopComponent.getRegistry().getOpened()) {
            if (!topComponent.isShowing() || !windowManager.isEditorTopComponent(topComponent)) continue;
            arrayList.add(topComponent);
        }
        return arrayList;
    }

    private void findNewPalette(final PaletteController paletteController, TopComponent topComponent, Set<TopComponent> set, boolean bl, final Object object) {
        PaletteController paletteController2 = this.getPaletteFromTopComponent(topComponent, true, true);
        bl &= this.isCurrentPaletteAvailable(paletteController, set);
        ArrayList<PaletteController> arrayList = new ArrayList<PaletteController>(3);
        if (null == paletteController2) {
            for (TopComponent topComponent2 : set) {
                paletteController2 = this.getPaletteFromTopComponent(topComponent2, true, true);
                if (null == paletteController2) continue;
                arrayList.add(paletteController2);
            }
            if (null != paletteController && (arrayList.contains(paletteController) || bl)) {
                paletteController2 = paletteController;
            } else if (arrayList.size() > 0) {
                paletteController2 = (PaletteController)arrayList.get(0);
            }
        }
        final PaletteController paletteController3 = paletteController2;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (PaletteSwitch.this.currentToken == object) {
                    PaletteSwitch.this.showHidePaletteTopComponent(paletteController, paletteController3);
                }
            }
        });
    }

    private boolean isCurrentPaletteAvailable(PaletteController paletteController, Set<TopComponent> set) {
        for (TopComponent topComponent : set) {
            PaletteController paletteController2 = this.getPaletteFromTopComponent(topComponent, false, true);
            if (null == paletteController2 || paletteController2 != paletteController) continue;
            return true;
        }
        return false;
    }
}

