/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.impl;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.dlight.api.datafilter.DataFilter;
import org.netbeans.modules.dlight.api.datafilter.support.TimeIntervalDataFilter;
import org.netbeans.modules.dlight.api.storage.DataRow;
import org.netbeans.modules.dlight.api.storage.DataTableMetadata;
import org.netbeans.modules.dlight.api.storage.DataTableMetadataFilter;
import org.netbeans.modules.dlight.api.storage.DataTableMetadataFilterSupport;
import org.netbeans.modules.dlight.impl.SQLDataStorage;
import org.netbeans.modules.dlight.spi.impl.TableDataProvider;
import org.netbeans.modules.dlight.spi.storage.DataStorage;
import org.netbeans.modules.dlight.spi.storage.ServiceInfoDataStorage;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLTableDataProvider
implements TableDataProvider {
    private final Lock lock = new Lock();
    private final List<DataFilter> filters = new ArrayList<DataFilter>();
    private SQLDataStorage storage;
    private ServiceInfoDataStorage serviceInfoStorage;

    @Override
    public final void attachTo(DataStorage dataStorage) {
        this.storage = (SQLDataStorage)dataStorage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <T extends DataFilter> Collection<T> getDataFilters(Class<T> clazz) {
        ArrayList<T> arrayList = new ArrayList<T>();
        Lock lock = this.lock;
        synchronized (lock) {
            for (DataFilter dataFilter : this.filters) {
                if (dataFilter.getClass() != clazz) continue;
                arrayList.add(clazz.cast(dataFilter));
            }
        }
        return arrayList;
    }

    @Override
    public List<DataRow> queryData(DataTableMetadata dataTableMetadata) {
        if (dataTableMetadata == null) {
            return null;
        }
        List<DataTableMetadata.Column> list = dataTableMetadata.getColumns();
        ArrayList<DataRow> arrayList = new ArrayList<DataRow>();
        Collection<TimeIntervalDataFilter> collection = this.getDataFilters(TimeIntervalDataFilter.class);
        ArrayList<DataTableMetadataFilter> arrayList2 = new ArrayList<DataTableMetadataFilter>();
        DataTableMetadataFilterSupport dataTableMetadataFilterSupport = DataTableMetadataFilterSupport.getInstance();
        for (TimeIntervalDataFilter object : collection) {
            arrayList2.addAll(dataTableMetadataFilterSupport.createFilters(dataTableMetadata, object));
        }
        try {
            ResultSet resultSet = this.storage.select(dataTableMetadata, arrayList2);
            if (resultSet == null) {
                return Collections.emptyList();
            }
            ArrayList<String> arrayList3 = new ArrayList<String>();
            for (DataTableMetadata.Column column : list) {
                arrayList3.add(column.getColumnName());
            }
            while (resultSet.next()) {
                ArrayList arrayList4 = new ArrayList();
                for (DataTableMetadata.Column column : list) {
                    arrayList4.add(resultSet.getObject(column.getColumnName()));
                }
                DataRow dataRow = new DataRow(arrayList3, arrayList4);
                arrayList.add(dataRow);
            }
        }
        catch (SQLException sQLException) {
            Exceptions.printStackTrace((Throwable)sQLException);
        }
        return arrayList;
    }

    @Override
    public void attachTo(ServiceInfoDataStorage serviceInfoDataStorage) {
        this.serviceInfoStorage = serviceInfoDataStorage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dataFiltersChanged(List<DataFilter> list, boolean bl) {
        if (bl) {
            return;
        }
        Lock lock = this.lock;
        synchronized (lock) {
            this.filters.clear();
            this.filters.addAll(list);
        }
    }

    private static final class Lock {
        private Lock() {
        }
    }
}

